/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import org.netbeans.lib.editor.util.ArrayUtilities;

public final class IndentUtils {
    private static final int MAX_CACHED_INDENT = 80;
    private static final String[] CACHED_SPACES_STRINGS = new String[81];
    private static final int MAX_CACHED_TAB_SIZE = 8;
    private static final String[][] CACHED_TAB_INDENTS;

    private IndentUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String cachedOrCreatedIndentString(int indent, boolean expandTabs, int tabSize) {
        String indentString;
        if (expandTabs || indent < tabSize) {
            if (indent > 80) return IndentUtils.createSpacesString(indent);
            String[] stringArray = CACHED_SPACES_STRINGS;
            synchronized (CACHED_SPACES_STRINGS) {
                indentString = CACHED_SPACES_STRINGS[indent];
                if (indentString != null) return indentString;
                indentString = CACHED_SPACES_STRINGS[80];
                if (indentString == null) {
                    IndentUtils.CACHED_SPACES_STRINGS[80] = indentString = IndentUtils.createSpacesString(80);
                }
                IndentUtils.CACHED_SPACES_STRINGS[indent] = indentString = indentString.substring(0, indent);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return indentString;
            }
        }
        if (indent > 80) return IndentUtils.createTabIndentString(indent, tabSize);
        if (tabSize > 8) return IndentUtils.createTabIndentString(indent, tabSize);
        String[][] stringArray = CACHED_TAB_INDENTS;
        synchronized (CACHED_TAB_INDENTS) {
            String[] tabIndents = CACHED_TAB_INDENTS[tabSize];
            if (tabIndents == null) {
                tabIndents = new String[80 - tabSize + 1];
                IndentUtils.CACHED_TAB_INDENTS[tabSize] = tabIndents;
            }
            if ((indentString = tabIndents[indent - tabSize]) != null) return indentString;
            tabIndents[indent - tabSize] = indentString = IndentUtils.createTabIndentString(indent, tabSize);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return indentString;
        }
    }

    private static String createSpacesString(int spaceCount) {
        StringBuilder sb = new StringBuilder(spaceCount);
        ArrayUtilities.appendSpaces((StringBuilder)sb, (int)spaceCount);
        return sb.toString();
    }

    private static String createTabIndentString(int indent, int tabSize) {
        StringBuilder sb = new StringBuilder();
        while (indent >= tabSize) {
            sb.append('\t');
            indent -= tabSize;
        }
        ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
        return sb.toString();
    }

    static {
        IndentUtils.CACHED_SPACES_STRINGS[0] = "";
        CACHED_TAB_INDENTS = new String[9][];
    }
}

