/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ThrowStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class GeneratingBracketCompleter {
    private static final RequestProcessor RP = new RequestProcessor("Generating Bracket Completer");
    static final String TYPE_PLACEHOLDER = "type";

    private GeneratingBracketCompleter() {
    }

    static void generateDocTags(BaseDocument doc, int offset, int indent) {
        DocTagsGenerator docTagsGenerator = new DocTagsGenerator(doc, offset, indent);
        RP.post((Runnable)docTagsGenerator);
    }

    private static void generateFunctionDoc(BaseDocument doc, int offset, int indent, ParserResult info, FunctionDeclaration decl) throws BadLocationException {
        StringBuilder toAdd = new StringBuilder();
        ScannerImpl i = new ScannerImpl(info, decl);
        i.scan(decl);
        GeneratingBracketCompleter.addVariables(doc, toAdd, "@global", indent, i.globals);
        GeneratingBracketCompleter.addVariables(doc, toAdd, "@staticvar", indent, i.staticvars);
        GeneratingBracketCompleter.addVariables(doc, toAdd, "@param", indent, i.params);
        if (i.hasReturn) {
            GeneratingBracketCompleter.generateDocEntry(doc, toAdd, "@return", indent, null, i.returnType);
        }
        GeneratingBracketCompleter.addVariables(doc, toAdd, "@throws", indent, i.throwsExceptions);
        doc.insertString(offset, toAdd.toString(), null);
    }

    private static void addVariables(BaseDocument doc, StringBuilder toAdd, String text, int indent, List<Pair<String, String>> vars) {
        for (Pair<String, String> p : vars) {
            GeneratingBracketCompleter.generateDocEntry(doc, toAdd, text, indent, p.getA(), p.getB());
        }
    }

    private static void generateDocEntry(BaseDocument doc, StringBuilder toAdd, String text, int indent, String name, String type) {
        toAdd.append("\n");
        toAdd.append(IndentUtils.createIndentString((Document)doc, (int)indent));
        toAdd.append(" * ");
        toAdd.append(text);
        if (type != null && !type.isEmpty()) {
            toAdd.append(" ");
            toAdd.append(type);
        } else {
            toAdd.append(" ");
            toAdd.append(TYPE_PLACEHOLDER);
        }
        if (name != null) {
            toAdd.append(" ");
            toAdd.append(name);
        }
    }

    private static void generateGlobalVariableDoc(BaseDocument doc, int offset, int indent, String indexName, String type) throws BadLocationException {
        StringBuilder toAdd = new StringBuilder();
        GeneratingBracketCompleter.generateDocEntry(doc, toAdd, "@global", indent, "$GLOBALS['" + indexName + "']", type);
        toAdd.append("\n").append(IndentUtils.createIndentString((Document)doc, (int)indent));
        toAdd.append(" * ").append("@name $").append(indexName);
        doc.insertString(offset - 1, toAdd.toString(), null);
    }

    private static void generateFieldDoc(BaseDocument doc, int offset, int indent, ParserResult info, FieldsDeclaration decl) throws BadLocationException {
        StringBuilder toAdd = new StringBuilder();
        GeneratingBracketCompleter.generateDocEntry(doc, toAdd, "@var", indent, null, null);
        doc.insertString(offset - 1, toAdd.toString(), null);
    }

    private static final class Pair<A, B> {
        private A a;
        private B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }
    }

    private static class DocTagsGenerator
    implements Runnable {
        private final BaseDocument doc;
        private final int offset;
        private final int indent;

        public DocTagsGenerator(BaseDocument doc, int offset, int indent) {
            this.doc = doc;
            this.offset = offset;
            this.indent = indent;
        }

        @Override
        public void run() {
            FileObject file = NavUtils.getFile((Document)this.doc);
            if (file == null) {
                return;
            }
            try {
                ParserManager.parse(Collections.singleton(Source.create((Document)this.doc)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        final ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                        if (parserResult != null) {
                            class Result
                            extends Error {
                                private ASTNode node;

                                public Result(ASTNode node) {
                                    this.node = node;
                                }
                            }
                            Variable variable;
                            ArrayAccess arrayAccess;
                            Assignment assignment;
                            ASTNode n = null;
                            try {
                                DefaultVisitor visitor = new DefaultVisitor(){

                                    @Override
                                    public void scan(ASTNode node) {
                                        Comment c;
                                        if (node != null && (c = Utils.getCommentForNode(Utils.getRoot(parserResult), node)) != null && c.getStartOffset() <= DocTagsGenerator.this.offset && DocTagsGenerator.this.offset <= c.getEndOffset()) {
                                            throw new Result(node);
                                        }
                                        super.scan(node);
                                    }
                                };
                                visitor.scan(Utils.getRoot(parserResult));
                            }
                            catch (Result r) {
                                n = r.node;
                            }
                            if (n == null) {
                                return;
                            }
                            if (n instanceof FunctionDeclaration) {
                                GeneratingBracketCompleter.generateFunctionDoc(DocTagsGenerator.this.doc, DocTagsGenerator.this.offset, DocTagsGenerator.this.indent, parserResult, (FunctionDeclaration)n);
                            }
                            if (n instanceof MethodDeclaration) {
                                GeneratingBracketCompleter.generateFunctionDoc(DocTagsGenerator.this.doc, DocTagsGenerator.this.offset, DocTagsGenerator.this.indent, parserResult, ((MethodDeclaration)n).getFunction());
                            }
                            if (n instanceof ExpressionStatement && ((ExpressionStatement)n).getExpression() instanceof Assignment && (assignment = (Assignment)((ExpressionStatement)n).getExpression()).getLeftHandSide() instanceof ArrayAccess && (arrayAccess = (ArrayAccess)assignment.getLeftHandSide()).getName() instanceof Variable && (variable = (Variable)arrayAccess.getName()).isDollared() && variable.getName() instanceof Identifier && "GLOBALS".equals(((Identifier)variable.getName()).getName()) && arrayAccess.getDimension().getIndex() instanceof Scalar) {
                                String index = ((Scalar)arrayAccess.getDimension().getIndex()).getStringValue().trim();
                                if (index.length() > 0 && (index.charAt(0) == '\'' || index.charAt(0) == '\"')) {
                                    index = index.substring(1, index.length() - 1);
                                }
                                String type = null;
                                if (assignment.getRightHandSide() instanceof Scalar) {
                                    switch (((Scalar)assignment.getRightHandSide()).getScalarType()) {
                                        case INT: {
                                            type = "integer";
                                            break;
                                        }
                                        case REAL: {
                                            type = "float";
                                            break;
                                        }
                                        case STRING: {
                                            type = "string";
                                            break;
                                        }
                                    }
                                }
                                GeneratingBracketCompleter.generateGlobalVariableDoc(DocTagsGenerator.this.doc, DocTagsGenerator.this.offset, DocTagsGenerator.this.indent, index, type);
                            }
                            if (n instanceof FieldsDeclaration) {
                                GeneratingBracketCompleter.generateFieldDoc(DocTagsGenerator.this.doc, DocTagsGenerator.this.offset, DocTagsGenerator.this.indent, parserResult, (FieldsDeclaration)n);
                            }
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class ScannerImpl
    extends DefaultVisitor {
        private List<Pair<String, String>> globals = new LinkedList<Pair<String, String>>();
        private List<Pair<String, String>> staticvars = new LinkedList<Pair<String, String>>();
        private List<Pair<String, String>> params = new LinkedList<Pair<String, String>>();
        private List<Pair<String, String>> throwsExceptions = new LinkedList<Pair<String, String>>();
        private List<String> usedThrows = new LinkedList<String>();
        final Set<VariableName> declaredVariables = new HashSet<VariableName>();
        private boolean hasReturn;
        private String returnType;
        private final FunctionDeclaration decl;
        private final FunctionScope fnc;

        public ScannerImpl(ParserResult info, FunctionDeclaration decl) {
            if (info instanceof PHPParseResult) {
                PHPParseResult parseResult = (PHPParseResult)info;
                Model model = parseResult.getModel();
                VariableScope variableScope = model.getVariableScope(decl.getEndOffset() - 1);
                if (variableScope instanceof FunctionScope) {
                    this.fnc = (FunctionScope)variableScope;
                    this.declaredVariables.addAll(this.fnc.getDeclaredVariables());
                } else {
                    this.fnc = null;
                }
            } else {
                this.fnc = null;
            }
            this.decl = decl;
        }

        @Override
        public void scan(ASTNode node) {
            if (this.fnc != null) {
                super.scan(node);
            }
        }

        @Override
        public void visit(FormalParameter p) {
            Reference ref;
            String name = "";
            Expression expr = p.getParameterName();
            Variable var = null;
            if (expr instanceof Variable) {
                var = (Variable)expr;
            }
            if (expr instanceof Reference && (ref = (Reference)expr).getExpression() instanceof Variable) {
                var = (Variable)ref.getExpression();
            }
            if (var != null && var.getName() instanceof Identifier) {
                name = ((Identifier)var.getName()).getName();
            }
            if (name != null) {
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    String type;
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    String string = type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                    if (type != null && type.contains("@")) {
                        type = null;
                    }
                    this.params.add(new Pair<String, String>(variable.getName(), type));
                }
            }
            super.visit(p);
        }

        @Override
        public void visit(GlobalStatement node) {
            for (Variable v : node.getVariables()) {
                String name = CodeUtils.extractVariableName(v);
                if (name == null) continue;
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    String type;
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    String string = type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                    if (type != null && type.contains("@")) {
                        type = null;
                    }
                    this.globals.add(new Pair<String, String>(variable.getName(), type));
                }
            }
            super.visit(node);
        }

        @Override
        public void visit(ReturnStatement node) {
            this.hasReturn = true;
            Collection<? extends String> typeNames = this.fnc.getReturnTypeNames();
            StringBuilder type = new StringBuilder();
            for (String string : typeNames) {
                if (string != null && string.contains("@")) break;
                type = type.toString().isEmpty() ? type.append(string) : type.append("|").append(string);
            }
            this.returnType = type.toString();
        }

        @Override
        public void visit(StaticStatement node) {
            for (Variable v : node.getVariables()) {
                String name = CodeUtils.extractVariableName(v);
                if (name == null) continue;
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    String type;
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    String string = type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                    if (type != null && type.contains("@")) {
                        type = null;
                    }
                    this.staticvars.add(new Pair<String, String>(variable.getName(), type));
                }
            }
            super.visit(node);
        }

        @Override
        public void visit(ThrowStatement node) {
            String type = this.getTypeFromThrowStatement(node);
            if (!this.usedThrows.contains(type)) {
                this.usedThrows.add(type);
                this.throwsExceptions.add(new Pair<Object, String>(null, type));
            }
            super.visit(node);
        }

        private String getTypeFromThrowStatement(ThrowStatement throwStatement) {
            String type = null;
            Expression expression = throwStatement.getExpression();
            if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
                Expression name = classInstanceCreation.getClassName().getName();
                if (name instanceof NamespaceName) {
                    NamespaceName namespaceName = (NamespaceName)name;
                    type = this.getTypeFromNamespaceName(namespaceName);
                }
            } else if (expression instanceof Variable) {
                Variable v = (Variable)expression;
                String name = CodeUtils.extractVariableName(v);
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                }
            }
            return type;
        }

        private String getTypeFromNamespaceName(NamespaceName namespaceName) {
            StringBuilder sbType = new StringBuilder();
            if (namespaceName.isGlobal()) {
                sbType.append("\\");
            }
            List<Identifier> segments = namespaceName.getSegments();
            Iterator<Identifier> iter = segments.iterator();
            while (iter.hasNext()) {
                sbType.append(iter.next().getName());
                if (!iter.hasNext()) continue;
                sbType.append("\\");
            }
            return sbType.toString();
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (node == this.decl) {
                super.visit(node);
            }
        }

        @Override
        public void visit(ClassDeclaration node) {
        }
    }
}

