/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.elements.FullyQualifiedElementImpl;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.nodes.NamespaceDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.openide.util.Parameters;

public class NamespaceElementImpl
extends FullyQualifiedElementImpl
implements NamespaceElement {
    public static final String IDX_FIELD = "ns";

    NamespaceElementImpl(QualifiedName qualifiedName, int offset, String fileUrl, ElementQuery elementQuery) {
        super(qualifiedName.toName().toString(), qualifiedName.toNamespaceName().toString(), fileUrl, offset, elementQuery);
    }

    public static Set<NamespaceElement> fromSignature(IndexQueryImpl indexQuery, IndexResult indexResult) {
        return NamespaceElementImpl.fromSignature(NameKind.empty(), indexQuery, indexResult);
    }

    public static Set<NamespaceElement> fromSignature(NameKind query, IndexQueryImpl indexQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<NamespaceElement> retval = new HashSet<NamespaceElement>();
        for (String val : values) {
            NamespaceElement namespace = NamespaceElementImpl.fromSignature(query, indexQuery, indexResult, Signature.get(val));
            if (namespace == null) continue;
            retval.add(namespace);
        }
        return retval;
    }

    public static NamespaceElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature sig) {
        NamespaceSignatureParser signParser = new NamespaceSignatureParser(sig);
        NamespaceElementImpl retval = null;
        if (NamespaceElementImpl.matchesQuery(query, signParser)) {
            retval = new NamespaceElementImpl(signParser.getQualifiedName(), 0, indexResult.getUrl().toString(), indexScopeQuery);
        }
        return retval;
    }

    public static NamespaceElement fromNode(NamespaceDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        NamespaceDeclarationInfo info = NamespaceDeclarationInfo.create(node);
        return new NamespaceElementImpl(info.getQualifiedName(), info.getRange().getStart(), fileQuery.getURL().toExternalForm(), fileQuery);
    }

    private static boolean matchesQuery(NameKind query, NamespaceSignatureParser signParser) {
        Parameters.notNull((CharSequence)"NameKind query: can't be null", (Object)query);
        QualifiedName qualifiedName = signParser.getQualifiedName();
        return query instanceof NameKind.Empty || !qualifiedName.isDefaultNamespace() && query.matchesName(NamespaceElement.KIND, qualifiedName);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        QualifiedName qualifiedName = this.getFullyQualifiedName();
        String name = qualifiedName.toName().toString();
        String namespaceName = qualifiedName.toNamespaceName().toString();
        sb.append(name.toLowerCase()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(name).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(namespaceName).append((Object)PhpElementImpl.Separator.SEMICOLON);
        this.checkSignature(sb);
        return sb.toString();
    }

    @Override
    public final PhpElementKind getPhpElementKind() {
        return NamespaceElement.KIND;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            NamespaceSignatureParser parser = new NamespaceSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getQualifiedName().toName().toString()));
            assert (this.getNamespaceName().equals(parser.getQualifiedName().toNamespaceName()));
        }
    }

    @Override
    public boolean equals(Object obj) {
        String otherNamespaceName;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceElementImpl other = (NamespaceElementImpl)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        String thisNamespaceName = this.getNamespaceName().toString();
        return thisNamespaceName.equals(otherNamespaceName = other.getNamespaceName().toString());
    }

    @Override
    public int hashCode() {
        int hash = 3;
        String thisNamespaceName = this.getNamespaceName().toString();
        hash = 71 * hash + this.getName().hashCode();
        hash = 71 * hash + thisNamespaceName.hashCode();
        return hash;
    }

    private static class NamespaceSignatureParser {
        private final Signature signature;

        NamespaceSignatureParser(Signature signature) {
            this.signature = signature;
        }

        QualifiedName getQualifiedName() {
            return FullyQualifiedElementImpl.composeQualifiedName(this.signature.string(2), this.signature.string(1));
        }
    }
}

