/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;

public class BaseFunctionElementSupport {
    private final List<ParameterElement> parameters;
    private final Set<TypeResolver> returnTypes;

    protected BaseFunctionElementSupport(List<ParameterElement> parameters, Set<TypeResolver> returnTypes) {
        this.parameters = parameters;
        this.returnTypes = returnTypes;
    }

    public final List<ParameterElement> getParameters() {
        return this.parameters;
    }

    public final Collection<TypeResolver> getReturnTypes() {
        return this.returnTypes;
    }

    public final String asString(BaseFunctionElement.PrintAs as, BaseFunctionElement element, TypeNameResolver typeNameResolver) {
        StringBuilder template = new StringBuilder();
        switch (as) {
            case NameAndParamsDeclaration: {
                template.append(" ").append(element.getName()).append("(");
                template.append(BaseFunctionElementSupport.parameters2String(this.getParameters(), ParameterElement.OutputType.SHORTEN_DECLARATION, typeNameResolver));
                template.append(")");
                break;
            }
            case NameAndParamsInvocation: {
                template.append(" ").append(element.getName()).append("(");
                template.append(BaseFunctionElementSupport.parameters2String(this.getParameters(), ParameterElement.OutputType.SIMPLE_NAME, typeNameResolver));
                template.append(")");
                break;
            }
            case DeclarationWithoutBody: {
                String modifiers = element.getPhpModifiers().toString();
                if (modifiers.length() > 0) {
                    template.append(modifiers).append(" ");
                }
                template.append("function");
                template.append(this.asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration, element, typeNameResolver));
                break;
            }
            case DeclarationWithEmptyBody: {
                template.append(this.asString(BaseFunctionElement.PrintAs.DeclarationWithoutBody, element, typeNameResolver));
                template.append("{\n}");
                break;
            }
            case DeclarationWithParentCallInBody: {
                template.append(this.asString(BaseFunctionElement.PrintAs.DeclarationWithoutBody, element, typeNameResolver));
                Collection<TypeResolver> returns = this.getReturnTypes();
                String methdodInvocation = this.asString(BaseFunctionElement.PrintAs.NameAndParamsInvocation, element, typeNameResolver);
                if (methdodInvocation.startsWith(" ")) {
                    methdodInvocation = methdodInvocation.substring(1);
                }
                if (returns.size() > 0) {
                    template.append(String.format("{%nreturn parent::%s;%n}", methdodInvocation));
                    break;
                }
                template.append(String.format("{%nparent::%s;%n}", methdodInvocation));
                break;
            }
            case ReturnSemiTypes: {
                for (TypeResolver typeResolver : this.getReturnTypes()) {
                    Object typeName;
                    if (typeResolver.isResolved()) {
                        typeName = typeResolver.getTypeName(false);
                        if (typeName == null) continue;
                        if (template.length() > 0) {
                            template.append("|");
                        }
                        template.append(typeNameResolver.resolve((QualifiedName)typeName).toString());
                        continue;
                    }
                    typeName = typeResolver.getRawTypeName();
                    if (typeName == null) continue;
                    if (template.length() > 0) {
                        template.append("|");
                    }
                    template.append((String)typeName);
                }
                break;
            }
            case ReturnTypes: {
                for (TypeResolver typeResolver : this.getReturnTypes()) {
                    QualifiedName typeName;
                    if (!typeResolver.isResolved() || (typeName = typeResolver.getTypeName(false)) == null) continue;
                    if (template.length() > 0) {
                        template.append("|");
                    }
                    template.append(typeNameResolver.resolve(typeName).toString());
                }
                break;
            }
            default: {
                assert (false) : as;
                break;
            }
        }
        return template.toString();
    }

    private static String parameters2String(List<ParameterElement> parameterList, ParameterElement.OutputType stringOutputType, TypeNameResolver typeNameResolver) {
        StringBuilder template = new StringBuilder();
        if (parameterList.size() > 0) {
            int n = parameterList.size();
            for (int i = 0; i < n; ++i) {
                StringBuilder paramSb = new StringBuilder();
                if (i > 0) {
                    paramSb.append(", ");
                }
                ParameterElement param = parameterList.get(i);
                paramSb.append(param.asString(stringOutputType, typeNameResolver));
                template.append((CharSequence)paramSb);
            }
        }
        return template.toString();
    }
}

