/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen.ui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.MutableTreeNode;
import org.netbeans.modules.php.editor.codegen.CGSGenerator;
import org.netbeans.modules.php.editor.codegen.CGSInfo;
import org.netbeans.modules.php.editor.codegen.ComboBoxModelElement;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.codegen.ui.CheckBoxTreeRenderer;
import org.netbeans.modules.php.editor.codegen.ui.CheckNode;
import org.netbeans.modules.php.editor.codegen.ui.NodeSelectionListener;
import org.openide.util.NbBundle;

public class ConstructorPanel
extends JPanel {
    protected final String className;
    protected final List<? extends Property> properties;
    protected final CGSInfo cgsInfo;
    private JCheckBox cbGenerateDoc;
    private JComboBox cbMethodGeneration;
    private JCheckBox fluentSetterCheckBox;
    private JLabel jLabel1;
    private JLabel label;
    private JPanel pGSCustomize;
    private JScrollPane scrollPane;

    public ConstructorPanel(CGSGenerator.GenType genType, CGSInfo cgsInfo) {
        this.initComponents();
        this.className = cgsInfo.getClassName();
        switch (genType) {
            case CONSTRUCTOR: {
                this.properties = cgsInfo.getProperties();
                break;
            }
            case GETTER: {
                this.properties = cgsInfo.getPossibleGetters();
                break;
            }
            case SETTER: {
                this.properties = cgsInfo.getPossibleSetters();
                break;
            }
            case METHODS: {
                this.properties = cgsInfo.getPossibleMethods();
                break;
            }
            default: {
                this.properties = cgsInfo.getPossibleGettersSetters();
            }
        }
        this.cgsInfo = cgsInfo;
        this.initPanel(genType);
        this.initTree();
    }

    private void initPanel(CGSGenerator.GenType genType) {
        boolean customizeMethodGeneration = true;
        String name = "";
        if (this.properties.size() > 0) {
            name = this.properties.get(0).getName();
        }
        ComboBoxModel model = genType.getModel(name);
        if (genType.equals((Object)CGSGenerator.GenType.METHODS)) {
            customizeMethodGeneration = false;
            Dimension preferredSize = this.getPreferredSize();
            this.setPreferredSize(new Dimension((int)(preferredSize.getWidth() * 1.3), (int)(preferredSize.getHeight() * 1.3)));
        }
        this.label.setText(genType.getPanelTitle());
        this.pGSCustomize.setVisible(customizeMethodGeneration);
        if (customizeMethodGeneration) {
            this.cbMethodGeneration.setModel(model);
            int index = 0;
            if (this.cgsInfo.getHowToGenerate() != null) {
                int i = 0;
                while (i < model.getSize()) {
                    Object modelElement = model.getElementAt(index);
                    assert (modelElement instanceof ComboBoxModelElement);
                    if (this.cgsInfo.getHowToGenerate().equals((Object)((ComboBoxModelElement)modelElement).getGenWay())) break;
                    index = i++;
                }
            }
            this.cbMethodGeneration.setSelectedIndex(index);
        }
        this.cbGenerateDoc.setSelected(this.cgsInfo.isGenerateDoc());
        this.cbGenerateDoc.setVisible(false);
        this.fluentSetterCheckBox.setVisible(genType.isFluentSetterVisible());
        this.fluentSetterCheckBox.setSelected(this.cgsInfo.isFluentSetter());
    }

    private void initTree() {
        JTree tree = new JTree(this.getRootNode());
        tree.setCellRenderer(new CheckBoxTreeRenderer());
        tree.getSelectionModel().setSelectionMode(1);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        NodeSelectionListener listener = new NodeSelectionListener(tree);
        tree.addMouseListener(listener);
        tree.addKeyListener(listener);
        tree.expandRow(0);
        tree.setShowsRootHandles(true);
        tree.setSelectionRow(0);
        this.initTree(tree);
        this.scrollPane.add(tree);
        this.scrollPane.setViewportView(tree);
    }

    protected MutableTreeNode getRootNode() {
        CheckNode.CGSClassNode root = new CheckNode.CGSClassNode(this.className);
        for (Property property : this.properties) {
            root.add(new CheckNode.CGSPropertyNode(property));
        }
        return root;
    }

    protected void initTree(JTree tree) {
    }

    private void initComponents() {
        this.label = new JLabel();
        this.scrollPane = new JScrollPane();
        this.pGSCustomize = new JPanel();
        this.jLabel1 = new JLabel();
        this.cbMethodGeneration = new JComboBox();
        this.cbGenerateDoc = new JCheckBox();
        this.fluentSetterCheckBox = new JCheckBox();
        this.label.setDisplayedMnemonic('G');
        this.label.setLabelFor(this.scrollPane);
        this.label.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.label.text"));
        this.jLabel1.setDisplayedMnemonic('M');
        this.jLabel1.setLabelFor(this.cbMethodGeneration);
        this.jLabel1.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.jLabel1.text"));
        this.cbMethodGeneration.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbMethodGeneration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstructorPanel.this.cbMethodGenerationActionPerformed(evt);
            }
        });
        GroupLayout pGSCustomizeLayout = new GroupLayout(this.pGSCustomize);
        this.pGSCustomize.setLayout(pGSCustomizeLayout);
        pGSCustomizeLayout.setHorizontalGroup(pGSCustomizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGSCustomizeLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbMethodGeneration, 0, 259, Short.MAX_VALUE)));
        pGSCustomizeLayout.setVerticalGroup(pGSCustomizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGSCustomizeLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(pGSCustomizeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbMethodGeneration, -2, -1, -2)).addGap(65, 65, 65)));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.jLabel1.AccessibleContext.accessibleName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.jLabel1.AccessibleContext.accessibleDescription"));
        this.cbMethodGeneration.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbMethodGeneration.AccessibleContext.accessibleName"));
        this.cbMethodGeneration.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbMethodGeneration.AccessibleContext.accessibleDescription"));
        this.cbGenerateDoc.setMnemonic('e');
        this.cbGenerateDoc.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"LBL_Generate_Documentation"));
        this.cbGenerateDoc.setCursor(new Cursor(0));
        this.cbGenerateDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstructorPanel.this.cbGenerateDocActionPerformed(evt);
            }
        });
        this.fluentSetterCheckBox.setMnemonic('F');
        this.fluentSetterCheckBox.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.fluentSetterCheckBox.text"));
        this.fluentSetterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstructorPanel.this.fluentSetterCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 422, Short.MAX_VALUE).addComponent(this.cbGenerateDoc, -1, 422, Short.MAX_VALUE).addComponent(this.pGSCustomize, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label).addComponent(this.fluentSetterCheckBox)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 206, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pGSCustomize, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbGenerateDoc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fluentSetterCheckBox).addContainerGap()));
        this.label.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.label.AccessibleContext.accessibleName"));
        this.label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.label.AccessibleContext.accessibleDescription"));
        this.scrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.scrollPane.AccessibleContext.accessibleName"));
        this.scrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.scrollPane.AccessibleContext.accessibleDescription"));
        this.pGSCustomize.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.pGSCustomize.AccessibleContext.accessibleName"));
        this.pGSCustomize.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.pGSCustomize.AccessibleContext.accessibleDescription"));
        this.cbGenerateDoc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbGenerateDoc.AccessibleContext.accessibleName"));
        this.cbGenerateDoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbGenerateDoc.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.AccessibleContext.accessibleDescription"));
    }

    private void cbMethodGenerationActionPerformed(ActionEvent evt) {
        Object selectedItem = this.cbMethodGeneration.getSelectedItem();
        assert (selectedItem instanceof ComboBoxModelElement);
        this.cgsInfo.setHowToGenerate(((ComboBoxModelElement)selectedItem).getGenWay());
    }

    private void cbGenerateDocActionPerformed(ActionEvent evt) {
        this.cgsInfo.setGenerateDoc(this.cbGenerateDoc.isSelected());
    }

    private void fluentSetterCheckBoxActionPerformed(ActionEvent evt) {
        this.cgsInfo.setFluentSetter(this.fluentSetterCheckBox.isSelected());
    }
}

