/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.LinkedList;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.openide.filesystems.FileObject;

public final class CodegenUtils {
    private CodegenUtils() {
    }

    public static TypeNameResolver createSmarterTypeNameResolver(PhpElement originalElement, Model currentModel, int caretOffset) {
        FileObject fileObject;
        assert (originalElement != null);
        assert (currentModel != null);
        TypeNameResolver result = TypeNameResolverImpl.forNull();
        LinkedList<TypeNameResolver> typeNameResolvers = new LinkedList<TypeNameResolver>();
        FileScope fileScope = ModelUtils.getFileScope(originalElement.getFileObject(), 300);
        if (fileScope != null && (fileObject = fileScope.getFileObject()) != null) {
            if (CodeUtils.isPhp52(fileObject)) {
                typeNameResolvers.add(TypeNameResolverImpl.forUnqualifiedName());
            } else {
                NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(fileScope, originalElement.getOffset());
                typeNameResolvers.add(TypeNameResolverImpl.forFullyQualifiedName(namespaceScope, originalElement.getOffset()));
                VariableScope variableScope = currentModel.getVariableScope(caretOffset);
                if (variableScope != null) {
                    typeNameResolvers.add(TypeNameResolverImpl.forSmartName(variableScope, caretOffset));
                }
            }
            result = TypeNameResolverImpl.forChainOf(typeNameResolvers);
        }
        return result;
    }
}

