/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.ElementTransformation;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TreeElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.codegen.CGSGenerator;
import org.netbeans.modules.php.editor.codegen.MethodProperty;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class CGSInfo {
    private String className = null;
    private boolean hasConstructor;
    private final List<Property> properties = new ArrayList<Property>();
    private final List<Property> possibleGetters = new ArrayList<Property>();
    private final List<Property> possibleSetters = new ArrayList<Property>();
    private final List<Property> possibleGettersSetters = new ArrayList<Property>();
    private final List<MethodProperty> possibleMethods = new ArrayList<MethodProperty>();
    private final JTextComponent textComp;
    private CGSGenerator.GenWay howToGenerate;
    private boolean generateDoc;
    private boolean fluentSetter;

    private CGSInfo(JTextComponent textComp) {
        this.textComp = textComp;
        this.hasConstructor = false;
        this.generateDoc = true;
        this.fluentSetter = false;
        this.howToGenerate = CGSGenerator.GenWay.AS_JAVA;
    }

    public static CGSInfo getCGSInfo(JTextComponent textComp) {
        CGSInfo info = new CGSInfo(textComp);
        info.findPropertyInScope();
        return info;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<MethodProperty> getPossibleMethods() {
        return this.possibleMethods;
    }

    public List<Property> getPossibleGetters() {
        return this.possibleGetters;
    }

    public List<Property> getPossibleGettersSetters() {
        return this.possibleGettersSetters;
    }

    public List<Property> getPossibleSetters() {
        return this.possibleSetters;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean hasConstructor() {
        return this.hasConstructor;
    }

    public CGSGenerator.GenWay getHowToGenerate() {
        return this.howToGenerate;
    }

    public void setHowToGenerate(CGSGenerator.GenWay howGenerate) {
        this.howToGenerate = howGenerate;
    }

    public boolean isGenerateDoc() {
        return this.generateDoc;
    }

    public void setGenerateDoc(boolean generateDoc) {
        this.generateDoc = generateDoc;
    }

    public boolean isFluentSetter() {
        return this.fluentSetter;
    }

    public void setFluentSetter(boolean fluentSetter) {
        this.fluentSetter = fluentSetter;
    }

    private void findPropertyInScope() {
        FileObject file = NavUtils.getFile(this.textComp.getDocument());
        if (file == null) {
            return;
        }
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)this.textComp.getDocument())), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    int caretOffset;
                    ClassDeclaration classDecl;
                    PHPParseResult info = (PHPParseResult)resultIterator.getParserResult();
                    if (info != null && (classDecl = CGSInfo.this.findEnclosingClass(info, caretOffset = CGSInfo.this.textComp.getCaretPosition())) != null) {
                        CGSInfo.this.className = classDecl.getName().getName();
                        if (CGSInfo.this.className != null) {
                            FileObject fileObject = info.getSnapshot().getSource().getFileObject();
                            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
                            ElementFilter forFilesFilter = ElementFilter.forFiles(fileObject);
                            QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(CGSInfo.this.className), caretOffset, info.getModel().getVariableScope(caretOffset));
                            Set<ClassElement> classes = forFilesFilter.filter(index.getClasses(NameKind.exact(fullyQualifiedName)));
                            for (ClassElement classElement : classes) {
                                ElementFilter forNotDeclared = ElementFilter.forExcludedElements(index.getDeclaredMethods(classElement));
                                HashSet<MethodElement> accessibleMethods = new HashSet<MethodElement>();
                                accessibleMethods.addAll(forNotDeclared.filter(index.getAccessibleMethods(classElement, classElement)));
                                accessibleMethods.addAll(ElementFilter.forExcludedElements(accessibleMethods).filter(forNotDeclared.filter(index.getConstructors(classElement))));
                                accessibleMethods.addAll(ElementFilter.forExcludedElements(accessibleMethods).filter(forNotDeclared.filter(index.getAccessibleMagicMethods(classElement))));
                                Set<TypeElement> preferedTypes = forFilesFilter.prefer(ElementTransformation.toMemberTypes().transform(accessibleMethods));
                                TreeElement<TypeElement> enclosingType = index.getInheritedTypesAsTree(classElement, preferedTypes);
                                ArrayList<MethodProperty> methodProperties = new ArrayList<MethodProperty>();
                                Set methods = ElementFilter.forMembersOfTypes(preferedTypes).filter(accessibleMethods);
                                for (MethodElement methodElement : methods) {
                                    if (methodElement.isFinal()) continue;
                                    methodProperties.add(new MethodProperty(methodElement, enclosingType));
                                }
                                Collections.sort(methodProperties, MethodProperty.getComparator());
                                CGSInfo.this.getPossibleMethods().addAll(methodProperties);
                            }
                        }
                        ArrayList<String> existingGetters = new ArrayList<String>();
                        ArrayList<String> existingSetters = new ArrayList<String>();
                        PropertiesVisitor visitor = new PropertiesVisitor(existingGetters, existingSetters, Utils.getRoot(info));
                        visitor.scan(classDecl);
                        for (Property property : CGSInfo.this.getProperties()) {
                            String propertyName = property.getName().toLowerCase();
                            boolean existGetter = existingGetters.contains(propertyName);
                            boolean existSetter = existingSetters.contains(propertyName);
                            if (!existGetter && !existSetter) {
                                CGSInfo.this.getPossibleGettersSetters().add(property);
                                CGSInfo.this.getPossibleGetters().add(property);
                                CGSInfo.this.getPossibleSetters().add(property);
                                continue;
                            }
                            if (!existGetter) {
                                CGSInfo.this.getPossibleGetters().add(property);
                                continue;
                            }
                            if (existSetter) continue;
                            CGSInfo.this.getPossibleSetters().add(property);
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private ClassDeclaration findEnclosingClass(ParserResult info, int offset) {
        List<ASTNode> nodes = NavUtils.underCaret(info, offset);
        int count = nodes.size();
        if (count > 2) {
            ASTNode declaration = nodes.get(count - 2);
            ASTNode block = nodes.get(count - 1);
            if (block instanceof Block && declaration instanceof ClassDeclaration) {
                return (ClassDeclaration)declaration;
            }
        }
        return null;
    }

    private class PropertiesVisitor
    extends DefaultVisitor {
        private final List<String> existingGetters;
        private final List<String> existingSetters;
        private final Program program;

        public PropertiesVisitor(List<String> existingGetters, List<String> existingSetters, Program program) {
            this.existingGetters = existingGetters;
            this.existingSetters = existingSetters;
            this.program = program;
        }

        @Override
        public void visit(FieldsDeclaration node) {
            List<SingleFieldDeclaration> fields = node.getFields();
            if (!BodyDeclaration.Modifier.isStatic(node.getModifier())) {
                for (SingleFieldDeclaration singleFieldDeclaration : fields) {
                    Variable variable = singleFieldDeclaration.getName();
                    if (variable == null || !(variable.getName() instanceof Identifier)) continue;
                    String name = ((Identifier)variable.getName()).getName();
                    CGSInfo.this.getProperties().add(new Property(name, node.getModifier(), this.getPropertyType(singleFieldDeclaration)));
                }
            }
        }

        private String getPropertyType(ASTNode node) {
            String result = "";
            Comment comment = Utils.getCommentForNode(this.program, node);
            if (comment instanceof PHPDocBlock) {
                result = this.getFirstTypeFromBlock((PHPDocBlock)comment);
            }
            return result;
        }

        private String getFirstTypeFromBlock(PHPDocBlock phpDoc) {
            String result = "";
            for (PHPDocTag pHPDocTag : phpDoc.getTags()) {
                if (pHPDocTag instanceof PHPDocTypeTag && pHPDocTag.getKind().equals((Object)PHPDocTag.Type.VAR) && !(result = this.getFirstTypeFromTag((PHPDocTypeTag)pHPDocTag)).isEmpty()) break;
            }
            return result;
        }

        private String getFirstTypeFromTag(PHPDocTypeTag typeTag) {
            String result = "";
            for (PHPDocTypeNode typeNode : typeTag.getTypes()) {
                String type = typeNode.getValue();
                if (VariousUtils.isPrimitiveType(type) || VariousUtils.isSpecialClassName(type)) continue;
                result = type;
                break;
            }
            return result;
        }

        @Override
        public void visit(MethodDeclaration node) {
            String name = node.getFunction().getFunctionName().getName();
            if (name != null) {
                if (name.startsWith("get")) {
                    String possibleProperty = name.substring("get".length());
                    this.existingGetters.addAll(this.getAllPossibleProperties(possibleProperty));
                } else if (name.startsWith("set")) {
                    String possibleProperty = name.substring("get".length());
                    this.existingSetters.addAll(this.getAllPossibleProperties(possibleProperty));
                } else if (CGSInfo.this.className != null && (CGSInfo.this.className.equals(name) || "__construct".equals(name))) {
                    CGSInfo.this.hasConstructor = true;
                }
            }
        }

        private List<String> getAllPossibleProperties(String possibleProperty) {
            LinkedList<String> allPossibleProperties = new LinkedList<String>();
            possibleProperty = possibleProperty.toLowerCase();
            allPossibleProperties.add(possibleProperty);
            if (possibleProperty.startsWith("_")) {
                allPossibleProperties.add(possibleProperty.substring(1));
            } else {
                allPossibleProperties.add("_" + possibleProperty);
            }
            return allPossibleProperties;
        }
    }
}

