/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.codegen.CGSInfo;
import org.netbeans.modules.php.editor.codegen.CodegenUtils;
import org.netbeans.modules.php.editor.codegen.ComboBoxModelElement;
import org.netbeans.modules.php.editor.codegen.MethodProperty;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.codegen.ui.ConstructorPanel;
import org.netbeans.modules.php.editor.codegen.ui.MethodPanel;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class CGSGenerator
implements CodeGenerator {
    protected static final String START_OF_GETTER = "get";
    protected static final String START_OF_SETTER = "set";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String PROPERTY = "${PROPERTY}";
    private static final String CURSOR = "${cursor}";
    private static final String PARAM_NAME = "${PARAM_NAME}";
    private static final String PARAM_TYPE = "${PARAM_TYPE}";
    private static final String UP_FIRST_LETTER_PROPERTY = "${UpFirstLetterProperty}";
    private static final String UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE = "${UpFirstLetterPropertyWithoutUnderscore}";
    private static final String PROPERTY_WITHOUT_UNDERSCORE = "${PropertyWithoutUnderscore}";
    private static final String FLUENT_SETTER = "${FluentSetter}";
    private static final String PARAMS = "${PARAMS}";
    private static final String ASSIGNMENTS = "${ASSIGNMENT}";
    private static final String TEMPLATE_NAME = "${TEMPLATE_NAME}";
    private static final String CONSTRUCTOR_TEMPLATE = "function __construct(${PARAMS}) {${ASSIGNMENT}${cursor}" + NEW_LINE + "}" + NEW_LINE;
    private static final String ASSIGNMENT_TEMPLATE = NEW_LINE + "$this->" + "${PROPERTY}" + " = $" + "${PARAM_NAME}" + ";";
    private static final String GETTER_TEMPLATE = "public function ${TEMPLATE_NAME}() {" + NEW_LINE + "return $$this->" + "${PROPERTY}" + ";" + NEW_LINE + "}" + NEW_LINE;
    private static final String SETTER_TEMPLATE = "public function ${TEMPLATE_NAME}(${PARAM_TYPE}$$${PARAM_NAME}) {" + ASSIGNMENT_TEMPLATE + NEW_LINE + "${FluentSetter}" + "}" + NEW_LINE;
    private final GenType genType;
    private final CGSInfo cgsInfo;
    private final JTextComponent component;
    private static final String GETTER_SETTER_PROJECT_PROPERTY = "getter.setter.method.name.generation";
    private static final String FLUENT_SETTER_PROJECT_PROPERTY = "fluent.setter.project.property";

    private CGSGenerator(JTextComponent component, CGSInfo cgsInfo, GenType type) {
        this.genType = type;
        this.cgsInfo = cgsInfo;
        this.component = component;
    }

    public void invoke() {
        FileObject fo = NbEditorUtilities.getFileObject((Document)this.component.getDocument());
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null) {
            Preferences preferences = ProjectUtils.getPreferences((Project)project, CGSGenerator.class, (boolean)false);
            try {
                this.cgsInfo.setHowToGenerate(GenWay.valueOf(preferences.get(GETTER_SETTER_PROJECT_PROPERTY, GenWay.AS_JAVA.name())));
            }
            catch (IllegalArgumentException ex) {
                this.cgsInfo.setHowToGenerate(GenWay.AS_JAVA);
            }
            this.cgsInfo.setFluentSetter(preferences.getBoolean(FLUENT_SETTER_PROJECT_PROPERTY, false));
            DialogDescriptor desc = new DialogDescriptor((Object)this.genType.createPanel(this.cgsInfo), this.genType.getDialogTitle());
            Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
            dialog.setVisible(true);
            dialog.dispose();
            if (desc.getValue() == DialogDescriptor.OK_OPTION) {
                CodeTemplateManager manager = CodeTemplateManager.get((Document)this.component.getDocument());
                CodeTemplate template = manager.createTemporary(this.genType.getTemplateText(this.cgsInfo, this.component));
                template.insert(this.component);
                preferences.put(GETTER_SETTER_PROJECT_PROPERTY, this.cgsInfo.getHowToGenerate().name());
                preferences.putBoolean(FLUENT_SETTER_PROJECT_PROPERTY, this.cgsInfo.isFluentSetter());
            }
        }
    }

    public String getDisplayName() {
        return this.genType.getDisplayName();
    }

    private static String getUnusedMethodName(List<String> usedMethods, String methodName) {
        if (usedMethods.contains(methodName)) {
            int counter = 1;
            while (usedMethods.contains(methodName + "_" + counter)) {
                ++counter;
            }
            methodName = methodName + "_" + counter;
        }
        usedMethods.add(methodName);
        return methodName;
    }

    private static String upFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String upFirstLetterWithoutUnderscore(String name) {
        return CGSGenerator.upFirstLetter(CGSGenerator.withoutUnderscore(name));
    }

    private static String withoutUnderscore(String name) {
        return name.length() > 0 && name.charAt(0) == '_' ? name.substring(1) : name;
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            JTextComponent textComp = (JTextComponent)context.lookup(JTextComponent.class);
            ArrayList<CGSGenerator> ret = new ArrayList<CGSGenerator>();
            CGSInfo info = CGSInfo.getCGSInfo(textComp);
            if (info.getClassName() != null) {
                if (!info.hasConstructor()) {
                    ret.add(new CGSGenerator(textComp, info, GenType.CONSTRUCTOR));
                }
                if (info.getPossibleGetters().size() > 0) {
                    ret.add(new CGSGenerator(textComp, info, GenType.GETTER));
                }
                if (info.getPossibleSetters().size() > 0) {
                    ret.add(new CGSGenerator(textComp, info, GenType.SETTER));
                }
                if (info.getPossibleGettersSetters().size() > 0) {
                    ret.add(new CGSGenerator(textComp, info, GenType.GETTER_AND_SETTER));
                }
                if (info.getPossibleMethods().size() > 0) {
                    ret.add(new CGSGenerator(textComp, info, GenType.METHODS));
                }
            }
            return ret;
        }
    }

    public static enum GenWay {
        AS_JAVA(NbBundle.getMessage(CGSGenerator.class, (String)"JAVA_STYLE"), "__construct($${PROPERTY})", "get${UpFirstLetterProperty}", "set${UpFirstLetterProperty}"),
        WITH_UNDERSCORE(NbBundle.getMessage(CGSGenerator.class, (String)"ADD_UNDERSCORE"), "__construct($${PROPERTY})", "get_${PROPERTY}", "set_${PROPERTY}"),
        WITHOUT_UNDERSCORE(NbBundle.getMessage(CGSGenerator.class, (String)"REMOVE_UNDERSCORE"), "__construct($${PropertyWithoutUnderscore})", "get${UpFirstLetterPropertyWithoutUnderscore}", "set${UpFirstLetterPropertyWithoutUnderscore}");

        private String constructorTemplate;
        private String getterTemplate;
        private String setterTemplate;
        private String simpleDescription;

        private GenWay(String simpleDescription, String constructorTemplate, String getterTemplate, String setterTemplate) {
            this.constructorTemplate = constructorTemplate;
            this.getterTemplate = getterTemplate;
            this.setterTemplate = setterTemplate;
            this.simpleDescription = simpleDescription;
        }

        public String getConstructorTemplate() {
            return this.constructorTemplate;
        }

        public String getGetterTemplate() {
            return this.getterTemplate;
        }

        public String getSetterTemplate() {
            return this.setterTemplate;
        }

        public String getSimpleDescription() {
            return this.simpleDescription;
        }

        public String getConstructorExample(String property) {
            return this.createExample(this.getConstructorTemplate(), property);
        }

        public String getGetterExample(String property) {
            return this.createExample(this.getGetterTemplate(), property);
        }

        public String getSetterExample(String property) {
            return this.createExample(this.getSetterTemplate(), property);
        }

        private String createExample(String template, String property) {
            String example = template;
            if (template.contains(CGSGenerator.PROPERTY)) {
                example = example.replace(CGSGenerator.PROPERTY, property);
            }
            if (template.contains(CGSGenerator.UP_FIRST_LETTER_PROPERTY)) {
                example = example.replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY, CGSGenerator.upFirstLetter(property));
            }
            if (template.contains(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE)) {
                example = example.replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, CGSGenerator.upFirstLetterWithoutUnderscore(property));
            }
            if (template.contains(CGSGenerator.PROPERTY_WITHOUT_UNDERSCORE)) {
                example = example.replace(CGSGenerator.PROPERTY_WITHOUT_UNDERSCORE, CGSGenerator.withoutUnderscore(property));
            }
            return example;
        }
    }

    public static enum GenType {
        CONSTRUCTOR(PanelStrategy.CONSTRUCTOR, FluentSetterStrategy.INVISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_CONSTRUCTOR");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                DefaultComboBoxModel<ComboBoxModelElement> result = new DefaultComboBoxModel<ComboBoxModelElement>();
                for (GenWay way : GenWay.values()) {
                    if (way.equals((Object)GenWay.WITH_UNDERSCORE)) continue;
                    result.addElement(new ComboBoxModelElement(way.getSimpleDescription() + ": " + way.getConstructorExample(propertyName), way));
                }
                return result;
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_CONSTRUCTOR");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_CONSTRUCTOR");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo, JTextComponent textComponent) {
                StringBuilder params = new StringBuilder();
                StringBuilder assignments = new StringBuilder();
                for (Property property : cgsInfo.getProperties()) {
                    String paramName;
                    String name = property.getName();
                    String string = paramName = cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.withoutUnderscore(name) : name;
                    if (!property.isSelected()) continue;
                    params.append(", ");
                    String type = property.getType();
                    if (type != null && !type.isEmpty()) {
                        params.append(property.getTypeForTemplate());
                    }
                    params.append("$").append(paramName);
                    assignments.append(ASSIGNMENT_TEMPLATE.replace(CGSGenerator.PROPERTY, name).replace(CGSGenerator.PARAM_NAME, paramName));
                }
                if (params.length() == 0) {
                    params.append(", ");
                }
                return CONSTRUCTOR_TEMPLATE.replace(CGSGenerator.PARAMS, params.toString().substring(2)).replace(CGSGenerator.ASSIGNMENTS, assignments);
            }
        }
        ,
        GETTER(PanelStrategy.CONSTRUCTOR, FluentSetterStrategy.INVISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                DefaultComboBoxModel<ComboBoxModelElement> result = new DefaultComboBoxModel<ComboBoxModelElement>();
                for (GenWay way : GenWay.values()) {
                    result.addElement(new ComboBoxModelElement(way.getSimpleDescription() + ": " + way.getGetterExample(propertyName), way));
                }
                return result;
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_GETTER");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_GETTERS");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo, JTextComponent textComponent) {
                StringBuilder getters = new StringBuilder();
                for (Property property : cgsInfo.getPossibleGetters()) {
                    if (!property.isSelected()) continue;
                    String name = property.getName();
                    String changedName = cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.upFirstLetterWithoutUnderscore(name) : CGSGenerator.upFirstLetter(name);
                    String methodName = CGSGenerator.getUnusedMethodName(new ArrayList(), changedName);
                    getters.append(this.getGetterTemplate(cgsInfo).replace(CGSGenerator.PROPERTY, name).replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY, methodName).replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, methodName));
                    getters.append(NEW_LINE);
                }
                return getters.toString();
            }
        }
        ,
        SETTER(PanelStrategy.CONSTRUCTOR, FluentSetterStrategy.VISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_SETTERS");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                DefaultComboBoxModel<ComboBoxModelElement> result = new DefaultComboBoxModel<ComboBoxModelElement>();
                for (GenWay way : GenWay.values()) {
                    result.addElement(new ComboBoxModelElement(way.getSimpleDescription() + ": " + way.getSetterExample(propertyName), way));
                }
                return result;
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_SETTER");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_SETTERS");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo, JTextComponent textComponent) {
                StringBuilder setters = new StringBuilder();
                for (Property property : cgsInfo.getPossibleSetters()) {
                    if (!property.isSelected()) continue;
                    String name = property.getName();
                    String paramName = cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.withoutUnderscore(name) : name;
                    String type = property.getType();
                    String changedName = cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.upFirstLetterWithoutUnderscore(name) : CGSGenerator.upFirstLetter(name);
                    String methodName = CGSGenerator.getUnusedMethodName(new ArrayList(), changedName);
                    setters.append(this.getSetterTemplate(cgsInfo).replace(CGSGenerator.PROPERTY, name).replace(CGSGenerator.PARAM_NAME, paramName).replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY, methodName).replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, methodName).replace(CGSGenerator.PARAM_TYPE, type.isEmpty() ? type : property.getTypeForTemplate()));
                    setters.append(NEW_LINE);
                }
                return setters.toString();
            }
        }
        ,
        GETTER_AND_SETTER(PanelStrategy.CONSTRUCTOR, FluentSetterStrategy.VISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS_AND_SETTERS");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                DefaultComboBoxModel<ComboBoxModelElement> result = new DefaultComboBoxModel<ComboBoxModelElement>();
                for (GenWay way : GenWay.values()) {
                    result.addElement(new ComboBoxModelElement(way.getSimpleDescription() + ": " + way.getGetterExample(propertyName) + ", " + way.getSetterExample(propertyName), way));
                }
                return result;
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_GETTER_AND_SETTER");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_GETTERS_AND_SETTERS");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo, JTextComponent textComponent) {
                StringBuilder gettersAndSetters = new StringBuilder();
                for (Property property : cgsInfo.getPossibleSetters()) {
                    if (!property.isSelected()) continue;
                    String name = property.getName();
                    String changedName = cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.upFirstLetterWithoutUnderscore(name) : CGSGenerator.upFirstLetter(name);
                    String methodName = CGSGenerator.getUnusedMethodName(new ArrayList(), changedName);
                    String paramName = cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.withoutUnderscore(name) : name;
                    gettersAndSetters.append(this.getGetterTemplate(cgsInfo).replace(CGSGenerator.PROPERTY, name).replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY, CGSGenerator.upFirstLetter(methodName)).replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, methodName));
                    gettersAndSetters.append(NEW_LINE);
                    String type = property.getType();
                    gettersAndSetters.append(this.getSetterTemplate(cgsInfo).replace(CGSGenerator.PROPERTY, name).replace(CGSGenerator.PARAM_NAME, paramName).replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY, CGSGenerator.upFirstLetter(methodName)).replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, methodName).replace(CGSGenerator.PARAM_TYPE, type.isEmpty() ? type : property.getTypeForTemplate()));
                    gettersAndSetters.append(NEW_LINE);
                }
                return gettersAndSetters.toString();
            }
        }
        ,
        METHODS(PanelStrategy.METHOD, FluentSetterStrategy.INVISIBLE){

            @Override
            public String getPanelTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_METHODS");
            }

            @Override
            public ComboBoxModel getModel(String propertyName) {
                return new DefaultComboBoxModel();
            }

            @Override
            public String getDisplayName() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_METHOD");
            }

            @Override
            public String getDialogTitle() {
                return NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_METHODS");
            }

            @Override
            public String getTemplateText(CGSInfo cgsInfo, JTextComponent textComponent) {
                StringBuilder inheritedMethods = new StringBuilder();
                for (MethodProperty methodProperty : cgsInfo.getPossibleMethods()) {
                    TypeNameResolver typeNameResolver;
                    if (!methodProperty.isSelected()) continue;
                    MethodElement method = methodProperty.getMethod();
                    TypeNameResolver typeNameResolver2 = typeNameResolver = method.getParameters().isEmpty() ? TypeNameResolverImpl.forNull() : CodegenUtils.createSmarterTypeNameResolver(method, ModelUtils.getModel(Source.create((Document)textComponent.getDocument()), 300), textComponent.getCaretPosition());
                    if (method.isAbstract() || method.isMagic() || method.getType().isInterface()) {
                        inheritedMethods.append(method.asString(BaseFunctionElement.PrintAs.DeclarationWithEmptyBody, typeNameResolver).replace("abstract ", ""));
                    } else {
                        inheritedMethods.append(method.asString(BaseFunctionElement.PrintAs.DeclarationWithParentCallInBody, typeNameResolver).replace("abstract ", ""));
                    }
                    inheritedMethods.append(NEW_LINE);
                }
                return inheritedMethods.toString();
            }
        };

        private final PanelStrategy panelStrategy;
        private final FluentSetterStrategy fluentSetterStrategy;

        public abstract String getPanelTitle();

        public abstract ComboBoxModel getModel(String var1);

        public abstract String getDisplayName();

        public abstract String getDialogTitle();

        public abstract String getTemplateText(CGSInfo var1, JTextComponent var2);

        private GenType(PanelStrategy panelStrategy, FluentSetterStrategy fluentSetterStrategy) {
            this.panelStrategy = panelStrategy;
            this.fluentSetterStrategy = fluentSetterStrategy;
        }

        public JPanel createPanel(CGSInfo cgsInfo) {
            return this.panelStrategy.createPanel(this, cgsInfo);
        }

        public boolean isFluentSetterVisible() {
            return this.fluentSetterStrategy.isFluentSetterVisible();
        }

        String getGetterTemplate(CGSInfo cgsInfo) {
            return GETTER_TEMPLATE.replace(CGSGenerator.TEMPLATE_NAME, cgsInfo.getHowToGenerate().getGetterTemplate());
        }

        String getSetterTemplate(CGSInfo cgsInfo) {
            String preparedSetterTemplate = SETTER_TEMPLATE.replace(CGSGenerator.TEMPLATE_NAME, cgsInfo.getHowToGenerate().getSetterTemplate());
            return cgsInfo.isFluentSetter() ? preparedSetterTemplate.replace(CGSGenerator.FLUENT_SETTER, "return $this;" + NEW_LINE) : preparedSetterTemplate.replace(CGSGenerator.FLUENT_SETTER, "");
        }

        private static enum FluentSetterStrategy {
            VISIBLE{

                @Override
                boolean isFluentSetterVisible() {
                    return true;
                }
            }
            ,
            INVISIBLE{

                @Override
                boolean isFluentSetterVisible() {
                    return false;
                }
            };


            abstract boolean isFluentSetterVisible();
        }

        private static enum PanelStrategy {
            CONSTRUCTOR{

                @Override
                JPanel createPanel(GenType genType, CGSInfo cgsInfo) {
                    return new ConstructorPanel(genType, cgsInfo);
                }
            }
            ,
            METHOD{

                @Override
                JPanel createPanel(GenType genType, CGSInfo cgsInfo) {
                    return new MethodPanel(cgsInfo);
                }
            };


            abstract JPanel createPanel(GenType var1, CGSInfo var2);
        }
    }
}

