/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.php.editor.actions.Bundle;
import org.netbeans.modules.php.editor.actions.FixUsesAction;
import org.netbeans.modules.php.editor.actions.IconsUtils;
import org.netbeans.modules.php.editor.actions.ImportData;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;

public class ImportDataCreator {
    public static final String NS_SEPARATOR = "\\";
    private final Map<String, List<UsedNamespaceName>> usedNames;
    private final ElementQuery.Index phpIndex;
    private final QualifiedName currentNamespace;
    private boolean shouldShowUsesPanel = false;
    private final FixUsesAction.Options options;
    private final List<PossibleItem> possibleItems = new ArrayList<PossibleItem>();

    private static Collection<TypeElement> sortTypeElements(Collection<TypeElement> filteredTypeElements) {
        ArrayList<TypeElement> sortedTypeElements = new ArrayList<TypeElement>(filteredTypeElements);
        Collections.sort(sortedTypeElements, new TypeElementsComparator());
        return sortedTypeElements;
    }

    public ImportDataCreator(Map<String, List<UsedNamespaceName>> usedNames, ElementQuery.Index phpIndex, QualifiedName currentNamespace, FixUsesAction.Options options) {
        this.usedNames = usedNames;
        this.phpIndex = phpIndex;
        this.currentNamespace = currentNamespace;
        this.options = options;
    }

    public ImportData create() {
        for (String typeName : this.usedNames.keySet()) {
            this.processTypeName(typeName);
        }
        ImportData data = new ImportData();
        for (PossibleItem possibleItem : this.possibleItems) {
            possibleItem.insertData(data);
        }
        data.shouldShowUsesPanel = this.shouldShowUsesPanel;
        return data;
    }

    private void processTypeName(String typeName) {
        Collection<TypeElement> possibleTypes = this.fetchPossibleTypes(typeName);
        Collection<TypeElement> filteredDuplicates = this.filterDuplicates(possibleTypes);
        Collection<TypeElement> filteredExactUnqualifiedNames = this.filterExactUnqualifiedName(filteredDuplicates, typeName);
        if (filteredExactUnqualifiedNames.isEmpty()) {
            this.possibleItems.add(new EmptyItem(typeName));
        } else {
            Collection<TypeElement> filteredTypeElements = this.filterTypesFromCurrentNamespace(filteredExactUnqualifiedNames);
            if (!filteredTypeElements.isEmpty()) {
                this.possibleItems.add(new ValidItem(typeName, filteredTypeElements));
            }
        }
    }

    private Collection<TypeElement> fetchPossibleTypes(String typeName) {
        Set<ClassElement> possibleClasses = this.phpIndex.getClasses(NameKind.prefix(typeName));
        Set<InterfaceElement> possibleIfaces = this.phpIndex.getInterfaces(NameKind.prefix(typeName));
        HashSet<TypeElement> possibleTypes = new HashSet<TypeElement>();
        possibleTypes.addAll(possibleClasses);
        possibleTypes.addAll(possibleIfaces);
        return possibleTypes;
    }

    private Collection<TypeElement> filterDuplicates(Collection<TypeElement> possibleTypes) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        HashSet<String> filteredTypeElements = new HashSet<String>();
        for (TypeElement typeElement : possibleTypes) {
            String typeElementName = typeElement.toString();
            if (filteredTypeElements.contains(typeElementName)) continue;
            filteredTypeElements.add(typeElementName);
            result.add(typeElement);
        }
        return result;
    }

    private Collection<TypeElement> filterExactUnqualifiedName(Collection<TypeElement> possibleTypes, String typeName) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeElement typeElement : possibleTypes) {
            if (!typeElement.getFullyQualifiedName().toString().endsWith(typeName)) continue;
            result.add(typeElement);
        }
        return result;
    }

    private Collection<TypeElement> filterTypesFromCurrentNamespace(Collection<TypeElement> possibleTypes) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeElement typeElement : possibleTypes) {
            if (typeElement.getNamespaceName().equals(this.currentNamespace)) continue;
            result.add(typeElement);
        }
        return result;
    }

    private QualifiedName createExactMatchName(QualifiedName currentType) {
        QualifiedName result = currentType;
        if (!currentType.getKind().isFullyQualified()) {
            String namespace = this.currentNamespace.toString();
            if (currentType.getSegments().size() > 1) {
                if (!namespace.trim().isEmpty()) {
                    namespace = namespace + NS_SEPARATOR;
                }
                namespace = namespace + currentType.toString(currentType.getSegments().size() - 2);
            }
            result = QualifiedName.createFullyQualified(currentType.getSegments().getLast(), namespace);
        }
        return result;
    }

    private boolean hasDefaultNamespaceName(Collection<TypeElement> possibleTypes) {
        boolean result = false;
        for (TypeElement typeElement : possibleTypes) {
            if (!typeElement.getNamespaceName().isDefaultNamespace()) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean hasExactName(Collection<TypeElement> typeElements, QualifiedName exactName) {
        boolean result = false;
        for (TypeElement typeElement : typeElements) {
            if (!typeElement.getFullyQualifiedName().equals(exactName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static class TypeElementsComparator
    implements Comparator<TypeElement>,
    Serializable {
        private TypeElementsComparator() {
        }

        @Override
        public int compare(TypeElement o1, TypeElement o2) {
            return o1.getFullyQualifiedName().toString().compareToIgnoreCase(o2.getFullyQualifiedName().toString()) * -1;
        }
    }

    private static class VariantsComparator
    implements Comparator<ImportData.ItemVariant>,
    Serializable {
        private VariantsComparator() {
        }

        @Override
        public int compare(ImportData.ItemVariant o1, ImportData.ItemVariant o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    private final class ValidItem
    implements PossibleItem {
        private final Collection<TypeElement> filteredTypeElements;
        private final String typeName;

        private ValidItem(String typeName, Collection<TypeElement> filteredTypeElements) {
            this.typeName = typeName;
            this.filteredTypeElements = filteredTypeElements;
        }

        @Override
        public void insertData(ImportData data) {
            Collection sortedTypeElements = ImportDataCreator.sortTypeElements(this.filteredTypeElements);
            ArrayList<ImportData.ItemVariant> variants = new ArrayList<ImportData.ItemVariant>();
            ImportData.ItemVariant defaultValue = null;
            boolean isFirst = true;
            for (TypeElement typeElement : sortedTypeElements) {
                ImportData.ItemVariant itemVariant = new ImportData.ItemVariant(typeElement.getFullyQualifiedName().toString(), ImportData.ItemVariant.UsagePolicy.CAN_BE_USED, IconsUtils.getElementIcon(typeElement.getPhpElementKind()));
                variants.add(itemVariant);
                if (isFirst) {
                    defaultValue = itemVariant;
                    isFirst = false;
                }
                ImportDataCreator.this.shouldShowUsesPanel = true;
            }
            ImportData.ItemVariant dontUseItemVariant = new ImportData.ItemVariant(Bundle.DoNotUseType(), ImportData.ItemVariant.UsagePolicy.CAN_NOT_BE_USED);
            variants.add(dontUseItemVariant);
            QualifiedName qualifiedTypeName = QualifiedName.create(this.typeName);
            if (qualifiedTypeName.getKind().isFullyQualified()) {
                if (ImportDataCreator.this.options.preferFullyQualifiedNames()) {
                    defaultValue = dontUseItemVariant;
                }
            } else {
                QualifiedName exactMatchName = ImportDataCreator.this.createExactMatchName(qualifiedTypeName);
                if (ImportDataCreator.this.currentNamespace.isDefaultNamespace() && ImportDataCreator.this.hasDefaultNamespaceName(sortedTypeElements) || ImportDataCreator.this.hasExactName(sortedTypeElements, exactMatchName)) {
                    defaultValue = dontUseItemVariant;
                }
            }
            Collections.sort(variants, new VariantsComparator());
            data.add(new ImportData.DataItem(this.typeName, variants, defaultValue, (List)ImportDataCreator.this.usedNames.get(this.typeName)));
        }
    }

    private static class EmptyItem
    implements PossibleItem {
        private final String typeName;

        public EmptyItem(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public void insertData(ImportData data) {
            ImportData.ItemVariant itemVariant = new ImportData.ItemVariant(Bundle.CanNotBeResolved(), ImportData.ItemVariant.UsagePolicy.CAN_NOT_BE_USED, IconsUtils.getErrorGlyphIcon());
            data.add(new ImportData.DataItem(this.typeName, Arrays.asList(itemVariant), itemVariant));
        }
    }

    private static interface PossibleItem {
        public void insertData(ImportData var1);
    }
}

