/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;

public class ImportData {
    public volatile boolean shouldShowUsesPanel;
    public volatile int caretPosition;
    private final List<DataItem> dataItems = new ArrayList<DataItem>();

    public void add(DataItem item) {
        this.dataItems.add(item);
    }

    public List<DataItem> getItems() {
        return new ArrayList<DataItem>(this.dataItems);
    }

    public List<ItemVariant> getDefaultVariants() {
        ArrayList<ItemVariant> result = new ArrayList<ItemVariant>();
        for (DataItem dataItem : this.dataItems) {
            result.add(dataItem.getDefaultVariant());
        }
        return result;
    }

    public static class ItemVariant {
        private final String name;
        private final UsagePolicy usagePolicy;
        private final Icon icon;

        public ItemVariant(String name, UsagePolicy usagePolicy) {
            this(name, usagePolicy, null);
        }

        public ItemVariant(String name, UsagePolicy usagePolicy, Icon icon) {
            assert (name != null);
            this.name = name;
            this.usagePolicy = usagePolicy;
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public boolean canBeUsed() {
            return this.usagePolicy.canBeUsed();
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 59 * hash + (this.icon != null ? this.icon.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemVariant other = (ItemVariant)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.icon == other.icon || this.icon != null && this.icon.equals(other.icon);
        }

        public static enum UsagePolicy {
            CAN_BE_USED{

                @Override
                boolean canBeUsed() {
                    return true;
                }
            }
            ,
            CAN_NOT_BE_USED{

                @Override
                boolean canBeUsed() {
                    return false;
                }
            };


            abstract boolean canBeUsed();
        }
    }

    public static class DataItem {
        private final String typeName;
        private final List<ItemVariant> variants;
        private final ItemVariant defaultVariant;
        private final List<UsedNamespaceName> usedNamespaceNames;

        public DataItem(String typeName, List<ItemVariant> variants, ItemVariant defaultVariant) {
            this(typeName, variants, defaultVariant, Collections.EMPTY_LIST);
        }

        public DataItem(String typeName, List<ItemVariant> variants, ItemVariant defaultVariant, List<UsedNamespaceName> usedNamespaceNames) {
            this.typeName = typeName;
            this.variants = variants;
            this.defaultVariant = defaultVariant;
            this.usedNamespaceNames = usedNamespaceNames;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public List<ItemVariant> getVariants() {
            return new ArrayList<ItemVariant>(this.variants);
        }

        public Icon[] getVariantIcons() {
            Icon[] variantIcons = new Icon[this.variants.size()];
            for (int i = 0; i < this.variants.size(); ++i) {
                ItemVariant itemVariant = this.variants.get(i);
                variantIcons[i] = itemVariant.getIcon();
            }
            return variantIcons;
        }

        public ItemVariant getDefaultVariant() {
            return this.defaultVariant;
        }

        public List<UsedNamespaceName> getUsedNamespaceNames() {
            return new ArrayList<UsedNamespaceName>(this.usedNamespaceNames);
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.typeName != null ? this.typeName.hashCode() : 0);
            hash = 37 * hash + (this.variants != null ? ((Object)this.variants).hashCode() : 0);
            hash = 37 * hash + (this.defaultVariant != null ? this.defaultVariant.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataItem other = (DataItem)obj;
            if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
                return false;
            }
            if (!(this.variants == other.variants || this.variants != null && ((Object)this.variants).equals(other.variants))) {
                return false;
            }
            return !(this.defaultVariant == null ? other.defaultVariant != null : !this.defaultVariant.equals(other.defaultVariant));
        }
    }
}

