/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.php.editor.actions.FixUsesAction;
import org.netbeans.modules.php.editor.actions.ImportData;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.SemanticAnalysis;
import org.netbeans.modules.php.editor.parser.UnusedOffsetRanges;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.util.Exceptions;

public class FixUsesPerformer {
    private static final String NEW_LINE = "\n";
    private static final String SEMICOLON = ";";
    private static final String SPACE = " ";
    private static final String USE_KEYWORD = "use";
    private static final String USE_PREFIX = "\nuse ";
    private static final String AS_KEYWORD = "as";
    private static final String AS_CONCAT = " as ";
    private static final String EMPTY_STRING = "";
    private static final String COLON = ",";
    private final PHPParseResult parserResult;
    private final ImportData importData;
    private final List<ImportData.ItemVariant> selections;
    private final boolean removeUnusedUses;
    private final FixUsesAction.Options options;
    private EditList editList;
    private BaseDocument baseDocument;

    public FixUsesPerformer(PHPParseResult parserResult, ImportData importData, List<ImportData.ItemVariant> selections, boolean removeUnusedUses, FixUsesAction.Options options) {
        this.parserResult = parserResult;
        this.importData = importData;
        this.selections = selections;
        this.removeUnusedUses = removeUnusedUses;
        this.options = options;
    }

    public void perform() {
        Document document = this.parserResult.getSnapshot().getSource().getDocument(false);
        if (document instanceof BaseDocument) {
            this.baseDocument = (BaseDocument)document;
            this.editList = new EditList(this.baseDocument);
            this.processExistingUses();
            this.processSelections();
            this.editList.apply();
        }
    }

    private void processSelections() {
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this.parserResult.getModel().getFileScope(), this.importData.caretPosition);
        assert (namespaceScope != null);
        int startOffset = FixUsesPerformer.getOffset(this.baseDocument, namespaceScope);
        ArrayList<String> useParts = new ArrayList<String>();
        Collection<? extends UseScope> declaredUses = namespaceScope.getDeclaredUses();
        for (UseScope useScope : declaredUses) {
            this.processUseElement(useScope, useParts);
        }
        for (int i = 0; i < this.selections.size(); ++i) {
            ImportData.ItemVariant itemVariant = this.selections.get(i);
            if (!itemVariant.canBeUsed()) continue;
            SanitizedUse sanitizedUse = new SanitizedUse(this.modifyUseName(itemVariant.getName()), useParts, this.createAliasStrategy(i, useParts, this.selections));
            if (sanitizedUse.shouldBeUsed()) {
                useParts.add(sanitizedUse.getSanitizedUsePart());
            }
            for (UsedNamespaceName usedNamespaceName : this.importData.getItems().get(i).getUsedNamespaceNames()) {
                this.editList.replace(usedNamespaceName.getOffset(), usedNamespaceName.getReplaceLength(), sanitizedUse.getReplaceName(usedNamespaceName), false, 0);
            }
        }
        this.editList.replace(startOffset, 0, this.createInsertString(useParts), false, 0);
    }

    private AliasStrategy createAliasStrategy(int selectionIndex, List<String> existingUseParts, List<ImportData.ItemVariant> selections) {
        AliasStrategyImpl createAliasStrategy = this.options.aliasesCapitalsOfNamespaces() ? new CapitalsStrategy(selectionIndex, existingUseParts, selections) : new UnqualifiedNameStrategy(selectionIndex, existingUseParts, selections);
        return createAliasStrategy;
    }

    private void processUseElement(UseScope useElement, List<String> useParts) {
        if (this.isUsed(useElement) || !this.removeUnusedUses) {
            AliasedName aliasedName = useElement.getAliasedName();
            if (aliasedName != null) {
                useParts.add(this.modifyUseName(aliasedName.getRealName().toString()) + AS_CONCAT + aliasedName.getAliasName());
            } else {
                useParts.add(this.modifyUseName(useElement.getName()));
            }
        }
    }

    private String modifyUseName(String useName) {
        String result = useName;
        result = this.options.startUseWithNamespaceSeparator() ? (result.startsWith("\\") ? result : "\\" + result) : (result.startsWith("\\") ? result.substring("\\".length()) : result);
        return result;
    }

    private boolean isUsed(UseScope useElement) {
        boolean result = true;
        for (UnusedOffsetRanges unusedRange : SemanticAnalysis.computeUnusedUsesOffsetRanges(this.parserResult)) {
            if (!unusedRange.getRangeToVisualise().containsInclusive(useElement.getOffset())) continue;
            result = false;
            break;
        }
        return result;
    }

    private String createInsertString(List<String> useParts) {
        StringBuilder insertString = new StringBuilder();
        Collections.sort(useParts, new UsePartsComparator());
        if (useParts.size() > 0) {
            insertString.append(NEW_LINE);
        }
        if (this.options.preferMultipleUseStatementsCombined()) {
            CodeStyle codeStyle = CodeStyle.get((Document)this.baseDocument);
            String indentString = IndentUtils.createIndentString((int)codeStyle.getIndentSize(), (boolean)codeStyle.expandTabToSpaces(), (int)codeStyle.getTabSize());
            insertString.append(USE_PREFIX);
            for (int i = 0; i < useParts.size(); ++i) {
                String usePart = useParts.get(i);
                if (i != 0) {
                    insertString.append(indentString);
                }
                insertString.append(usePart);
                insertString.append(i + 1 == useParts.size() ? SEMICOLON : ",\n");
            }
        } else {
            for (String usePart : useParts) {
                insertString.append(USE_PREFIX).append(usePart).append(SEMICOLON);
            }
        }
        return insertString.toString();
    }

    private void processExistingUses() {
        ExistingUseStatementVisitor visitor = new ExistingUseStatementVisitor();
        Program program = this.parserResult.getProgram();
        if (program != null) {
            program.accept(visitor);
        }
        for (OffsetRange offsetRange : visitor.getUsedRanges()) {
            int startOffset = this.getOffsetWithoutLeadingWhitespaces(offsetRange.getStart());
            this.editList.replace(startOffset, offsetRange.getEnd() - startOffset, EMPTY_STRING, false, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOffsetWithoutLeadingWhitespaces(int startOffset) {
        int result = startOffset;
        this.baseDocument.readLock();
        try {
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)this.baseDocument, startOffset);
            if (ts != null) {
                ts.move(startOffset);
                while (ts.movePrevious() && ((PHPTokenId)ts.token().id()).equals((Object)PHPTokenId.WHITESPACE)) {
                    result = ts.offset();
                }
            }
        }
        finally {
            this.baseDocument.readUnlock();
        }
        return result;
    }

    private static int getOffset(BaseDocument baseDocument, NamespaceScope namespaceScope) {
        try {
            return Utilities.getRowEnd((BaseDocument)baseDocument, (int)FixUsesPerformer.getReferenceElement(namespaceScope).getOffset());
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 0;
        }
    }

    private static ModelElement getReferenceElement(NamespaceScope namespaceScope) {
        Scope offsetElement = null;
        Collection<? extends UseScope> declaredUses = namespaceScope.getDeclaredUses();
        for (UseScope useScope : declaredUses) {
            if (offsetElement != null && offsetElement.getOffset() >= useScope.getOffset()) continue;
            offsetElement = useScope;
        }
        return offsetElement != null ? offsetElement : namespaceScope;
    }

    private static class ExistingUseStatementVisitor
    extends DefaultVisitor {
        private final List<OffsetRange> usedRanges = new LinkedList<OffsetRange>();

        private ExistingUseStatementVisitor() {
        }

        public List<OffsetRange> getUsedRanges() {
            return Collections.unmodifiableList(this.usedRanges);
        }

        @Override
        public void visit(UseStatement node) {
            this.usedRanges.add(new OffsetRange(node.getStartOffset(), node.getEndOffset()));
        }
    }

    private static class UsePartsComparator
    implements Comparator<String>,
    Serializable {
        private UsePartsComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }

    private static class SanitizedUse {
        private final String use;
        private String alias;
        private final boolean shouldBeUsed;

        public SanitizedUse(String use, List<String> existingUseParts, AliasStrategy createAliasStrategy) {
            this.use = use;
            QualifiedName qualifiedName = QualifiedName.create(use);
            if (!existingUseParts.contains(use)) {
                this.alias = createAliasStrategy.createAlias(qualifiedName);
                this.shouldBeUsed = true;
            } else {
                this.shouldBeUsed = false;
            }
        }

        public String getSanitizedUsePart() {
            return this.hasAlias() ? this.use + FixUsesPerformer.AS_CONCAT + this.alias : this.use;
        }

        private boolean hasAlias() {
            return this.alias != null && !this.alias.isEmpty();
        }

        public String getReplaceName(UsedNamespaceName usedNamespaceName) {
            return this.hasAlias() ? this.alias : usedNamespaceName.getReplaceName();
        }

        public boolean shouldBeUsed() {
            return this.shouldBeUsed;
        }
    }

    private static class UnqualifiedNameStrategy
    extends AliasStrategyImpl {
        public UnqualifiedNameStrategy(int selectionIndex, List<String> existingUseParts, List<ImportData.ItemVariant> selections) {
            super(selectionIndex, existingUseParts, selections);
        }

        @Override
        protected String getPossibleAliasName(QualifiedName qualifiedName) {
            return qualifiedName.getName();
        }
    }

    private static class CapitalsStrategy
    extends AliasStrategyImpl {
        public CapitalsStrategy(int selectionIndex, List<String> existingUseParts, List<ImportData.ItemVariant> selections) {
            super(selectionIndex, existingUseParts, selections);
        }

        @Override
        protected String getPossibleAliasName(QualifiedName qualifiedName) {
            StringBuilder sb = new StringBuilder();
            for (String segment : qualifiedName.getSegments()) {
                sb.append(Character.toUpperCase(segment.charAt(0)));
            }
            return sb.toString();
        }
    }

    private static abstract class AliasStrategyImpl
    implements AliasStrategy {
        private final int selectionIndex;
        private final List<String> existingUseParts;
        private final List<ImportData.ItemVariant> selections;

        public AliasStrategyImpl(int selectionIndex, List<String> existingUseParts, List<ImportData.ItemVariant> selections) {
            this.selectionIndex = selectionIndex;
            this.existingUseParts = existingUseParts;
            this.selections = selections;
        }

        @Override
        public String createAlias(QualifiedName qualifiedName) {
            String possibleAliasedName;
            String result = FixUsesPerformer.EMPTY_STRING;
            String newAliasedName = possibleAliasedName = this.getPossibleAliasName(qualifiedName);
            int i = 1;
            while (this.existSelectionWith(newAliasedName, this.selectionIndex) || this.existUseWith(newAliasedName)) {
                result = newAliasedName = possibleAliasedName + ++i;
            }
            return result.isEmpty() && this.mustHaveAlias(qualifiedName) ? possibleAliasedName : result;
        }

        private boolean mustHaveAlias(QualifiedName qualifiedName) {
            String unqualifiedName = qualifiedName.getName();
            return this.existSelectionWith(unqualifiedName, this.selectionIndex) || this.existUseWith(unqualifiedName);
        }

        private boolean existSelectionWith(String name, int selectionIndex) {
            boolean result = false;
            for (int i = selectionIndex + 1; i < this.selections.size(); ++i) {
                if (!this.endsWithName(this.selections.get(i).getName(), name)) continue;
                result = true;
            }
            return result;
        }

        private boolean existUseWith(String name) {
            boolean result = false;
            for (String existingUsePart : this.existingUseParts) {
                if (!this.endsWithName(existingUsePart, name) && !existingUsePart.endsWith(FixUsesPerformer.SPACE + name)) continue;
                result = true;
            }
            return result;
        }

        private boolean endsWithName(String usePart, String name) {
            return usePart.endsWith("\\" + name);
        }

        protected abstract String getPossibleAliasName(QualifiedName var1);
    }

    private static interface AliasStrategy {
        public String createAlias(QualifiedName var1);
    }
}

