/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.editor.actions.Bundle;
import org.netbeans.modules.php.editor.actions.FixDuplicateImportStmts;
import org.netbeans.modules.php.editor.actions.FixUsesPerformer;
import org.netbeans.modules.php.editor.actions.ImportData;
import org.netbeans.modules.php.editor.actions.ImportDataCreator;
import org.netbeans.modules.php.editor.actions.UsedNamesComputer;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class FixUsesAction
extends BaseAction {
    static final String ACTION_NAME = "fix-uses";
    private static final String PREFERENCES_NODE_KEY = FixUsesAction.class.getName();
    private static final String KEY_REMOVE_UNUSED_USES = "remove.unused.uses";
    private static final boolean REMOVE_UNUSED_USES_DEFAULT = true;
    private static final RequestProcessor WORKER = new RequestProcessor(FixUsesAction.class.getName(), 1);

    public FixUsesAction() {
        super(10);
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (target != null) {
            final int caretPosition = target.getCaretPosition();
            final AtomicBoolean cancel = new AtomicBoolean();
            final AtomicReference importData = new AtomicReference();
            final UserTask task = new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parserResult = resultIterator.getParserResult();
                    if (parserResult instanceof PHPParseResult) {
                        if (cancel.get()) {
                            return;
                        }
                        ImportData data = FixUsesAction.computeUses((PHPParseResult)parserResult, caretPosition);
                        if (cancel.get()) {
                            return;
                        }
                        if (data.shouldShowUsesPanel) {
                            if (!cancel.get()) {
                                importData.set(data);
                            }
                        } else {
                            FixUsesAction.performFixUses((PHPParseResult)parserResult, data, data.getDefaultVariants(), FixUsesAction.isRemoveUnusedUses());
                        }
                    }
                }
            };
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ParserManager.parse(Collections.singleton(Source.create((Document)target.getDocument())), (UserTask)task);
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }, (String)Bundle.LongName(), (AtomicBoolean)cancel, (boolean)false);
            if (importData.get() != null && !cancel.get()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FixUsesAction.showFixUsesDialog(target, (ImportData)importData.get());
                    }
                });
            }
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(FixUsesAction.class).node(PREFERENCES_NODE_KEY);
    }

    private static boolean isRemoveUnusedUses() {
        return FixUsesAction.getPreferences().getBoolean(KEY_REMOVE_UNUSED_USES, true);
    }

    private static void setRemoveUnusedUses(boolean removeUnusedUses) {
        FixUsesAction.getPreferences().putBoolean(KEY_REMOVE_UNUSED_USES, removeUnusedUses);
    }

    private static ImportData computeUses(PHPParseResult parserResult, int caretPosition) {
        Map<String, List<UsedNamespaceName>> filteredExistingNames = new UsedNamesComputer(parserResult, caretPosition).computeNames();
        ElementQuery.Index index = parserResult.getModel().getIndexScope().getIndex();
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(parserResult.getModel().getFileScope(), caretPosition);
        assert (namespaceScope != null);
        ImportData importData = new ImportDataCreator(filteredExistingNames, index, namespaceScope.getNamespaceName(), FixUsesAction.createOptions(parserResult)).create();
        importData.caretPosition = caretPosition;
        return importData;
    }

    private static void performFixUses(PHPParseResult parserResult, ImportData importData, List<ImportData.ItemVariant> selections, boolean removeUnusedUses) {
        new FixUsesPerformer(parserResult, importData, selections, removeUnusedUses, FixUsesAction.createOptions(parserResult)).perform();
    }

    private static Options createOptions(PHPParseResult parserResult) {
        Document document = parserResult.getSnapshot().getSource().getDocument(false);
        CodeStyle codeStyle = CodeStyle.get(document);
        return new Options(codeStyle);
    }

    private static void showFixUsesDialog(final JTextComponent target, final ImportData importData) {
        final FixDuplicateImportStmts panel = new FixDuplicateImportStmts();
        panel.initPanel(importData, FixUsesAction.isRemoveUnusedUses());
        final JButton ok = new JButton(Bundle.LBL_Ok());
        final JButton cancel = new JButton(Bundle.LBL_Cancel());
        final AtomicBoolean stop = new AtomicBoolean();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.LongName(), true, new Object[]{ok, cancel}, (Object)ok, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, true);
        final Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ok.setEnabled(false);
                final List<ImportData.ItemVariant> selections = panel.getSelections();
                final boolean removeUnusedUses = panel.getRemoveUnusedImports();
                WORKER.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ParserManager.parse(Collections.singleton(Source.create((Document)target.getDocument())), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    Parser.Result parserResult = resultIterator.getParserResult();
                                    if (parserResult instanceof PHPParseResult) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                cancel.setEnabled(false);
                                                ((JDialog)d).setDefaultCloseOperation(0);
                                            }
                                        });
                                        if (stop.get()) {
                                            return;
                                        }
                                        FixUsesAction.performFixUses((PHPParseResult)parserResult, importData, selections, removeUnusedUses);
                                    }
                                }
                            });
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        FixUsesAction.setRemoveUnusedUses(removeUnusedUses);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                d.setVisible(false);
                            }
                        });
                    }
                });
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stop.set(true);
                d.setVisible(false);
            }
        });
        d.setVisible(true);
        d.dispose();
    }

    public static class Options {
        private final boolean preferFullyQualifiedNames;
        private final boolean preferMultipleUseStatementsCombined;
        private final boolean startUseWithNamespaceSeparator;
        private final boolean aliasesCapitalsOfNamespaces;

        public Options(boolean preferFullyQualifiedNames, boolean preferMultipleUseStatementsCombined, boolean startUseWithNamespaceSeparator, boolean aliasesCapitalsOfNamespaces) {
            this.preferFullyQualifiedNames = preferFullyQualifiedNames;
            this.preferMultipleUseStatementsCombined = preferMultipleUseStatementsCombined;
            this.startUseWithNamespaceSeparator = startUseWithNamespaceSeparator;
            this.aliasesCapitalsOfNamespaces = aliasesCapitalsOfNamespaces;
        }

        public Options(CodeStyle codeStyle) {
            this.preferFullyQualifiedNames = codeStyle.preferFullyQualifiedNames();
            this.preferMultipleUseStatementsCombined = codeStyle.preferMultipleUseStatementsCombined();
            this.startUseWithNamespaceSeparator = codeStyle.startUseWithNamespaceSeparator();
            this.aliasesCapitalsOfNamespaces = codeStyle.aliasesFromCapitalsOfNamespaces();
        }

        public boolean preferFullyQualifiedNames() {
            return this.preferFullyQualifiedNames;
        }

        public boolean preferMultipleUseStatementsCombined() {
            return this.preferMultipleUseStatementsCombined;
        }

        public boolean startUseWithNamespaceSeparator() {
            return this.startUseWithNamespaceSeparator;
        }

        public boolean aliasesCapitalsOfNamespaces() {
            return this.aliasesCapitalsOfNamespaces;
        }
    }

    public static final class GlobalAction
    extends MainMenuAction {
        public GlobalAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return Bundle.FixUsesLabel();
        }

        protected String getActionName() {
            return FixUsesAction.ACTION_NAME;
        }
    }
}

