/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;

public class PhpEmbeddingProvider
extends EmbeddingProvider {
    public static final String GENERATED_CODE = "@@@";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)snapshot.getText(), PHPTokenId.language());
        TokenSequence sequence = th.tokenSequence(PHPTokenId.language());
        if (sequence == null) {
            Logger.getLogger("PhpEmbeddingProvider").log(Level.WARNING, "TokenHierarchy.tokenSequence(PhpTokenId.language()) == null for static immutable PHP TokenHierarchy!\nFile = ''{0}'' ;snapshot mimepath=''{1}''", new Object[]{snapshot.getSource().getFileObject().getPath(), snapshot.getMimePath()});
            return Collections.emptyList();
        }
        sequence.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        int from = -1;
        int len = 0;
        while (sequence.moveNext()) {
            Token t = sequence.token();
            if (t.id() == PHPTokenId.T_INLINE_HTML) {
                if (from < 0) {
                    from = sequence.offset();
                }
                len += t.length();
                continue;
            }
            if (from >= 0) {
                embeddings.add(snapshot.create(from, len, "text/html"));
                embeddings.add(snapshot.create((CharSequence)GENERATED_CODE, "text/html"));
            }
            from = -1;
            len = 0;
        }
        if (from >= 0) {
            embeddings.add(snapshot.create(from, len, "text/html"));
        }
        if (embeddings.isEmpty()) {
            return Collections.singletonList(snapshot.create((CharSequence)"", "text/html"));
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 110;
    }

    public void cancel() {
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new PhpEmbeddingProvider());
        }
    }
}

