/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.PHPCompletionResult;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPDocCommentTokenId;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.project.api.PhpAnnotations;
import org.netbeans.modules.php.spi.annotation.AnnotationCompletionTag;
import org.netbeans.modules.php.spi.annotation.AnnotationCompletionTagProvider;
import org.openide.util.ImageUtilities;

public final class PHPDOCCodeCompletion {
    private static final String TAG_PREFIX = "@";

    private PHPDOCCodeCompletion() {
    }

    static boolean isTypeCtx(PHPCompletionItem.CompletionRequest request) {
        TokenSequence<PHPTokenId> phpTS;
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = phpTS = th != null ? LexUtilities.getPHPTokenSequence(th, request.anchor) : null;
        if (phpTS != null) {
            TokenSequence tokenSequence2;
            phpTS.move(request.anchor);
            TokenSequence tokenSequence3 = tokenSequence2 = phpTS.moveNext() ? phpTS.embedded(PHPDocCommentTokenId.language()) : null;
            if (tokenSequence2 == null) {
                return false;
            }
            tokenSequence2.move(request.anchor);
            if (tokenSequence2.movePrevious()) {
                int offset = tokenSequence2.offset() + tokenSequence2.token().length();
                if (tokenSequence2.moveNext()) {
                    CharSequence text = tokenSequence2.token().text();
                    String txt = ((Object)text.subSequence(0, request.anchor - offset)).toString();
                    if (!txt.trim().isEmpty() && txt.charAt(txt.length() - 1) == '|') {
                        txt = txt.trim();
                        for (int i = 0; i < txt.length(); ++i) {
                            if (!Character.isWhitespace(txt.charAt(i))) continue;
                            return false;
                        }
                        return true;
                    }
                    for (int i = 0; i < txt.length(); ++i) {
                        if (Character.isWhitespace(txt.charAt(i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static void complete(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (request.prefix.startsWith(TAG_PREFIX)) {
            PHPDOCCodeCompletion.completeAnnotation(completionResult, request);
        }
    }

    private static void completeAnnotation(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        String prefix = request.prefix.substring(TAG_PREFIX.length());
        List providers = PhpAnnotations.getDefault().getCompletionTagProviders(request.info.getSnapshot().getSource().getFileObject());
        ASTNode nodeAfterOffset = Utils.getNodeAfterOffset(request.result, request.anchor);
        int priority = 0;
        for (AnnotationCompletionTagProvider annotationProvider : providers) {
            ++priority;
            List annotations = nodeAfterOffset instanceof TypeDeclaration ? annotationProvider.getTypeAnnotations() : (nodeAfterOffset instanceof MethodDeclaration ? annotationProvider.getMethodAnnotations() : (nodeAfterOffset instanceof FunctionDeclaration ? annotationProvider.getFunctionAnnotations() : (nodeAfterOffset instanceof FieldsDeclaration ? annotationProvider.getFieldAnnotations() : annotationProvider.getAnnotations())));
            for (AnnotationCompletionTag tag : annotations) {
                if (!tag.getName().startsWith(prefix)) continue;
                completionResult.add(new PHPDOCCodeCompletionItem(request.anchor, tag, annotationProvider.getName(), priority));
            }
        }
    }

    public static class PHPDOCCodeCompletionItem
    implements CompletionProposal {
        private static final String PHP_ANNOTATION_ICON = "org/netbeans/modules/php/editor/resources/annotation.png";
        private static final ImageIcon ANNOTATION_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/editor/resources/annotation.png"));
        private final AnnotationCompletionTag tag;
        private final int anchorOffset;
        private final PHPDOCTagElement elem;
        private final String providerName;
        private final int priority;

        public PHPDOCCodeCompletionItem(int anchorOffset, AnnotationCompletionTag tag, String providerName, int priority) {
            this.tag = tag;
            this.anchorOffset = anchorOffset;
            this.providerName = providerName;
            this.priority = priority;
            this.elem = new PHPDOCTagElement(tag.getName(), tag.getDocumentation());
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public ElementHandle getElement() {
            return this.elem;
        }

        public String getName() {
            return PHPDOCCodeCompletion.TAG_PREFIX + this.tag.getName();
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getSortText() {
            return this.priority + this.providerName + this.getName();
        }

        public int getSortPrioOverride() {
            return 0;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            this.tag.formatParameters(formatter);
            return formatter.getText();
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return this.providerName;
        }

        public ElementKind getKind() {
            return this.elem.getKind();
        }

        public ImageIcon getIcon() {
            return ANNOTATION_ICON;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isSmart() {
            return false;
        }

        public String getCustomInsertTemplate() {
            return this.tag.getInsertTemplate();
        }
    }
}

