/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.Bundle;
import org.netbeans.modules.php.editor.CCDocHtmlFormatter;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PHPCodeCompletion;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.parser.annotation.LinkParsedLine;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

class DocRenderer {
    private static final String TD_STYLE = "style=\"text-aling:left; border-width: 0px;padding: 1px;padding:3px;\" ";
    private static final String TD_STYLE_MAX_WIDTH = "style=\"text-aling:left; border-width: 0px;padding: 1px;padding:3px;width:80%;\" ";
    private static final String TABLE_STYLE = "style=\"border: 0px; width: 100%;\"";
    private static final Logger LOGGER = Logger.getLogger(PHPCodeCompletion.class.getName());

    DocRenderer() {
    }

    static String document(ParserResult info, ElementHandle element) {
        if (element instanceof PHPDOCTagElement) {
            PHPDOCTagElement pHPDOCTagElement = (PHPDOCTagElement)element;
            return pHPDOCTagElement.getDoc();
        }
        if (element instanceof PredefinedSymbolElement) {
            PredefinedSymbolElement predefinedSymbolElement = (PredefinedSymbolElement)element;
            return predefinedSymbolElement.getDoc();
        }
        if (element instanceof PhpElement) {
            return DocRenderer.documentIndexedElement((PhpElement)element);
        }
        if (element instanceof TypeMemberElement) {
            TypeMemberElement indexedClassMember = (TypeMemberElement)element;
            return DocRenderer.documentIndexedElement(indexedClassMember);
        }
        return null;
    }

    private static String documentIndexedElement(PhpElement indexedElement) {
        StringBuilder description = new StringBuilder();
        CCDocHtmlFormatter locationHeader = new CCDocHtmlFormatter();
        CCDocHtmlFormatter header = new CCDocHtmlFormatter();
        String location = DocRenderer.getLocation(indexedElement);
        StringBuilder phpDoc = new StringBuilder();
        ElementQuery elementQuery = indexedElement.getElementQuery();
        if (location != null) {
            locationHeader.appendHtml(String.format("<div align=\"right\"><font size=-1>%s</font></div>", location));
        }
        if (DocRenderer.canBeProcessed(indexedElement) && DocRenderer.getPhpDoc(indexedElement, header, phpDoc).length() == 0 && indexedElement instanceof MethodElement) {
            ElementFilter forName = ElementFilter.forName(NameKind.exact(indexedElement.getName()));
            ElementQuery.Index index = elementQuery.getQueryScope().isIndexScope() ? (ElementQuery.Index)elementQuery : ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(indexedElement.getFileObject()));
            Set<TypeElement> inheritedTypes = index.getInheritedTypes(((MethodElement)indexedElement).getType());
            Iterator<TypeElement> typeIt = inheritedTypes.iterator();
            while (phpDoc.length() == 0 && typeIt.hasNext()) {
                Set<MethodElement> inheritedMethods = forName.filter(index.getDeclaredMethods(typeIt.next()));
                Iterator<MethodElement> methodIt = inheritedMethods.iterator();
                while (phpDoc.length() == 0 && methodIt.hasNext()) {
                    header = new CCDocHtmlFormatter();
                    DocRenderer.getPhpDoc(methodIt.next(), header, phpDoc);
                }
            }
        }
        if (phpDoc.length() > 0) {
            description.append((CharSequence)phpDoc);
        } else {
            description.append(Bundle.PHPDocNotFound());
        }
        return String.format("%s%s%s", locationHeader.getText(), header.getText(), description.toString());
    }

    private static boolean canBeProcessed(PhpElement indexedElement) {
        return indexedElement != null && indexedElement.getOffset() > -1 && indexedElement.getFileObject() != null;
    }

    private static StringBuilder getPhpDoc(PhpElement indexedElement, CCDocHtmlFormatter header, StringBuilder phpDoc) {
        if (DocRenderer.canBeProcessed(indexedElement)) {
            FileObject nextFo = indexedElement.getFileObject();
            try {
                Source source = Source.create((FileObject)nextFo);
                if (source != null) {
                    ParserManager.parse(Collections.singleton(source), (UserTask)new PHPDocExtractor(header, phpDoc, indexedElement));
                }
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return phpDoc;
    }

    private static String getLocation(PhpElement indexedElement) {
        String location = null;
        if (indexedElement.isPlatform()) {
            location = Bundle.PHPPlatform();
        } else {
            FileObject fobj = indexedElement.getFileObject();
            if (fobj != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fobj);
                if (project != null) {
                    Sources sources = ProjectUtils.getSources((Project)project);
                    for (SourceGroup group : sources.getSourceGroups("PHPSOURCE")) {
                        String relativePath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fobj);
                        if (relativePath == null) continue;
                        location = relativePath;
                        break;
                    }
                    if (location == null) {
                        location = fobj.getPath();
                    }
                } else {
                    location = indexedElement.getFilenameUrl();
                }
            }
        }
        return location;
    }

    static final class PHPDocExtractor
    extends UserTask {
        private static final Pattern KEEP_TAGS_PATTERN = Pattern.compile("<(?!(/|b|code|br|i|kbd|li|ol|p|pre|samp|ul|var|table|tr|th|td)(\\b|\\s))", 2);
        private static final Pattern REPLACE_NEWLINE_PATTERN = Pattern.compile("(\r?\n){2,}");
        private static final Pattern LIST_PATTERN = Pattern.compile("(\r?\n)(?=([-+#o]\\s|\\d\\.?\\s))");
        private static final ArrayList<String> LINK_TAGS = new ArrayList();
        private CCDocHtmlFormatter header;
        private StringBuilder phpDoc;
        private PhpElement indexedElement;

        public PHPDocExtractor(CCDocHtmlFormatter header, StringBuilder phpDoc, PhpElement indexedElement) {
            this.header = header;
            this.phpDoc = phpDoc;
            this.indexedElement = indexedElement;
        }

        public void cancel() {
        }

        private void doFunctionDeclaration(FunctionDeclaration functionDeclaration) {
            String fname = CodeUtils.extractFunctionName(functionDeclaration);
            this.header.appendHtml("<font size=\"+1\">");
            this.header.name(ElementKind.METHOD, true);
            this.header.appendText(fname);
            this.header.name(ElementKind.METHOD, false);
            this.header.appendHtml("</font>");
            this.header.parameters(true);
            this.header.appendText("(");
            int paramCount = functionDeclaration.getFormalParameters().size();
            for (int i = 0; i < paramCount; ++i) {
                Identifier paramId;
                FormalParameter param = functionDeclaration.getFormalParameters().get(i);
                if (param.getParameterType() != null && (paramId = CodeUtils.extractUnqualifiedIdentifier(param.getParameterType())) != null) {
                    this.header.type(true);
                    this.header.appendText(paramId.getName() + " ");
                    this.header.type(false);
                }
                this.header.appendText(CodeUtils.getParamDisplayName(param));
                if (param.getDefaultValue() != null) {
                    this.header.type(true);
                    this.header.appendText("=");
                    if (param.getDefaultValue() instanceof Scalar) {
                        Scalar scalar = (Scalar)param.getDefaultValue();
                        this.header.appendText(scalar.getStringValue());
                    }
                    this.header.type(false);
                }
                if (i + 1 >= paramCount) continue;
                this.header.appendText(", ");
            }
            this.header.appendText(")");
            this.header.parameters(false);
        }

        private void extractPHPDoc(PHPDocMethodTag methodTag) {
            StringBuilder params = new StringBuilder();
            StringBuilder returnValue = new StringBuilder();
            String description = methodTag.getDocumentation();
            if (description != null && description.length() > 0) {
                description = PHPDocExtractor.processPhpDoc(description);
            }
            if (methodTag.getParameters() != null && methodTag.getParameters().size() > 0) {
                for (PHPDocVarTypeTag tag : methodTag.getParameters()) {
                    params.append(this.composeParameterLine(tag));
                }
            }
            returnValue.append(this.composeReturnValue(methodTag.getTypes(), null));
            this.phpDoc.append(this.composeFunctionDoc(description, params.toString(), returnValue.toString(), null, null));
        }

        private void extractPHPDoc(PHPDocBlock pHPDocBlock) {
            StringBuilder params = new StringBuilder();
            StringBuilder links = new StringBuilder();
            StringBuilder returnValue = new StringBuilder();
            StringBuilder others = new StringBuilder();
            for (PHPDocTag tag : pHPDocBlock.getTags()) {
                AnnotationParsedLine kind = tag.getKind();
                if (kind.equals((Object)PHPDocTag.Type.PARAM)) {
                    params.append(this.composeParameterLine((PHPDocVarTypeTag)tag));
                    continue;
                }
                if (kind.equals((Object)PHPDocTag.Type.RETURN)) {
                    PHPDocTypeTag returnTag = (PHPDocTypeTag)tag;
                    returnValue.append(this.composeReturnValue(returnTag.getTypes(), returnTag.getDocumentation()));
                    continue;
                }
                if (kind.equals((Object)PHPDocTag.Type.VAR)) {
                    PHPDocTypeTag typeTag = (PHPDocTypeTag)tag;
                    String type = this.composeType(typeTag.getTypes());
                    others.append(PHPDocExtractor.processPhpDoc(String.format("<tr><th align=\"left\">Type:</th><td>%s</td></tr>", type)));
                    continue;
                }
                if (kind instanceof LinkParsedLine) {
                    String line = String.format("<a href=\"%s\">%s</a><br>%n", kind.getDescription(), kind.getDescription());
                    links.append(line);
                    continue;
                }
                String oline = String.format("<tr><th align=\"left\">%s</th><td>%s</td></tr>%n", PHPDocExtractor.processPhpDoc(tag.getKind().getName()), PHPDocExtractor.processPhpDoc(tag.getKind().getDescription()));
                others.append(oline);
            }
            this.phpDoc.append(this.composeFunctionDoc(this.processDescription(PHPDocExtractor.processPhpDoc(pHPDocBlock.getDescription())), params.toString(), returnValue.toString(), links.toString(), others.toString()));
        }

        protected String processDescription(String text) {
            StringBuilder result = new StringBuilder();
            int lastIndex = 0;
            int index = text.indexOf(123, 0);
            while (index > -1 && text.length() > index + 1) {
                String tag;
                int endIndex;
                result.append(text.substring(lastIndex, index));
                lastIndex = index;
                char charAt = text.charAt(index + 2);
                if ((charAt == 'l' || charAt == 's' || charAt == 'u') && (endIndex = text.indexOf(32, index)) > -1 && LINK_TAGS.contains(tag = text.substring(index + 1, endIndex).trim()) && (endIndex = text.indexOf(125, index = endIndex + 1)) > -1) {
                    String link = text.substring(index, endIndex).trim();
                    result.append(String.format("<a href=\"%s\">%s</a>", link, link));
                    lastIndex = endIndex + 1;
                }
                index = text.indexOf(123, index + 1);
            }
            if (lastIndex > -1) {
                result.append(text.substring(lastIndex));
            }
            return result.toString();
        }

        private String composeFunctionDoc(String description, String parameters, String returnValue, String links, String others) {
            StringBuilder value = new StringBuilder();
            value.append(description);
            value.append("<br />\n");
            if (parameters.length() > 0) {
                value.append("<h3>");
                value.append(Bundle.Parameters());
                value.append("</h3>\n<table cellspacing=0 style=\"border: 0px; width: 100%;\">\n").append(parameters).append("</table>\n");
            }
            if (returnValue.length() > 0) {
                value.append("<h3>");
                value.append(Bundle.ReturnValue());
                value.append("</h3>\n<table>\n");
                value.append(returnValue);
                value.append("</table>");
            }
            if (links != null && links.length() > 0) {
                value.append("<h3>");
                value.append(Bundle.OnlineDocs());
                value.append("</h3>\n").append(links);
            }
            if (others != null && others.length() > 0) {
                value.append("<table>\n").append(others).append("</table>\n");
            }
            return value.toString();
        }

        private String composeParameterLine(PHPDocVarTypeTag param) {
            String type = this.composeType(param.getTypes());
            String pline = String.format("<tr><td>&nbsp;</td><td valign=\"top\" %s><nobr>%s</nobr></td><td valign=\"top\" %s><nobr><b>%s</b></nobr></td><td valign=\"top\" %s>%s</td></tr>%n", DocRenderer.TD_STYLE, type, DocRenderer.TD_STYLE, param.getVariable().getValue(), DocRenderer.TD_STYLE_MAX_WIDTH, param.getDocumentation() == null ? "&nbsp" : PHPDocExtractor.processPhpDoc(param.getDocumentation()));
            return pline;
        }

        private String composeReturnValue(List<PHPDocTypeNode> types, String documentation) {
            StringBuilder returnValue = new StringBuilder();
            if (types != null && types.size() > 0) {
                returnValue.append(String.format("<tr><td>&nbsp;</td><td><b>%s:</b></td><td>%s</td></tr>", Bundle.Type(), this.composeType(types)));
            }
            if (documentation != null && documentation.length() > 0) {
                returnValue.append(String.format("<tr><td>&nbsp;</td><td valign=\"top\"><b>%s:</b></td><td>%s</td></tr>", Bundle.Description(), PHPDocExtractor.processPhpDoc(documentation)));
            }
            return returnValue.toString();
        }

        private String composeType(List<PHPDocTypeNode> types) {
            StringBuilder type = new StringBuilder();
            if (types != null) {
                for (PHPDocTypeNode typeNode : types) {
                    if (type.length() > 0) {
                        type.append(" | ");
                    }
                    type.append(typeNode.getValue());
                    if (!typeNode.isArray()) continue;
                    type.append("[]");
                }
            }
            return type.toString();
        }

        static String processPhpDoc(String phpDoc) {
            String result = Bundle.PHPDocNotFound();
            if (StringUtils.hasText((String)phpDoc)) {
                String notags = KEEP_TAGS_PATTERN.matcher(phpDoc).replaceAll("&lt;");
                notags = REPLACE_NEWLINE_PATTERN.matcher(notags).replaceAll("<br><br>");
                result = LIST_PATTERN.matcher(notags).replaceAll("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            return result;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Program program;
            ParserResult presult = (ParserResult)resultIterator.getParserResult();
            if (presult != null && (program = Utils.getRoot(presult)) != null) {
                ASTNode node = Utils.getNodeAtOffset(program, this.indexedElement.getOffset());
                if (node == null) {
                    LOGGER.log(Level.WARNING, "Could not find AST node for element {0} defined in {1}", new Object[]{this.indexedElement.getName(), this.indexedElement.getFilenameUrl()});
                    return;
                }
                if (node instanceof FunctionDeclaration) {
                    this.doFunctionDeclaration((FunctionDeclaration)node);
                } else {
                    PhpElement constant;
                    this.header.name(this.indexedElement.getKind(), true);
                    this.header.appendText(this.indexedElement.getName());
                    this.header.name(this.indexedElement.getKind(), false);
                    String value = null;
                    if (this.indexedElement instanceof ConstantElement) {
                        constant = (ConstantElement)this.indexedElement;
                        value = constant.getValue();
                    } else if (this.indexedElement instanceof TypeConstantElement) {
                        constant = (TypeConstantElement)this.indexedElement;
                        value = constant.getValue();
                    }
                    if (value != null) {
                        this.header.appendText(" = ");
                        this.header.appendText(value);
                    }
                }
                this.header.appendHtml("<br/><br/>");
                if (node instanceof PHPDocTag) {
                    if (node instanceof PHPDocMethodTag) {
                        this.extractPHPDoc((PHPDocMethodTag)node);
                    } else if (node instanceof PHPDocVarTypeTag) {
                        PHPDocVarTypeTag varTypeTag = (PHPDocVarTypeTag)node;
                        String type = this.composeType(varTypeTag.getTypes());
                        this.phpDoc.append(PHPDocExtractor.processPhpDoc(String.format("%s<br /><table><tr><th align=\"left\">Type:</th><td>%s</td></tr></table>", varTypeTag.getDocumentation(), type)));
                    } else {
                        this.phpDoc.append(PHPDocExtractor.processPhpDoc(((PHPDocTag)node).getDocumentation()));
                    }
                } else {
                    Comment comment = Utils.getCommentForNode(program, node);
                    if (comment instanceof PHPDocBlock) {
                        this.extractPHPDoc((PHPDocBlock)comment);
                    }
                }
            }
        }

        static {
            LINK_TAGS.add("@link");
            LINK_TAGS.add("@see");
            LINK_TAGS.add("@use");
        }
    }
}

