/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class NamedServicesProvider {
    private static final Map<String, Reference<Lookup>> namedServicesProviders = Collections.synchronizedMap(new HashMap());

    public static Lookup forPath(String path) {
        Lookup lkp;
        Reference<Lookup> ref = namedServicesProviders.get(path);
        Lookup lookup = lkp = ref == null ? null : ref.get();
        if (lkp != null) {
            return lkp;
        }
        NamedServicesProvider prov = Lookup.getDefault().lookup(NamedServicesProvider.class);
        if (prov != null && !path.startsWith("URLStreamHandler/")) {
            lkp = prov.create(path);
        } else {
            ClassLoader l = Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null && (l = Thread.currentThread().getContextClassLoader()) == null) {
                l = NamedServicesProvider.class.getClassLoader();
            }
            lkp = Lookups.metaInfServices(l, "META-INF/namedservices/" + path);
        }
        namedServicesProviders.put(path, new WeakReference<Lookup>(lkp));
        return lkp;
    }

    public static <T> T getConfigObject(String filePath, Class<T> type) {
        NamedServicesProvider prov = Lookup.getDefault().lookup(NamedServicesProvider.class);
        return prov != null ? (T)prov.lookupObject(filePath, type) : null;
    }

    public static Lookup createLookupFor(Object obj) {
        NamedServicesProvider prov = Lookup.getDefault().lookup(NamedServicesProvider.class);
        return prov != null ? prov.lookupFor(obj) : null;
    }

    static void clearCache() {
        boolean assertsOn = false;
        if (!$assertionsDisabled) {
            assertsOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertsOn) {
            throw new IllegalStateException();
        }
        namedServicesProviders.clear();
    }

    protected NamedServicesProvider() {
        if (this.getClass().getName().equals("org.openide.util.lookup.PathInLookupTest$P")) {
            return;
        }
        if (this.getClass().getName().equals("org.openide.util.UtilitiesTest$NamedServicesProviderImpl")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.openide.filesystems.RecognizeInstanceFiles")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.settings.RecognizeInstanceObjects")) {
            return;
        }
        throw new IllegalStateException();
    }

    protected abstract Lookup create(String var1);

    protected <T> T lookupObject(String path, Class<T> type) {
        return this.create(path).lookup(type);
    }

    protected Lookup lookupFor(Object obj) {
        return null;
    }
}

