/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.php.symfony2.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Symfony2OptionsPanel
extends JPanel {
    private static final long serialVersionUID = -4674683641321L;
    private static final String SANDBOX_LAST_FOLDER_SUFFIX = ".sandbox";
    private static final FileFilter ZIP_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.isFile() && f.getName().toLowerCase().endsWith(".zip");
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_ZipFilesFilter();
        }
    };
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel downloadLabel;
    private JLabel errorLabel;
    private JCheckBox ignoreCacheCheckBox;
    private JLabel noteLabel;
    private JButton sandboxBrowseButton;
    private JLabel sandboxInfoLabel;
    private JLabel sandboxLabel;
    private JTextField sandboxTextField;

    public Symfony2OptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.initListeners();
    }

    private void initListeners() {
        this.sandboxTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                Symfony2OptionsPanel.this.fireChange();
            }
        });
        this.ignoreCacheCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Symfony2OptionsPanel.this.fireChange();
            }
        });
    }

    public String getSandbox() {
        return this.sandboxTextField.getText();
    }

    public void setSandbox(String sandbox) {
        this.sandboxTextField.setText(sandbox);
    }

    public boolean getIgnoreCache() {
        return this.ignoreCacheCheckBox.isSelected();
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.ignoreCacheCheckBox.setSelected(ignoreCache);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.sandboxLabel = new JLabel();
        this.sandboxTextField = new JTextField();
        this.sandboxBrowseButton = new JButton();
        this.sandboxInfoLabel = new JLabel();
        this.ignoreCacheCheckBox = new JCheckBox();
        this.errorLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.downloadLabel = new JLabel();
        this.sandboxLabel.setLabelFor(this.sandboxTextField);
        Mnemonics.setLocalizedText((JLabel)this.sandboxLabel, (String)NbBundle.getMessage(Symfony2OptionsPanel.class, (String)"Symfony2OptionsPanel.sandboxLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.sandboxBrowseButton, (String)NbBundle.getMessage(Symfony2OptionsPanel.class, (String)"Symfony2OptionsPanel.sandboxBrowseButton.text"));
        this.sandboxBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Symfony2OptionsPanel.this.sandboxBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.sandboxInfoLabel, (String)NbBundle.getMessage(Symfony2OptionsPanel.class, (String)"Symfony2OptionsPanel.sandboxInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreCacheCheckBox, (String)NbBundle.getMessage(Symfony2OptionsPanel.class, (String)"Symfony2OptionsPanel.ignoreCacheCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(Symfony2OptionsPanel.class, (String)"Symfony2OptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.downloadLabel, (String)NbBundle.getMessage(Symfony2OptionsPanel.class, (String)"Symfony2OptionsPanel.downloadLabel.text"));
        this.downloadLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                Symfony2OptionsPanel.this.downloadLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Symfony2OptionsPanel.this.downloadLabelMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sandboxLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sandboxInfoLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.sandboxTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sandboxBrowseButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ignoreCacheCheckBox, -2, -1, -2).addComponent(this.errorLabel).addComponent(this.noteLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.downloadLabel, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sandboxLabel).addComponent(this.sandboxTextField, -2, -1, -2).addComponent(this.sandboxBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sandboxInfoLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.ignoreCacheCheckBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 125, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void sandboxBrowseButtonActionPerformed(ActionEvent evt) {
        File sandbox = new FileChooserBuilder(Symfony2OptionsPanel.class.getName() + SANDBOX_LAST_FOLDER_SUFFIX).setTitle(Bundle.LBL_SelectSandbox()).setFilesOnly(true).setFileFilter(ZIP_FILE_FILTER).showOpenDialog();
        if (sandbox != null) {
            sandbox = FileUtil.normalizeFile((File)sandbox);
            this.sandboxTextField.setText(sandbox.getAbsolutePath());
        }
    }

    private void downloadLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void downloadLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://symfony.com/download");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

