/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.options;

import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class Symfony2Options {
    private static final String PREFERENCES_PATH = "symfony2";
    private static final Symfony2Options INSTANCE = new Symfony2Options();
    private static final String SANDBOX = "sandbox";
    private static final String IGNORE_CACHE = "ignore.cache";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private Symfony2Options() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                Symfony2Options.this.changeSupport.fireChange();
            }
        });
    }

    public static Symfony2Options getInstance() {
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getSandbox() {
        return this.getPreferences().get(SANDBOX, null);
    }

    public void setSandbox(String sandbox) {
        this.getPreferences().put(SANDBOX, sandbox);
    }

    public boolean getIgnoreCache() {
        return this.getPreferences().getBoolean(IGNORE_CACHE, true);
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.getPreferences().putBoolean(IGNORE_CACHE, ignoreCache);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(Symfony2Options.class).node(PREFERENCES_PATH);
    }
}

