/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.symfony2.commands.Bundle;
import org.netbeans.modules.php.symfony2.commands.Symfony2CommandVO;
import org.netbeans.modules.php.symfony2.commands.Symfony2CommandsXmlParser;
import org.netbeans.modules.php.symfony2.preferences.Symfony2Preferences;
import org.netbeans.modules.php.symfony2.ui.options.Symfony2OptionsPanelController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.InputOutput;

public final class Symfony2Script {
    private static final Logger LOGGER = Logger.getLogger(Symfony2Script.class.getName());
    private static final List<String> CACHE_CLEAR_COMMAND = Collections.singletonList("cache:clear");
    private static final List<String> CACHE_WARMUP_COMMAND = Collections.singletonList("cache:warmup");
    private static final List<String> LIST_COMMANDS_COMMAND = Arrays.asList("list", "--xml");
    private static final List<String> DEFAULT_PARAMS = Collections.singletonList("--ansi");
    public static final String SCRIPT_NAME = "console";
    private final String symfony2Path;

    private Symfony2Script(String symfony2Path) {
        this.symfony2Path = symfony2Path;
    }

    public static FileObject getPath(PhpModule phpModule) {
        return Symfony2Script.getPath(phpModule, Symfony2Preferences.getAppDir(phpModule));
    }

    public static FileObject getPath(PhpModule phpModule, String relativeAppDir) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        FileObject appDir = sourceDirectory.getFileObject(relativeAppDir);
        if (appDir == null) {
            return null;
        }
        return appDir.getFileObject(SCRIPT_NAME);
    }

    public static Symfony2Script forPhpModule(PhpModule phpModule, boolean warn) throws InvalidPhpExecutableException {
        String error;
        String console = null;
        FileObject script = Symfony2Script.getPath(phpModule);
        if (script != null) {
            console = FileUtil.toFile((FileObject)script).getAbsolutePath();
        }
        if ((error = Symfony2Script.validate(console)) == null) {
            return new Symfony2Script(console);
        }
        if (warn) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.MSG_InvalidSymfony2Script(error), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        throw new InvalidPhpExecutableException(error);
    }

    public static String validate(String command) {
        return PhpExecutableValidator.validateCommand((String)command, (String)Bundle.Symfony2Script_script_label());
    }

    public void clearCache(PhpModule phpModule) {
        this.runCommand(phpModule, CACHE_CLEAR_COMMAND, null);
    }

    public void cacheWarmUp(PhpModule phpModule) {
        this.runCommand(phpModule, CACHE_WARMUP_COMMAND, null);
    }

    public void runCommand(PhpModule phpModule, List<String> parameters, Runnable postExecution) {
        this.createExecutable(phpModule).displayName(this.getDisplayName(phpModule, parameters.get(0))).additionalParameters(this.getAllParameters(parameters)).run(this.getDescriptor(postExecution));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Symfony2CommandVO> getCommands(PhpModule phpModule) {
        File tmpFile;
        try {
            tmpFile = File.createTempFile("nb-symfony2-commands-", ".xml");
            tmpFile.deleteOnExit();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
        Future result = this.createExecutable(phpModule).fileOutput(tmpFile, true).additionalParameters(LIST_COMMANDS_COMMAND).run(this.getSilentDescriptor());
        try {
            if (result == null || (Integer)result.get() != 0) {
                this.runCommand(phpModule, LIST_COMMANDS_COMMAND, null);
                return null;
            }
        }
        catch (CancellationException ex) {
            return null;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)"Symfony2");
            return null;
        }
        ArrayList<Symfony2CommandVO> commandsVO = new ArrayList<Symfony2CommandVO>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpFile), "UTF-8"));
            Symfony2CommandsXmlParser.parse(reader, commandsVO);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            if (!tmpFile.delete()) {
                LOGGER.info("Cannot delete temporary file");
            }
        }
        if (commandsVO.isEmpty()) {
            this.runCommand(phpModule, LIST_COMMANDS_COMMAND, null);
            return null;
        }
        return commandsVO;
    }

    private PhpExecutable createExecutable(PhpModule phpModule) {
        return new PhpExecutable(this.symfony2Path).workDir(FileUtil.toFile((FileObject)phpModule.getSourceDirectory()));
    }

    private String getDisplayName(PhpModule phpModule, String command) {
        return Bundle.Symfony2Script_command_title(phpModule.getDisplayName(), command);
    }

    private List<String> getAllParameters(List<String> params) {
        ArrayList<String> allParams = new ArrayList<String>(DEFAULT_PARAMS.size() + params.size());
        allParams.addAll(DEFAULT_PARAMS);
        allParams.addAll(params);
        return allParams;
    }

    private ExecutionDescriptor getDescriptor(Runnable postExecution) {
        ExecutionDescriptor executionDescriptor = PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath(Symfony2OptionsPanelController.getOptionsPath()).inputVisible(true);
        if (postExecution != null) {
            executionDescriptor = executionDescriptor.postExecution(postExecution);
        }
        return executionDescriptor;
    }

    private ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL);
    }
}

