/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.commands;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.symfony2.commands.Bundle;
import org.netbeans.modules.php.symfony2.commands.Symfony2CommandVO;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class Symfony2CommandsXmlParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(Symfony2CommandsXmlParser.class.getName());
    private final XMLReader xmlReader;
    private final List<Symfony2CommandVO> commands;
    private String currentCommand = null;
    private StringBuilder currentUsage = null;
    private String currentDescription = null;
    private StringBuilder currentHelp = null;
    private Content content = Content.NONE;

    private Symfony2CommandsXmlParser(List<Symfony2CommandVO> commands) throws SAXException {
        assert (commands != null);
        this.commands = commands;
        this.xmlReader = FileUtils.createXmlReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(Reader reader, List<Symfony2CommandVO> commands) {
        try {
            Symfony2CommandsXmlParser parser = new Symfony2CommandsXmlParser(commands);
            parser.xmlReader.setContentHandler(parser);
            parser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("command".equals(qName)) {
            assert (this.currentCommand == null);
            assert (this.currentUsage == null);
            assert (this.currentDescription == null);
            assert (this.currentHelp == null);
            this.currentCommand = attributes.getValue("name");
        } else if ("usage".equals(qName)) {
            assert (this.content == Content.NONE);
            assert (this.currentUsage == null);
            assert (this.currentDescription == null);
            assert (this.currentHelp == null);
            if (this.currentCommand != null) {
                this.content = Content.USAGE;
                this.currentUsage = new StringBuilder();
            }
        } else if ("description".equals(qName)) {
            assert (this.content == Content.NONE);
            assert (this.currentDescription == null);
            assert (this.currentHelp == null);
            if (this.currentCommand != null) {
                this.content = Content.DESCRIPTION;
            }
        } else if ("help".equals(qName)) {
            assert (this.content == Content.NONE);
            assert (this.currentHelp == null);
            if (this.currentCommand != null) {
                this.content = Content.HELP;
                this.currentHelp = new StringBuilder();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("usage".equals(qName)) {
            if (this.content == Content.USAGE) {
                this.content = Content.NONE;
            }
        } else if ("description".equals(qName)) {
            if (this.content == Content.DESCRIPTION) {
                this.content = Content.NONE;
            }
        } else if ("help".equals(qName) && this.content == Content.HELP) {
            assert (this.currentCommand != null);
            if (this.currentUsage == null) {
                this.currentUsage = new StringBuilder();
            }
            if (this.currentDescription == null) {
                this.currentDescription = "";
            }
            this.commands.add(new Symfony2CommandVO(this.currentCommand.trim(), this.currentDescription.trim(), Symfony2CommandsXmlParser.processHelp(this.currentUsage.toString().trim(), this.currentHelp.toString().trim())));
            this.currentCommand = null;
            this.currentUsage = null;
            this.currentDescription = null;
            this.currentHelp = null;
            this.content = Content.NONE;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.content) {
            case USAGE: {
                this.currentUsage.append(ch, start, length);
                break;
            }
            case DESCRIPTION: {
                this.currentDescription = new String(ch, start, length);
                break;
            }
            case HELP: {
                assert (this.currentHelp != null);
                this.currentHelp.append(ch, start, length);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false) : "Unknown content: " + (Object)((Object)this.content);
                break;
            }
        }
    }

    private static String processHelp(String usage, String help) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.hasText((String)usage)) {
            result.append(Bundle.LBL_Usage());
            result.append("<br><i>");
            result.append(usage);
            result.append("</i><br><br>");
        }
        if (StringUtils.hasText((String)help)) {
            help = help.replace("<info>", "<i>");
            help = help.replace("</info>", "</i>");
            help = help.replace("<comment>", "<i>");
            help = help.replace("</comment>", "</i>");
            help = help.replace("\n", "<br>");
            result.append(help);
        }
        if (result.length() == 0) {
            return "";
        }
        return "<html>" + result.toString();
    }

    static enum Content {
        NONE,
        USAGE,
        DESCRIPTION,
        HELP;

    }
}

