/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.netbeans.modules.php.symfony2.Bundle;
import org.netbeans.modules.php.symfony2.Symfony2PhpFrameworkProvider;
import org.netbeans.modules.php.symfony2.options.Symfony2Options;
import org.netbeans.modules.php.symfony2.ui.wizards.NewProjectConfigurationPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public class Symfony2PhpModuleExtender
extends PhpModuleExtender {
    static final String SYMFONY_ZIP_ENTRY_PREFIX = "Symfony/";
    private NewProjectConfigurationPanel panel = null;

    public void addChangeListener(ChangeListener listener) {
        this.getPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getPanel().removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        return this.getPanel().getErrorMessage();
    }

    public String getWarningMessage() {
        return null;
    }

    public Set<FileObject> extend(PhpModule phpModule) throws PhpModuleExtender.ExtendingException {
        try {
            this.unpackSandbox(phpModule);
        }
        catch (IOException ex) {
            Logger.getLogger(Symfony2PhpModuleExtender.class.getName()).log(Level.INFO, "Cannot unpack Symfony Standard Edition.", ex);
            throw new PhpModuleExtender.ExtendingException(Bundle.MSG_NotExtended(), (Throwable)ex);
        }
        Symfony2PhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule).refreshFrameworkCommandsLater(null);
        return this.getInitialFiles(phpModule);
    }

    private void unpackSandbox(PhpModule phpModule) throws IOException {
        String sandbox = Symfony2Options.getInstance().getSandbox();
        File sourceDir = FileUtil.toFile((FileObject)phpModule.getSourceDirectory());
        FileUtils.unzip((String)sandbox, (File)sourceDir, (FileUtils.ZipEntryFilter)new FileUtils.ZipEntryFilter(){

            public boolean accept(ZipEntry zipEntry) {
                return !Symfony2PhpModuleExtender.SYMFONY_ZIP_ENTRY_PREFIX.equals(zipEntry.getName());
            }

            public String getName(ZipEntry zipEntry) {
                String entryName = zipEntry.getName();
                if (entryName.startsWith(Symfony2PhpModuleExtender.SYMFONY_ZIP_ENTRY_PREFIX)) {
                    entryName = entryName.replaceFirst(Symfony2PhpModuleExtender.SYMFONY_ZIP_ENTRY_PREFIX, "");
                }
                return entryName;
            }
        });
    }

    private Set<FileObject> getInitialFiles(PhpModule phpModule) {
        HashSet<FileObject> files = new HashSet<FileObject>();
        this.addSourceFile(files, phpModule, "app/config/parameters.ini");
        this.addSourceFile(files, phpModule, "src/Acme/DemoBundle/Controller/DemoController.php");
        this.addSourceFile(files, phpModule, "src/Acme/DemoBundle/Resources/views/Demo/index.html.twig");
        if (files.isEmpty()) {
            this.addSourceFile(files, phpModule, "web/app_dev");
        }
        return files;
    }

    private void addSourceFile(Set<FileObject> files, PhpModule phpModule, String relativePath) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            assert (false) : "Module extender for no sources of: " + phpModule.getName();
            return;
        }
        FileObject fileObject = sourceDirectory.getFileObject(relativePath);
        if (fileObject != null) {
            files.add(fileObject);
        }
    }

    private synchronized NewProjectConfigurationPanel getPanel() {
        if (this.panel == null) {
            this.panel = new NewProjectConfigurationPanel();
        }
        return this.panel;
    }
}

