/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.lib.api.CssColor;
import org.netbeans.modules.css.lib.api.properties.FixedTextGrammarElement;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.TokenAcceptor;
import org.netbeans.modules.css.lib.api.properties.UnitGrammarElement;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.css.visual.RuleEditorNode;
import org.netbeans.modules.css.visual.RuleEditorPanel;
import org.netbeans.modules.css.visual.actions.GoToSourceAction;
import org.netbeans.modules.css.visual.editors.Bundle;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class PropertyValuesEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private Collection<UnitGrammarElement> unitElements;
    private Collection<FixedTextGrammarElement> fixedElements;
    private boolean addNoneProperty;
    private List<String> tags;
    private Map<String, FixedTextGrammarElement> tags2fixedElement = new HashMap<String, FixedTextGrammarElement>();
    private boolean containsColor;
    private FileObject file;
    private PropertyDefinition pmodel;
    private RuleEditorPanel panel;
    private final boolean isAggregatedProperty;
    private static final String CHOOSE_COLOR_ITEM = "<html><b>" + Bundle.choose_color_item() + "</b></html>";
    private static final JColorChooser COLOR_CHOOSER = new JColorChooser();

    public PropertyValuesEditor(RuleEditorPanel panel, PropertyDefinition pmodel, Model model, Collection<FixedTextGrammarElement> fixedElements, Collection<UnitGrammarElement> unitElements, boolean addNoneProperty) {
        this.panel = panel;
        this.fixedElements = fixedElements;
        this.unitElements = unitElements;
        this.addNoneProperty = addNoneProperty;
        this.file = (FileObject)model.getLookup().lookup(FileObject.class);
        this.pmodel = pmodel;
        this.isAggregatedProperty = pmodel != null ? Properties.isAggregatedProperty((FileObject)this.file, (PropertyDefinition)pmodel) : false;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public synchronized String[] getTags() {
        if (this.isAggregatedProperty) {
            return null;
        }
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
            TreeSet<String> fixedElementNames = new TreeSet<String>();
            for (FixedTextGrammarElement element : this.fixedElements) {
                String value = element.getValue();
                if (value.length() <= 0 || !Character.isLetter(value.charAt(0))) continue;
                fixedElementNames.add(value);
                this.tags2fixedElement.put(value, element);
                if (!"@colors-list".equals(element.origin())) continue;
                this.containsColor = true;
            }
            this.tags.addAll(fixedElementNames);
            if (this.containsColor) {
                Project project;
                if (this.file != null && (project = FileOwnerQuery.getOwner((FileObject)this.file)) != null) {
                    try {
                        TreeSet<String> hashColorCodes = new TreeSet<String>();
                        CssIndex index = CssIndex.create((Project)project);
                        Map result = index.findAll(RefactoringElementType.COLOR);
                        for (FileObject f : result.keySet()) {
                            Collection colors = (Collection)result.get(f);
                            for (String color : colors) {
                                hashColorCodes.add(color);
                            }
                        }
                        this.tags.addAll(0, hashColorCodes);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.tags.add(0, CHOOSE_COLOR_ITEM);
            }
        }
        return this.tags.isEmpty() ? null : this.tags.toArray(new String[0]);
    }

    @Override
    public void setAsText(String str) {
        if (str == null) {
            return;
        }
        if (str.isEmpty()) {
            return;
        }
        if (str.equals(this.getValue())) {
            return;
        }
        if (CHOOSE_COLOR_ITEM.equals(str)) {
            final AtomicReference color_ref = new AtomicReference();
            JDialog dialog = JColorChooser.createDialog(EditorRegistry.lastFocusedComponent(), Bundle.choose_color_item(), true, COLOR_CHOOSER, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    color_ref.set(COLOR_CHOOSER.getColor());
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            dialog.setVisible(true);
            dialog.dispose();
            Color color = (Color)color_ref.get();
            if (color != null) {
                str = WebUtils.toHexCode((Color)color);
            } else {
                return;
            }
        }
        this.editingFinished();
        this.setValue(str);
    }

    @Override
    public String getAsText() {
        return this.getValue().toString();
    }

    private void editingFinished() {
        this.panel.editingFinished();
    }

    private void editingCancelled() {
        this.panel.disposeEditedDeclaration();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "; property: " + this.pmodel != null ? this.pmodel.getName() : "?";
    }

    public void attachEnv(PropertyEnv env) {
        env.getFeatureDescriptor().setValue("canEditAsText", Boolean.TRUE);
        env.getFeatureDescriptor().setValue("nb.property.editor.callback", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editingCancelled".equals(evt.getPropertyName())) {
                    PropertyValuesEditor.this.editingCancelled();
                }
            }
        });
        env.getFeatureDescriptor().setValue("nb.propertysheet.mouse.doubleclick.listener", new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                FeatureDescriptor selected;
                if (me.getID() == 501 && SwingUtilities.isLeftMouseButton(me) && me.getClickCount() > 1 && (selected = PropertyValuesEditor.this.panel.getSelected()) != null && selected instanceof RuleEditorNode.DeclarationProperty) {
                    RuleEditorNode.DeclarationProperty declarationProperty = (RuleEditorNode.DeclarationProperty)((Object)selected);
                    GoToSourceAction action = new GoToSourceAction(PropertyValuesEditor.this.panel, declarationProperty);
                    action.actionPerformed(null);
                }
            }
        });
        if (this.containsColor) {
            env.getFeatureDescriptor().setValue("customListCellRendererSupport", new ColorListCellRendererSupport());
        }
        env.getFeatureDescriptor().setValue("valueIncrement", new SpinnerModel(){

            private String getNextValue(boolean forward) {
                String value = PropertyValuesEditor.this.getAsText();
                for (TokenAcceptor genericAcceptor : TokenAcceptor.ACCEPTORS) {
                    TokenAcceptor.NumberPostfixAcceptor acceptor;
                    if (genericAcceptor instanceof TokenAcceptor.NumberPostfixAcceptor) {
                        acceptor = (TokenAcceptor.NumberPostfixAcceptor)genericAcceptor;
                        if (!acceptor.accepts(value)) continue;
                        int i = acceptor.getNumberValue((CharSequence)value).intValue();
                        CharSequence postfix = acceptor.getPostfix((CharSequence)value);
                        StringBuilder sb = new StringBuilder();
                        sb.append(i + (forward ? 1 : -1));
                        if (postfix != null) {
                            sb.append(postfix);
                        }
                        return sb.toString();
                    }
                    if (!(genericAcceptor instanceof TokenAcceptor.Number) || !(acceptor = (TokenAcceptor.Number)genericAcceptor).accepts(value)) continue;
                    int i = acceptor.getNumberValue(value).intValue();
                    StringBuilder sb = new StringBuilder();
                    sb.append(i + (forward ? 1 : -1));
                    return sb.toString();
                }
                return null;
            }

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public void setValue(Object value) {
            }

            @Override
            public Object getNextValue() {
                return this.getNextValue(true);
            }

            @Override
            public Object getPreviousValue() {
                return this.getNextValue(false);
            }

            @Override
            public void addChangeListener(ChangeListener l) {
            }

            @Override
            public void removeChangeListener(ChangeListener l) {
            }
        });
    }

    private class ColorListCellRendererSupport
    extends AtomicReference<ListCellRenderer>
    implements ListCellRenderer {
        private ColorListCellRendererSupport() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component res;
            ListCellRenderer peer = (ListCellRenderer)this.get();
            assert (peer != null);
            if (peer instanceof ColorListCellRendererSupport) {
                System.out.println("warning: nesting of ColorListCellRendererSupport!");
            }
            if ((res = peer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus)) instanceof JLabel) {
                JLabel label = (JLabel)res;
                assert (value instanceof String);
                String strval = (String)value;
                ImageIcon icon = null;
                if (strval.startsWith("#")) {
                    String colorCode = strval.substring(1);
                    icon = WebUtils.createColorIcon((String)colorCode);
                }
                if (strval.equals(CHOOSE_COLOR_ITEM)) {
                    Color chooserColor = COLOR_CHOOSER.getColor();
                    String hexCode = chooserColor != null ? WebUtils.toHexCode((Color)chooserColor) : null;
                    icon = WebUtils.createColorIcon((String)hexCode);
                }
                FixedTextGrammarElement element = (FixedTextGrammarElement)PropertyValuesEditor.this.tags2fixedElement.get(strval);
                if (!"inherit".equals(strval) && element != null && "@colors-list".equals(element.origin())) {
                    CssColor color = CssColor.getColor((String)strval);
                    icon = WebUtils.createColorIcon((String)(color == null ? null : color.colorCode()));
                }
                label.setIcon(icon);
            } else {
                System.out.println("res instance " + res);
            }
            return res;
        }
    }
}

