/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.StringTokenizer;
import org.netbeans.modules.css.model.api.semantic.Edge;
import org.netbeans.modules.css.model.api.semantic.box.BoxElement;
import org.netbeans.modules.css.model.api.semantic.box.EditableBox;
import org.netbeans.modules.css.visual.editors.EditableBoxCustomEditor;
import org.netbeans.modules.css.visual.editors.EditableBoxModelProperty;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Exceptions;

public class EditableBoxPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String SEPARATOR = " ";
    private static final String NO_VALUE = "-";
    private static final String OVERRIDES = "x";
    EditableBox editableBox;
    EditableBoxModelProperty property;

    public EditableBoxPropertyEditor(EditableBoxModelProperty property) {
        this.property = property;
        this.editableBox = property.getEditableBox();
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rect) {
        Font originalFont = g.getFont();
        int originalFontSize = originalFont.getSize();
        Font derivedFont = originalFont.deriveFont((float)((double)originalFontSize * 0.75));
        g.setFont(derivedFont);
        int height = (int)rect.getHeight();
        int width = (int)rect.getWidth() / 4;
        int fontHeight = derivedFont.getSize();
        int textY = height - (height - fontHeight) / 2;
        Color color = g.getColor();
        for (Edge e : Edge.values()) {
            BoxElement element = this.editableBox.getEdge(e);
            g.setColor(Color.WHITE);
            g.fillRect(e.ordinal() * width, 0, width, height);
            g.setColor(Color.LIGHT_GRAY);
            g.drawRect(e.ordinal() * width, 0, width, height);
            if (element == null) continue;
            if (element == BoxElement.EMPTY) {
                int x = e.ordinal() * width;
                g.drawLine(x, 0, x + width, height);
                g.drawLine(x, height, x + width, 0);
                continue;
            }
            g.setColor(color);
            g.drawString(element.asText(), e.ordinal() * width + 2, textY);
        }
    }

    @Override
    public Component getCustomEditor() {
        return new EditableBoxCustomEditor(this);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public String getAsText() {
        StringBuilder b = new StringBuilder();
        for (Edge e : Edge.values()) {
            BoxElement mw = this.editableBox.getEdge(e);
            if (mw == null) {
                b.append(NO_VALUE);
            } else if (BoxElement.EMPTY == mw) {
                b.append(OVERRIDES);
            } else {
                b.append(mw.asText());
            }
            b.append(SEPARATOR);
        }
        return b.toString();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(string, SEPARATOR);
        int defined = 0;
        EnumMap<Edge, String> edges = new EnumMap<Edge, String>(Edge.class);
        String[] values = new String[4];
        while (st.hasMoreTokens()) {
            values[defined++] = st.nextToken();
        }
        if (defined == 0) {
            throw new IllegalArgumentException("Too few arguments");
        }
        if (defined == 1) {
            edges.put(Edge.TOP, values[0]);
            edges.put(Edge.BOTTOM, values[0]);
            edges.put(Edge.RIGHT, values[0]);
            edges.put(Edge.LEFT, values[0]);
        } else if (defined == 2) {
            edges.put(Edge.TOP, values[0]);
            edges.put(Edge.BOTTOM, values[0]);
            edges.put(Edge.RIGHT, values[1]);
            edges.put(Edge.LEFT, values[1]);
        } else if (defined == 3) {
            edges.put(Edge.TOP, values[0]);
            edges.put(Edge.BOTTOM, values[0]);
            edges.put(Edge.RIGHT, values[1]);
            edges.put(Edge.LEFT, values[2]);
        } else {
            edges.put(Edge.TOP, values[0]);
            edges.put(Edge.RIGHT, values[1]);
            edges.put(Edge.BOTTOM, values[2]);
            edges.put(Edge.LEFT, values[3]);
        }
        for (Edge e : Edge.values()) {
            BoxElement element;
            String token = (String)edges.get(e);
            if (OVERRIDES.equalsIgnoreCase(token)) {
                element = BoxElement.EMPTY;
            } else if (NO_VALUE.equalsIgnoreCase(token)) {
                element = null;
            } else {
                element = this.editableBox.createElement((CharSequence)token);
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Invalid value %s", token));
                }
            }
            this.editableBox.setEdge(e, element);
        }
        this.setPropertyValue();
    }

    void setPropertyValue() {
        try {
            this.property.setValue(this.editableBox);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void attachEnv(PropertyEnv env) {
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                EditableBoxPropertyEditor.this.setPropertyValue();
            }
        });
    }
}

