/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.netbeans.modules.css.model.api.semantic.Edge;
import org.netbeans.modules.css.model.api.semantic.box.BoxElement;
import org.netbeans.modules.css.model.api.semantic.box.EditableBox;
import org.netbeans.modules.css.visual.editors.EditableBoxPropertyEditor;

public class EditableBoxCustomEditor
extends JPanel {
    private EditableBoxPropertyEditor editor;
    private JComboBox bottom;
    private JComboBox left;
    private JComboBox right;
    private JComboBox top;

    public EditableBoxCustomEditor(EditableBoxPropertyEditor editor) {
        this.editor = editor;
        this.initComponents();
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container cntnr, Component cmpnt) {
                if ((cmpnt = cmpnt.getParent()) == EditableBoxCustomEditor.this.top) {
                    return EditableBoxCustomEditor.this.right;
                }
                if (cmpnt == EditableBoxCustomEditor.this.right) {
                    return EditableBoxCustomEditor.this.bottom;
                }
                if (cmpnt == EditableBoxCustomEditor.this.bottom) {
                    return EditableBoxCustomEditor.this.left;
                }
                if (cmpnt == EditableBoxCustomEditor.this.left) {
                    return EditableBoxCustomEditor.this.top;
                }
                return null;
            }

            @Override
            public Component getComponentBefore(Container cntnr, Component cmpnt) {
                if ((cmpnt = cmpnt.getParent()) == EditableBoxCustomEditor.this.top) {
                    return EditableBoxCustomEditor.this.left;
                }
                if (cmpnt == EditableBoxCustomEditor.this.right) {
                    return EditableBoxCustomEditor.this.top;
                }
                if (cmpnt == EditableBoxCustomEditor.this.bottom) {
                    return EditableBoxCustomEditor.this.right;
                }
                if (cmpnt == EditableBoxCustomEditor.this.left) {
                    return EditableBoxCustomEditor.this.bottom;
                }
                return null;
            }

            @Override
            public Component getFirstComponent(Container cntnr) {
                return EditableBoxCustomEditor.this.top;
            }

            @Override
            public Component getLastComponent(Container cntnr) {
                return EditableBoxCustomEditor.this.left;
            }

            @Override
            public Component getDefaultComponent(Container cntnr) {
                return EditableBoxCustomEditor.this.top;
            }
        });
    }

    private ComboBoxModel modelFor(Edge e) {
        BoxElement mw = this.editor.editableBox.getEdge(e);
        String value = mw != null ? mw.asText() : "";
        TreeSet<String> set = new TreeSet<String>();
        set.add(value);
        return new DefaultComboBoxModel(new Vector(set));
    }

    private void initComponents() {
        this.top = new JComboBox();
        this.right = new JComboBox();
        this.bottom = new JComboBox();
        this.left = new JComboBox();
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 20, 0, 20, 0};
        layout.rowHeights = new int[]{0, 20, 0, 20, 0};
        this.setLayout(layout);
        this.top.setEditable(true);
        this.top.setModel(this.modelFor(Edge.TOP));
        this.top.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditableBoxCustomEditor.this.topActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.top, gridBagConstraints);
        this.right.setEditable(true);
        this.right.setModel(this.modelFor(Edge.RIGHT));
        this.right.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditableBoxCustomEditor.this.rightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.right, gridBagConstraints);
        this.bottom.setEditable(true);
        this.bottom.setModel(this.modelFor(Edge.BOTTOM));
        this.bottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditableBoxCustomEditor.this.bottomActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.bottom, gridBagConstraints);
        this.left.setEditable(true);
        this.left.setModel(this.modelFor(Edge.LEFT));
        this.left.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditableBoxCustomEditor.this.leftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.left, gridBagConstraints);
    }

    private void setEdge(Edge e) {
        JComboBox cb = this.getJComboBoxForEdge(e);
        String value = cb.getModel().getSelectedItem().toString();
        if (value.length() > 0) {
            EditableBox editableBox = this.editor.editableBox;
            BoxElement boxElement = editableBox.createElement((CharSequence)value);
            this.editor.editableBox.setEdge(e, boxElement);
        }
    }

    private void topActionPerformed(ActionEvent evt) {
        this.setEdge(Edge.TOP);
    }

    private void rightActionPerformed(ActionEvent evt) {
        this.setEdge(Edge.RIGHT);
    }

    private void bottomActionPerformed(ActionEvent evt) {
        this.setEdge(Edge.BOTTOM);
    }

    private void leftActionPerformed(ActionEvent evt) {
        this.setEdge(Edge.LEFT);
    }

    private JComboBox getJComboBoxForEdge(Edge e) {
        switch (e) {
            case BOTTOM: {
                return this.bottom;
            }
            case LEFT: {
                return this.left;
            }
            case TOP: {
                return this.top;
            }
            case RIGHT: {
                return this.right;
            }
        }
        return null;
    }
}

