/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.api;

import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.visual.RuleEditorPanel;
import org.netbeans.modules.css.visual.api.DeclarationInfo;
import org.netbeans.modules.css.visual.api.ViewMode;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public final class RuleEditorController {
    private static final Logger LOG = Logger.getLogger("rule.editor");
    private RuleEditorPanel peer;

    public static RuleEditorController createInstance() {
        return new RuleEditorController(new RuleEditorPanel());
    }

    private RuleEditorController(RuleEditorPanel peer) {
        this.peer = peer;
    }

    public JComponent getRuleEditorComponent() {
        return this.peer;
    }

    RuleEditorPanel getRuleEditorPanel() {
        return this.peer;
    }

    public void setModel(final Model cssSourceModel) {
        LOG.log(Level.FINER, "setModel({0}) called by {1}", new Object[]{cssSourceModel, Thread.currentThread().getStackTrace()[2].toString()});
        Parameters.notNull((CharSequence)"cssSourceModel", (Object)cssSourceModel);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                RuleEditorController.this.peer.setModel(cssSourceModel);
            }
        });
    }

    public void setRule(final Rule rule) {
        LOG.log(Level.FINER, "setRule({0}) called by {1}", new Object[]{rule, Thread.currentThread().getStackTrace()[2].toString()});
        Parameters.notNull((CharSequence)"rule", (Object)rule);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                RuleEditorController.this.peer.setRule(rule);
            }
        });
    }

    public void setNoRuleState() {
        LOG.log(Level.FINER, "setNoRuleState() called by {0}", new Object[]{Thread.currentThread().getStackTrace()[2].toString()});
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                RuleEditorController.this.peer.setNoRuleState();
            }
        });
    }

    public void setDeclarationInfo(final Declaration declaration, final DeclarationInfo declarationInfo) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                RuleEditorController.this.peer.setDeclarationInfo(declaration, declarationInfo);
            }
        });
    }

    public void setViewMode(ViewMode sortMode) {
        this.peer.setViewMode(sortMode);
    }

    public void addRuleEditorListener(PropertyChangeListener listener) {
        this.peer.addRuleEditorListener(listener);
    }

    public void removeRuleEditorListener(PropertyChangeListener listener) {
        this.peer.removeRuleEditorListener(listener);
    }

    public static enum PropertyNames {
        MODEL_SET,
        RULE_SET;

    }
}

