/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.api;

import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.css.visual.CssStylesPanel;
import org.netbeans.modules.css.visual.api.Bundle;
import org.netbeans.modules.css.visual.api.EditCSSRulesAction;
import org.netbeans.modules.css.visual.api.RuleEditorController;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="CssStylesTC", persistenceType=0, iconBase="org/netbeans/modules/css/visual/resources/css_rule.png")
public final class CssStylesTC
extends TopComponent {
    private static final String HELP_ID = "css_visual_CssStylesTC";
    public static final String ID = "CssStylesTC";
    private CssStylesPanel cssStylesPanel;
    private JLabel noContentLabel;

    public CssStylesTC() {
        this.setLayout(new BorderLayout());
        this.cssStylesPanel = new CssStylesPanel();
        this.initNoContentLabel();
        this.add(this.noContentLabel, "Center");
        this.associateLookup(this.cssStylesPanel.getLookup());
        this.setFileNameInTitle(null);
        this.setToolTipText(Bundle.HINT_CssStylesTC());
    }

    private void initNoContentLabel() {
        this.noContentLabel = new JLabel();
        this.noContentLabel.setText(Bundle.CssStylesTC_no_content());
        this.noContentLabel.setHorizontalAlignment(0);
        this.noContentLabel.setVerticalAlignment(0);
        this.noContentLabel.setEnabled(false);
        this.noContentLabel.setBackground(new BeanTreeView().getViewport().getView().getBackground());
        this.noContentLabel.setOpaque(true);
    }

    private void setContent(JComponent component) {
        if (component.getParent() == null) {
            this.removeAll();
            this.add(component, "Center");
            this.revalidate();
            this.repaint();
        }
    }

    public void setUnsupportedContext(FileObject file) {
        this.setFileNameInTitle(file);
        this.setContent(this.noContentLabel);
    }

    public void setContext(FileObject file) {
        this.setFileNameInTitle(file);
        this.setContent(this.cssStylesPanel);
        this.cssStylesPanel.setContext(file);
        EditCSSRulesAction.getDefault().setContext(file);
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.getRuleEditorController().getRuleEditorPanel().componentDeactivated();
    }

    public RuleEditorController getRuleEditorController() {
        return this.cssStylesPanel.getRuleEditorController();
    }

    private void setFileNameInTitle(FileObject file) {
        String fileName = file == null ? "" : file.getNameExt() + " - ";
        this.setName(Bundle.CTL_CssStylesTC_title(fileName));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }
}

