/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.RuleEditorPanel;
import org.netbeans.modules.css.visual.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DeleteRuleAction
extends AbstractAction {
    private RuleEditorPanel panel;

    public DeleteRuleAction(RuleEditorPanel panel) {
        super(Bundle.label_delete_rule());
        this.panel = panel;
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final Model model = this.panel.getModel();
        final Rule rule = this.panel.getRule();
        assert (model != null);
        assert (rule != null);
        final AtomicReference ruleName_ref = new AtomicReference();
        model.runReadTask(new Model.ModelTask(){

            public void run(StyleSheet styleSheet) {
                ruleName_ref.set(((Object)model.getElementSource((Element)rule.getSelectorsGroup())).toString());
            }
        });
        String ruleName = (String)ruleName_ref.get();
        assert (ruleName != null);
        FileObject file = (FileObject)model.getLookup().lookup(FileObject.class);
        String fileName = file != null ? file.getNameExt() : "???";
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)Bundle.delete_rule_confirmation(ruleName, fileName), 0);
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (option == NotifyDescriptor.YES_OPTION) {
            model.runWriteTask(new Model.ModelTask(){

                public void run(StyleSheet styleSheet) {
                    styleSheet.getBody().removeRule(rule);
                    try {
                        model.applyChanges();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }
}

