/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.css.visual.DocumentViewModel;
import org.netbeans.modules.css.visual.DocumentViewPanel;
import org.netbeans.modules.css.visual.Filter;
import org.netbeans.modules.css.visual.Location;
import org.netbeans.modules.css.visual.RuleHandle;
import org.netbeans.modules.css.visual.RuleNode;
import org.netbeans.modules.css.visual.actions.OpenLocationAction;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class StyleSheetNode
extends AbstractNode {
    static final String ICON_BASE = "org/netbeans/modules/css/visual/resources/style_sheet_16.png";
    private final FileObject styleSheet;

    StyleSheetNode(DocumentViewModel model, FileObject stylesheet, Filter filter) {
        super((Children)new StyleSheetChildren(model, stylesheet, filter), Lookups.fixed((Object[])new Object[]{new Location(stylesheet)}));
        this.styleSheet = stylesheet;
        this.updateDisplayName();
        this.setIconBaseWithExtension(ICON_BASE);
    }

    private void updateDisplayName() {
        FileObject webRoot = ProjectWebRootQuery.getWebRoot((FileObject)this.styleSheet);
        String path = webRoot == null ? this.styleSheet.getNameExt() : FileUtil.getRelativePath((FileObject)webRoot, (FileObject)this.styleSheet);
        this.setDisplayName(path);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenLocationAction.class);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(OpenLocationAction.class)};
    }

    static class StyleSheetChildren
    extends Children.Keys<RuleHandle>
    implements ChangeListener {
        private DocumentViewModel model;
        private FileObject stylesheet;
        private Filter filter;

        StyleSheetChildren(DocumentViewModel model, FileObject stylesheet, Filter filter) {
            this.model = model;
            this.stylesheet = stylesheet;
            this.filter = filter;
            filter.addPropertyChangeListener(this.createListener());
            this.refreshKeys();
        }

        void setModel(DocumentViewModel newModel) {
            if (this.model != null) {
                this.model.removeChangeListener(this);
            }
            this.model = newModel;
            if (this.model != null) {
                this.model.addChangeListener(this);
            }
            this.refreshKeys();
        }

        private PropertyChangeListener createListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propertyName = evt.getPropertyName();
                    if ("pattern".equals(propertyName)) {
                        DocumentViewPanel.RP.post(new Runnable(){

                            @Override
                            public void run() {
                                StyleSheetChildren.this.refreshKeys();
                            }
                        });
                    }
                }
            };
        }

        private void refreshKeys() {
            ArrayList<RuleHandle> keys = new ArrayList<RuleHandle>();
            List<RuleHandle> ruleHandles = this.model.getFilesToRulesMap().get(this.stylesheet);
            if (ruleHandles != null) {
                for (RuleHandle handle : ruleHandles) {
                    if (!this.includeKey(handle)) continue;
                    keys.add(handle);
                }
            }
            this.setKeys(keys);
        }

        private boolean includeKey(RuleHandle rule) {
            boolean include = true;
            String pattern = this.filter.getPattern();
            if (pattern != null) {
                String selector = rule.getDisplayName();
                include = selector.indexOf(pattern) != -1;
            }
            return include;
        }

        protected Node[] createNodes(RuleHandle key) {
            return new Node[]{new RuleNode(key)};
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.refreshKeys();
        }
    }
}

