/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JComponent;
import org.netbeans.modules.css.visual.Bundle;
import org.netbeans.modules.css.visual.DocumentViewPanel;
import org.netbeans.modules.css.visual.spi.CssStylesPanelProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class DocumentViewPanelProvider
implements CssStylesPanelProvider {
    private static String DOCUMENT_PANEL_ID = "static_document";
    private static Collection<String> MIME_TYPES = new HashSet<String>(Arrays.asList("text/css", "text/html", "text/xhtml"));
    private DocumentViewPanel panel;

    @Override
    public String getPanelDisplayName() {
        return Bundle.DocumentView_displayName();
    }

    @Override
    public JComponent getContent(Lookup lookup) {
        if (this.panel == null) {
            this.panel = new DocumentViewPanel(lookup);
        }
        return this.panel;
    }

    @Override
    public String getPanelID() {
        return DOCUMENT_PANEL_ID;
    }

    @Override
    public Lookup getLookup() {
        return this.panel.getLookup();
    }

    @Override
    public void activated() {
    }

    @Override
    public void deactivated() {
    }

    @Override
    public boolean providesContentFor(FileObject file) {
        return MIME_TYPES.contains(file.getMIMEType());
    }
}

