/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelUtils;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.CssStylesListenerSupport;
import org.netbeans.modules.css.visual.CustomToolbar;
import org.netbeans.modules.css.visual.DocumentNode;
import org.netbeans.modules.css.visual.DocumentViewModel;
import org.netbeans.modules.css.visual.FakeRootNode;
import org.netbeans.modules.css.visual.Filter;
import org.netbeans.modules.css.visual.Location;
import org.netbeans.modules.css.visual.RuleHandle;
import org.netbeans.modules.css.visual.api.EditCSSRulesAction;
import org.netbeans.modules.css.visual.api.RuleEditorController;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DocumentViewPanel
extends JPanel
implements ExplorerManager.Provider {
    static RequestProcessor RP = new RequestProcessor();
    private BeanTreeView treeView;
    private ExplorerManager manager = new ExplorerManager();
    private final Lookup lookup;
    private final Lookup cssStylesLookup;
    private Lookup.Result<FileObject> lookupFileObjectResult;
    private Filter filter = new Filter();
    private DocumentViewModel documentModel;
    private DocumentNode documentNode;
    private final EditCSSRulesAction createRuleAction;
    private final PropertyChangeListener RULE_EDITOR_CONTROLLER_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (RuleEditorController.PropertyNames.RULE_SET.name().equals(pce.getPropertyName())) {
                final Rule rule = (Rule)pce.getNewValue();
                if (rule == null) {
                    DocumentViewPanel.this.setSelectedStyleSheet();
                    return;
                }
                Model model = rule.getModel();
                model.runReadTask(new Model.ModelTask(){

                    public void run(StyleSheet styleSheet) {
                        DocumentViewPanel.this.setSelectedRule(RuleHandle.createRuleHandle(rule));
                    }
                });
            }
        }
    };
    Object lastHover = null;
    private JToggleButton createRuleToggleButton;
    private JTextField filterTextField;
    private JToggleButton filterToggleButton;
    private JPanel northPanel;

    public DocumentViewPanel(Lookup cssStylesLookup) {
        this.cssStylesLookup = cssStylesLookup;
        this.createRuleAction = EditCSSRulesAction.getDefault();
        this.lookupFileObjectResult = cssStylesLookup.lookupResult(FileObject.class);
        this.lookupFileObjectResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                try {
                    DocumentViewPanel.this.contextChanged();
                }
                catch (Throwable t) {
                    Exceptions.printStackTrace((Throwable)t);
                }
            }
        });
        RuleEditorController controller = (RuleEditorController)cssStylesLookup.lookup(RuleEditorController.class);
        controller.addRuleEditorListener(this.RULE_EDITOR_CONTROLLER_LISTENER);
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.getExplorerManager(), (ActionMap)this.getActionMap());
        Lookup.Result lookupResult = this.lookup.lookupResult(Node.class);
        lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Node selected;
                Node[] selectedNodes = DocumentViewPanel.this.manager.getSelectedNodes();
                Node node = selected = selectedNodes.length > 0 ? selectedNodes[0] : null;
                if (selected != null) {
                    Location location;
                    RuleHandle ruleHandle = (RuleHandle)selected.getLookup().lookup(RuleHandle.class);
                    if (ruleHandle != null) {
                        DocumentViewPanel.this.selectRuleInRuleEditor(ruleHandle);
                        CssStylesListenerSupport.fireRuleSelected(ruleHandle.getRule());
                    }
                    if ((location = (Location)selected.getLookup().lookup(Location.class)) != null) {
                        DocumentViewPanel.this.createRuleAction.setContext(location.getFile());
                    }
                }
            }
        });
        this.initComponents();
        this.initTreeView();
        CustomToolbar toolbar = new CustomToolbar();
        toolbar.addButton(this.filterToggleButton);
        toolbar.addLineSeparator();
        toolbar.addButton(this.createRuleToggleButton);
        this.northPanel.add((Component)toolbar, "East");
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            private void contentChanged() {
                DocumentViewPanel.this.filter.setPattern(DocumentViewPanel.this.filterTextField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.contentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.contentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.setFilterVisible(true, false);
        this.filterToggleButton.setSelected(true);
        this.initializeNodes();
        this.contextChanged();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void setSelectedRule(RuleHandle handle) {
        try {
            Node[] nodeArray;
            Node foundRuleNode = DocumentViewPanel.findLocation(this.manager.getRootContext(), handle);
            if (foundRuleNode != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = foundRuleNode;
            } else {
                nodeArray = new Node[]{};
            }
            Node[] toSelect = nodeArray;
            this.manager.setSelectedNodes(toSelect);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void setSelectedStyleSheet() {
        try {
            Node[] nodeArray;
            Node styleSheetNode = DocumentViewPanel.findLocation(this.manager.getRootContext(), new Location(this.getContext()));
            if (styleSheetNode != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = styleSheetNode;
            } else {
                nodeArray = new Node[]{};
            }
            Node[] toSelect = nodeArray;
            this.manager.setSelectedNodes(toSelect);
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void selectRuleInRuleEditor(RuleHandle handle) {
        RuleEditorController rec = (RuleEditorController)this.cssStylesLookup.lookup(RuleEditorController.class);
        final Rule rule = handle.getRule();
        final AtomicReference matched_rule_ref = new AtomicReference();
        FileObject file = handle.getFile();
        Source source = Source.create((FileObject)file);
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                    if (ri != null) {
                        CssParserResult result = (CssParserResult)ri.getParserResult();
                        final Model model = Model.getModel((CssParserResult)result);
                        model.runReadTask(new Model.ModelTask(){

                            public void run(StyleSheet styleSheet) {
                                ModelUtils utils = new ModelUtils(model);
                                Rule match = utils.findMatchingRule(rule.getModel(), rule);
                                matched_rule_ref.set(match);
                            }
                        });
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Rule match = (Rule)matched_rule_ref.get();
        if (match != null) {
            rec.setModel(match.getModel());
            rec.setRule(match);
        }
    }

    public final ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private FileObject getContext() {
        return (FileObject)this.cssStylesLookup.lookup(FileObject.class);
    }

    private void contextChanged() {
        FileObject context = this.getContext();
        this.createRuleAction.setContext(context);
        if (this.documentModel != null) {
            this.documentModel.dispose();
        }
        this.documentModel = context == null ? null : new DocumentViewModel(context);
        RP.post(new Runnable(){

            @Override
            public void run() {
                DocumentViewPanel.this.documentNode.setModel(DocumentViewPanel.this.documentModel);
                DocumentViewPanel.this.setSelectedStyleSheet();
            }
        });
    }

    private void initTreeView() {
        this.treeView = new BeanTreeView(){
            {
                MouseAdapter listener = DocumentViewPanel.this.createTreeMouseListener();
                this.tree.addMouseListener(listener);
                this.tree.addMouseMotionListener(listener);
                this.tree.setCellRenderer(DocumentViewPanel.this.createTreeCellRenderer(this.tree.getCellRenderer()));
            }

            public void expandAll() {
                Node root = DocumentViewPanel.this.manager.getRootContext();
                this.expandAll(root);
                this.collapseNode(root);
                this.expandNode(root);
            }

            private void expandAll(Node node) {
                DocumentViewPanel.this.treeView.expandNode(node);
                for (Node subNode : node.getChildren().getNodes(true)) {
                    if (subNode.isLeaf()) continue;
                    this.expandAll(subNode);
                }
            }
        };
        this.treeView.setAllowedDragActions(0);
        this.treeView.setAllowedDropActions(0);
        this.treeView.setRootVisible(false);
        this.add((Component)this.treeView, "Center");
    }

    private void initializeNodes() {
        this.documentNode = new DocumentNode(this.documentModel, this.filter);
        FakeRootNode<DocumentNode> root = new FakeRootNode<DocumentNode>(this.documentNode, new Action[0]);
        this.manager.setRootContext(root);
        this.treeView.expandAll();
    }

    public static Node findLocation(Node root, Location location) {
        Location candidate = (Location)root.getLookup().lookup(Location.class);
        if (candidate != null && location.equals(candidate)) {
            return root;
        }
        for (Node node : root.getChildren().getNodes()) {
            Node result = DocumentViewPanel.findLocation(node, location);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public MouseAdapter createTreeMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.processEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.processEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.processEvent(null);
                DocumentViewPanel.this.lastHover = new Object();
            }

            private void processEvent(MouseEvent e) {
            }
        };
    }

    private TreeCellRenderer createTreeCellRenderer(final TreeCellRenderer delegate) {
        Color origColor = UIManager.getColor("Tree.selectionBackground");
        Color color = origColor.brighter().brighter();
        if (color.equals(Color.WHITE)) {
            color = origColor.darker();
        }
        final Color hoverColor = color;
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel component;
                if (!selected && value == DocumentViewPanel.this.lastHover) {
                    component = (JLabel)delegate.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, hasFocus);
                    component.setBackground(hoverColor);
                    component.setOpaque(true);
                } else {
                    component = (JLabel)delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                }
                return component;
            }
        };
    }

    private void setFilterVisible(boolean visible, boolean requestFocus) {
        this.northPanel.remove(this.filterTextField);
        if (visible) {
            this.northPanel.add((Component)this.filterTextField, "Center");
            this.filter.setPattern(this.filterTextField.getText());
            if (requestFocus) {
                this.filterTextField.requestFocus();
            }
        } else {
            this.filter.setPattern(null);
        }
        this.northPanel.revalidate();
        this.northPanel.repaint();
    }

    private void initComponents() {
        this.createRuleToggleButton = new JToggleButton();
        this.filterToggleButton = new JToggleButton();
        this.filterTextField = new JTextField();
        this.northPanel = new JPanel();
        this.createRuleToggleButton.setAction(this.createRuleAction);
        this.createRuleToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/css/visual/resources/newRule.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.createRuleToggleButton, null);
        this.createRuleToggleButton.setToolTipText(NbBundle.getMessage(DocumentViewPanel.class, (String)"CreateRuleDialog.title"));
        this.createRuleToggleButton.setFocusable(false);
        this.createRuleToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentViewPanel.this.createRuleToggleButtonActionPerformed(evt);
            }
        });
        this.filterToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/css/visual/resources/find.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.filterToggleButton, null);
        this.filterToggleButton.setToolTipText(NbBundle.getMessage(DocumentViewPanel.class, (String)"DocumentViewPanel.filterToggleButton.toolTipText"));
        this.filterToggleButton.setFocusable(false);
        this.filterToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentViewPanel.this.filterToggleButtonActionPerformed(evt);
            }
        });
        this.filterTextField.setText(NbBundle.getMessage(DocumentViewPanel.class, (String)"DocumentViewPanel.filterTextField.text"));
        this.filterTextField.setToolTipText(NbBundle.getMessage(DocumentViewPanel.class, (String)"DocumentViewPanel.filterToggleButton.toolTipText"));
        this.setLayout(new BorderLayout());
        this.northPanel.setLayout(new BorderLayout());
        this.add((Component)this.northPanel, "North");
    }

    private void filterToggleButtonActionPerformed(ActionEvent evt) {
        this.setFilterVisible(this.filterToggleButton.isSelected(), true);
    }

    private void createRuleToggleButtonActionPerformed(ActionEvent evt) {
        this.createRuleToggleButton.setSelected(false);
    }
}

