/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelVisitor;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.RuleHandle;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class DocumentViewModel
implements ChangeListener {
    private final FileObject file;
    private Project project;
    private CssIndex index;
    private boolean needsRefresh;
    private ChangeSupport changeSupport;
    private boolean initialized;
    private Map<FileObject, List<RuleHandle>> relatedStylesheets;

    public DocumentViewModel(FileObject file) {
        this.file = file;
        this.changeSupport = new ChangeSupport((Object)this);
        this.needsRefresh = true;
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            this.project = FileOwnerQuery.getOwner((FileObject)this.file);
            if (this.project == null) {
                this.relatedStylesheets = Collections.emptyMap();
                this.needsRefresh = false;
                return;
            }
            try {
                this.index = CssIndex.get((Project)this.project);
                this.index.addChangeListener((ChangeListener)this);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.initialized = true;
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    void dispose() {
        if (this.index != null) {
            this.index.removeChangeListener((ChangeListener)this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.needsRefresh = true;
        this.changeSupport.fireChange();
    }

    public synchronized Map<FileObject, List<RuleHandle>> getFilesToRulesMap() {
        assert (!EventQueue.isDispatchThread());
        this.initialize();
        if (this.needsRefresh) {
            this.update();
            this.needsRefresh = false;
        }
        return this.relatedStylesheets;
    }

    private void update() {
        this.relatedStylesheets = new HashMap<FileObject, List<RuleHandle>>();
        DependenciesGraph dependencies = this.index.getDependencies(this.file);
        Collection allRelatedFiles = dependencies.getAllReferedFiles();
        for (final FileObject related : allRelatedFiles) {
            if (!this.isStyleSheet(related)) continue;
            Source source = Source.create((FileObject)related);
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                        if (ri != null) {
                            CssParserResult result = (CssParserResult)ri.getParserResult();
                            Model model = Model.getModel((CssParserResult)result);
                            final ArrayList rules = new ArrayList();
                            ModelVisitor.Adapter visitor = new ModelVisitor.Adapter(){

                                public void visitRule(Rule rule) {
                                    rules.add(RuleHandle.createRuleHandle(rule));
                                }
                            };
                            model.runReadTask(new Model.ModelTask((ModelVisitor)visitor){
                                final /* synthetic */ ModelVisitor val$visitor;
                                {
                                    this.val$visitor = modelVisitor;
                                }

                                public void run(StyleSheet styleSheet) {
                                    styleSheet.accept(this.val$visitor);
                                }
                            });
                            DocumentViewModel.this.relatedStylesheets.put(related, rules);
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private boolean isStyleSheet(FileObject file) {
        return "text/css".equals(file.getMIMEType());
    }
}

