/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.css.visual.Bundle;
import org.netbeans.modules.css.visual.DocumentViewModel;
import org.netbeans.modules.css.visual.Filter;
import org.netbeans.modules.css.visual.StyleSheetNode;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class DocumentNode
extends AbstractNode {
    static final String ICON_BASE = "org/netbeans/modules/css/visual/resources/style_sheet_16.png";

    DocumentNode(DocumentViewModel pageModel, Filter filter) {
        super((Children)new DocumentChildren(pageModel, filter));
        this.setDisplayName(Bundle.DocumentNode_displayName());
        this.setIconBaseWithExtension(ICON_BASE);
    }

    void setModel(DocumentViewModel model) {
        Node[] nodes;
        DocumentChildren children = (DocumentChildren)this.getChildren();
        children.setModel(model);
        for (Node node : nodes = this.getChildren().getNodes(true)) {
            StyleSheetNode sn = (StyleSheetNode)node;
            StyleSheetNode.StyleSheetChildren snChildren = (StyleSheetNode.StyleSheetChildren)sn.getChildren();
            snChildren.setModel(model);
        }
    }

    static class DocumentChildren
    extends Children.Keys<FileObject>
    implements ChangeListener {
        private static boolean first_run = true;
        private Filter filter;
        private DocumentViewModel model;

        private DocumentChildren(DocumentViewModel model, Filter filter) {
            this.model = model;
            this.filter = filter;
        }

        private void setModel(DocumentViewModel newModel) {
            if (this.model != null) {
                this.model.removeChangeListener(this);
            }
            this.model = newModel;
            if (this.model != null) {
                this.model.addChangeListener(this);
            }
            this.refreshKeys();
        }

        private void refreshKeys() {
            if (first_run) {
                try {
                    ParserManager.parseWhenScanFinished((String)"text/css", (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            DocumentChildren.this.refreshKeysImpl();
                            first_run = false;
                        }
                    });
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.refreshKeysImpl();
            }
        }

        private void refreshKeysImpl() {
            List keys = this.model != null ? this.model.getFilesToRulesMap().keySet() : Collections.emptyList();
            this.setKeys(keys);
        }

        protected Node[] createNodes(FileObject key) {
            return new Node[]{new StyleSheetNode(this.model, key, this.filter)};
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.refreshKeys();
        }
    }
}

