/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.visual.api.CssStylesTC;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class CssStylesTCController
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(CssStylesTCController.class);
    private static final Set<String> SUPPORTED_MIMES = new HashSet<String>(Arrays.asList("text/css", "text/html", "text/xhtml"));
    private static CssStylesTCController STATIC_INSTANCE;
    private TopComponent activeCssContentTC = null;

    static synchronized void init() {
        if (STATIC_INSTANCE == null) {
            STATIC_INSTANCE = new CssStylesTCController();
        }
    }

    public CssStylesTCController() {
        TopComponent.Registry reg = WindowManager.getDefault().getRegistry();
        reg.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)reg));
        this.propertyChange(new PropertyChangeEvent(this, "activated", null, TopComponent.getRegistry().getActivated()));
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        TopComponent closedTC;
        if ("activated".equals(evt.getPropertyName())) {
            final TopComponent activated = (TopComponent)evt.getNewValue();
            if (!WindowManager.getDefault().isOpenedEditorTopComponent(activated)) {
                return;
            }
            if (activated instanceof CssStylesTC) {
                return;
            }
            RP.post(new Runnable(){

                @Override
                public void run() {
                    final FileObject file = CssStylesTCController.this.getFileObject(activated);
                    final boolean supported = file != null && CssStylesTCController.this.isSupportedFileType(file);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (supported) {
                                CssStylesTCController.this.openCssStyles(activated, file);
                            } else {
                                CssStylesTCController.this.getCssStylesTC().setUnsupportedContext(file);
                                if (CssStylesTCController.this.activeCssContentTC != null) {
                                    CssStylesTCController.this.closeCssStyles();
                                }
                            }
                        }
                    });
                }
            });
        } else if (this.activeCssContentTC != null && "tcClosed".equals(evt.getPropertyName()) && (closedTC = (TopComponent)evt.getNewValue()) == this.activeCssContentTC) {
            this.closeCssStyles();
        }
    }

    private boolean isSupportedFileType(FileObject fob) {
        return SUPPORTED_MIMES.contains(fob.getMIMEType());
    }

    private FileObject getFileObject(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        return (FileObject)tc.getLookup().lookup(FileObject.class);
    }

    private void openCssStyles(TopComponent tc, FileObject file) {
        this.activeCssContentTC = tc;
        this.getCssStylesTC().setContext(file);
        this.getCssStylesTCGroup().open();
    }

    private void closeCssStyles() {
        this.activeCssContentTC = null;
        this.getCssStylesTCGroup().close();
    }

    private CssStylesTC getCssStylesTC() {
        return (CssStylesTC)WindowManager.getDefault().findTopComponent("CssStylesTC");
    }

    private TopComponentGroup getCssStylesTCGroup() {
        return WindowManager.getDefault().findTopComponentGroup("CssStyles");
    }
}

