/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.api.ClassNamesForFileOraculum;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReader
implements Symbol.Completer {
    public static final Context.Key<ClassReader> classReaderKey = new Context.Key();
    public static final int INITIAL_BUFFER_SIZE = 65520;
    Annotate annotate;
    boolean verbose;
    boolean checkClassFile;
    public boolean readAllOfClassFile = false;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAnnotations;
    boolean allowSimplifiedVarargs;
    boolean lintClassfile;
    public boolean saveParameterNames;
    private boolean cacheCompletionFailure;
    public boolean preferSource;
    final Log log;
    Symtab syms;
    Types types;
    final Names names;
    final Name completionFailureName;
    private final JavaFileManager fileManager;
    JCDiagnostic.Factory diagFactory;
    private final ClassNamesForFileOraculum classNamesOraculum;
    private final boolean ideMode;
    public SourceCompleter sourceCompleter = null;
    private Map<Name, Symbol.ClassSymbol> classes;
    private Map<Name, Symbol.PackageSymbol> packages;
    protected Scope typevars;
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    byte[] buf = new byte[65520];
    protected int bp;
    Object[] poolObj;
    int[] poolIdx;
    int majorVersion;
    int minorVersion;
    int[] parameterNameIndices;
    boolean haveParameterNameIndices;
    Set<Name> warnedAttrs = new HashSet<Name>();
    byte[] signature;
    int sigp;
    int siglimit;
    boolean sigEnterPhase = false;
    byte[] signatureBuffer = new byte[0];
    int sbp = 0;
    protected Set<AttributeKind> CLASS_ATTRIBUTE = EnumSet.of(AttributeKind.CLASS);
    protected Set<AttributeKind> MEMBER_ATTRIBUTE = EnumSet.of(AttributeKind.MEMBER);
    protected Set<AttributeKind> CLASS_OR_MEMBER_ATTRIBUTE = EnumSet.of(AttributeKind.CLASS, AttributeKind.MEMBER);
    protected Map<Name, AttributeReader> attributeReaders = new HashMap<Name, AttributeReader>();
    private boolean readingClassAttr = false;
    private List<Type> missingTypeVariables = List.nil();
    private List<Type> foundTypeVariables = List.nil();
    private boolean suppressFlush = false;
    private boolean filling = false;
    private Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, (JCDiagnostic)null);
    protected JavaFileManager.Location currentLoc;
    private boolean verbosePath;

    public static ClassReader instance(Context context) {
        ClassReader instance = context.get(classReaderKey);
        if (instance == null) {
            instance = new ClassReader(context, true);
        }
        return instance;
    }

    public void init(Symtab syms) {
        this.init(syms, true);
    }

    private void init(Symtab syms, boolean definitive) {
        if (this.classes != null) {
            return;
        }
        if (definitive) {
            Assert.check(this.packages == null || this.packages == syms.packages);
            this.packages = syms.packages;
            Assert.check(this.classes == null || this.classes == syms.classes);
            this.classes = syms.classes;
        } else {
            this.packages = new HashMap<Name, Symbol.PackageSymbol>();
            this.classes = new HashMap<Name, Symbol.ClassSymbol>();
        }
        this.packages.put(this.names.empty, syms.rootPackage);
        syms.rootPackage.completer = this;
        syms.unnamedPackage.completer = this;
    }

    protected ClassReader(Context context, boolean definitive) {
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
        this.verbosePath = true;
        if (definitive) {
            context.put(classReaderKey, this);
        }
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.classNamesOraculum = context.get(ClassNamesForFileOraculum.class);
        this.init(this.syms, definitive);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.annotate = Annotate.instance(context);
        this.verbose = options.isSet(OptionName.VERBOSE);
        this.checkClassFile = options.isSet("-checkclassfile");
        this.ideMode = options.get("ide") != null;
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowVarargs = source.allowVarargs();
        this.allowAnnotations = source.allowAnnotations();
        this.allowSimplifiedVarargs = source.allowSimplifiedVarargs();
        this.saveParameterNames = options.isSet("save-parameter-names");
        this.cacheCompletionFailure = options.isUnset("dev");
        this.preferSource = "source".equals(options.get("-Xprefer"));
        this.completionFailureName = options.isSet("failcomplete") ? this.names.fromString(options.get("failcomplete")) : null;
        this.typevars = new Scope(this.syms.noSymbol);
        this.lintClassfile = Lint.instance(context).isEnabled(Lint.LintCategory.CLASSFILE);
        this.initAttributeReaders();
    }

    private void enterMember(Symbol.ClassSymbol c, Symbol sym) {
        if ((sym.flags_field & 0x80001000L) != 4096L) {
            c.members_field.enter(sym);
        }
    }

    private JCDiagnostic createBadClassFileDiagnostic(JavaFileObject file, JCDiagnostic diag) {
        String key = file.getKind() == JavaFileObject.Kind.SOURCE ? "bad.source.file.header" : "bad.class.file.header";
        return this.diagFactory.fragment(key, file, diag);
    }

    public BadClassFile badClassFile(String key, Object ... args) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFile, this.diagFactory.fragment(key, args));
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    byte nextByte() {
        return this.buf[this.bp++];
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    char getChar(int bp) {
        return (char)(((this.buf[bp] & 0xFF) << 8) + (this.buf[bp + 1] & 0xFF));
    }

    int getInt(int bp) {
        return ((this.buf[bp] & 0xFF) << 24) + ((this.buf[bp + 1] & 0xFF) << 16) + ((this.buf[bp + 2] & 0xFF) << 8) + (this.buf[bp + 3] & 0xFF);
    }

    long getLong(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bp, 8));
        try {
            return bufin.readLong();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    float getFloat(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bp, 4));
        try {
            return bufin.readFloat();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    double getDouble(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bp, 8));
        try {
            return bufin.readDouble();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.poolObj = new Object[this.poolIdx.length];
        int i = 1;
        block7: while (i < this.poolIdx.length) {
            this.poolIdx[i++] = this.bp;
            byte tag = this.buf[this.bp++];
            switch (tag) {
                case 1: 
                case 2: {
                    char len = this.nextChar();
                    this.bp += len;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: {
                    this.bp += 2;
                    continue block7;
                }
                case 15: {
                    this.bp += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.bp += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++i;
                    continue block7;
                }
            }
            throw this.badClassFile("bad.const.pool.tag.at", Byte.toString(tag), Integer.toString(this.bp - 1));
        }
    }

    Object readPool(int i) {
        Object result = this.poolObj[i];
        if (result != null) {
            return result;
        }
        int index = this.poolIdx[i];
        if (index == 0) {
            return null;
        }
        byte tag = this.buf[index];
        switch (tag) {
            case 1: {
                this.poolObj[i] = this.names.fromUtf(this.buf, index + 3, this.getChar(index + 1));
                break;
            }
            case 2: {
                throw this.badClassFile("unicode.str.not.supported", new Object[0]);
            }
            case 7: {
                this.poolObj[i] = this.readClassOrType(this.getChar(index + 1));
                break;
            }
            case 8: {
                this.poolObj[i] = this.readName(this.getChar(index + 1)).toString();
                break;
            }
            case 9: {
                Symbol.ClassSymbol owner = this.readClassSymbol(this.getChar(index + 1));
                ClassFile.NameAndType nt = (ClassFile.NameAndType)this.readPool(this.getChar(index + 3));
                this.poolObj[i] = new Symbol.VarSymbol(0L, nt.name, nt.type, owner);
                break;
            }
            case 10: 
            case 11: {
                Symbol.ClassSymbol owner = this.readClassSymbol(this.getChar(index + 1));
                ClassFile.NameAndType nt = (ClassFile.NameAndType)this.readPool(this.getChar(index + 3));
                this.poolObj[i] = new Symbol.MethodSymbol(0L, nt.name, nt.type, owner);
                break;
            }
            case 12: {
                this.poolObj[i] = new ClassFile.NameAndType(this.readName(this.getChar(index + 1)), this.readType(this.getChar(index + 3)));
                break;
            }
            case 3: {
                this.poolObj[i] = this.getInt(index + 1);
                break;
            }
            case 4: {
                this.poolObj[i] = new Float(this.getFloat(index + 1));
                break;
            }
            case 5: {
                this.poolObj[i] = new Long(this.getLong(index + 1));
                break;
            }
            case 6: {
                this.poolObj[i] = new Double(this.getDouble(index + 1));
                break;
            }
            case 15: {
                this.skipBytes(4);
                break;
            }
            case 16: {
                this.skipBytes(3);
                break;
            }
            case 18: {
                this.skipBytes(5);
                break;
            }
            default: {
                throw this.badClassFile("bad.const.pool.tag", Byte.toString(tag));
            }
        }
        return this.poolObj[i];
    }

    Type readType(int i) {
        int index = this.poolIdx[i];
        return this.sigToType(this.buf, index + 3, this.getChar(index + 1));
    }

    Object readClassOrType(int i) {
        int index = this.poolIdx[i];
        char len = this.getChar(index + 1);
        int start = index + 3;
        Assert.check(this.buf[start] == 91 || this.buf[start + len - 1] != 59);
        return this.buf[start] == 91 || this.buf[start + len - 1] == 59 ? this.sigToType(this.buf, start, len) : this.enterClass(this.names.fromUtf(ClassFile.internalize(this.buf, start, len)));
    }

    List<Type> readTypeParams(int i) {
        int index = this.poolIdx[i];
        return this.sigToTypeParams(this.buf, index + 3, this.getChar(index + 1));
    }

    Symbol.ClassSymbol readClassSymbol(int i) {
        return (Symbol.ClassSymbol)this.readPool(i);
    }

    Name readName(int i) {
        return (Name)this.readPool(i);
    }

    Type sigToType(byte[] sig, int offset, int len) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + len;
        return this.sigToType();
    }

    Type sigToType() {
        switch ((char)this.signature[this.sigp]) {
            case 'T': {
                ++this.sigp;
                int start = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.sigEnterPhase ? Type.noType : this.findTypeVar(this.names.fromUtf(this.signature, start, this.sigp - 1 - start));
            }
            case '+': {
                ++this.sigp;
                Type t = this.sigToType();
                return new Type.WildcardType(t, BoundKind.EXTENDS, this.syms.boundClass);
            }
            case '*': {
                ++this.sigp;
                return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
            }
            case '-': {
                ++this.sigp;
                Type t = this.sigToType();
                return new Type.WildcardType(t, BoundKind.SUPER, this.syms.boundClass);
            }
            case 'B': {
                ++this.sigp;
                return this.syms.byteType;
            }
            case 'C': {
                ++this.sigp;
                return this.syms.charType;
            }
            case 'D': {
                ++this.sigp;
                return this.syms.doubleType;
            }
            case 'F': {
                ++this.sigp;
                return this.syms.floatType;
            }
            case 'I': {
                ++this.sigp;
                return this.syms.intType;
            }
            case 'J': {
                ++this.sigp;
                return this.syms.longType;
            }
            case 'L': 
            case 'R': {
                Type t = this.classSigToType();
                if (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    throw this.badClassFile("deprecated inner class signature syntax (please recompile from source)", new Object[0]);
                }
                return t;
            }
            case 'S': {
                ++this.sigp;
                return this.syms.shortType;
            }
            case 'V': {
                ++this.sigp;
                return this.syms.voidType;
            }
            case 'Z': {
                ++this.sigp;
                return this.syms.booleanType;
            }
            case '[': {
                ++this.sigp;
                return new Type.ArrayType(this.sigToType(), (Symbol.TypeSymbol)this.syms.arrayClass);
            }
            case '(': {
                ++this.sigp;
                List<Type> argtypes = this.sigToTypes(')');
                Type restype = this.sigToType();
                List<Type> thrown = List.nil();
                while (this.signature[this.sigp] == 94) {
                    ++this.sigp;
                    thrown = thrown.prepend(this.sigToType());
                }
                return new Type.MethodType(argtypes, restype, thrown.reverse(), this.syms.methodClass);
            }
            case '<': {
                this.typevars = this.typevars.dup(this.currentOwner);
                Type.ForAll poly = new Type.ForAll(this.sigToTypeParams(), this.sigToType());
                this.typevars = this.typevars.leave();
                return poly;
            }
        }
        throw this.badClassFile("bad.signature", Convert.utf2string(this.signature, this.sigp, 10));
    }

    Type classSigToType() {
        if (this.signature[this.sigp] != 76 && this.signature[this.sigp] != 82) {
            throw this.badClassFile("bad.class.signature", Convert.utf2string(this.signature, this.sigp, 10));
        }
        boolean err = this.signature[this.sigp] == 82;
        ++this.sigp;
        Type outer = Type.noType;
        int startSbp = this.sbp;
        block10: while (true) {
            byte c = this.signature[this.sigp++];
            switch (c) {
                case 59: {
                    Symbol.ClassSymbol t = this.enterClass(this.names.fromUtf(this.signatureBuffer, startSbp, this.sbp - startSbp));
                    outer = err ? new Type.ErrorType((Type)Type.noType, t, false) : (outer == Type.noType ? t.erasure(this.types) : new Type.ClassType(outer, List.<Type>nil(), t));
                    this.sbp = startSbp;
                    return outer;
                }
                case 60: {
                    Symbol.ClassSymbol t = this.enterClass(this.names.fromUtf(this.signatureBuffer, startSbp, this.sbp - startSbp));
                    outer = new Type.ClassType(outer, this.sigToTypes('>'), t){
                        boolean completed;
                        {
                            this.completed = false;
                        }

                        public Type getEnclosingType() {
                            if (!this.completed) {
                                this.completed = true;
                                try {
                                    this.tsym.complete();
                                }
                                catch (Symbol.CompletionFailure cf) {
                                    // empty catch block
                                }
                                Type enclosingType = this.tsym.type.getEnclosingType();
                                if (enclosingType != Type.noType) {
                                    List<Type> typeArgs = super.getEnclosingType().allparams();
                                    List<Type> typeParams = enclosingType.allparams();
                                    if (typeParams.length() != typeArgs.length()) {
                                        super.setEnclosingType(ClassReader.this.types.erasure(enclosingType));
                                    } else {
                                        super.setEnclosingType(ClassReader.this.types.subst(enclosingType, typeParams, typeArgs));
                                    }
                                } else {
                                    super.setEnclosingType(Type.noType);
                                }
                            }
                            return super.getEnclosingType();
                        }

                        public void setEnclosingType(Type outer) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    switch (this.signature[this.sigp++]) {
                        case 59: {
                            if (this.sigp < this.signature.length && this.signature[this.sigp] == 46) {
                                this.sigp += this.sbp - startSbp + 3;
                                this.signatureBuffer[this.sbp++] = 36;
                                continue block10;
                            }
                            this.sbp = startSbp;
                            return outer;
                        }
                        case 46: {
                            this.signatureBuffer[this.sbp++] = 36;
                            continue block10;
                        }
                    }
                    throw new AssertionError(this.signature[this.sigp - 1]);
                }
                case 46: {
                    this.signatureBuffer[this.sbp++] = 36;
                    continue block10;
                }
                case 47: {
                    this.signatureBuffer[this.sbp++] = 46;
                    continue block10;
                }
            }
            this.signatureBuffer[this.sbp++] = c;
        }
    }

    List<Type> sigToTypes(char terminator) {
        List<Object> head;
        List<Object> tail = head = List.of(null);
        while (this.signature[this.sigp] != terminator) {
            tail = tail.setTail(List.of(this.sigToType()));
        }
        ++this.sigp;
        return head.tail;
    }

    List<Type> sigToTypeParams(byte[] sig, int offset, int len) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + len;
        return this.sigToTypeParams();
    }

    List<Type> sigToTypeParams() {
        List<Type> tvars = List.nil();
        if (this.signature[this.sigp] == 60) {
            ++this.sigp;
            int start = this.sigp;
            this.sigEnterPhase = true;
            while (this.signature[this.sigp] != 62) {
                tvars = tvars.prepend(this.sigToTypeParam());
            }
            this.sigEnterPhase = false;
            this.sigp = start;
            while (this.signature[this.sigp] != 62) {
                this.sigToTypeParam();
            }
            ++this.sigp;
        }
        return tvars.reverse();
    }

    Type sigToTypeParam() {
        Type.TypeVar tvar;
        int start = this.sigp;
        while (this.signature[this.sigp] != 58) {
            ++this.sigp;
        }
        Name name = this.names.fromUtf(this.signature, start, this.sigp - start);
        if (this.sigEnterPhase) {
            tvar = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.typevars.enter(tvar.tsym);
        } else {
            tvar = (Type.TypeVar)this.findTypeVar(name);
        }
        List<Type> bounds = List.nil();
        Type st = null;
        if (this.signature[this.sigp] == 58 && this.signature[this.sigp + 1] == 58) {
            ++this.sigp;
            st = this.syms.objectType;
        }
        while (this.signature[this.sigp] == 58) {
            ++this.sigp;
            bounds = bounds.prepend(this.sigToType());
        }
        if (!this.sigEnterPhase) {
            this.types.setBounds(tvar, bounds.reverse(), st);
        }
        return tvar;
    }

    Type findTypeVar(Name name) {
        Scope.Entry e = this.typevars.lookup(name);
        if (e.scope != null) {
            return e.sym.type;
        }
        if (this.readingClassAttr) {
            Type.TypeVar t = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.missingTypeVariables = this.missingTypeVariables.prepend(t);
            return t;
        }
        throw this.badClassFile("undecl.type.var", name);
    }

    private void initAttributeReaders() {
        AttributeReader[] readers;
        for (AttributeReader r : readers = new AttributeReader[]{new AttributeReader(this.names.Code, ClassFile.Version.V45_3, (Set)this.MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                if (ClassReader.this.readAllOfClassFile || ClassReader.this.saveParameterNames) {
                    ((Symbol.MethodSymbol)sym).code = ClassReader.this.readCode(sym);
                } else {
                    ClassReader.this.bp += attrLen;
                }
            }
        }, new AttributeReader(this.names.ConstantValue, ClassFile.Version.V45_3, (Set)this.MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                Object v = ClassReader.this.readPool(ClassReader.this.nextChar());
                if ((sym.flags() & 0x10L) != 0L) {
                    ((Symbol.VarSymbol)sym).setData(v);
                }
            }
        }, new AttributeReader(this.names.Deprecated, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                sym.flags_field |= 0x20000L;
            }
        }, new AttributeReader(this.names.Exceptions, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                int nexceptions = ClassReader.this.nextChar();
                List<Type> thrown = List.nil();
                for (int j = 0; j < nexceptions; ++j) {
                    thrown = thrown.prepend(ClassReader.this.readClassSymbol((int)ClassReader.this.nextChar()).type);
                }
                if (sym.type.getThrownTypes().isEmpty()) {
                    sym.type.asMethodType().thrown = thrown.reverse();
                }
            }
        }, new AttributeReader(this.names.InnerClasses, ClassFile.Version.V45_3, (Set)this.CLASS_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
                ClassReader.this.readInnerClasses(c);
            }
        }, new AttributeReader(this.names.LocalVariableTable, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                int newbp = ClassReader.this.bp + attrLen;
                if (ClassReader.this.saveParameterNames) {
                    int numEntries = ClassReader.this.nextChar();
                    for (int i = 0; i < numEntries; ++i) {
                        char start_pc = ClassReader.this.nextChar();
                        char length = ClassReader.this.nextChar();
                        char nameIndex = ClassReader.this.nextChar();
                        char sigIndex = ClassReader.this.nextChar();
                        char register = ClassReader.this.nextChar();
                        if (start_pc != '\u0000') continue;
                        if (register >= ClassReader.this.parameterNameIndices.length) {
                            int newSize = Math.max(register, ClassReader.this.parameterNameIndices.length + 8);
                            ClassReader.this.parameterNameIndices = Arrays.copyOf(ClassReader.this.parameterNameIndices, newSize);
                        }
                        ClassReader.this.parameterNameIndices[register] = nameIndex;
                        ClassReader.this.haveParameterNameIndices = true;
                    }
                }
                ClassReader.this.bp = newbp;
            }
        }, new AttributeReader(this.names.SourceFile, ClassFile.Version.V45_3, (Set)this.CLASS_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
                Name n = ClassReader.this.readName(ClassReader.this.nextChar());
                c.sourcefile = new SourceFileObject(n, c.flatname);
            }
        }, new AttributeReader(this.names.Synthetic, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                if (ClassReader.this.allowGenerics || (sym.flags_field & 0x80000000L) == 0L) {
                    sym.flags_field |= 0x1000L;
                }
            }
        }, new AttributeReader(this.names.EnclosingMethod, ClassFile.Version.V49, (Set)this.CLASS_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                int newbp = ClassReader.this.bp + attrLen;
                ClassReader.this.readEnclosingMethodAttr(sym);
                ClassReader.this.bp = newbp;
            }
        }, new AttributeReader(this.names.Signature, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public boolean accepts(AttributeKind kind) {
                return super.accepts(kind) && (ClassReader.this.allowGenerics || ClassReader.this.ideMode);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void read(Symbol sym, int attrLen) {
                block5: {
                    if (sym.kind == 2) {
                        Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
                        ClassReader.this.readingClassAttr = true;
                        try {
                            Type.ClassType ct1 = (Type.ClassType)c.type;
                            Assert.check(c == ClassReader.this.currentOwner);
                            ct1.typarams_field = ClassReader.this.readTypeParams(ClassReader.this.nextChar());
                            ct1.supertype_field = ClassReader.this.sigToType();
                            ListBuffer<Type> is = new ListBuffer<Type>();
                            while (ClassReader.this.sigp != ClassReader.this.siglimit) {
                                is.append(ClassReader.this.sigToType());
                            }
                            ct1.interfaces_field = is.toList();
                            Object var7_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            ClassReader.this.readingClassAttr = false;
                            throw throwable;
                        }
                        ClassReader.this.readingClassAttr = false;
                        {
                            break block5;
                        }
                    }
                    List<Type> thrown = sym.type.getThrownTypes();
                    sym.type = ClassReader.this.readType(ClassReader.this.nextChar());
                    if (sym.kind == 16 && sym.type.getThrownTypes().isEmpty()) {
                        sym.type.asMethodType().thrown = thrown;
                    }
                }
            }
        }, new AttributeReader(this.names.AnnotationDefault, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                ClassReader.this.attachAnnotationDefault(sym);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                ClassReader.this.attachAnnotations(sym);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleParameterAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                ClassReader.this.attachParameterAnnotations(sym);
            }
        }, new AttributeReader(this.names.RuntimeVisibleAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                ClassReader.this.attachAnnotations(sym);
            }
        }, new AttributeReader(this.names.RuntimeVisibleParameterAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                ClassReader.this.attachParameterAnnotations(sym);
            }
        }, new AttributeReader(this.names.Annotation, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                if (ClassReader.this.allowAnnotations || ClassReader.this.ideMode) {
                    sym.flags_field |= 0x2000L;
                }
            }
        }, new AttributeReader(this.names.Bridge, ClassFile.Version.V49, (Set)this.MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                sym.flags_field |= 0x80000000L;
                if (!ClassReader.this.allowGenerics) {
                    sym.flags_field &= 0xFFFFFFFFFFFFEFFFL;
                }
            }
        }, new AttributeReader(this.names.Enum, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                sym.flags_field |= 0x4000L;
            }
        }, new AttributeReader(this.names.Varargs, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                if (ClassReader.this.allowVarargs || ClassReader.this.ideMode) {
                    sym.flags_field |= 0x400000000L;
                }
            }
        }, new AttributeReader(this.names._org_netbeans_TypeSignature, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                sym.type = ClassReader.this.readType(ClassReader.this.nextChar());
            }
        }, new AttributeReader(this.names._org_netbeans_ParameterNames, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                List<Type> parameterTypes;
                int newbp = ClassReader.this.bp + attrLen;
                List<Name> parameterNames = List.nil();
                int numParams = 0;
                if (sym.type != null && (parameterTypes = sym.type.getParameterTypes()) != null) {
                    numParams = parameterTypes.length();
                }
                for (int i = 0; i < numParams; ++i) {
                    if (ClassReader.this.bp >= newbp - 1) continue;
                    parameterNames = parameterNames.prepend(ClassReader.this.readName(ClassReader.this.nextChar()));
                }
                parameterNames = parameterNames.reverse();
                while (parameterNames.length() < numParams) {
                    parameterNames = parameterNames.prepend(ClassReader.this.names.empty);
                }
                ((Symbol.MethodSymbol)sym).savedParameterNames = parameterNames;
            }
        }, new AttributeReader(this.names._org_netbeans_SourceLevelAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                ClassReader.this.attachAnnotations(sym);
            }
        }, new AttributeReader(this.names._org_netbeans_SourceLevelParameterAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            public void read(Symbol sym, int attrLen) {
                ClassReader.this.attachParameterAnnotations(sym);
            }
        }}) {
            this.attributeReaders.put(r.name, r);
        }
    }

    void unrecognized(Name attrName) {
        if (this.checkClassFile) {
            this.printCCF("ccf.unrecognized.attribute", attrName);
        }
    }

    protected void readEnclosingMethodAttr(Symbol sym) {
        sym.owner.members().remove(sym);
        Symbol.ClassSymbol self = (Symbol.ClassSymbol)sym;
        Symbol.ClassSymbol c = this.readClassSymbol(this.nextChar());
        ClassFile.NameAndType nt = (ClassFile.NameAndType)this.readPool(this.nextChar());
        if (c.members_field == null) {
            throw this.badClassFile("bad.enclosing.class", self, c);
        }
        Symbol.MethodSymbol m = this.findMethod(nt, c.members_field, self.flags());
        if (nt != null && m == null) {
            throw this.badClassFile("bad.enclosing.method", self);
        }
        self.name = this.simpleBinaryName(self.flatname, c.flatname);
        self.owner = m != null ? m : c;
        self.fullname = self.name.isEmpty() ? this.names.empty : Symbol.ClassSymbol.formFullName(self.name, self.owner);
        if (c.classfile != null && c.classfile.getKind() == JavaFileObject.Kind.SOURCE) {
            throw new Abort();
        }
        if (m != null) {
            ((Type.ClassType)sym.type).setEnclosingType(m.type);
        } else if ((self.flags_field & 8L) == 0L) {
            ((Type.ClassType)sym.type).setEnclosingType(c.type);
        } else {
            ((Type.ClassType)sym.type).setEnclosingType(Type.noType);
        }
        this.enterTypevars(self);
        if (!this.missingTypeVariables.isEmpty()) {
            ListBuffer<Type> typeVars = new ListBuffer<Type>();
            for (Type typevar : this.missingTypeVariables) {
                typeVars.append(this.findTypeVar(typevar.tsym.name));
            }
            this.foundTypeVariables = typeVars.toList();
        } else {
            this.foundTypeVariables = List.nil();
        }
    }

    protected Name simpleBinaryName(Name self, Name enclosing) {
        int index;
        String selfStr = self.toString();
        String enclStr = enclosing.toString();
        if (selfStr.length() <= enclStr.length()) {
            throw this.badClassFile("bad.enclosing.method", self);
        }
        String simpleBinaryName = selfStr.substring(enclStr.length());
        if (simpleBinaryName.length() < 1 || simpleBinaryName.charAt(0) != '$') {
            throw this.badClassFile("bad.enclosing.method", self);
        }
        for (index = 1; index < simpleBinaryName.length() && ClassReader.isAsciiDigit(simpleBinaryName.charAt(index)); ++index) {
        }
        return this.names.fromString(simpleBinaryName.substring(index));
    }

    private Symbol.MethodSymbol findMethod(ClassFile.NameAndType nt, Scope scope, long flags) {
        if (nt == null) {
            return null;
        }
        Type.MethodType type = nt.type.asMethodType();
        Scope.Entry e = scope.lookup(nt.name);
        while (e.scope != null) {
            if (e.sym.kind == 16 && this.isSameBinaryType(e.sym.type.asMethodType(), type)) {
                return (Symbol.MethodSymbol)e.sym;
            }
            e = e.next();
        }
        if (nt.name != this.names.init) {
            return null;
        }
        if ((flags & 0x200L) != 0L) {
            return null;
        }
        if (nt.type.getParameterTypes().isEmpty()) {
            return null;
        }
        nt.type = new Type.MethodType(nt.type.getParameterTypes().tail, nt.type.getReturnType(), nt.type.getThrownTypes(), this.syms.methodClass);
        return this.findMethod(nt, scope, flags);
    }

    protected boolean isSameBinaryType(Type.MethodType mt1, Type.MethodType mt2) {
        List<Type> types1 = this.types.erasure((List<Type>)mt1.getParameterTypes()).prepend(this.types.erasure(mt1.getReturnType()));
        List<Type> types2 = ((List)mt2.getParameterTypes()).prepend(mt2.getReturnType());
        while (!types1.isEmpty() && !types2.isEmpty()) {
            if (((Type)types1.head).tsym != ((Type)types2.head).tsym) {
                return false;
            }
            types1 = types1.tail;
            types2 = types2.tail;
        }
        return types1.isEmpty() && types2.isEmpty();
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    void readMemberAttrs(Symbol sym) {
        this.readAttrs(sym, AttributeKind.MEMBER);
    }

    void readAttrs(Symbol sym, AttributeKind kind) {
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            Name attrName = this.readName(this.nextChar());
            int attrLen = this.nextInt();
            AttributeReader r = this.attributeReaders.get(attrName);
            if (r != null && r.accepts(kind)) {
                r.read(sym, attrLen);
                continue;
            }
            this.unrecognized(attrName);
            this.bp += attrLen;
        }
    }

    void readClassAttrs(Symbol.ClassSymbol c) {
        this.readAttrs(c, AttributeKind.CLASS);
    }

    Code readCode(Symbol owner) {
        this.nextChar();
        this.nextChar();
        int code_length = this.nextInt();
        this.bp += code_length;
        char exception_table_length = this.nextChar();
        this.bp += exception_table_length * 8;
        this.readMemberAttrs(owner);
        return null;
    }

    void attachAnnotations(Symbol sym) {
        int numAttributes = this.nextChar();
        if (numAttributes != 0) {
            ListBuffer<CompoundAnnotationProxy> proxies = new ListBuffer<CompoundAnnotationProxy>();
            for (int i = 0; i < numAttributes; ++i) {
                CompoundAnnotationProxy proxy = this.readCompoundAnnotation();
                if (proxy.type.tsym == this.syms.proprietaryType.tsym) {
                    sym.flags_field |= 0x4000000000L;
                } else {
                    proxies.append(proxy);
                }
                if (this.majorVersion < ClassFile.Version.V51.major || proxy.type.tsym != this.syms.polymorphicSignatureType.tsym && proxy.type.tsym != this.syms.transientPolymorphicSignatureType.tsym) continue;
                sym.flags_field |= 0x10000000000L;
            }
            this.annotate.later(new AnnotationCompleter(sym, proxies.toList()));
        }
    }

    void attachParameterAnnotations(Symbol method) {
        Symbol.MethodSymbol meth = (Symbol.MethodSymbol)method;
        int numParameters = this.buf[this.bp++] & 0xFF;
        List<Symbol.VarSymbol> parameters = meth.params();
        int pnum = 0;
        while (parameters.tail != null) {
            this.attachAnnotations((Symbol)parameters.head);
            parameters = parameters.tail;
            ++pnum;
        }
        if (pnum != numParameters) {
            throw this.badClassFile("bad.runtime.invisible.param.annotations", meth);
        }
    }

    void attachAnnotationDefault(Symbol sym) {
        Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
        Attribute value = this.readAttributeValue();
        this.annotate.later(new AnnotationDefaultCompleter(meth, value));
    }

    Type readTypeOrClassSymbol(int i) {
        if (this.buf[this.poolIdx[i]] == 7) {
            return this.readClassSymbol((int)i).type;
        }
        return this.readType(i);
    }

    Type readEnumType(int i) {
        int index = this.poolIdx[i];
        char length = this.getChar(index + 1);
        if (this.buf[index + length + 2] != 59) {
            return this.enterClass((Name)this.readName((int)i)).type;
        }
        return this.readType(i);
    }

    CompoundAnnotationProxy readCompoundAnnotation() {
        Type t = this.readTypeOrClassSymbol(this.nextChar());
        int numFields = this.nextChar();
        ListBuffer<Pair<Name, Attribute>> pairs = new ListBuffer<Pair<Name, Attribute>>();
        for (int i = 0; i < numFields; ++i) {
            Name name = this.readName(this.nextChar());
            Attribute value = this.readAttributeValue();
            pairs.append(new Pair<Name, Attribute>(name, value));
        }
        return new CompoundAnnotationProxy(t, pairs.toList());
    }

    Attribute readAttributeValue() {
        char c = (char)this.buf[this.bp++];
        switch (c) {
            case 'B': {
                return new Attribute.Constant(this.syms.byteType, this.readPool(this.nextChar()));
            }
            case 'C': {
                return new Attribute.Constant(this.syms.charType, this.readPool(this.nextChar()));
            }
            case 'D': {
                return new Attribute.Constant(this.syms.doubleType, this.readPool(this.nextChar()));
            }
            case 'F': {
                return new Attribute.Constant(this.syms.floatType, this.readPool(this.nextChar()));
            }
            case 'I': {
                return new Attribute.Constant(this.syms.intType, this.readPool(this.nextChar()));
            }
            case 'J': {
                return new Attribute.Constant(this.syms.longType, this.readPool(this.nextChar()));
            }
            case 'S': {
                return new Attribute.Constant(this.syms.shortType, this.readPool(this.nextChar()));
            }
            case 'Z': {
                return new Attribute.Constant(this.syms.booleanType, this.readPool(this.nextChar()));
            }
            case 's': {
                return new Attribute.Constant(this.syms.stringType, this.readPool(this.nextChar()).toString());
            }
            case 'e': {
                return new EnumAttributeProxy(this.readEnumType(this.nextChar()), this.readName(this.nextChar()));
            }
            case 'c': {
                return new Attribute.Class(this.types, this.readTypeOrClassSymbol(this.nextChar()));
            }
            case '[': {
                int n = this.nextChar();
                ListBuffer<Attribute> l = new ListBuffer<Attribute>();
                for (int i = 0; i < n; ++i) {
                    l.append(this.readAttributeValue());
                }
                return new ArrayAttributeProxy(l.toList());
            }
            case '@': {
                return this.readCompoundAnnotation();
            }
        }
        throw new AssertionError((Object)("unknown annotation tag '" + c + "'"));
    }

    Symbol.VarSymbol readField() {
        long flags = this.adjustFieldFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        Symbol.VarSymbol v = new Symbol.VarSymbol(flags, name, type, this.currentOwner);
        this.readMemberAttrs(v);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol.MethodSymbol readMethod() {
        long flags = this.adjustMethodFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        if (name == this.names.init && this.currentOwner.hasOuterInstance() && !this.currentOwner.name.isEmpty()) {
            type = new Type.MethodType(this.adjustMethodParams(flags, type.getParameterTypes()), type.getReturnType(), type.getThrownTypes(), this.syms.methodClass);
        }
        Symbol.MethodSymbol m = new Symbol.MethodSymbol(flags, name, type, this.currentOwner);
        if (this.saveParameterNames) {
            this.initParameterNames(m);
        }
        Symbol prevOwner = this.currentOwner;
        this.currentOwner = m;
        try {
            this.readMemberAttrs(m);
            Object var8_6 = null;
            this.currentOwner = prevOwner;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.currentOwner = prevOwner;
            throw throwable;
        }
        if (this.saveParameterNames) {
            this.setParameterNames(m, type);
        }
        return m;
    }

    private List<Type> adjustMethodParams(long flags, List<Type> args) {
        boolean isVarargs;
        boolean bl = isVarargs = (flags & 0x400000000L) != 0L;
        if (isVarargs) {
            Type varargsElem = args.last();
            ListBuffer adjustedArgs = ListBuffer.lb();
            for (Type t : args) {
                adjustedArgs.append(t != varargsElem ? t : ((Type.ArrayType)t).makeVarargs());
            }
            args = adjustedArgs.toList();
        }
        return args.tail;
    }

    void initParameterNames(Symbol.MethodSymbol sym) {
        int excessSlots = 4;
        int expectedParameterSlots = Code.width(sym.type.getParameterTypes()) + 4;
        if (this.parameterNameIndices == null || this.parameterNameIndices.length < expectedParameterSlots) {
            this.parameterNameIndices = new int[expectedParameterSlots];
        } else {
            Arrays.fill(this.parameterNameIndices, 0);
        }
        this.haveParameterNameIndices = false;
    }

    void setParameterNames(Symbol.MethodSymbol sym, Type jvmType) {
        int firstParam;
        if (!this.haveParameterNameIndices || sym.type == null || sym.type.getParameterTypes() == null) {
            return;
        }
        int n = firstParam = (sym.flags() & 8L) == 0L ? 1 : 0;
        if (sym.name == this.names.init && this.currentOwner.hasOuterInstance() && !this.currentOwner.name.isEmpty()) {
            ++firstParam;
        }
        if (sym.type != jvmType) {
            int skip = Code.width(jvmType.getParameterTypes()) - Code.width(sym.type.getParameterTypes());
            firstParam += skip;
        }
        List<Name> paramNames = List.nil();
        int index = firstParam;
        for (Type t : sym.type.getParameterTypes()) {
            int nameIdx = index < this.parameterNameIndices.length ? this.parameterNameIndices[index] : 0;
            Name name = nameIdx == 0 ? this.names.empty : this.readName(nameIdx);
            paramNames = paramNames.prepend(name);
            index += Code.width(t);
        }
        sym.savedParameterNames = paramNames.reverse();
    }

    void skipBytes(int n) {
        this.bp += n;
    }

    void skipMember() {
        this.bp += 6;
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            this.bp += 2;
            int attrLen = this.nextInt();
            this.bp += attrLen;
        }
    }

    protected void enterTypevars(Type t) {
        if (t.getEnclosingType() != null && t.getEnclosingType().tag == 10) {
            this.enterTypevars(t.getEnclosingType());
        }
        List<Type> xs = t.getTypeArguments();
        while (xs.nonEmpty()) {
            this.typevars.enter(((Type)xs.head).tsym);
            xs = xs.tail;
        }
    }

    protected void enterTypevars(Symbol sym) {
        if (sym.owner.kind == 16) {
            this.enterTypevars(sym.owner);
            this.enterTypevars(sym.owner.owner);
        }
        this.enterTypevars(sym.type);
    }

    void readClass(Symbol.ClassSymbol c) {
        int i;
        int i2;
        Symbol.ClassSymbol self;
        Type.ClassType ct = (Type.ClassType)c.type;
        c.members_field = new Scope(c);
        this.typevars = this.typevars.dup(this.currentOwner);
        if (ct.getEnclosingType().tag == 10) {
            this.enterTypevars(ct.getEnclosingType());
        }
        long flags = this.adjustClassFlags(this.nextChar());
        if (c.owner.kind == 1) {
            c.flags_field = flags;
        }
        if (c != (self = this.readClassSymbol(this.nextChar()))) {
            throw this.badClassFile("class.file.wrong.class", self.flatname);
        }
        int startbp = this.bp;
        this.nextChar();
        char interfaceCount = this.nextChar();
        this.bp += interfaceCount * 2;
        int fieldCount = this.nextChar();
        for (int i3 = 0; i3 < fieldCount; ++i3) {
            this.skipMember();
        }
        int methodCount = this.nextChar();
        for (i2 = 0; i2 < methodCount; ++i2) {
            this.skipMember();
        }
        this.readClassAttrs(c);
        if (this.readAllOfClassFile) {
            for (i2 = 1; i2 < this.poolObj.length; ++i2) {
                this.readPool(i2);
            }
            c.pool = new Pool(this.poolObj.length, this.poolObj);
        }
        this.bp = startbp;
        int n = this.nextChar();
        if (ct.supertype_field == null) {
            ct.supertype_field = n == 0 ? Type.noType : this.readClassSymbol(n).erasure(this.types);
        }
        n = this.nextChar();
        List<Type> is = List.nil();
        for (i = 0; i < n; ++i) {
            Type _inter = this.readClassSymbol(this.nextChar()).erasure(this.types);
            is = is.prepend(_inter);
        }
        if (ct.interfaces_field == null) {
            ct.interfaces_field = is.reverse();
        }
        Assert.check(fieldCount == this.nextChar());
        for (i = 0; i < fieldCount; ++i) {
            this.enterMember(c, this.readField());
        }
        Assert.check(methodCount == this.nextChar());
        for (i = 0; i < methodCount; ++i) {
            this.enterMember(c, this.readMethod());
        }
        this.typevars = this.typevars.leave();
    }

    void readInnerClasses(Symbol.ClassSymbol c) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            Symbol.ClassSymbol outer = this.readClassSymbol(this.nextChar());
            Name name = this.readName(this.nextChar());
            if (name == null) {
                name = this.names.empty;
            }
            long flags = this.adjustClassFlags(this.nextChar());
            if (outer == null) continue;
            if (name == this.names.empty) {
                name = this.names.one;
            }
            Symbol.ClassSymbol member = this.enterClass(name, outer);
            if ((flags & 8L) == 0L) {
                ((Type.ClassType)member.type).setEnclosingType(outer.type);
                if (member.erasure_field != null) {
                    ((Type.ClassType)member.erasure_field).setEnclosingType(this.types.erasure(outer.type));
                }
            }
            if (c != outer) continue;
            member.flags_field = flags;
            this.enterMember(c, member);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readClassFile(Symbol.ClassSymbol c) throws IOException {
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw this.badClassFile("illegal.start.of.class.file", new Object[0]);
        }
        this.minorVersion = this.nextChar();
        this.majorVersion = this.nextChar();
        int maxMajor = Target.MAX().majorVersion;
        int maxMinor = Target.MAX().minorVersion;
        if (this.majorVersion > maxMajor || this.majorVersion * 1000 + this.minorVersion < Target.MIN().majorVersion * 1000 + Target.MIN().minorVersion) {
            if (this.majorVersion != maxMajor + 1) throw this.badClassFile("wrong.version", Integer.toString(this.majorVersion), Integer.toString(this.minorVersion), Integer.toString(maxMajor), Integer.toString(maxMinor));
            this.log.warning("big.major.version", this.currentClassFile, this.majorVersion, maxMajor);
        } else if (this.checkClassFile && this.majorVersion == maxMajor && this.minorVersion > maxMinor) {
            this.printCCF("found.later.version", Integer.toString(this.minorVersion));
        }
        this.indexPool();
        if (this.signatureBuffer.length < this.bp) {
            int ns = Integer.highestOneBit(this.bp) << 1;
            this.signatureBuffer = new byte[ns];
        }
        this.readClass(c);
    }

    long adjustFieldFlags(long flags) {
        return flags | 0x2000000000000000L;
    }

    long adjustMethodFlags(long flags) {
        if ((flags & 0x40L) != 0L) {
            flags &= 0xFFFFFFFFFFFFFFBFL;
            flags |= 0x80000000L;
            if (!this.allowGenerics) {
                flags &= 0xFFFFFFFFFFFFEFFFL;
            }
        }
        if ((flags & 0x80L) != 0L) {
            flags &= 0xFFFFFFFFFFFFFF7FL;
            flags |= 0x400000000L;
        }
        return flags |= 0x2000000000000000L;
    }

    long adjustClassFlags(long flags) {
        return (flags |= 0x2000000000000000L) & 0xFFFFFFFFFFFFFFDFL;
    }

    public Symbol.ClassSymbol defineClass(Name name, Symbol owner) {
        Symbol.ClassSymbol c = new Symbol.ClassSymbol(0L, name, owner);
        if (owner.kind == 1) {
            Assert.checkNull((Object)this.classes.get(c.flatname), c);
        }
        c.completer = this;
        return c;
    }

    public Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol owner) {
        Name flatname = Symbol.TypeSymbol.formFlatName(name, owner);
        Symbol.ClassSymbol c = this.classes.get(flatname);
        if (c == null) {
            c = this.defineClass(name, owner);
            this.classes.put(flatname, c);
        } else if ((c.name != name || c.owner != owner) && owner.kind == 2 && c.owner.kind == 1) {
            c.owner.members().remove(c);
            c.name = name;
            c.owner = owner;
            c.fullname = Symbol.ClassSymbol.formFullName(name, owner);
        }
        return c;
    }

    public Symbol.ClassSymbol enterClass(Name flatname, Name name, Symbol owner) {
        Symbol.ClassSymbol c = this.classes.get(flatname);
        if (c == null) {
            c = this.defineClass(name, owner);
            c.flatname = flatname;
            this.classes.put(flatname, c);
        } else if ((c.name != name || c.owner != owner) && (c.owner.kind & 3) != 0) {
            c.owner.members().remove(c);
            c.name = name;
            c.owner = owner;
            c.fullname = Symbol.ClassSymbol.formFullName(name, owner);
        }
        return c;
    }

    public Symbol.ClassSymbol enterClass(Name flatName, JavaFileObject classFile) {
        Symbol.ClassSymbol cs = this.classes.get(flatName);
        if (cs != null) {
            String msg = Log.format("%s: completer = %s; class file = %s; source file = %s", cs.fullname, cs.completer, cs.classfile, cs.sourcefile);
            throw new AssertionError((Object)msg);
        }
        Name packageName = Convert.packagePart(flatName);
        Symbol.PackageSymbol owner = packageName.isEmpty() ? this.syms.unnamedPackage : this.enterPackage(packageName);
        cs = this.defineClass(Convert.shortName(flatName), owner);
        cs.classfile = classFile;
        this.classes.put(flatName, cs);
        return cs;
    }

    public Symbol.ClassSymbol enterClass(Name flatname) {
        Symbol.ClassSymbol c;
        if (flatname == null) {
            flatname = this.names.empty;
        }
        if ((c = this.classes.get(flatname)) == null) {
            return this.enterClass(flatname, (JavaFileObject)null);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (sym.kind == 2) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
            c.members_field = new Scope.ErrorScope(c);
            Scope.ErrorScope tempScope = c.members_field;
            boolean saveSuppressFlush = this.suppressFlush;
            this.suppressFlush = true;
            try {
                this.completeOwners(c.owner);
                this.completeEnclosing(c);
                Object var6_7 = null;
                this.suppressFlush = saveSuppressFlush;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.suppressFlush = saveSuppressFlush;
                throw throwable;
            }
            if (c.members_field == tempScope) {
                try {
                    this.fillIn(c);
                }
                catch (Abort a) {
                    this.classes.remove(c.flatname);
                }
            }
        } else if (sym.kind == 1) {
            Symbol.PackageSymbol p = (Symbol.PackageSymbol)sym;
            try {
                this.fillIn(p);
            }
            catch (IOException ex) {
                throw new Symbol.CompletionFailure(sym, ex.getLocalizedMessage()).initCause(ex);
            }
        }
        if (!this.filling && !this.suppressFlush) {
            this.annotate.flush();
        }
    }

    private void completeOwners(Symbol o) {
        if (o.kind != 1) {
            this.completeOwners(o.owner);
        }
        o.complete();
    }

    private void completeEnclosing(Symbol.ClassSymbol c) {
        if (c.owner.kind == 1) {
            Symbol owner = c.owner;
            for (Name name : Convert.enclosingCandidates(Convert.shortName(c.name))) {
                Symbol encl = owner.members().lookup((Name)name).sym;
                if (encl == null) {
                    encl = this.classes.get(Symbol.TypeSymbol.formFlatName(name, owner));
                }
                if (encl == null) continue;
                encl.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillIn(Symbol.ClassSymbol c) {
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure((Symbol)c, "user-selected completion failure by class name");
        }
        this.currentOwner = c;
        this.warnedAttrs.clear();
        JavaFileObject classfile = c.classfile;
        if (classfile != null) {
            JavaFileObject previousClassFile = this.currentClassFile;
            try {
                try {
                    block19: {
                        if (this.filling) {
                            StringBuilder sb = new StringBuilder();
                            for (StackTraceElement[] trace : Thread.getAllStackTraces().values()) {
                                for (StackTraceElement element : trace) {
                                    sb.append(element).append('\n');
                                }
                                sb.append('\n');
                            }
                            Assert.error("Filling " + classfile.toUri() + " during " + previousClassFile + "\n" + sb);
                        }
                        this.currentClassFile = classfile;
                        if (this.verbose) {
                            this.log.printVerbose("loading", this.currentClassFile.toString());
                        }
                        if (classfile.getKind() == JavaFileObject.Kind.CLASS) {
                            this.filling = true;
                            try {
                                this.bp = 0;
                                this.buf = ClassReader.readInputStream(this.buf, classfile.openInputStream());
                                this.readClassFile(c);
                                if (!this.missingTypeVariables.isEmpty() && !this.foundTypeVariables.isEmpty()) {
                                    List<Type> missing = this.missingTypeVariables;
                                    List<Type> found = this.foundTypeVariables;
                                    this.missingTypeVariables = List.nil();
                                    this.foundTypeVariables = List.nil();
                                    this.filling = false;
                                    Type.ClassType ct = (Type.ClassType)this.currentOwner.type;
                                    ct.supertype_field = this.types.subst(ct.supertype_field, missing, found);
                                    ct.interfaces_field = this.types.subst(ct.interfaces_field, missing, found);
                                } else if (this.missingTypeVariables.isEmpty() != this.foundTypeVariables.isEmpty()) {
                                    Name name = ((Type)this.missingTypeVariables.head).tsym.name;
                                    throw this.badClassFile("undecl.type.var", name);
                                }
                                Object var12_13 = null;
                            }
                            catch (Throwable throwable) {
                                Object var12_14 = null;
                                this.missingTypeVariables = List.nil();
                                this.foundTypeVariables = List.nil();
                                this.filling = false;
                                throw throwable;
                            }
                            this.missingTypeVariables = List.nil();
                            this.foundTypeVariables = List.nil();
                            this.filling = false;
                            {
                                break block19;
                            }
                        }
                        if (this.sourceCompleter != null) {
                            if (!classfile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE)) {
                                this.sourceCompleter.complete(c);
                            }
                        } else {
                            throw new IllegalStateException("Source completer required to read " + classfile.toUri());
                        }
                    }
                    Object var14_16 = null;
                    this.currentClassFile = previousClassFile;
                    return;
                }
                catch (IOException ex) {
                    throw this.badClassFile("unable.to.access.file", ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                this.currentClassFile = previousClassFile;
                throw throwable;
            }
        }
        JCDiagnostic diag = this.diagFactory.fragment("class.file.not.found", c.flatname);
        throw this.newCompletionFailure(c, diag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readInputStream(byte[] buf, InputStream s) throws IOException {
        byte[] byArray;
        try {
            buf = ClassReader.ensureCapacity(buf, s.available());
            int r = s.read(buf);
            int bp = 0;
            while (r != -1) {
                buf = ClassReader.ensureCapacity(buf, bp += r);
                r = s.read(buf, bp, buf.length - bp);
            }
            byArray = buf;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                s.close();
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            s.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return byArray;
    }

    private static byte[] ensureCapacity(byte[] buf, int needed) {
        if (buf.length <= needed) {
            byte[] old = buf;
            buf = new byte[Integer.highestOneBit(needed) << 1];
            System.arraycopy(old, 0, buf, 0, old.length);
        }
        return buf;
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.TypeSymbol c, JCDiagnostic diag) {
        if (!this.cacheCompletionFailure) {
            return new Symbol.CompletionFailure((Symbol)c, diag);
        }
        Symbol.CompletionFailure result = this.cachedCompletionFailure;
        result.sym = c;
        result.diag = diag;
        return result;
    }

    public Symbol.ClassSymbol loadClass(Name flatname) throws Symbol.CompletionFailure {
        boolean absent = this.classes.get(flatname) == null;
        Symbol.ClassSymbol c = this.enterClass(flatname);
        if (c.members_field == null && c.completer != null) {
            try {
                c.complete();
            }
            catch (Symbol.CompletionFailure ex) {
                if (absent) {
                    this.classes.remove(flatname);
                }
                throw ex;
            }
        }
        return c;
    }

    public boolean packageExists(Name fullname) {
        return this.enterPackage(fullname).exists();
    }

    public Symbol.PackageSymbol enterPackage(Name fullname) {
        Symbol.PackageSymbol p = this.packages.get(fullname);
        if (p == null) {
            Assert.check(!fullname.isEmpty(), "rootPackage missing!");
            p = new Symbol.PackageSymbol(Convert.shortName(fullname), this.enterPackage(Convert.packagePart(fullname)));
            p.completer = this;
            this.packages.put(fullname, p);
        }
        return p;
    }

    public Symbol.PackageSymbol enterPackage(Name name, Symbol.PackageSymbol owner) {
        return this.enterPackage(Symbol.TypeSymbol.formFullName(name, owner));
    }

    protected void includeClassFile(Symbol.PackageSymbol p, JavaFileObject file) {
        String binaryName = this.fileManager.inferBinaryName(this.currentLoc, file);
        this.includeClassFile(p, file, binaryName);
    }

    protected void includeClassFile(Symbol.PackageSymbol p, JavaFileObject file, String binaryName) {
        Symbol.ClassSymbol c;
        JavaFileObject.Kind kind;
        if ((p.flags_field & 0x800000L) == 0L) {
            Symbol q = p;
            while (q != null && q.kind == 1) {
                q.flags_field |= 0x800000L;
                q = q.owner;
            }
        }
        int seen = (kind = file.getKind()) == JavaFileObject.Kind.CLASS ? 0x2000000 : 0x4000000;
        int lastDot = binaryName.lastIndexOf(".");
        Name classname = this.names.fromString(binaryName.substring(lastDot + 1));
        boolean isPkgInfo = classname == this.names.package_info;
        Symbol.ClassSymbol classSymbol = c = isPkgInfo ? p.package_info : (Symbol.ClassSymbol)p.members_field.lookup((Name)classname).sym;
        if (c == null) {
            c = this.enterClass(classname, p);
            if (c.classfile == null) {
                c.classfile = file;
            }
            if (isPkgInfo) {
                p.package_info = c;
            } else if (c.owner == p) {
                p.members_field.enter(c);
            }
        } else if (c.classfile != null && (c.flags_field & (long)seen) == 0L) {
            if ((c.flags_field & 0x6000000L) != 0L) {
                c.classfile = this.preferredFileObject(file, c.classfile);
            }
        } else if (c.classfile != null && this.isSigOverClass(c.classfile, file)) {
            c.classfile = file;
        }
        c.flags_field |= (long)seen;
    }

    private boolean isSigOverClass(JavaFileObject a, JavaFileObject b) {
        String patha = a.getName().toLowerCase();
        String pathb = b.getName().toLowerCase();
        return pathb.endsWith(".sig") && patha.endsWith(".class");
    }

    protected JavaFileObject preferredFileObject(JavaFileObject a, JavaFileObject b) {
        long bdate;
        if (this.preferSource && !b.getName().toLowerCase().endsWith(".sig")) {
            return a.getKind() == JavaFileObject.Kind.SOURCE ? a : b;
        }
        long adate = a.getLastModified();
        return adate > (bdate = b.getLastModified()) ? a : b;
    }

    protected EnumSet<JavaFileObject.Kind> getPackageFileKinds() {
        return EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);
    }

    protected void extraFileActions(Symbol.PackageSymbol pack, JavaFileObject fe) {
    }

    private void fillIn(Symbol.PackageSymbol p) throws IOException {
        if (p.members_field == null) {
            p.members_field = new Scope(p);
        }
        String packageName = p.fullname.toString();
        EnumSet<JavaFileObject.Kind> kinds = this.getPackageFileKinds();
        this.fillIn(p, StandardLocation.PLATFORM_CLASS_PATH, this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, packageName, EnumSet.of(JavaFileObject.Kind.CLASS), false));
        EnumSet<JavaFileObject.Kind> classKinds = EnumSet.copyOf(kinds);
        classKinds.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean wantClassFiles = !classKinds.isEmpty();
        EnumSet<JavaFileObject.Kind> sourceKinds = EnumSet.copyOf(kinds);
        sourceKinds.remove((Object)JavaFileObject.Kind.CLASS);
        boolean wantSourceFiles = !sourceKinds.isEmpty();
        boolean haveSourcePath = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH);
        if (this.verbose && this.verbosePath && this.fileManager instanceof StandardJavaFileManager) {
            List<Object> path;
            StandardJavaFileManager fm = (StandardJavaFileManager)this.fileManager;
            if (haveSourcePath && wantSourceFiles) {
                path = List.nil();
                for (File file : fm.getLocation(StandardLocation.SOURCE_PATH)) {
                    path = path.prepend(file);
                }
                this.log.printVerbose("sourcepath", path.reverse().toString());
            } else if (wantSourceFiles) {
                path = List.nil();
                for (File file : fm.getLocation(StandardLocation.CLASS_PATH)) {
                    path = path.prepend(file);
                }
                this.log.printVerbose("sourcepath", path.reverse().toString());
            }
            if (wantClassFiles) {
                path = List.nil();
                for (File file : fm.getLocation(StandardLocation.PLATFORM_CLASS_PATH)) {
                    path = path.prepend(file);
                }
                for (File file : fm.getLocation(StandardLocation.CLASS_PATH)) {
                    path = path.prepend(file);
                }
                this.log.printVerbose("classpath", path.reverse().toString());
            }
        }
        if (wantSourceFiles && !haveSourcePath) {
            this.fillIn(p, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, packageName, kinds, false));
        } else {
            if (wantClassFiles) {
                this.fillIn(p, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, packageName, classKinds, false));
            }
            if (wantSourceFiles) {
                this.fillIn(p, StandardLocation.SOURCE_PATH, this.fileManager.list(StandardLocation.SOURCE_PATH, packageName, sourceKinds, false));
            }
        }
        this.verbosePath = false;
    }

    private void fillIn(Symbol.PackageSymbol p, JavaFileManager.Location location, Iterable<JavaFileObject> files) {
        JavaFileObject[] sources;
        this.currentLoc = location;
        block3: for (JavaFileObject fo : files) {
            switch (fo.getKind()) {
                case CLASS: 
                case SOURCE: {
                    String binaryName;
                    String[] binaryNames = null;
                    if (this.classNamesOraculum != null) {
                        binaryNames = this.classNamesOraculum.divineClassName(fo);
                    }
                    if (binaryNames == null && (binaryName = this.fileManager.inferBinaryName(this.currentLoc, fo)) != null) {
                        binaryNames = new String[]{binaryName};
                    }
                    if (binaryNames == null) continue block3;
                    for (String binaryName2 : binaryNames) {
                        String simpleName = binaryName2.substring(binaryName2.lastIndexOf(".") + 1);
                        if (!SourceVersion.isIdentifier(simpleName) && !simpleName.equals("package-info")) continue;
                        this.includeClassFile(p, fo);
                    }
                    continue block3;
                }
                default: {
                    this.extraFileActions(p, fo);
                }
            }
        }
        if (this.classNamesOraculum != null && location == StandardLocation.SOURCE_PATH && (sources = this.classNamesOraculum.divineSources(p.fullname.toString())) != null) {
            for (JavaFileObject fo : sources) {
                for (String binaryName : this.classNamesOraculum.divineClassName(fo)) {
                    String simpleName = binaryName.substring(binaryName.lastIndexOf(".") + 1);
                    if (!SourceVersion.isIdentifier(simpleName) && !simpleName.equals("package-info")) continue;
                    this.includeClassFile(p, fo, binaryName);
                }
            }
        }
    }

    private void printCCF(String key, Object arg) {
        this.log.printNoteLines(key, arg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceFileObject
    extends BaseFileObject {
        private Name name;
        private Name flatname;

        public SourceFileObject(Name name, Name flatname) {
            super(null);
            this.name = name;
            this.flatname = flatname;
        }

        @Override
        public URI toUri() {
            try {
                return new URI(null, this.name.toString(), null);
            }
            catch (URISyntaxException e) {
                throw new BaseFileObject.CannotCreateUriError(this.name.toString(), e);
            }
        }

        @Override
        public String getName() {
            return this.name.toString();
        }

        @Override
        public String getShortName() {
            return this.getName();
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return SourceFileObject.getKind(this.getName());
        }

        @Override
        public InputStream openInputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream openOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> path) {
            return this.flatname.toString();
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return true;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceFileObject)) {
                return false;
            }
            SourceFileObject o = (SourceFileObject)other;
            return this.name.equals(o.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static interface SourceCompleter {
        public void complete(Symbol.ClassSymbol var1) throws Symbol.CompletionFailure;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AnnotationCompleter
    extends AnnotationDeproxy
    implements Annotate.Annotator {
        final Symbol sym;
        final List<CompoundAnnotationProxy> l;
        final JavaFileObject classFile;

        @Override
        public String toString() {
            return " ClassReader annotate " + this.sym.owner + "." + this.sym + " with " + this.l;
        }

        public AnnotationCompleter(Symbol sym, List<CompoundAnnotationProxy> l) {
            this.sym = sym;
            this.l = l;
            this.classFile = ClassReader.this.currentClassFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enterAnnotation() {
            JavaFileObject previousClassFile = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                List<Attribute.Compound> newList = this.deproxyCompoundList(this.l);
                this.sym.attributes_field = this.sym.attributes_field == null ? newList : newList.prependList(this.sym.attributes_field);
                Object var4_3 = null;
                ClassReader.this.currentClassFile = previousClassFile;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ClassReader.this.currentClassFile = previousClassFile;
                throw throwable;
            }
        }
    }

    protected class AnnotationDefaultCompleter
    extends AnnotationDeproxy
    implements Annotate.Annotator {
        final Symbol.MethodSymbol sym;
        final Attribute value;
        final JavaFileObject classFile;

        public String toString() {
            return " ClassReader store default for " + this.sym.owner + "." + this.sym + " is " + this.value;
        }

        public AnnotationDefaultCompleter(Symbol.MethodSymbol sym, Attribute value) {
            this.classFile = ClassReader.this.currentClassFile;
            this.sym = sym;
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enterAnnotation() {
            JavaFileObject previousClassFile = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                this.sym.defaultValue = this.deproxy(this.sym.type.getReturnType(), this.value);
                Object var3_2 = null;
                ClassReader.this.currentClassFile = previousClassFile;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ClassReader.this.currentClassFile = previousClassFile;
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationDeproxy
    implements ProxyVisitor {
        private Symbol.ClassSymbol requestingOwner;
        Attribute result;
        Type type;

        AnnotationDeproxy() {
            this.requestingOwner = ClassReader.this.currentOwner.kind == 16 ? ClassReader.this.currentOwner.enclClass() : (Symbol.ClassSymbol)ClassReader.this.currentOwner;
        }

        List<Attribute.Compound> deproxyCompoundList(List<CompoundAnnotationProxy> pl) {
            ListBuffer<Attribute.Compound> buf = new ListBuffer<Attribute.Compound>();
            List<CompoundAnnotationProxy> l = pl;
            while (l.nonEmpty()) {
                buf.append(this.deproxyCompound((CompoundAnnotationProxy)l.head));
                l = l.tail;
            }
            return buf.toList();
        }

        Attribute.Compound deproxyCompound(CompoundAnnotationProxy a) {
            ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> buf = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
            List<Pair<Name, Attribute>> l = a.values;
            while (l.nonEmpty()) {
                Symbol.MethodSymbol meth = this.findAccessMethod(a.type, (Name)((Pair)l.head).fst);
                buf.append(new Pair<Symbol.MethodSymbol, Attribute>(meth, this.deproxy(meth.type.getReturnType(), (Attribute)((Pair)l.head).snd)));
                l = l.tail;
            }
            return new Attribute.Compound(a.type, buf.toList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Symbol.MethodSymbol findAccessMethod(Type container, Name name) {
            Symbol.CompletionFailure failure = null;
            try {
                Scope.Entry e = container.tsym.members().lookup(name);
                while (e.scope != null) {
                    Symbol sym = e.sym;
                    if (sym.kind == 16 && sym.type.getParameterTypes().length() == 0) {
                        return (Symbol.MethodSymbol)sym;
                    }
                    e = e.next();
                }
            }
            catch (Symbol.CompletionFailure ex) {
                failure = ex;
            }
            JavaFileObject prevSource = ClassReader.this.log.useSource(this.requestingOwner.classfile);
            try {
                if (failure == null) {
                    ClassReader.this.log.warning("annotation.method.not.found", container, name);
                } else {
                    ClassReader.this.log.warning("annotation.method.not.found.reason", container, name, failure.getDetailValue());
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                ClassReader.this.log.useSource(prevSource);
                throw throwable;
            }
            ClassReader.this.log.useSource(prevSource);
            Type.MethodType mt = new Type.MethodType(List.<Type>nil(), ClassReader.this.syms.botType, List.<Type>nil(), ClassReader.this.syms.methodClass);
            return new Symbol.MethodSymbol(1025L, name, mt, container.tsym);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Attribute deproxy(Type t, Attribute a) {
            Type oldType = this.type;
            try {
                this.type = t;
                a.accept(this);
                Attribute attribute = this.result;
                Object var6_5 = null;
                this.type = oldType;
                return attribute;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.type = oldType;
                throw throwable;
            }
        }

        @Override
        public void visitConstant(Attribute.Constant value) {
            this.result = value;
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.result = clazz;
        }

        @Override
        public void visitEnum(Attribute.Enum e) {
            throw new AssertionError();
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            throw new AssertionError();
        }

        @Override
        public void visitArray(Attribute.Array array) {
            throw new AssertionError();
        }

        @Override
        public void visitError(Attribute.Error e) {
            throw new AssertionError();
        }

        @Override
        public void visitEnumAttributeProxy(EnumAttributeProxy proxy) {
            Symbol.TypeSymbol enumTypeSym = proxy.enumType.tsym;
            Symbol.VarSymbol enumerator = null;
            Symbol.CompletionFailure failure = null;
            try {
                Scope.Entry e = enumTypeSym.members().lookup(proxy.enumerator);
                while (e.scope != null) {
                    if (e.sym.kind == 4) {
                        enumerator = (Symbol.VarSymbol)e.sym;
                        break;
                    }
                    e = e.next();
                }
            }
            catch (Symbol.CompletionFailure ex) {
                failure = ex;
            }
            if (enumerator == null) {
                if (failure != null) {
                    ClassReader.this.log.warning("unknown.enum.constant.reason", ClassReader.this.currentClassFile, enumTypeSym, proxy.enumerator, failure.getDiagnostic());
                } else {
                    ClassReader.this.log.warning("unknown.enum.constant", ClassReader.this.currentClassFile, enumTypeSym, proxy.enumerator);
                }
                this.result = new Attribute.Enum(enumTypeSym.type, new Symbol.VarSymbol(0L, proxy.enumerator, ClassReader.this.syms.botType, enumTypeSym));
            } else {
                this.result = new Attribute.Enum(enumTypeSym.type, enumerator);
            }
        }

        @Override
        public void visitArrayAttributeProxy(ArrayAttributeProxy proxy) {
            int length = proxy.values.length();
            Attribute[] ats = new Attribute[length];
            Type elemtype = ClassReader.this.types.elemtype(this.type);
            int i = 0;
            List<Attribute> p = proxy.values;
            while (p.nonEmpty()) {
                ats[i++] = this.deproxy(elemtype, (Attribute)p.head);
                p = p.tail;
            }
            this.result = new Attribute.Array(this.type, ats);
        }

        @Override
        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy proxy) {
            this.result = this.deproxyCompound(proxy);
        }
    }

    static class TypeAnnotationProxy {
        final CompoundAnnotationProxy compound;
        final TypeAnnotationPosition position;

        public TypeAnnotationProxy(CompoundAnnotationProxy compound, TypeAnnotationPosition position) {
            this.compound = compound;
            this.position = position;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CompoundAnnotationProxy
    extends Attribute {
        final List<Pair<Name, Attribute>> values;

        public CompoundAnnotationProxy(Type type, List<Pair<Name, Attribute>> values) {
            super(type);
            this.values = values;
        }

        @Override
        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitCompoundAnnotationProxy(this);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("@");
            buf.append(this.type.tsym.getQualifiedName());
            buf.append("/*proxy*/{");
            boolean first = true;
            List<Pair<Name, Attribute>> v = this.values;
            while (v.nonEmpty()) {
                Pair value = (Pair)v.head;
                if (!first) {
                    buf.append(",");
                }
                first = false;
                buf.append((CharSequence)value.fst);
                buf.append("=");
                buf.append(value.snd);
                v = v.tail;
            }
            buf.append("}");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ArrayAttributeProxy
    extends Attribute {
        List<Attribute> values;

        public ArrayAttributeProxy(List<Attribute> values) {
            super(null);
            this.values = values;
        }

        @Override
        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitArrayAttributeProxy(this);
        }

        @Override
        public String toString() {
            return "{" + this.values + "}";
        }
    }

    protected static class EnumAttributeProxy
    extends Attribute {
        Type enumType;
        Name enumerator;

        public EnumAttributeProxy(Type enumType, Name enumerator) {
            super(null);
            this.enumType = enumType;
            this.enumerator = enumerator;
        }

        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitEnumAttributeProxy(this);
        }

        public String toString() {
            return "/*proxy enum*/" + this.enumType + "." + this.enumerator;
        }
    }

    static interface ProxyVisitor
    extends Attribute.Visitor {
        public void visitEnumAttributeProxy(EnumAttributeProxy var1);

        public void visitArrayAttributeProxy(ArrayAttributeProxy var1);

        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AttributeReader {
        public final Name name;
        public final ClassFile.Version version;
        public final Set<AttributeKind> kinds;

        protected AttributeReader(Name name, ClassFile.Version version, Set<AttributeKind> kinds) {
            this.name = name;
            this.version = version;
            this.kinds = kinds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean accepts(AttributeKind kind) {
            if (this.kinds.contains((Object)kind)) {
                if (ClassReader.this.majorVersion > this.version.major || ClassReader.this.majorVersion == this.version.major && ClassReader.this.minorVersion >= this.version.minor) {
                    return true;
                }
                if (ClassReader.this.lintClassfile && !ClassReader.this.warnedAttrs.contains(this.name)) {
                    JavaFileObject prev = ClassReader.this.log.useSource(ClassReader.this.currentClassFile);
                    try {
                        ClassReader.this.log.warning(Lint.LintCategory.CLASSFILE, (JCDiagnostic.DiagnosticPosition)null, "future.attr", this.name, this.version.major, this.version.minor, ClassReader.this.majorVersion, ClassReader.this.minorVersion);
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        ClassReader.this.log.useSource(prev);
                        throw throwable;
                    }
                    ClassReader.this.log.useSource(prev);
                    ClassReader.this.warnedAttrs.add(this.name);
                }
                return ClassReader.this.ideMode;
            }
            return false;
        }

        public abstract void read(Symbol var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AttributeKind {
        CLASS,
        MEMBER;

    }

    public class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.TypeSymbol sym, JavaFileObject file, JCDiagnostic diag) {
            super((Symbol)sym, ClassReader.this.createBadClassFileDiagnostic(file, diag));
        }
    }
}

