/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MissingPlatformError;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repair
extends TreeTranslator {
    protected static final Context.Key<Repair> repairKey = new Context.Key();
    private static final String ERR_MESSAGE = "Uncompilable source code";
    private static final Logger LOGGER = Logger.getLogger(Repair.class.getName());
    private Symtab syms;
    private Resolve rs;
    private Enter enter;
    private Types types;
    private Log log;
    private TreeMaker make;
    private JCDiagnostic.Factory diags;
    private boolean allowEnums;
    private Env<AttrContext> attrEnv;
    private boolean hasError;
    private JCDiagnostic err;
    private JCTree classLevelErrTree;
    private String classLevelErrMessage;
    private String errMessage;
    private JCTree.JCBlock staticInit;
    private List<JCTree> parents;
    private Set<Symbol.ClassSymbol> repairedClasses = new HashSet<Symbol.ClassSymbol>();
    private boolean isErrClass;
    private boolean insideErrEnum;
    private Name fixedTopLevelName;

    public static Repair instance(Context context) {
        Repair instance = context.get(repairKey);
        if (instance == null) {
            instance = new Repair(context);
        }
        return instance;
    }

    private Repair(Context context) {
        context.put(repairKey, this);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.enter = Enter.instance(context);
        this.types = Types.instance(context);
        this.log = Log.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Source source = Source.instance(context);
        this.allowEnums = source.allowEnums();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JCTree> T translate(T tree) {
        JCTree parent;
        block12: {
            T t;
            if (tree == null) {
                return null;
            }
            if (tree.type != null && tree.type.constValue() instanceof String && ((String)tree.type.constValue()).length() >= 65535) {
                this.log.error(tree.pos(), "limit.string", new Object[0]);
            }
            this.parents = this.parents.prepend(tree);
            try {
                if (!this.hasError) break block12;
                t = super.translate(tree);
                Object var4_4 = null;
                this.parents = this.parents.tail;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.parents = this.parents.tail;
                throw throwable;
            }
            return t;
        }
        this.err = this.log.getErrDiag(tree);
        if (this.err != null) {
            this.hasError = true;
        }
        tree = super.translate(tree);
        Object var4_5 = null;
        this.parents = this.parents.tail;
        if ((tree.type != null && tree.type.isErroneous() || tree.type == this.syms.unknownType) && ((parent = (JCTree)this.parents.head) == null || parent.getTag() != 3)) {
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Erroneous tree type: " + tree.type;
            }
        }
        if (!this.hasError || !(tree instanceof JCTree.JCStatement)) {
            return tree;
        }
        if (tree.getTag() == 14) {
            return tree;
        }
        if ((tree.getTag() == 3 || tree.getTag() == 5) && ((parent = (JCTree)this.parents.head) == null || parent.getTag() != 7 && parent.getTag() != 14)) {
            return tree;
        }
        String msg = this.err != null ? this.err.getMessage(null) : this.errMessage;
        this.hasError = false;
        this.err = null;
        this.errMessage = null;
        if (tree.getTag() == 7) {
            ((JCTree.JCBlock)tree).stats = List.of(this.generateErrStat(tree.pos(), msg));
            return tree;
        }
        return (T)this.generateErrStat(tree.pos(), msg);
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        super.visitImport(tree);
        if (this.hasError && this.err != null) {
            this.classLevelErrTree = this.err.getTree();
            this.classLevelErrMessage = this.err.getMessage(null);
        }
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        super.visitTypeParameter(tree);
        if (tree.type != null && tree.type.tag == 14) {
            Type.TypeVar tv = (Type.TypeVar)tree.type;
            if (tv.bound != null && tv.bound.isErroneous() || tv.bound == this.syms.unknownType) {
                if (this.err == null && this.errMessage == null) {
                    this.errMessage = "Erroneous type var bound: " + tv.bound;
                }
                tv.bound = this.syms.objectType;
                this.hasError = true;
            }
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.translateClass(tree.sym);
        this.result = tree;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        super.visitVarDef(tree);
        if (!this.allowEnums && tree.sym != null && (tree.sym.flags_field & 0x4000L) != 0L) {
            tree.sym.flags_field &= 0xFFFFFFFFFFFFBFFFL;
            tree.mods.flags &= 0xFFFFFFFFFFFFBFFFL;
        }
        if (this.hasError) {
            JCTree parent;
            JCTree jCTree = parent = this.parents != null ? (JCTree)this.parents.tail.head : null;
            if (parent != null && parent.getTag() == 3) {
                tree.init = this.err != null ? this.generateErrExpr(this.err.getTree(), this.err.getMessage(null)) : this.generateErrExpr(tree.init, this.errMessage);
                this.hasError = false;
                this.err = null;
                this.errMessage = null;
                if (tree.sym != null) {
                    tree.sym.setData(null);
                }
            }
        } else if (tree.sym == null) {
            JCTree parent;
            JCTree jCTree = parent = this.parents != null ? (JCTree)this.parents.tail.head : null;
            if (parent != null && parent.getTag() != 3) {
                this.hasError = true;
                if (this.err == null && this.errMessage == null) {
                    this.errMessage = "Null tree sym: " + tree;
                }
            }
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        boolean hadDuplicateSymError = this.hasError && this.err != null && "compiler.err.already.defined".equals(this.err.getCode());
        tree.mods = this.translate(tree.mods);
        tree.restype = this.translate(tree.restype);
        tree.typarams = this.translateTypeParams(tree.typarams);
        tree.params = this.translateVarDefs(tree.params);
        tree.thrown = this.translate((JCTree)((Object)tree.thrown));
        tree.defaultValue = this.translate(tree.defaultValue);
        tree.body = this.translate(tree.body);
        this.result = tree;
        if (this.isErrClass && tree.body != null) {
            Symbol sym;
            JCTree.JCMethodInvocation app = TreeInfo.firstConstructorCall(tree);
            Name meth = app != null ? TreeInfo.name(app.meth) : null;
            Symbol symbol = sym = app != null ? TreeInfo.symbol(app.meth) : null;
            if (meth != null && (meth == meth.table.names._this || meth == meth.table.names._super) && sym != null && sym.owner.getQualifiedName() != meth.table.names.java_lang_Enum) {
                tree.body.stats.tail = List.nil();
            } else {
                tree.body.stats = List.nil();
            }
        }
        if (this.hasError && !hadDuplicateSymError) {
            if (tree.body != null) {
                if (tree.sym != null) {
                    tree.sym.flags_field &= 0xFFFFFFFFFFFFFAFFL;
                }
                tree.body.stats = List.of(this.generateErrStat(tree.pos(), this.err != null ? this.err.getMessage(null) : this.errMessage));
            } else if (tree.sym == null || (tree.sym.flags_field & 0x400L) == 0L) {
                (tree.body = this.make.Block((long)0L, List.<JCTree.JCStatement>nil())).stats = List.of(this.generateErrStat(tree.pos(), this.err != null ? this.err.getMessage(null) : this.errMessage));
            }
            if (tree.sym != null) {
                tree.sym.defaultValue = null;
            }
            tree.defaultValue = null;
            this.hasError = false;
            this.err = null;
            this.errMessage = null;
        }
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        if (tree.isStatic() && this.staticInit == null) {
            this.staticInit = tree;
        }
        List<JCTree.JCStatement> last = null;
        List<JCTree.JCStatement> l = tree.stats;
        while (l.nonEmpty()) {
            l.head = this.translate((JCTree)l.head);
            if (last == null && ((JCTree.JCStatement)l.head).getTag() == 24) {
                last = l;
            }
            l = l.tail;
        }
        if (last != null) {
            last.tail = List.nil();
        }
        this.result = tree;
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        Symbol meth = TreeInfo.symbol(tree.meth);
        if (meth == null) {
            LOGGER.warning("Repair.visitApply tree [" + tree + "] has null symbol.");
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Null tree sym: " + tree.meth;
            }
        } else if (meth.type == null) {
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Null sym type: " + meth;
            }
        } else if (meth.type.isErroneous() || meth.type == this.syms.unknownType) {
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Erroneous sym type: " + meth.type;
            }
        }
        super.visitApply(tree);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        Symbol ctor = tree.constructor;
        if (ctor == null) {
            LOGGER.warning("Repair.visitNewClass tree [" + tree + "] has null constructor symbol.");
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Null tree ctor sym: " + tree.constructor;
            }
        } else if (tree.constructorType == null) {
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Null ctor sym type: " + ctor;
            }
        } else if (tree.constructorType.isErroneous() || tree.constructorType == this.syms.unknownType) {
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Erroneous ctor sym type: " + tree.constructorType;
            }
        }
        super.visitNewClass(tree);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        Symbol operator = tree.operator;
        if (operator == null) {
            LOGGER.warning("Repair.visitUnary tree [" + tree + "] has null operator symbol.");
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Null operator: " + tree;
            }
        }
        super.visitUnary(tree);
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        Symbol operator = tree.operator;
        if (operator == null) {
            LOGGER.warning("Repair.visitBinary tree [" + tree + "] has null operator symbol.");
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Null operator: " + tree;
            }
        }
        super.visitBinary(tree);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        Symbol operator = tree.operator;
        if (operator == null) {
            LOGGER.warning("Repair.visitAssignop tree [" + tree + "] has null operator symbol.");
            this.hasError = true;
            if (this.err == null && this.errMessage == null) {
                this.errMessage = "Null operator: " + tree;
            }
        }
        super.visitAssignop(tree);
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        tree.pat = this.translate(tree.pat);
        List<JCTree.JCStatement> last = null;
        List<JCTree.JCStatement> l = tree.stats;
        while (l.nonEmpty()) {
            l.head = this.translate((JCTree)l.head);
            if (last == null && ((JCTree.JCStatement)l.head).getTag() == 24) {
                last = l;
            }
            l = l.tail;
        }
        if (last != null) {
            last.tail = List.nil();
        }
        this.result = tree;
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        this.hasError = true;
        this.result = tree;
    }

    private JCTree.JCStatement generateErrStat(JCDiagnostic.DiagnosticPosition pos, String msg) {
        this.make.at(pos);
        Type.ClassType ctype = (Type.ClassType)this.syms.runtimeExceptionType;
        Symbol ctor = this.rs.resolveConstructor(pos, this.attrEnv, ctype, List.of(this.syms.stringType), null, false, false);
        if (ctor.kind == 16) {
            JCTree.JCLiteral literal = this.make.Literal(msg != null ? "Uncompilable source code - " + msg : ERR_MESSAGE);
            JCTree.JCNewClass tree = this.make.NewClass(null, null, this.make.QualIdent(ctype.tsym), List.of(literal), null);
            tree.type = ctype;
            tree.constructor = ctor;
            return this.make.Throw(tree);
        }
        ctor = this.rs.resolveConstructor(pos, this.attrEnv, ctype, List.<Type>nil(), null, false, false);
        if (ctor.kind == 16) {
            JCTree.JCNewClass tree = this.make.NewClass(null, null, this.make.QualIdent(ctype.tsym), List.<JCTree.JCExpression>nil(), null);
            tree.type = ctype;
            tree.constructor = ctor;
            return this.make.Throw(tree);
        }
        throw new MissingPlatformError(this.diags.fragment("fatal.err.cant.locate.ctor", ctype));
    }

    private JCTree.JCExpression generateErrExpr(JCDiagnostic.DiagnosticPosition pos, String msg) {
        this.make.at(pos);
        JCTree.JCErroneous expr = this.make.Erroneous(List.of(this.generateErrStat(pos, msg)));
        expr.type = this.syms.errType;
        return expr;
    }

    private JCTree.JCBlock generateErrStaticInit(JCDiagnostic.DiagnosticPosition pos, String msg) {
        this.make.at(pos);
        return this.make.Block(8L, List.of(this.generateErrStat(pos, msg)));
    }

    private JCTree.JCMethodDecl generateErrMethod(Symbol.MethodSymbol sym) {
        this.make.at(null);
        return this.make.MethodDef(sym, this.make.Block(0L, List.of(this.generateErrStat(null, null))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateClass(Symbol.ClassSymbol c) {
        if (c == null) {
            return;
        }
        Type st = this.types.supertype(c.type);
        if (st != null && st.tag == 10) {
            this.translateClass((Symbol.ClassSymbol)st.tsym);
        }
        LOGGER.finest("Repair.translateClass: " + c);
        if (this.repairedClasses.contains(c)) {
            LOGGER.finest("Repair.translateClass: Should be already done");
            return;
        }
        Env<AttrContext> myEnv = this.enter.typeEnvs.get(c);
        if (myEnv == null) {
            LOGGER.finest("Repair.translateClass: Context not found");
            return;
        }
        LOGGER.finest("Repair.translateClass: Repairing " + c);
        this.repairedClasses.add(c);
        Env<AttrContext> oldEnv = this.attrEnv;
        try {
            this.attrEnv = myEnv;
            TreeMaker oldMake = this.make;
            this.make = this.make.forToplevel(this.attrEnv.toplevel);
            boolean oldHasError = this.hasError;
            boolean oldIsErrClass = this.isErrClass;
            boolean oldInsideErrEnum = this.insideErrEnum;
            JCDiagnostic oldErr = this.err;
            JCTree oldClassLevelErrTree = this.classLevelErrTree;
            String oldClassLevelErrMessage = this.classLevelErrMessage;
            JCTree.JCBlock oldStaticinit = this.staticInit;
            try {
                for (JCTree.JCImport imp : this.attrEnv.toplevel.getImports()) {
                    this.translate(imp);
                    if (this.classLevelErrTree == null) continue;
                    break;
                }
                this.hasError = false;
                this.isErrClass = c.type.isErroneous() || c.type == this.syms.unknownType;
                this.err = null;
                this.staticInit = null;
                JCTree.JCClassDecl tree = (JCTree.JCClassDecl)this.attrEnv.tree;
                Element enclosingElement = c.getEnclosingElement();
                if (c.name == c.name.table.names.error && ((Symbol)enclosingElement).getKind() == ElementKind.PACKAGE) {
                    JavaFileObject source = c.sourcefile;
                    String path = source.toUri().getPath();
                    int start = path.lastIndexOf(47);
                    int end = path.lastIndexOf(46);
                    c.name = this.fixedTopLevelName = c.name.table.fromString(path.substring(start + 1, end));
                    c.flatname = c.fullname = Symbol.TypeSymbol.formFullName(c.name, (Symbol)enclosingElement);
                    tree.name = c.name;
                    this.isErrClass = true;
                    this.hasError = true;
                    this.err = this.diags.error(this.log.currentSource(), tree, "expected", Token.IDENTIFIER);
                } else if (this.fixedTopLevelName != null) {
                    c.fullname = Symbol.TypeSymbol.formFullName(c.name, (Symbol)enclosingElement);
                    c.flatname = Symbol.TypeSymbol.formFlatName(c.name, (Symbol)enclosingElement);
                }
                tree.mods = this.translate(tree.mods);
                tree.typarams = this.translateTypeParams(tree.typarams);
                tree.extending = this.translate(tree.extending);
                tree.implementing = this.translate((JCTree)((Object)tree.implementing));
                if (!this.hasError && (this.err = this.log.getErrDiag(tree)) != null) {
                    this.hasError = true;
                    this.isErrClass = true;
                }
                if (!(this.allowEnums && !this.isErrClass && !this.insideErrEnum || (c.flags_field & 0x4000L) == 0L && (tree.mods.flags & 0x4000L) == 0L)) {
                    this.insideErrEnum = true;
                    c.flags_field &= 0xFFFFFFFFFFFFBFFFL;
                    tree.mods.flags &= 0xFFFFFFFFFFFFBFFFL;
                    this.hasError = true;
                    this.isErrClass = true;
                    this.classLevelErrTree = tree;
                }
                if (this.hasError && this.err != null) {
                    this.isErrClass = true;
                    this.classLevelErrTree = this.err.getTree();
                    this.classLevelErrMessage = this.err.getMessage(null);
                } else if ((c.type.isErroneous() || c.type == this.syms.unknownType) && oldHasError && oldErr != null) {
                    this.classLevelErrTree = oldErr.getTree();
                    this.classLevelErrMessage = oldErr.getMessage(null);
                }
                if (tree.defs != null) {
                    HashSet<Symbol.MethodSymbol> nonAbstractMethods = new HashSet<Symbol.MethodSymbol>();
                    Scope.Entry e = tree.sym.members_field.elems;
                    while (e != null) {
                        if (e.sym.kind == 16 && (e.sym.flags_field & 0x400L) == 0L && e.sym.name != e.sym.name.table.names.clinit) {
                            nonAbstractMethods.add((Symbol.MethodSymbol)e.sym);
                        }
                        e = e.sibling;
                    }
                    List<JCTree> last = null;
                    List<JCTree> l = tree.defs;
                    while (l != null && l.nonEmpty()) {
                        if (((JCTree)l.head).getTag() == 4) {
                            nonAbstractMethods.remove(((JCTree.JCMethodDecl)l.head).sym);
                        }
                        this.hasError = false;
                        this.err = null;
                        if (((JCTree)l.head).getTag() == 3 && ((JCTree.JCClassDecl)l.head).name == c.name.table.names.error) {
                            Scope.Entry prev = null;
                            Scope.Entry e2 = tree.sym.members_field.elems;
                            while (e2 != null) {
                                if (e2.sym == ((JCTree.JCClassDecl)l.head).sym) {
                                    if (prev == null) {
                                        tree.sym.members_field.elems = e2.sibling;
                                        break;
                                    }
                                    prev.sibling = e2.sibling;
                                    break;
                                }
                                prev = e2;
                                e2 = e2.sibling;
                            }
                            if (last != null) {
                                last.tail = l.tail;
                            } else {
                                tree.defs = l.tail;
                            }
                        } else {
                            l.head = this.translate((JCTree)l.head);
                            if (((JCTree)l.head).getTag() == 4 && ((JCTree.JCMethodDecl)l.head).sym == null || ((JCTree)l.head).getTag() == 5 && ((JCTree.JCVariableDecl)l.head).sym == null) {
                                this.hasError = true;
                            }
                            if (this.hasError) {
                                if (((JCTree)l.head).getTag() == 3 && tree.sym.members_field.includes(((JCTree.JCClassDecl)l.head).sym)) {
                                    last = l;
                                } else if (last != null) {
                                    last.tail = l.tail;
                                } else {
                                    tree.defs = l.tail;
                                }
                                if (this.classLevelErrTree == null) {
                                    if (this.err != null) {
                                        this.classLevelErrTree = this.err.getTree();
                                        this.classLevelErrMessage = this.err.getMessage(null);
                                    } else {
                                        this.classLevelErrTree = (JCTree)l.head;
                                    }
                                }
                            } else {
                                last = l;
                            }
                        }
                        l = l.tail;
                    }
                    if (this.classLevelErrTree != null) {
                        if (this.staticInit != null) {
                            this.staticInit.stats = List.of(this.generateErrStat(this.classLevelErrTree, this.classLevelErrMessage));
                        } else {
                            tree.defs = tree.defs.prepend(this.generateErrStaticInit(this.classLevelErrTree, this.classLevelErrMessage));
                        }
                    }
                    for (Symbol.MethodSymbol symbol : nonAbstractMethods) {
                        if ((symbol.flags() & 0x80000000L) != 0L || (symbol.owner.flags() & 0x4000L) != 0L && (symbol.name == symbol.name.table.names.values && symbol.type.asMethodType().argtypes.isEmpty() || symbol.name == symbol.name.table.names.valueOf && this.types.isSameType((Type)symbol.type.asMethodType().argtypes.head, this.enter.syms.stringType) && symbol.type.asMethodType().argtypes.tail.isEmpty())) continue;
                        tree.defs = tree.defs.prepend(this.generateErrMethod(symbol));
                    }
                }
                Object var21_23 = null;
                this.staticInit = oldStaticinit;
                this.classLevelErrTree = oldClassLevelErrTree;
                this.classLevelErrMessage = oldClassLevelErrMessage;
                this.err = oldErr;
                this.isErrClass = oldIsErrClass;
                this.insideErrEnum = oldInsideErrEnum;
                this.hasError = oldHasError;
                this.make = oldMake;
            }
            catch (Throwable throwable) {
                Object var21_24 = null;
                this.staticInit = oldStaticinit;
                this.classLevelErrTree = oldClassLevelErrTree;
                this.classLevelErrMessage = oldClassLevelErrMessage;
                this.err = oldErr;
                this.isErrClass = oldIsErrClass;
                this.insideErrEnum = oldInsideErrEnum;
                this.hasError = oldHasError;
                this.make = oldMake;
                throw throwable;
            }
            Object var23_26 = null;
            this.attrEnv = oldEnv;
        }
        catch (Throwable throwable) {
            Object var23_27 = null;
            this.attrEnv = oldEnv;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree translateTopLevelClass(Env<AttrContext> env, JCTree tree, TreeMaker localMake) {
        try {
            this.attrEnv = env;
            this.make = localMake;
            this.hasError = false;
            this.insideErrEnum = false;
            this.parents = List.nil();
            JCTree jCTree = this.translate(tree);
            Object var6_5 = null;
            this.attrEnv = null;
            this.make = null;
            this.fixedTopLevelName = null;
            return jCTree;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.attrEnv = null;
            this.make = null;
            this.fixedTopLevelName = null;
            throw throwable;
        }
    }

    public void flush() {
        this.repairedClasses.clear();
    }
}

