/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Warner;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.ElementKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check {
    protected static final Context.Key<Check> checkKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Symtab syms;
    private final Enter enter;
    private final Infer infer;
    private final Types types;
    private final JCDiagnostic.Factory diags;
    private final boolean skipAnnotations;
    private boolean warnOnSyntheticConflicts;
    private boolean suppressAbortOnBadClassFile;
    private boolean enableSunApiLintControl;
    private final TreeInfo treeinfo;
    private Lint lint;
    private Symbol.MethodSymbol method;
    boolean allowGenerics;
    boolean allowAnnotations;
    boolean allowCovariantReturns;
    boolean allowSimplifiedVarargs;
    boolean complexInference;
    char syntheticNameChar;
    public Map<Name, Symbol.ClassSymbol> compiled = new HashMap<Name, Symbol.ClassSymbol>();
    private MandatoryWarningHandler deprecationHandler;
    private MandatoryWarningHandler uncheckedHandler;
    private MandatoryWarningHandler sunApiHandler;
    private DeferredLintHandler deferredLintHandler;
    Types.UnaryVisitor<Boolean> isTypeArgErroneous = new Types.UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type t, Void s) {
            return t.isErroneous();
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar t, Void s) {
            return (Boolean)this.visit(t.getUpperBound());
        }

        @Override
        public Boolean visitCapturedType(Type.CapturedType t, Void s) {
            return (Boolean)this.visit(t.getUpperBound()) != false || (Boolean)this.visit(t.getLowerBound()) != false;
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Void s) {
            return (Boolean)this.visit(t.type);
        }
    };
    Warner overrideWarner = new Warner();

    public static Check instance(Context context) {
        Check instance = context.get(checkKey);
        if (instance == null) {
            instance = new Check(context);
        }
        return instance;
    }

    protected Check(Context context) {
        context.put(checkKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.enter = Enter.instance(context);
        this.infer = Infer.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Options options = Options.instance(context);
        this.lint = Lint.instance(context);
        this.treeinfo = TreeInfo.instance(context);
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowAnnotations = source.allowAnnotations();
        this.allowCovariantReturns = source.allowCovariantReturns();
        this.allowSimplifiedVarargs = source.allowSimplifiedVarargs();
        this.complexInference = options.isSet(OptionName.COMPLEXINFERENCE);
        this.skipAnnotations = options.isSet("skipAnnotations");
        this.warnOnSyntheticConflicts = options.isSet("warnOnSyntheticConflicts");
        this.suppressAbortOnBadClassFile = options.isSet("suppressAbortOnBadClassFile");
        this.enableSunApiLintControl = options.isSet("enableSunApiLintControl");
        Target target = Target.instance(context);
        this.syntheticNameChar = target.syntheticNameChar();
        boolean verboseDeprecated = this.lint.isEnabled(Lint.LintCategory.DEPRECATION);
        boolean verboseUnchecked = this.lint.isEnabled(Lint.LintCategory.UNCHECKED);
        boolean verboseSunApi = this.lint.isEnabled(Lint.LintCategory.SUNAPI);
        boolean enforceMandatoryWarnings = source.enforceMandatoryWarnings();
        this.deprecationHandler = new MandatoryWarningHandler(this.log, verboseDeprecated, enforceMandatoryWarnings, "deprecated", Lint.LintCategory.DEPRECATION);
        this.uncheckedHandler = new MandatoryWarningHandler(this.log, verboseUnchecked, enforceMandatoryWarnings, "unchecked", Lint.LintCategory.UNCHECKED);
        this.sunApiHandler = new MandatoryWarningHandler(this.log, verboseSunApi, enforceMandatoryWarnings, "sunapi", null);
        this.deferredLintHandler = DeferredLintHandler.immediateHandler;
    }

    Lint setLint(Lint newLint) {
        Lint prev = this.lint;
        this.lint = newLint;
        return prev;
    }

    DeferredLintHandler setDeferredLintHandler(DeferredLintHandler newDeferredLintHandler) {
        DeferredLintHandler prev = this.deferredLintHandler;
        this.deferredLintHandler = newDeferredLintHandler;
        return prev;
    }

    Symbol.MethodSymbol setMethod(Symbol.MethodSymbol newMethod) {
        Symbol.MethodSymbol prev = this.method;
        this.method = newMethod;
        return prev;
    }

    void warnDeprecated(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (!this.lint.isSuppressed(Lint.LintCategory.DEPRECATION)) {
            this.deprecationHandler.report(pos, "has.been.deprecated", sym, sym.location());
        }
    }

    public void warnUnchecked(JCDiagnostic.DiagnosticPosition pos, String msg, Object ... args) {
        if (!this.lint.isSuppressed(Lint.LintCategory.UNCHECKED)) {
            this.uncheckedHandler.report(pos, msg, args);
        }
    }

    void warnUnsafeVararg(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        if (this.lint.isEnabled(Lint.LintCategory.VARARGS) && this.allowSimplifiedVarargs) {
            this.log.warning(Lint.LintCategory.VARARGS, pos, key, args);
        }
    }

    public void warnSunApi(JCDiagnostic.DiagnosticPosition pos, String msg, Object ... args) {
        if (!this.lint.isSuppressed(Lint.LintCategory.SUNAPI)) {
            this.sunApiHandler.report(pos, msg, args);
        }
    }

    public void warnStatic(JCDiagnostic.DiagnosticPosition pos, String msg, Object ... args) {
        if (this.lint.isEnabled(Lint.LintCategory.STATIC)) {
            this.log.warning(Lint.LintCategory.STATIC, pos, msg, args);
        }
    }

    public void reportDeferredDiagnostics() {
        this.deprecationHandler.reportDeferredDiagnostic();
        this.uncheckedHandler.reportDeferredDiagnostic();
        this.sunApiHandler.reportDeferredDiagnostic();
    }

    public Type completionError(JCDiagnostic.DiagnosticPosition pos, Symbol.CompletionFailure ex) {
        this.log.error(pos, "cant.access", ex.sym, ex.getDetailValue());
        if (ex instanceof ClassReader.BadClassFile && !this.suppressAbortOnBadClassFile) {
            throw new Abort();
        }
        return this.syms.errType;
    }

    Type typeError(JCDiagnostic.DiagnosticPosition pos, Object problem, Type found, Type req) {
        this.log.error(pos, "prob.found.req", problem, found, req);
        return this.types.createErrorType(found);
    }

    Type typeError(JCDiagnostic.DiagnosticPosition pos, String problem, Type found, Type req, Object explanation) {
        this.log.error(pos, "prob.found.req.1", problem, found, req, explanation);
        return this.types.createErrorType(found);
    }

    Type typeTagError(JCDiagnostic.DiagnosticPosition pos, Object required, Object found) {
        if (found instanceof Type && ((Type)found).tag == 9) {
            this.log.error(pos, "illegal.start.of.type", new Object[0]);
            return this.syms.errType;
        }
        this.log.error(pos, "type.found.req", found, required);
        return this.types.createErrorType(found instanceof Type ? (Type)found : this.syms.errType);
    }

    void earlyRefError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        this.log.error(pos, "cant.ref.before.ctor.called", sym);
    }

    void duplicateError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (!sym.type.isErroneous()) {
            Symbol location = sym.location();
            if (location.kind == 16 && ((Symbol.MethodSymbol)location).isStaticOrInstanceInit()) {
                this.log.error(pos, "already.defined.in.clinit", Kinds.kindName(sym), sym, Kinds.kindName(sym.location()), Kinds.kindName(sym.location().enclClass()), sym.location().enclClass());
            } else {
                this.log.error(pos, "already.defined", Kinds.kindName(sym), sym, Kinds.kindName(sym.location()), sym.location());
            }
        }
    }

    void varargsDuplicateError(JCDiagnostic.DiagnosticPosition pos, Symbol sym1, Symbol sym2) {
        if (!sym1.type.isErroneous() && !sym2.type.isErroneous()) {
            this.log.error(pos, "array.and.varargs", sym1, sym2, sym2.location());
        }
    }

    void checkTransparentVar(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol v, Scope s) {
        if (s.next != null) {
            Scope.Entry e = s.next.lookup(v.name);
            while (e.scope != null && e.sym.owner == v.owner) {
                if (e.sym.kind == 4 && (e.sym.owner.kind & 0x14) != 0 && v.name != this.names.error) {
                    this.duplicateError(pos, e.sym);
                    return;
                }
                e = e.next();
            }
        }
    }

    void checkTransparentClass(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c, Scope s) {
        if (s.next != null) {
            Scope.Entry e = s.next.lookup(c.name);
            while (e.scope != null && e.sym.owner == c.owner) {
                if (e.sym.kind == 2 && e.sym.type.tag != 14 && (e.sym.owner.kind & 0x14) != 0 && c.name != this.names.error) {
                    this.duplicateError(pos, e.sym);
                    return;
                }
                e = e.next();
            }
        }
    }

    boolean checkUniqueClassName(JCDiagnostic.DiagnosticPosition pos, Name name, Scope s) {
        Scope.Entry e = s.lookup(name);
        while (e.scope == s) {
            if (e.sym.kind == 2) {
                if (e.sym.name != this.names.error) {
                    this.duplicateError(pos, e.sym);
                }
                return false;
            }
            e = e.next();
        }
        Symbol sym = s.owner;
        while (sym != null) {
            if (sym.kind == 2 && sym.name == name && sym.name != this.names.error) {
                this.duplicateError(pos, sym);
                return true;
            }
            sym = sym.owner;
        }
        return true;
    }

    Name localClassName(Symbol.ClassSymbol c) {
        int i = 1;
        Name flatname;
        while (this.compiled.get(flatname = this.names.fromString("" + c.owner.enclClass().flatname + this.syntheticNameChar + i + c.name)) != null) {
            ++i;
        }
        return flatname;
    }

    Name localClassName(Symbol.ClassSymbol enclClass, Name name, int index) {
        Name flatname = this.names.fromString("" + enclClass.flatname + this.syntheticNameChar + index + name);
        return flatname;
    }

    public Type checkType(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
        return this.checkType(pos, found, req, "incompatible.types");
    }

    Type checkType(JCDiagnostic.DiagnosticPosition pos, Type found, Type req, String errKey) {
        if (req.tag == 19) {
            return req;
        }
        if (found.tag == 16) {
            return this.instantiatePoly(pos, (Type.ForAll)found, req, this.convertWarner(pos, found, req));
        }
        if (req.tag == 18) {
            return found;
        }
        if (this.types.isAssignable(found, req, this.convertWarner(pos, found, req))) {
            return found;
        }
        if (found.tag <= 7 && req.tag <= 7) {
            return this.typeError(pos, this.diags.fragment("possible.loss.of.precision", new Object[0]), found, req);
        }
        if (found.isSuperBound()) {
            this.log.error(pos, "assignment.from.super-bound", found);
            return this.types.createErrorType(found);
        }
        if (req.isExtendsBound()) {
            this.log.error(pos, "assignment.to.extends-bound", req);
            return this.types.createErrorType(found);
        }
        return this.typeError(pos, this.diags.fragment(errKey, new Object[0]), found, req);
    }

    Type instantiatePoly(JCDiagnostic.DiagnosticPosition pos, Type.ForAll t, Type pt, Warner warn) throws Infer.NoInstanceException {
        if (pt == Infer.anyPoly && this.complexInference) {
            return t;
        }
        if (pt == Infer.anyPoly || pt.tag == 18) {
            Type newpt = t.qtype.tag <= 9 ? t.qtype : this.syms.objectType;
            return this.instantiatePoly(pos, t, newpt, warn);
        }
        if (pt.tag == 19) {
            return pt;
        }
        try {
            return this.infer.instantiateExpr(t, pt, warn);
        }
        catch (Infer.NoInstanceException ex) {
            if (ex.isAmbiguous) {
                JCDiagnostic d = ex.getDiagnostic();
                this.log.error(pos, "undetermined.type" + (d != null ? ".1" : ""), t, d);
                return this.types.createErrorType(pt);
            }
            JCDiagnostic d = ex.getDiagnostic();
            return this.typeError(pos, this.diags.fragment("incompatible.types" + (d != null ? ".1" : ""), d), t, pt);
        }
        catch (Infer.InvalidInstanceException ex) {
            JCDiagnostic d = ex.getDiagnostic();
            this.log.error(pos, "invalid.inferred.types", t.tvars, d);
            return this.types.createErrorType(pt);
        }
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
        if (found.tag == 16) {
            this.instantiatePoly(pos, (Type.ForAll)found, req, this.castWarner(pos, found, req));
            return req;
        }
        if (this.types.isCastable(found, req, this.castWarner(pos, found, req))) {
            return req;
        }
        return this.typeError(pos, this.diags.fragment("inconvertible.types", new Object[0]), found, req);
    }

    boolean isTypeVar(Type t) {
        return t.tag == 14 || t.tag == 11 && this.isTypeVar(this.types.elemtype(t));
    }

    private boolean checkExtends(Type a, Type bound) {
        if (a.isUnbound()) {
            return true;
        }
        if (a.tag != 15) {
            a = this.types.upperBound(a);
            return this.types.isSubtype(a, bound);
        }
        if (a.isExtendsBound()) {
            return this.types.isCastable(bound, this.types.upperBound(a), Warner.noWarnings);
        }
        if (a.isSuperBound()) {
            return !this.types.notSoftSubtype(this.types.lowerBound(a), bound);
        }
        return true;
    }

    Type checkNonVoid(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.tag == 9) {
            this.log.error(pos, "void.not.allowed.here", new Object[0]);
            return this.types.createErrorType(t);
        }
        return t;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.tag != 10 && t.tag != 19) {
            return this.typeTagError(pos, this.diags.fragment("type.req.class", new Object[0]), t.tag == 14 ? this.diags.fragment("type.parameter", t) : t);
        }
        return t;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition pos, Type t, boolean noBounds) {
        t = this.checkClassType(pos, t);
        if (noBounds && t.isParameterized()) {
            List<Type> args = t.getTypeArguments();
            while (args.nonEmpty()) {
                if (((Type)args.head).tag == 15) {
                    return this.typeTagError(pos, this.diags.fragment("type.req.exact", new Object[0]), args.head);
                }
                args = args.tail;
            }
        }
        return t;
    }

    Type checkReifiableReferenceType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.tag != 10 && t.tag != 11 && t.tag != 19) {
            return this.typeTagError(pos, this.diags.fragment("type.req.class.array", new Object[0]), t);
        }
        if (!this.types.isReifiable(t)) {
            this.log.error(pos, "illegal.generic.type.for.instof", new Object[0]);
            return this.types.createErrorType(t);
        }
        return t;
    }

    Type checkRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        switch (t.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: {
                return t;
            }
        }
        return this.typeTagError(pos, this.diags.fragment("type.req.ref", new Object[0]), t);
    }

    List<Type> checkRefTypes(List<JCTree.JCExpression> trees, List<Type> types) {
        List<JCTree.JCExpression> tl = trees;
        List<Type> l = types;
        while (l.nonEmpty()) {
            l.head = this.checkRefType(((JCTree.JCExpression)tl.head).pos(), (Type)l.head);
            tl = tl.tail;
            l = l.tail;
        }
        return types;
    }

    Type checkNullOrRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        switch (t.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                return t;
            }
        }
        return this.typeTagError(pos, this.diags.fragment("type.req.ref", new Object[0]), t);
    }

    boolean checkDisjoint(JCDiagnostic.DiagnosticPosition pos, long flags, long set1, long set2) {
        if ((flags & set1) != 0L && (flags & set2) != 0L) {
            this.log.error(pos, "illegal.combination.of.modifiers", Flags.asFlagSet(TreeInfo.firstFlag(flags & set1)), Flags.asFlagSet(TreeInfo.firstFlag(flags & set2)));
            return false;
        }
        return true;
    }

    Type checkDiamond(JCTree.JCNewClass tree, Type t) {
        if (!TreeInfo.isDiamond(tree) || t.isErroneous()) {
            return this.checkClassType(tree.clazz.pos(), t, true);
        }
        if (tree.def != null) {
            this.log.error(tree.clazz.pos(), "cant.apply.diamond.1", t, this.diags.fragment("diamond.and.anon.class", t));
            return this.types.createErrorType(t);
        }
        if (t.tsym.type.getTypeArguments().isEmpty()) {
            this.log.error(tree.clazz.pos(), "cant.apply.diamond.1", t, this.diags.fragment("diamond.non.generic", t));
            return this.types.createErrorType(t);
        }
        if (tree.typeargs != null && tree.typeargs.nonEmpty()) {
            this.log.error(tree.clazz.pos(), "cant.apply.diamond.1", t, this.diags.fragment("diamond.and.explicit.params", t));
            return this.types.createErrorType(t);
        }
        return t;
    }

    void checkVarargsMethodDecl(Env<AttrContext> env, JCTree.JCMethodDecl tree) {
        Symbol.MethodSymbol m = tree.sym;
        if (!this.allowSimplifiedVarargs) {
            return;
        }
        boolean hasTrustMeAnno = m.attribute(this.syms.trustMeType.tsym) != null;
        Type varargElemType = null;
        if (m.isVarArgs()) {
            varargElemType = this.types.elemtype(tree.params.last().type);
        }
        if (hasTrustMeAnno && !this.isTrustMeAllowedOnMethod(m)) {
            if (varargElemType != null) {
                this.log.error(tree, "varargs.invalid.trustme.anno", this.syms.trustMeType.tsym, this.diags.fragment("varargs.trustme.on.virtual.varargs", m));
            } else {
                this.log.error(tree, "varargs.invalid.trustme.anno", this.syms.trustMeType.tsym, this.diags.fragment("varargs.trustme.on.non.varargs.meth", m));
            }
        } else if (hasTrustMeAnno && varargElemType != null && this.types.isReifiable(varargElemType)) {
            this.warnUnsafeVararg(tree, "varargs.redundant.trustme.anno", this.syms.trustMeType.tsym, this.diags.fragment("varargs.trustme.on.reifiable.varargs", varargElemType));
        } else if (!hasTrustMeAnno && varargElemType != null && !this.types.isReifiable(varargElemType)) {
            this.warnUnchecked(((JCTree.JCVariableDecl)tree.params.head).pos(), "unchecked.varargs.non.reifiable.type", varargElemType);
        }
    }

    private boolean isTrustMeAllowedOnMethod(Symbol s) {
        return (s.flags() & 0x400000000L) != 0L && (s.isConstructor() || (s.flags() & 0x18L) != 0L);
    }

    void checkVararg(JCDiagnostic.DiagnosticPosition pos, List<Type> argtypes, Symbol msym) {
        Type argtype = argtypes.last();
        if (!(this.types.isReifiable(argtype) || this.allowSimplifiedVarargs && msym.attribute(this.syms.trustMeType.tsym) != null && this.isTrustMeAllowedOnMethod(msym))) {
            this.warnUnchecked(pos, "unchecked.generic.array.creation", argtype);
        }
    }

    public boolean checkValidGenericType(Type t) {
        return this.firstIncompatibleTypeArg(t) == null;
    }

    private Type firstIncompatibleTypeArg(Type type) {
        List<Type> formals = type.tsym.type.allparams();
        List<Type> actuals = type.allparams();
        List<Type> args = type.getTypeArguments();
        List<Type> forms = type.tsym.type.getTypeArguments();
        ListBuffer<Type> bounds_buf = new ListBuffer<Type>();
        while (args.nonEmpty() && forms.nonEmpty()) {
            bounds_buf.append(this.types.subst(((Type)forms.head).getUpperBound(), formals, actuals));
            args = args.tail;
            forms = forms.tail;
        }
        args = type.getTypeArguments();
        List<Type> tvars_cap = this.types.substBounds(formals, formals, this.types.capture(type).allparams());
        while (args.nonEmpty() && tvars_cap.nonEmpty()) {
            ((Type)args.head).withTypeVar((Type.TypeVar)tvars_cap.head);
            args = args.tail;
            tvars_cap = tvars_cap.tail;
        }
        args = type.getTypeArguments();
        List bounds = bounds_buf.toList();
        while (args.nonEmpty() && bounds.nonEmpty()) {
            Type actual = (Type)args.head;
            if (!(this.isTypeArgErroneous(actual) || ((Type)bounds.head).isErroneous() || this.checkExtends(actual, (Type)bounds.head))) {
                return (Type)args.head;
            }
            args = args.tail;
            bounds = bounds.tail;
        }
        args = type.getTypeArguments();
        bounds = bounds_buf.toList();
        for (Type arg : this.types.capture(type).getTypeArguments()) {
            if (arg.tag == 14 && arg.getUpperBound().isErroneous() && !((Type)bounds.head).isErroneous() && !this.isTypeArgErroneous((Type)args.head)) {
                return (Type)args.head;
            }
            bounds = bounds.tail;
            args = args.tail;
        }
        return null;
    }

    boolean isTypeArgErroneous(Type t) {
        return this.isTypeArgErroneous.visit(t);
    }

    long checkFlags(JCDiagnostic.DiagnosticPosition pos, long flags, Symbol sym, JCTree tree) {
        long mask;
        long implicit = 0L;
        switch (sym.kind) {
            case 4: {
                if (sym.owner.kind != 2 && sym.owner.kind != 31) {
                    mask = 0x200000010L;
                    break;
                }
                if ((sym.owner.flags_field & 0x200L) != 0L) {
                    implicit = 25L;
                    mask = 25L;
                    break;
                }
                mask = 16607L;
                break;
            }
            case 16: {
                if (sym.name == this.names.init) {
                    if ((sym.owner.flags_field & 0x4000L) != 0L) {
                        implicit = 2L;
                        mask = 2L;
                    } else {
                        mask = 7L;
                    }
                } else if ((sym.owner.flags_field & 0x200L) != 0L) {
                    implicit = 1025L;
                    mask = 1025L;
                } else {
                    mask = 3391L;
                }
                if (((flags | implicit) & 0x400L) != 0L) break;
                implicit |= sym.owner.flags_field & 0x800L;
                break;
            }
            case 2: 
            case 31: {
                if (sym.isLocal()) {
                    mask = 23568L;
                    if (sym.name.isEmpty()) {
                        mask |= 8L;
                        implicit |= 0x10L;
                    }
                    if ((sym.owner.flags_field & 8L) == 0L && (flags & 0x4000L) != 0L) {
                        this.log.error(pos, "enums.must.be.static", new Object[0]);
                    }
                } else if (sym.owner.kind == 2 || sym.owner.kind == 31) {
                    mask = 24087L;
                    if (sym.owner.owner.kind == 1 || (sym.owner.flags_field & 8L) != 0L) {
                        mask |= 8L;
                    } else if ((flags & 0x4000L) != 0L) {
                        this.log.error(pos, "enums.must.be.static", new Object[0]);
                    }
                    if ((flags & 0x4200L) != 0L) {
                        implicit = 8L;
                    }
                } else {
                    mask = 32273L;
                }
                if ((flags & 0x200L) != 0L) {
                    implicit |= 0x400L;
                }
                if ((flags & 0x4000L) != 0L) {
                    mask &= 0xFFFFFFFFFFFFFBEFL;
                    implicit |= this.implicitEnumFinalFlag(tree);
                }
                implicit |= sym.owner.flags_field & 0x800L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long illegal = flags & 0xFFFL & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (illegal != 0L) {
            if ((illegal & 0x200L) != 0L) {
                this.log.error(pos, "intf.not.allowed.here", new Object[0]);
                mask |= 0x200L;
            } else {
                this.log.error(pos, "mod.not.allowed.here", Flags.asFlagSet(illegal));
            }
        } else if (sym.kind == 2 || this.checkDisjoint(pos, flags, 1024L, 10L)) {
            if (this.checkDisjoint(pos, flags, 1536L, 304L)) {
                if (this.checkDisjoint(pos, flags, 1L, 6L)) {
                    if (this.checkDisjoint(pos, flags, 2L, 5L)) {
                        if (this.checkDisjoint(pos, flags, 16L, 64L)) {
                            if (sym.kind != 2 && !this.checkDisjoint(pos, flags, 1280L, 2048L)) {
                                flags &= 0xFFFFFFFFFFFFF7FFL;
                            }
                        } else {
                            flags &= 0xFFFFFFFFFFFFFFBFL;
                        }
                    } else {
                        flags &= 0xFFFFFFFFFFFFFFFAL;
                    }
                } else {
                    flags &= 0xFFFFFFFFFFFFFFF9L;
                }
            } else {
                flags &= 0xFFFFFFFFFFFFFECFL;
            }
        } else {
            flags &= 0xFFFFFFFFFFFFFFF5L;
        }
        return flags & (mask | 0xFFFFFFFFFFFFF000L) | implicit;
    }

    private long implicitEnumFinalFlag(JCTree tree) {
        if (tree.getTag() != 3) {
            return 0L;
        }
        class SpecialTreeVisitor
        extends JCTree.Visitor {
            boolean specialized = false;

            SpecialTreeVisitor() {
            }

            public void visitTree(JCTree tree) {
            }

            public void visitVarDef(JCTree.JCVariableDecl tree) {
                if ((tree.mods.flags & 0x4000L) != 0L && tree.init instanceof JCTree.JCNewClass && ((JCTree.JCNewClass)tree.init).def != null) {
                    this.specialized = true;
                }
            }
        }
        SpecialTreeVisitor sts = new SpecialTreeVisitor();
        JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)tree;
        for (JCTree defs : cdef.defs) {
            defs.accept(sts);
            if (!sts.specialized) continue;
            return 0L;
        }
        return 16L;
    }

    void validate(JCTree tree, Env<AttrContext> env) {
        this.validate(tree, env, true);
    }

    void validate(JCTree tree, Env<AttrContext> env, boolean checkRaw) {
        new Validator(env).validateTree(tree, checkRaw, true);
    }

    void validate(List<? extends JCTree> trees, Env<AttrContext> env) {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            this.validate((JCTree)l.head, env);
            l = l.tail;
        }
    }

    boolean subset(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubtype(t, (Type)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    boolean intersects(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubtype(t, (Type)l.head) || this.types.isSubtype((Type)l.head, t)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    List<Type> incl(Type t, List<Type> ts) {
        return this.subset(t, ts) ? ts : this.excl(t, ts).prepend(t);
    }

    List<Type> excl(Type t, List<Type> ts) {
        if (ts.isEmpty()) {
            return ts;
        }
        List<Type> ts1 = this.excl(t, ts.tail);
        if (this.types.isSubtype((Type)ts.head, t)) {
            return ts1;
        }
        if (ts1 == ts.tail) {
            return ts;
        }
        return ts1.prepend((Type)ts.head);
    }

    List<Type> union(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.incl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    List<Type> diff(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.excl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    public List<Type> intersect(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = List.nil();
        List<Type> l = ts1;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts2)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        l = ts2;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts1)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        return ts;
    }

    boolean isUnchecked(Symbol.ClassSymbol exc) {
        return exc.kind == 31 || exc.isSubClass(this.syms.errorType.tsym, this.types) || exc.isSubClass(this.syms.runtimeExceptionType.tsym, this.types);
    }

    boolean isUnchecked(Type exc) {
        return exc == null ? true : (exc.tag == 14 ? this.isUnchecked(this.types.supertype(exc)) : (exc.tag == 10 ? this.isUnchecked((Symbol.ClassSymbol)exc.tsym) : exc.tag == 17 || exc.tag == 19));
    }

    boolean isUnchecked(JCDiagnostic.DiagnosticPosition pos, Type exc) {
        try {
            return this.isUnchecked(exc);
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(pos, ex);
            return true;
        }
    }

    boolean isHandled(Type exc, List<Type> handled) {
        return this.isUnchecked(exc) || this.subset(exc, handled);
    }

    List<Type> unhandled(List<Type> thrown, List<Type> handled) {
        List<Type> unhandled = List.nil();
        List<Type> l = thrown;
        while (l.nonEmpty()) {
            if (!this.isHandled((Type)l.head, handled)) {
                unhandled = unhandled.prepend((Type)l.head);
            }
            l = l.tail;
        }
        return unhandled;
    }

    static int protection(long flags) {
        switch ((short)(flags & 7L)) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            default: {
                return 0;
            }
            case 0: 
        }
        return 2;
    }

    Object cannotOverride(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "cant.override" : ((m.owner.flags() & 0x200L) == 0L ? "cant.implement" : "clashes.with");
        return this.diags.fragment(key, m, m.location(), other, other.location());
    }

    Object uncheckedOverrides(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "unchecked.override" : ((m.owner.flags() & 0x200L) == 0L ? "unchecked.implement" : "unchecked.clash.with");
        return this.diags.fragment(key, m, m.location(), other, other.location());
    }

    Object varargsOverrides(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "varargs.override" : ((m.owner.flags() & 0x200L) == 0L ? "varargs.implement" : "varargs.clash.with");
        return this.diags.fragment(key, m, m.location(), other, other.location());
    }

    void checkOverride(JCTree tree, Symbol.MethodSymbol m, Symbol.MethodSymbol other, Symbol.ClassSymbol origin) {
        if ((m.flags() & 0x80001000L) != 0L || (other.flags() & 0x1000L) != 0L) {
            return;
        }
        if ((m.flags() & 8L) != 0L && (other.flags() & 8L) == 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.static", this.cannotOverride(m, other));
            return;
        }
        if ((other.flags() & 0x10L) != 0L || (m.flags() & 8L) == 0L && (other.flags() & 8L) != 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.meth", this.cannotOverride(m, other), Flags.asFlagSet(other.flags() & 0x18L));
            return;
        }
        if ((m.owner.flags() & 0x2000L) != 0L) {
            return;
        }
        if ((origin.flags() & 0x200L) == 0L && Check.protection(m.flags()) > Check.protection(other.flags())) {
            this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.weaker.access", this.cannotOverride(m, other), other.flags() == 0L ? Flags.Flag.PACKAGE : Flags.asFlagSet(other.flags() & 7L));
            return;
        }
        Type mt = this.types.memberType(origin.type, m);
        Type ot = this.types.memberType(origin.type, other);
        List<Type> mtvars = mt.getTypeArguments();
        List<Type> otvars = ot.getTypeArguments();
        Type mtres = mt.getReturnType();
        Type otres = this.types.subst(ot.getReturnType(), otvars, mtvars);
        this.overrideWarner.clear();
        boolean resultTypesOK = this.types.returnTypeSubstitutable(mt, ot, otres, this.overrideWarner);
        if (!resultTypesOK) {
            if (this.allowCovariantReturns || m.owner == origin || !m.owner.isSubClass(other.owner, this.types)) {
                this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.incompatible.ret", this.cannotOverride(m, other), mtres, otres);
                return;
            }
        } else if (this.overrideWarner.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
            this.warnDeferredUnchecked(TreeInfo.diagnosticPositionFor(m, tree), "override.unchecked.ret", this.uncheckedOverrides(m, other), mtres, otres);
        }
        List<Type> otthrown = this.types.subst(ot.getThrownTypes(), otvars, mtvars);
        List<Type> unhandledErased = this.unhandled(mt.getThrownTypes(), this.types.erasure(otthrown));
        List<Type> unhandledUnerased = this.unhandled(mt.getThrownTypes(), otthrown);
        if (unhandledErased.nonEmpty()) {
            this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.meth.doesnt.throw", this.cannotOverride(m, other), unhandledUnerased.head);
            return;
        }
        if (unhandledUnerased.nonEmpty()) {
            this.warnDeferredUnchecked(TreeInfo.diagnosticPositionFor(m, tree), "override.unchecked.thrown", this.cannotOverride(m, other), unhandledUnerased.head);
            return;
        }
        if (((m.flags() ^ other.flags()) & 0x400000000L) != 0L && this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            this.log.warning(TreeInfo.diagnosticPositionFor(m, tree), (m.flags() & 0x400000000L) != 0L ? "override.varargs.missing" : "override.varargs.extra", this.varargsOverrides(m, other));
        }
        if ((other.flags() & 0x80000000L) != 0L) {
            this.log.warning(TreeInfo.diagnosticPositionFor(m, tree), "override.bridge", this.uncheckedOverrides(m, other));
        }
        if (!this.isDeprecatedOverrideIgnorable(other, origin)) {
            this.checkDeprecated(TreeInfo.diagnosticPositionFor(m, tree), m, other);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warnDeferredUnchecked(final JCDiagnostic.DiagnosticPosition pos, final String msg, final Object ... args) {
        JCDiagnostic.DiagnosticPosition prevPos = this.deferredLintHandler.getPos();
        this.deferredLintHandler.setPos(pos);
        try {
            this.deferredLintHandler.report(new DeferredLintHandler.LintLogger(){

                public void report() {
                    Check.this.warnUnchecked(pos, msg, args);
                }
            });
            Object var6_5 = null;
            this.deferredLintHandler.setPos(prevPos);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.deferredLintHandler.setPos(prevPos);
            throw throwable;
        }
    }

    private boolean isDeprecatedOverrideIgnorable(Symbol.MethodSymbol m, Symbol.ClassSymbol origin) {
        Symbol.ClassSymbol mc = m.enclClass();
        Type st = this.types.supertype(origin.type);
        if (st.tag != 10) {
            return true;
        }
        Symbol.MethodSymbol stimpl = m.implementation((Symbol.ClassSymbol)st.tsym, this.types, false);
        if (mc != null && (mc.flags() & 0x200L) != 0L) {
            List<Type> intfs = this.types.interfaces(origin.type);
            return intfs.contains(mc.type) ? false : stimpl != null;
        }
        return stimpl != m;
    }

    public void checkCompatibleConcretes(JCDiagnostic.DiagnosticPosition pos, Type site) {
        Type sup = this.types.supertype(site);
        if (sup.tag != 10) {
            return;
        }
        Type t1 = sup;
        while (t1.tsym.type.isParameterized()) {
            Scope.Entry e1 = t1.tsym.members().elems;
            while (e1 != null) {
                Symbol s1 = e1.sym;
                if (s1.kind == 16 && (s1.flags() & 0x80001008L) == 0L && s1.isInheritedIn(site.tsym, this.types) && ((Symbol.MethodSymbol)s1).implementation(site.tsym, this.types, true) == s1) {
                    Type st1 = this.types.memberType(t1, s1);
                    int s1ArgsLength = st1.getParameterTypes().length();
                    if (st1 != s1.type) {
                        Type t2 = sup;
                        while (t2.tag == 10) {
                            Scope.Entry e2 = t2.tsym.members().lookup(s1.name);
                            while (e2.scope != null) {
                                Type st2;
                                Symbol s2 = e2.sym;
                                if (s2 != s1 && s2.kind == 16 && (s2.flags() & 0x80001008L) == 0L && s2.type.getParameterTypes().length() == s1ArgsLength && s2.isInheritedIn(site.tsym, this.types) && ((Symbol.MethodSymbol)s2).implementation(site.tsym, this.types, true) == s2 && this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) {
                                    this.log.error(pos, "concrete.inheritance.conflict", s1, t1, s2, t2, sup);
                                }
                                e2 = e2.next();
                            }
                            t2 = this.types.supertype(t2);
                        }
                    }
                }
                e1 = e1.sibling;
            }
            t1 = this.types.supertype(t1);
        }
    }

    public boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2) {
        return this.checkCompatibleAbstracts(pos, t1, t2, this.types.makeCompoundType(t1, t2));
    }

    public boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        return this.firstIncompatibility(pos, t1, t2, site) == null;
    }

    private Symbol firstIncompatibility(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        HashMap<Symbol.TypeSymbol, Type> interfaces2;
        HashMap<Symbol.TypeSymbol, Type> interfaces1 = new HashMap<Symbol.TypeSymbol, Type>();
        this.closure(t1, interfaces1);
        if (t1 == t2) {
            interfaces2 = interfaces1;
        } else {
            interfaces2 = new HashMap<Symbol.TypeSymbol, Type>();
            this.closure(t2, interfaces1, interfaces2);
        }
        for (Type t3 : interfaces1.values()) {
            for (Type t4 : interfaces2.values()) {
                Symbol s = this.firstDirectIncompatibility(pos, t3, t4, site);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (t.tag != 10) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typeMap);
            }
        }
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typesSkip, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (t.tag != 10) {
            return;
        }
        if (typesSkip.get(t.tsym) != null) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typesSkip, typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typesSkip, typeMap);
            }
        }
    }

    private Symbol firstDirectIncompatibility(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        Scope.Entry e1 = t1.tsym.members().elems;
        while (e1 != null) {
            Symbol.MethodSymbol impl;
            Symbol s1 = e1.sym;
            Type st1 = null;
            if (s1.kind == 16 && s1.isInheritedIn(site.tsym, this.types) && ((impl = ((Symbol.MethodSymbol)s1).implementation(site.tsym, this.types, false)) == null || (impl.flags() & 0x400L) != 0L)) {
                Scope.Entry e2 = t2.tsym.members().lookup(s1.name);
                while (e2.scope != null) {
                    Symbol s2 = e2.sym;
                    if (s1 != s2 && s2.kind == 16 && s2.isInheritedIn(site.tsym, this.types)) {
                        Type st2;
                        if (st1 == null) {
                            st1 = this.types.memberType(t1, s1);
                        }
                        if (this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) {
                            Type rt2;
                            boolean compat;
                            List<Type> tvars1 = st1.getTypeArguments();
                            List<Type> tvars2 = st2.getTypeArguments();
                            Type rt1 = st1.getReturnType();
                            boolean bl = compat = this.types.isSameType(rt1, rt2 = this.types.subst(st2.getReturnType(), tvars2, tvars1)) || rt1.tag >= 10 && rt2.tag >= 10 && (this.types.covariantReturnType(rt1, rt2, Warner.noWarnings) || this.types.covariantReturnType(rt2, rt1, Warner.noWarnings)) || this.checkCommonOverriderIn(s1, s2, site);
                            if (!compat) {
                                this.log.error(pos, "types.incompatible.diff.ret", t1, t2, s2.name + "(" + this.types.memberType(t2, s2).getParameterTypes() + ")");
                                return s2;
                            }
                        } else if (this.checkNameClash((Symbol.ClassSymbol)site.tsym, s1, s2) && !this.checkCommonOverriderIn(s1, s2, site)) {
                            this.log.error(pos, "name.clash.same.erasure.no.override", s1, s1.location(), s2, s2.location());
                            return s2;
                        }
                    }
                    e2 = e2.next();
                }
            }
            e1 = e1.sibling;
        }
        return null;
    }

    boolean checkCommonOverriderIn(Symbol s1, Symbol s2, Type site) {
        HashMap<Symbol.TypeSymbol, Type> supertypes = new HashMap<Symbol.TypeSymbol, Type>();
        Type st1 = this.types.memberType(site, s1);
        Type st2 = this.types.memberType(site, s2);
        this.closure(site, supertypes);
        for (Type t : supertypes.values()) {
            Scope.Entry e = t.tsym.members().lookup(s1.name);
            while (e.scope != null) {
                Type st3;
                Symbol s3 = e.sym;
                if (s3 != s1 && s3 != s2 && s3.kind == 16 && (s3.flags() & 0x80001000L) == 0L && this.types.overrideEquivalent(st3 = this.types.memberType(site, s3), st1) && this.types.overrideEquivalent(st3, st2)) {
                    boolean compat;
                    if (s3.owner == site.tsym) {
                        return true;
                    }
                    List<Type> tvars1 = st1.getTypeArguments();
                    List<Type> tvars2 = st2.getTypeArguments();
                    List<Type> tvars3 = st3.getTypeArguments();
                    Type rt1 = st1.getReturnType();
                    Type rt2 = st2.getReturnType();
                    Type rt13 = this.types.subst(st3.getReturnType(), tvars3, tvars1);
                    Type rt23 = this.types.subst(st3.getReturnType(), tvars3, tvars2);
                    boolean bl = compat = rt13.tag >= 10 && rt23.tag >= 10 && this.types.covariantReturnType(rt13, rt1, Warner.noWarnings) && this.types.covariantReturnType(rt23, rt2, Warner.noWarnings);
                    if (compat) {
                        return true;
                    }
                }
                e = e.next();
            }
        }
        return false;
    }

    void checkOverride(JCTree tree, Symbol.MethodSymbol m) {
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)m.owner;
        if ((origin.flags() & 0x4000L) != 0L && this.names.finalize.equals(m.name) && m.overrides(this.syms.enumFinalFinalize, origin, this.types, false)) {
            this.log.error(tree.pos(), "enum.no.finalize", new Object[0]);
            return;
        }
        Type t = origin.type;
        while (t.tag == 10) {
            if (t != origin.type) {
                this.checkOverride(tree, t, origin, m);
            }
            for (Type t2 : this.types.interfaces(t)) {
                this.checkOverride(tree, t2, origin, m);
            }
            t = this.types.supertype(t);
        }
    }

    void checkOverride(JCTree tree, Type site, Symbol.ClassSymbol origin, Symbol.MethodSymbol m) {
        Symbol.TypeSymbol c = site.tsym;
        Scope.Entry e = c.members().lookup(m.name);
        while (e.scope != null) {
            if (m.overrides(e.sym, origin, this.types, false) && (e.sym.flags() & 0x400L) == 0L) {
                this.checkOverride(tree, m, (Symbol.MethodSymbol)e.sym, origin);
            }
            e = e.next();
        }
    }

    private boolean checkNameClash(Symbol.ClassSymbol origin, Symbol s1, Symbol s2) {
        ClashFilter cf = new ClashFilter(origin.type);
        return cf.accepts(s1) && cf.accepts(s2) && this.types.hasSameArgs(s1.erasure(this.types), s2.erasure(this.types));
    }

    void checkAllDefined(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        try {
            Symbol.MethodSymbol undef = this.firstUndef(c, c);
            if (undef != null) {
                if ((c.flags() & 0x4000L) != 0L && this.types.supertype((Type)c.type).tsym == this.syms.enumSym && (c.flags() & 0x10L) == 0L) {
                    c.flags_field |= 0x400L;
                } else {
                    Symbol.MethodSymbol undef1 = new Symbol.MethodSymbol(undef.flags(), undef.name, this.types.memberType(c.type, undef), undef.owner);
                    this.log.error(pos, "does.not.override.abstract", c, undef1, undef1.location());
                }
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(pos, ex);
        }
    }

    private Symbol.MethodSymbol firstUndef(Symbol.ClassSymbol impl, Symbol.ClassSymbol c) {
        Symbol.MethodSymbol undef = null;
        if (c == impl || (c.flags() & 0x600L) != 0L) {
            Scope s = c.members();
            Scope.Entry e = s.elems;
            while (undef == null && e != null) {
                Symbol.MethodSymbol absmeth;
                Symbol.MethodSymbol implmeth;
                if (e.sym.kind == 16 && (e.sym.flags() & 0x200400L) == 1024L && ((implmeth = (absmeth = (Symbol.MethodSymbol)e.sym).implementation(impl, this.types, true)) == null || implmeth == absmeth)) {
                    undef = absmeth;
                }
                e = e.sibling;
            }
            if (undef == null) {
                Type st = this.types.supertype(c.type);
                if (st.tag == 10) {
                    undef = this.firstUndef(impl, (Symbol.ClassSymbol)st.tsym);
                }
            }
            List<Type> l = this.types.interfaces(c.type);
            while (undef == null && l.nonEmpty()) {
                undef = this.firstUndef(impl, (Symbol.ClassSymbol)((Type)l.head).tsym);
                l = l.tail;
            }
        }
        return undef;
    }

    void checkNonCyclicDecl(JCTree.JCClassDecl tree) {
        CycleChecker cc = new CycleChecker();
        cc.scan(tree);
        if (!cc.errorFound && !cc.partialCheck) {
            tree.sym.flags_field |= 0x40000000L;
        }
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition pos, Type t) {
        this.checkNonCyclicInternal(pos, t);
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition pos, Type.TypeVar t) {
        this.checkNonCyclic1(pos, t, List.<Type.TypeVar>nil());
    }

    private void checkNonCyclic1(JCDiagnostic.DiagnosticPosition pos, Type t, List<Type.TypeVar> seen) {
        if (t.tag == 14 && (t.tsym.flags() & 0x10000000L) != 0L) {
            return;
        }
        if (seen.contains(t)) {
            Type.TypeVar tv = (Type.TypeVar)t;
            tv.bound = this.types.createErrorType(t);
            this.log.error(pos, "cyclic.inheritance", t);
        } else if (t.tag == 14) {
            Type.TypeVar tv = (Type.TypeVar)t;
            seen = seen.prepend(tv);
            for (Type b : this.types.getBounds(tv)) {
                this.checkNonCyclic1(pos, b, seen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNonCyclicInternal(JCDiagnostic.DiagnosticPosition pos, Type t) {
        boolean complete = true;
        Symbol.TypeSymbol c = t.tsym;
        if ((c.flags_field & 0x40000000L) != 0L) {
            return true;
        }
        if ((c.flags_field & 0x8000000L) != 0L) {
            this.noteCyclic(pos, (Symbol.ClassSymbol)c);
        } else if (!c.type.isErroneous()) {
            try {
                c.flags_field |= 0x8000000L;
                if (c.type.tag == 10) {
                    Type st;
                    Type.ClassType clazz = (Type.ClassType)c.type;
                    if (clazz.interfaces_field != null) {
                        List<Type> l = clazz.interfaces_field;
                        while (l.nonEmpty()) {
                            complete &= this.checkNonCyclicInternal(pos, (Type)l.head);
                            l = l.tail;
                        }
                    }
                    if (clazz.supertype_field != null && (st = clazz.supertype_field) != null && st.tag == 10) {
                        complete &= this.checkNonCyclicInternal(pos, st);
                    }
                    if (c.owner.kind == 2) {
                        complete &= this.checkNonCyclicInternal(pos, c.owner.type);
                    }
                }
                Object var8_7 = null;
                c.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                c.flags_field &= 0xFFFFFFFFF7FFFFFFL;
                throw throwable;
            }
        }
        if (complete) {
            boolean bl = complete = (c.flags_field & 0x10000000L) == 0L && c.completer == null;
        }
        if (complete) {
            c.flags_field |= 0x40000000L;
        }
        return complete;
    }

    private void noteCyclic(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        this.log.error(pos, "cyclic.inheritance", c);
        List<Type> l = this.types.interfaces(c.type);
        while (l.nonEmpty()) {
            l.head = this.types.createErrorType((Symbol.ClassSymbol)((Type)l.head).tsym, Type.noType);
            l = l.tail;
        }
        Type st = this.types.supertype(c.type);
        if (st.tag == 10) {
            ((Type.ClassType)c.type).supertype_field = this.types.createErrorType((Symbol.ClassSymbol)st.tsym, Type.noType);
        }
        c.type = this.types.createErrorType(c, c.type);
        c.flags_field |= 0x40000000L;
    }

    void checkImplementations(JCTree.JCClassDecl tree) {
        this.checkImplementations(tree, tree.sym);
    }

    void checkImplementations(JCTree.JCClassDecl tree, Symbol.ClassSymbol ic) {
        Symbol.ClassSymbol origin = tree.sym;
        List<Type> l = this.types.closure(ic.type);
        while (l.nonEmpty()) {
            ElementKind kind = ((Type)l.head).tsym.getKind();
            if (kind.isClass() || kind.isInterface()) {
                Symbol.ClassSymbol lc = (Symbol.ClassSymbol)((Type)l.head).tsym;
                if ((this.allowGenerics || origin != lc) && (lc.flags() & 0x400L) != 0L) {
                    Scope.Entry e = lc.members().elems;
                    while (e != null) {
                        Symbol.MethodSymbol absmeth;
                        Symbol.MethodSymbol implmeth;
                        if (e.sym.kind == 16 && (e.sym.flags() & 0x408L) == 1024L && (implmeth = (absmeth = (Symbol.MethodSymbol)e.sym).implementation(origin, this.types, false)) != null && implmeth != absmeth && (implmeth.owner.flags() & 0x200L) == (origin.flags() & 0x200L)) {
                            this.checkOverride((JCTree)tree, implmeth, absmeth, origin);
                        }
                        e = e.sibling;
                    }
                }
            }
            l = l.tail;
        }
    }

    void checkCompatibleSupertypes(JCDiagnostic.DiagnosticPosition pos, Type c) {
        List<Type> supertypes = this.types.interfaces(c);
        Type supertype = this.types.supertype(c);
        if (supertype.tag == 10 && (supertype.tsym.flags() & 0x400L) != 0L) {
            supertypes = supertypes.prepend(supertype);
        }
        List<Type> l = supertypes;
        while (l.nonEmpty()) {
            if (this.allowGenerics && !((Type)l.head).getTypeArguments().isEmpty() && !this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)l.head, c)) {
                return;
            }
            List<Type> m = supertypes;
            while (m != l) {
                if (!this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)m.head, c)) {
                    return;
                }
                m = m.tail;
            }
            l = l.tail;
        }
        this.checkCompatibleConcretes(pos, c);
    }

    void checkConflicts(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Symbol.TypeSymbol c) {
        Type previous = null;
        Type ct = c.type;
        while (ct != Type.noType && ct != previous) {
            Scope.Entry e = ct.tsym.members().lookup(sym.name);
            while (e.scope == ct.tsym.members()) {
                if (sym.kind == e.sym.kind && this.types.isSameType(this.types.erasure(sym.type), this.types.erasure(e.sym.type)) && sym != e.sym && (sym.flags() & 0x1000L) != (e.sym.flags() & 0x1000L) && (sym.flags() & 0x200000L) == 0L && (e.sym.flags() & 0x200000L) == 0L && (sym.flags() & 0x80000000L) == 0L && (e.sym.flags() & 0x80000000L) == 0L) {
                    this.syntheticError(pos, (e.sym.flags() & 0x1000L) == 0L ? e.sym : sym);
                    return;
                }
                e = e.next();
            }
            previous = ct;
            ct = this.types.supertype(ct);
        }
    }

    void checkOverrideClashes(JCDiagnostic.DiagnosticPosition pos, Type site, Symbol.MethodSymbol sym) {
        if (site == null || site.isErroneous()) {
            return;
        }
        ClashFilter cf = new ClashFilter(site);
        for (Symbol m1 : this.types.membersClosure(site, false).getElementsByName(sym.name, cf)) {
            if (!sym.overrides(m1, site.tsym, this.types, false)) continue;
            for (Symbol m2 : this.types.membersClosure(site, false).getElementsByName(sym.name, cf)) {
                if (m2 == m1 || this.types.isSubSignature(sym.type, this.types.memberType(site, m2), false) || !this.types.hasSameArgs(m2.erasure(this.types), m1.erasure(this.types))) continue;
                sym.flags_field |= 0x80000000000L;
                String key = m1 == sym ? "name.clash.same.erasure.no.override" : "name.clash.same.erasure.no.override.1";
                this.log.error(pos, key, sym, sym.location(), m2, m2.location(), m1, m1.location());
                return;
            }
        }
    }

    void checkHideClashes(JCDiagnostic.DiagnosticPosition pos, Type site, Symbol.MethodSymbol sym) {
        if (site.isErroneous()) {
            return;
        }
        ClashFilter cf = new ClashFilter(site);
        for (Symbol s : this.types.membersClosure(site, true).getElementsByName(sym.name, cf)) {
            if (this.types.isSubSignature(sym.type, this.types.memberType(site, s), false) || !this.types.hasSameArgs(s.erasure(this.types), sym.erasure(this.types))) continue;
            this.log.error(pos, "name.clash.same.erasure.no.hide", sym, sym.location(), s, s.location());
            return;
        }
    }

    private void syntheticError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (!sym.type.isErroneous()) {
            if (this.warnOnSyntheticConflicts) {
                this.log.warning(pos, "synthetic.name.conflict", sym, sym.location());
            } else {
                this.log.error(pos, "synthetic.name.conflict", sym, sym.location());
            }
        }
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition pos, Type type) {
        this.checkClassBounds(pos, new HashMap<Symbol.TypeSymbol, Type>(), type);
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition pos, Map<Symbol.TypeSymbol, Type> seensofar, Type type) {
        if (type.isErroneous()) {
            return;
        }
        List<Type> l = this.types.interfaces(type);
        while (l.nonEmpty()) {
            List<Type> newparams;
            List<Type> oldparams;
            Type it = (Type)l.head;
            Type oldit = seensofar.put(it.tsym, it);
            if (oldit != null && !this.types.containsTypeEquivalent(oldparams = oldit.allparams(), newparams = it.allparams())) {
                this.log.error(pos, "cant.inherit.diff.arg", it.tsym, Type.toString(oldparams), Type.toString(newparams));
            }
            this.checkClassBounds(pos, seensofar, it);
            l = l.tail;
        }
        Type st = this.types.supertype(type);
        if (st != null) {
            this.checkClassBounds(pos, seensofar, st);
        }
    }

    void checkNotRepeated(JCDiagnostic.DiagnosticPosition pos, Type it, Set<Type> its) {
        if (its.contains(it)) {
            this.log.error(pos, "repeated.interface", new Object[0]);
        } else {
            its.add(it);
        }
    }

    void validateAnnotationTree(JCTree tree) {
        class AnnotationValidator
        extends TreeScanner {
            AnnotationValidator() {
            }

            public void visitAnnotation(JCTree.JCAnnotation tree) {
                if (tree.type != null && !tree.type.isErroneous()) {
                    super.visitAnnotation(tree);
                    Check.this.validateAnnotation(tree);
                }
            }
        }
        tree.accept(new AnnotationValidator());
    }

    void validateAnnotationType(JCTree restype) {
        if (restype != null) {
            this.validateAnnotationType(restype.pos(), restype.type);
        }
    }

    void validateAnnotationType(JCDiagnostic.DiagnosticPosition pos, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (this.types.isSameType(type, this.syms.stringType)) {
            return;
        }
        if ((type.tsym.flags() & 0x4000L) != 0L) {
            return;
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            return;
        }
        if (this.types.lowerBound((Type)type).tsym == this.syms.classType.tsym) {
            return;
        }
        if (this.types.isArray(type) && !this.types.isArray(this.types.elemtype(type))) {
            this.validateAnnotationType(pos, this.types.elemtype(type));
            return;
        }
        this.log.error(pos, "invalid.annotation.member.type", new Object[0]);
    }

    void validateAnnotationMethod(JCDiagnostic.DiagnosticPosition pos, Symbol.MethodSymbol m) {
        Type sup = this.syms.annotationType;
        while (sup.tag == 10) {
            Scope s = sup.tsym.members();
            Scope.Entry e = s.lookup(m.name);
            while (e.scope != null) {
                if (e.sym.kind == 16 && (e.sym.flags() & 5L) != 0L && this.types.overrideEquivalent(m.type, e.sym.type)) {
                    this.log.error(pos, "intf.annotation.member.clash", e.sym, sup);
                }
                e = e.next();
            }
            sup = this.types.supertype(sup);
        }
    }

    public void validateAnnotations(List<JCTree.JCAnnotation> annotations, Symbol s) {
        if (this.skipAnnotations) {
            return;
        }
        for (JCTree.JCAnnotation a : annotations) {
            this.validateAnnotation(a, s);
        }
    }

    public void validateAnnotation(JCTree.JCAnnotation a, Symbol s) {
        this.validateAnnotationTree(a);
        if (!this.annotationApplicable(a, s)) {
            this.log.error(a.pos(), "annotation.type.not.applicable", new Object[0]);
        }
        if (a.annotationType.type.tsym == this.syms.overrideType.tsym && !this.isOverrider(s)) {
            this.log.error(a.pos(), "method.does.not.override.superclass", new Object[0]);
        }
    }

    boolean isOverrider(Symbol s) {
        if (s.kind != 16 || s.isStatic()) {
            return false;
        }
        Symbol.MethodSymbol m = (Symbol.MethodSymbol)s;
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)m.owner;
        for (Type sup : this.types.closure(owner.type)) {
            if (sup == owner.type) continue;
            Scope scope = sup.tsym.members();
            Scope.Entry e = scope.lookup(m.name);
            while (e.scope != null) {
                if (!e.sym.isStatic() && m.overrides(e.sym, owner, this.types, true)) {
                    return true;
                }
                e = e.next();
            }
        }
        return false;
    }

    boolean annotationApplicable(JCTree.JCAnnotation a, Symbol s) {
        Attribute.Compound atTarget = a.annotationType.type.tsym.attribute(this.syms.annotationTargetType.tsym);
        if (atTarget == null) {
            return true;
        }
        Attribute atValue = atTarget.member(this.names.value);
        if (!(atValue instanceof Attribute.Array)) {
            return true;
        }
        Attribute.Array arr = (Attribute.Array)atValue;
        for (Attribute app : arr.values) {
            if (!(app instanceof Attribute.Enum)) {
                return true;
            }
            Attribute.Enum e = (Attribute.Enum)app;
            if (e.value.name == this.names.TYPE) {
                if (s.kind != 2) continue;
                return true;
            }
            if (e.value.name == this.names.FIELD) {
                if (s.kind != 4 || s.owner.kind == 16) continue;
                return true;
            }
            if (e.value.name == this.names.METHOD) {
                if (s.kind != 16 || s.isConstructor()) continue;
                return true;
            }
            if (e.value.name == this.names.PARAMETER) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) == 0L) continue;
                return true;
            }
            if (e.value.name == this.names.CONSTRUCTOR) {
                if (s.kind != 16 || !s.isConstructor()) continue;
                return true;
            }
            if (e.value.name == this.names.LOCAL_VARIABLE) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) != 0L) continue;
                return true;
            }
            if (e.value.name == this.names.ANNOTATION_TYPE) {
                if (s.kind != 2 || (s.flags() & 0x2000L) == 0L) continue;
                return true;
            }
            if (e.value.name == this.names.PACKAGE) {
                if (s.kind != 1) continue;
                return true;
            }
            if (e.value.name == this.names.TYPE_USE) {
                if (s.kind != 2 && s.kind != 4 && (s.kind != 16 || s.isConstructor() || s.type.getReturnType().tag == 9)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void validateAnnotation(JCTree.JCAnnotation a) {
        TreeSet<Symbol> members = new TreeSet<Symbol>(new Comparator<Symbol>(){

            @Override
            public int compare(Symbol t, Symbol t1) {
                return t.name.compareTo(t1.name);
            }
        });
        Scope.Entry e = a.annotationType.type.tsym.members().elems;
        while (e != null) {
            if (e.sym.kind == 16) {
                members.add((Symbol.MethodSymbol)e.sym);
            }
            e = e.sibling;
        }
        for (JCTree.JCExpression arg : a.args) {
            if (arg.getTag() != 30) continue;
            JCTree.JCAssign jCAssign = (JCTree.JCAssign)arg;
            Symbol m2 = TreeInfo.symbol(jCAssign.lhs);
            if (m2 == null || m2.type.isErroneous() || members.remove(m2)) continue;
            this.log.error(jCAssign.lhs.pos(), "duplicate.annotation.member.value", m2.name, a.type);
        }
        ListBuffer missingDefaults = ListBuffer.lb();
        for (Symbol.MethodSymbol methodSymbol : members) {
            if (methodSymbol.defaultValue != null || methodSymbol.type.isErroneous() || methodSymbol.name == methodSymbol.name.table.names.clinit) continue;
            missingDefaults.append(methodSymbol.name);
        }
        if (missingDefaults.nonEmpty()) {
            String key = missingDefaults.size() > 1 ? "annotation.missing.default.value.1" : "annotation.missing.default.value";
            this.log.error(a.pos(), key, a.type, missingDefaults);
        }
        if (a.annotationType.type.tsym != this.syms.annotationTargetType.tsym || a.args.tail == null) {
            return;
        }
        if (((JCTree.JCExpression)a.args.head).getTag() != 30) {
            return;
        }
        JCTree.JCAssign assign = (JCTree.JCAssign)a.args.head;
        Symbol symbol = TreeInfo.symbol(assign.lhs);
        if (symbol.name != this.names.value) {
            return;
        }
        JCTree.JCExpression rhs = assign.rhs;
        if (rhs.getTag() != 28) {
            return;
        }
        JCTree.JCNewArray na = (JCTree.JCNewArray)rhs;
        HashSet<Symbol> targets = new HashSet<Symbol>();
        for (JCTree.JCExpression elem : na.elems) {
            if (targets.add(TreeInfo.symbol(elem))) continue;
            this.log.error(elem.pos(), "repeated.annotation.target", new Object[0]);
        }
    }

    void checkDeprecatedAnnotation(JCDiagnostic.DiagnosticPosition pos, Symbol s) {
        if (this.allowAnnotations && this.lint.isEnabled(Lint.LintCategory.DEP_ANN) && (s.flags() & 0x20000L) != 0L && !this.syms.deprecatedType.isErroneous() && s.attribute(this.syms.deprecatedType.tsym) == null) {
            this.log.warning(Lint.LintCategory.DEP_ANN, pos, "missing.deprecated.annotation", new Object[0]);
        }
    }

    void checkDeprecated(final JCDiagnostic.DiagnosticPosition pos, Symbol other, final Symbol s) {
        if ((s.flags() & 0x20000L) != 0L && (other.flags() & 0x20000L) == 0L && s.outermostClass() != other.outermostClass()) {
            this.deferredLintHandler.report(new DeferredLintHandler.LintLogger(){

                public void report() {
                    Check.this.warnDeprecated(pos, s);
                }
            });
        }
    }

    void checkSunAPI(final JCDiagnostic.DiagnosticPosition pos, final Symbol s) {
        if ((s.flags() & 0x4000000000L) != 0L) {
            this.deferredLintHandler.report(new DeferredLintHandler.LintLogger(){

                public void report() {
                    if (Check.this.enableSunApiLintControl) {
                        Check.this.warnSunApi(pos, "sun.proprietary", s);
                    } else {
                        Check.this.log.strictWarning(pos, "sun.proprietary", s);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElements(JCTree.JCClassDecl tree) {
        if ((tree.sym.flags_field & 0x2000L) == 0L) {
            return;
        }
        Assert.check((tree.sym.flags_field & 0x8000000L) == 0L);
        try {
            tree.sym.flags_field |= 0x8000000L;
            for (JCTree def : tree.defs) {
                if (def.getTag() != 4) continue;
                JCTree.JCMethodDecl meth = (JCTree.JCMethodDecl)def;
                this.checkAnnotationResType(meth.pos(), meth.restype.type);
            }
            Object var6_5 = null;
            tree.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tree.sym.flags_field |= 0x800000000L;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            tree.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tree.sym.flags_field |= 0x800000000L;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElementsInternal(JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol tsym) {
        if ((tsym.flags_field & 0x800000000L) != 0L) {
            return;
        }
        if ((tsym.flags_field & 0x8000000L) != 0L) {
            this.log.error(pos, "cyclic.annotation.element", new Object[0]);
            return;
        }
        try {
            tsym.flags_field |= 0x8000000L;
            Scope.Entry e = tsym.members().elems;
            while (e != null) {
                Symbol s = e.sym;
                if (s.kind == 16) {
                    this.checkAnnotationResType(pos, ((Symbol.MethodSymbol)s).type.getReturnType());
                }
                e = e.sibling;
            }
            Object var6_5 = null;
            tsym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tsym.flags_field |= 0x800000000L;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            tsym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tsym.flags_field |= 0x800000000L;
            throw throwable;
        }
    }

    void checkAnnotationResType(JCDiagnostic.DiagnosticPosition pos, Type type) {
        switch (type.tag) {
            case 10: {
                if ((type.tsym.flags() & 0x2000L) == 0L) break;
                this.checkNonCyclicElementsInternal(pos, type.tsym);
                break;
            }
            case 11: {
                this.checkAnnotationResType(pos, this.types.elemtype(type));
                break;
            }
        }
    }

    void checkCyclicConstructors(JCTree.JCClassDecl tree) {
        HashMap<Symbol, Symbol> callMap = new HashMap<Symbol, Symbol>();
        List<JCTree> l = tree.defs;
        while (l.nonEmpty()) {
            JCTree.JCMethodInvocation app = TreeInfo.firstConstructorCall((JCTree)l.head);
            if (app != null) {
                JCTree.JCMethodDecl meth = (JCTree.JCMethodDecl)l.head;
                if (TreeInfo.name(app.meth) == this.names._this) {
                    callMap.put(meth.sym, TreeInfo.symbol(app.meth));
                } else if (meth.sym != null) {
                    meth.sym.flags_field |= 0x40000000L;
                }
            }
            l = l.tail;
        }
        Symbol[] ctors = new Symbol[]{};
        for (Symbol caller : ctors = callMap.keySet().toArray(ctors)) {
            this.checkCyclicConstructor(tree, caller, callMap);
        }
    }

    private void checkCyclicConstructor(JCTree.JCClassDecl tree, Symbol ctor, Map<Symbol, Symbol> callMap) {
        if (ctor != null && (ctor.flags_field & 0x40000000L) == 0L) {
            if ((ctor.flags_field & 0x8000000L) != 0L) {
                this.log.error(TreeInfo.diagnosticPositionFor(ctor, tree), "recursive.ctor.invocation", new Object[0]);
            } else {
                ctor.flags_field |= 0x8000000L;
                this.checkCyclicConstructor(tree, callMap.remove(ctor), callMap);
                ctor.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            ctor.flags_field |= 0x40000000L;
        }
    }

    int checkOperator(JCDiagnostic.DiagnosticPosition pos, Symbol.OperatorSymbol operator, int tag, Type left, Type right) {
        if (operator.opcode == 277) {
            this.log.error(pos, "operator.cant.be.applied.1", this.treeinfo.operatorName(tag), left, right);
        }
        return operator.opcode;
    }

    void checkDivZero(JCDiagnostic.DiagnosticPosition pos, Symbol operator, Type operand) {
        int opc;
        if (operand.constValue() != null && this.lint.isEnabled(Lint.LintCategory.DIVZERO) && operand.tag <= 5 && ((Number)operand.constValue()).longValue() == 0L && ((opc = ((Symbol.OperatorSymbol)operator).opcode) == 108 || opc == 112 || opc == 109 || opc == 113)) {
            this.log.warning(Lint.LintCategory.DIVZERO, pos, "div.zero", new Object[0]);
        }
    }

    void checkEmptyIf(JCTree.JCIf tree) {
        if (tree.thenpart.getTag() == 6 && tree.elsepart == null && this.lint.isEnabled(Lint.LintCategory.EMPTY)) {
            this.log.warning(Lint.LintCategory.EMPTY, tree.thenpart.pos(), "empty.if", new Object[0]);
        }
    }

    boolean checkUnique(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        if (sym.type.isErroneous()) {
            return true;
        }
        if (sym.owner.name == this.names.any) {
            return false;
        }
        Scope.Entry e = s.lookup(sym.name);
        while (e.scope == s) {
            if (sym != e.sym && (e.sym.flags() & 0x80000000000L) == 0L && sym.kind == e.sym.kind && sym.name != this.names.error && (sym.kind != 16 || this.types.hasSameArgs(this.types.erasure(sym.type), this.types.erasure(e.sym.type)))) {
                if ((sym.flags() & 0x400000000L) != (e.sym.flags() & 0x400000000L)) {
                    this.varargsDuplicateError(pos, sym, e.sym);
                    return true;
                }
                if (sym.kind == 16 && !this.types.hasSameArgs(sym.type, e.sym.type, false)) {
                    this.duplicateErasureError(pos, sym, e.sym);
                    sym.flags_field |= 0x80000000000L;
                    return true;
                }
                this.duplicateError(pos, e.sym);
                return false;
            }
            e = e.next();
        }
        return true;
    }

    void duplicateErasureError(JCDiagnostic.DiagnosticPosition pos, Symbol sym1, Symbol sym2) {
        if (!sym1.type.isErroneous() && !sym2.type.isErroneous()) {
            this.log.error(pos, "name.clash.same.erasure", sym1, sym2);
        }
    }

    boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        return this.checkUniqueImport(pos, sym, s, false);
    }

    boolean checkUniqueStaticImport(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        return this.checkUniqueImport(pos, sym, s, true);
    }

    private boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s, boolean staticImport) {
        Scope.Entry e = s.lookup(sym.name);
        while (e.scope != null) {
            boolean isClassDecl;
            boolean bl = isClassDecl = e.scope == s;
            if ((isClassDecl || sym != e.sym) && sym.kind == e.sym.kind && sym.name != this.names.error) {
                if (!e.sym.type.isErroneous()) {
                    String what = e.sym.toString();
                    if (!isClassDecl) {
                        if (staticImport) {
                            this.log.error(pos, "already.defined.static.single.import", what);
                        } else {
                            this.log.error(pos, "already.defined.single.import", what);
                        }
                    } else if (sym != e.sym) {
                        this.log.error(pos, "already.defined.this.unit", what);
                    }
                }
                return false;
            }
            e = e.next();
        }
        return true;
    }

    public void checkCanonical(JCTree tree) {
        if (!this.isCanonical(tree)) {
            this.log.error(tree.pos(), "import.requires.canonical", TreeInfo.symbol(tree));
        }
    }

    private boolean isCanonical(JCTree tree) {
        while (tree.getTag() == 34) {
            JCTree.JCFieldAccess s = (JCTree.JCFieldAccess)tree;
            if (s.sym.owner != TreeInfo.symbol(s.selected)) {
                return false;
            }
            tree = s.selected;
        }
        return true;
    }

    public Warner castWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.cast.to.type", found, expected);
    }

    public Warner convertWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.assign", found, expected);
    }

    private class ConversionWarner
    extends Warner {
        final String uncheckedKey;
        final Type found;
        final Type expected;

        public ConversionWarner(JCDiagnostic.DiagnosticPosition pos, String uncheckedKey, Type found, Type expected) {
            super(pos);
            this.uncheckedKey = uncheckedKey;
            this.found = found;
            this.expected = expected;
        }

        public void warn(Lint.LintCategory lint) {
            boolean warned = this.warned;
            super.warn(lint);
            if (warned) {
                return;
            }
            switch (lint) {
                case UNCHECKED: {
                    Check.this.warnUnchecked(this.pos(), "prob.found.req", Check.this.diags.fragment(this.uncheckedKey, new Object[0]), this.found, this.expected);
                    break;
                }
                case VARARGS: {
                    if (Check.this.method == null || Check.this.method.attribute(((Check)Check.this).syms.trustMeType.tsym) == null || !Check.this.isTrustMeAllowedOnMethod(Check.this.method) || Check.this.types.isReifiable(((Check)Check.this).method.type.getParameterTypes().last())) break;
                    Check.this.warnUnsafeVararg(this.pos(), "varargs.unsafe.use.varargs.param", ((Check)Check.this).method.params.last());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected lint: " + (Object)((Object)lint)));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClashFilter
    implements Filter<Symbol> {
        Type site;

        ClashFilter(Type site) {
            this.site = site;
        }

        boolean shouldSkip(Symbol s) {
            return (s.flags() & 0x80000000000L) != 0L && s.owner == this.site.tsym;
        }

        @Override
        public boolean accepts(Symbol s) {
            return s.kind == 16 && (s.flags() & 0x1000L) == 0L && !this.shouldSkip(s) && s.isInheritedIn(this.site.tsym, Check.this.types) && !s.isConstructor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CycleChecker
    extends TreeScanner {
        List<Symbol> seenClasses = List.nil();
        boolean errorFound = false;
        boolean partialCheck = false;

        CycleChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSymbol(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
            block6: {
                if (sym != null && sym.kind == 2) {
                    Env<AttrContext> classEnv = Check.this.enter.getEnv((Symbol.TypeSymbol)sym);
                    if (classEnv != null) {
                        DiagnosticSource prevSource = Check.this.log.currentSource();
                        try {
                            Check.this.log.useSource(classEnv.toplevel.sourcefile);
                            this.scan(classEnv.tree);
                            Object var6_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            Check.this.log.useSource(prevSource.getFile());
                            throw throwable;
                        }
                        Check.this.log.useSource(prevSource.getFile());
                        {
                            break block6;
                        }
                    }
                    if (sym.kind == 2) {
                        this.checkClass(pos, sym, List.<JCTree>nil());
                    }
                } else {
                    this.partialCheck = true;
                }
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            super.visitSelect(tree);
            this.checkSymbol(tree.pos(), tree.sym);
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            this.checkSymbol(tree.pos(), tree.sym);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            this.scan(tree.clazz);
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
            this.scan(tree.elemtype);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            List<JCTree> supertypes = List.nil();
            if (tree.getExtendsClause() != null) {
                supertypes = supertypes.prepend(tree.getExtendsClause());
            }
            if (tree.getImplementsClause() != null) {
                for (JCTree.JCExpression intf : tree.getImplementsClause()) {
                    supertypes = supertypes.prepend(intf);
                }
            }
            this.checkClass(tree.pos(), tree.sym, supertypes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkClass(JCDiagnostic.DiagnosticPosition pos, Symbol c, List<JCTree> supertypes) {
            if ((c.flags_field & 0x40000000L) != 0L) {
                return;
            }
            if (this.seenClasses.contains(c)) {
                this.errorFound = true;
                Check.this.noteCyclic(pos, (Symbol.ClassSymbol)c);
            } else if (!c.type.isErroneous()) {
                block10: {
                    try {
                        this.seenClasses = this.seenClasses.prepend(c);
                        if (c.type.tag != 10) break block10;
                        if (supertypes.nonEmpty()) {
                            this.scan(supertypes);
                        } else {
                            Type.ClassType ct = (Type.ClassType)c.type;
                            if (ct.supertype_field == null || ct.interfaces_field == null) {
                                this.partialCheck = true;
                                Object var8_5 = null;
                                this.seenClasses = this.seenClasses.tail;
                                return;
                            }
                            this.checkSymbol(pos, ct.supertype_field.tsym);
                            for (Type intf : ct.interfaces_field) {
                                this.checkSymbol(pos, intf.tsym);
                            }
                        }
                        if (c.owner.kind != 2) break block10;
                        this.checkSymbol(pos, c.owner);
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        this.seenClasses = this.seenClasses.tail;
                        throw throwable;
                    }
                }
                Object var8_6 = null;
                this.seenClasses = this.seenClasses.tail;
                {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Validator
    extends JCTree.Visitor {
        boolean isOuter;
        Env<AttrContext> env;

        Validator(Env<AttrContext> env) {
            this.env = env;
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
            tree.elemtype.accept(this);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            if (tree.type != null && tree.type.tag == 10) {
                boolean is_java_lang_Class;
                List<JCTree.JCExpression> args = tree.arguments;
                List<Type> forms = tree.type.tsym.type.getTypeArguments();
                Type incompatibleArg = Check.this.firstIncompatibleTypeArg(tree.type);
                if (incompatibleArg != null) {
                    for (JCTree.JCExpression arg : tree.arguments) {
                        if (arg.type == incompatibleArg) {
                            Check.this.log.error(arg, "not.within.bounds", incompatibleArg, forms.head);
                        }
                        forms = forms.tail;
                    }
                }
                forms = tree.type.tsym.type.getTypeArguments();
                boolean bl = is_java_lang_Class = tree.type.tsym.flatName() == ((Check)Check.this).names.java_lang_Class;
                while (args.nonEmpty() && forms.nonEmpty()) {
                    this.validateTree((JCTree)args.head, !this.isOuter || !is_java_lang_Class, false);
                    args = args.tail;
                    forms = forms.tail;
                }
                if (tree.type.getEnclosingType().isRaw()) {
                    Check.this.log.error(tree.pos(), "improperly.formed.type.inner.raw.param", new Object[0]);
                }
                if (tree.clazz.getTag() == 34) {
                    this.visitSelectInternal((JCTree.JCFieldAccess)tree.clazz);
                }
            }
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            this.validateTrees(tree.bounds, true, this.isOuter);
            Check.this.checkClassBounds(tree.pos(), tree.type);
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard tree) {
            if (tree.inner != null) {
                this.validateTree(tree.inner, true, this.isOuter);
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            if (tree.type.tag == 10) {
                this.visitSelectInternal(tree);
                if (tree.selected.type.isParameterized() && tree.type.tsym.type.getTypeArguments().nonEmpty()) {
                    Check.this.log.error(tree.pos(), "improperly.formed.type.param.missing", new Object[0]);
                }
            }
        }

        public void visitSelectInternal(JCTree.JCFieldAccess tree) {
            if (tree.type.tsym.isStatic() && tree.selected.type.isParameterized()) {
                Check.this.log.error(tree.pos(), "cant.select.static.class.from.param.type", new Object[0]);
            } else {
                tree.selected.accept(this);
            }
        }

        @Override
        public void visitTree(JCTree tree) {
        }

        public void validateTree(JCTree tree, boolean checkRaw, boolean isOuter) {
            try {
                if (tree != null) {
                    this.isOuter = isOuter;
                    tree.accept(this);
                    if (checkRaw) {
                        this.checkRaw(tree, this.env);
                    }
                }
            }
            catch (Symbol.CompletionFailure ex) {
                Check.this.completionError(tree.pos(), ex);
            }
        }

        public void validateTrees(List<? extends JCTree> trees, boolean checkRaw, boolean isOuter) {
            List<JCTree> l = trees;
            while (l.nonEmpty()) {
                this.validateTree((JCTree)l.head, checkRaw, isOuter);
                l = l.tail;
            }
        }

        void checkRaw(JCTree tree, Env<AttrContext> env) {
            if (Check.this.lint.isEnabled(Lint.LintCategory.RAW) && tree.type.tag == 10 && !TreeInfo.isDiamond(tree) && !env.enclClass.name.isEmpty() && tree.type.isRaw()) {
                Check.this.log.warning(Lint.LintCategory.RAW, tree.pos(), "raw.class.use", tree.type, tree.type.tsym.type);
            }
        }
    }
}

