/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.javaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.glassfish.javaee.ide.MonitorProgressObject;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.openide.util.RequestProcessor;

public class UpdateContextRoot
implements ProgressListener {
    private MonitorProgressObject returnProgress;
    private Hk2TargetModuleID moduleId;
    private ServerInstance si;
    private boolean needToDo;
    private static final RequestProcessor RP = new RequestProcessor("UpdateContextRoot", 5);

    public UpdateContextRoot(MonitorProgressObject returnProgress, Hk2TargetModuleID moduleId, ServerInstance si, boolean needToDo) {
        this.returnProgress = returnProgress;
        this.moduleId = moduleId;
        this.si = si;
        this.needToDo = needToDo;
    }

    public void handleProgressEvent(ProgressEvent event) {
        if (event.getDeploymentStatus().isCompleted()) {
            if (this.needToDo) {
                this.returnProgress.operationStateChanged(GlassfishModule.OperationState.RUNNING, event.getDeploymentStatus().getMessage());
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        ServerCommand.GetPropertyCommand gpc = new ServerCommand.GetPropertyCommand("applications.application.*.context-root");
                        Future result = ((GlassfishModule)UpdateContextRoot.this.si.getBasicNode().getLookup().lookup(GlassfishModule.class)).execute((ServerCommand)gpc);
                        try {
                            if (result.get(60L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                                Map retVal = gpc.getData();
                                String newCR = (String)retVal.get("applications.application." + UpdateContextRoot.this.moduleId.getModuleID() + ".context-root");
                                if (null != newCR) {
                                    UpdateContextRoot.this.moduleId.setPath(newCR);
                                    UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "updated the moduleid");
                                } else {
                                    UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "no moduleid update necessary");
                                }
                            } else {
                                UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "no moduleid update necessary");
                            }
                        }
                        catch (InterruptedException ex) {
                            UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.FAILED, "failed updating the moduleid..");
                            Logger.getLogger("glassfish-javaee").log(Level.INFO, "", ex);
                        }
                        catch (ExecutionException ex) {
                            UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.FAILED, "failed updating the moduleid...");
                            Logger.getLogger("glassfish-javaee").log(Level.INFO, "", ex);
                        }
                        catch (TimeoutException ex) {
                            UpdateContextRoot.this.returnProgress.operationStateChanged(GlassfishModule.OperationState.FAILED, "failed updating the moduleid....");
                            Logger.getLogger("glassfish-javaee").log(Level.INFO, "", ex);
                        }
                    }
                });
            } else {
                this.returnProgress.operationStateChanged(GlassfishModule.OperationState.COMPLETED, event.getDeploymentStatus().getMessage());
            }
        } else if (event.getDeploymentStatus().isFailed()) {
            this.returnProgress.operationStateChanged(GlassfishModule.OperationState.FAILED, event.getDeploymentStatus().getMessage());
        } else {
            this.returnProgress.operationStateChanged(GlassfishModule.OperationState.RUNNING, event.getDeploymentStatus().getMessage());
        }
    }
}

