/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.tools.ide.data.GlassFishLibrary;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.glassfish.tools.ide.server.config.LibraryBuilder;
import org.glassfish.tools.ide.server.config.LibraryConfig;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;

public class Hk2LibraryProvider {
    private static final String PROVIDER_TYPE = "j2se";
    private static final String JAVAEE_NAME_SUFFIX = " Java EE";
    private static final String JERSEY_NAME_SUFFIX = " Jersey";
    private static final String JAXRS_NAME_SUFFIX = " JAX-RS";
    private static final URL LIBRARY_BUILDER_CONFIG_DEFAULT = Hk2LibraryProvider.class.getResource("GlassFishLibsDefault.xml");
    private static final LibraryConfig.Next LIBRARY_BUILDER_CONFIG_V2 = new LibraryConfig.Next(GlassFishVersion.GF_4, Hk2LibraryProvider.class.getResource("GlassFishLibs2.xml"));
    private static final LibraryConfig libraryConfig = new LibraryConfig(LIBRARY_BUILDER_CONFIG_DEFAULT, new LibraryConfig.Next[]{LIBRARY_BUILDER_CONFIG_V2});
    private Pattern JAVAEE_PATTERN = Pattern.compile("[jJ]ava {0,1}[eE]{2}");
    private Pattern JERSEY_PATTERN = Pattern.compile("[jJ]ersey.*");
    private Pattern JAXRS_PATTERN = Pattern.compile("[jJ][aA][xX][ -]{0,1}[rR][sS]");
    private volatile LibraryBuilder builder;
    private final String serverHome;
    private final String serverName;
    private volatile String javaEEName = null;
    private volatile String jerseyName = null;
    private volatile String jaxRsName = null;

    Hk2LibraryProvider(Hk2DeploymentManager dm) {
        if (dm == null) {
            throw new IllegalArgumentException("GlassFish server deployment manager shall not be null.");
        }
        this.serverHome = (String)dm.getCommonServerSupport().getInstanceProperties().get("homefolder");
        this.serverName = (String)dm.getCommonServerSupport().getInstanceProperties().get("displayName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaEEName() {
        if (this.javaEEName != null) {
            return this.javaEEName;
        }
        Hk2LibraryProvider hk2LibraryProvider = this;
        synchronized (hk2LibraryProvider) {
            StringBuilder sb = new StringBuilder(this.serverName.length() + JAVAEE_NAME_SUFFIX.length());
            sb.append(this.serverName);
            sb.append(JAVAEE_NAME_SUFFIX);
            this.javaEEName = sb.toString();
        }
        return this.javaEEName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJerseyName() {
        if (this.jerseyName != null) {
            return this.jerseyName;
        }
        Hk2LibraryProvider hk2LibraryProvider = this;
        synchronized (hk2LibraryProvider) {
            StringBuilder sb = new StringBuilder(this.serverName.length() + JERSEY_NAME_SUFFIX.length());
            sb.append(this.serverName);
            sb.append(JERSEY_NAME_SUFFIX);
            this.jerseyName = sb.toString();
        }
        return this.jerseyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJaxRsName() {
        if (this.jaxRsName != null) {
            return this.jaxRsName;
        }
        Hk2LibraryProvider hk2LibraryProvider = this;
        synchronized (hk2LibraryProvider) {
            StringBuilder sb = new StringBuilder(this.serverName.length() + JAXRS_NAME_SUFFIX.length());
            sb.append(this.serverName);
            sb.append(JAXRS_NAME_SUFFIX);
            this.jaxRsName = sb.toString();
        }
        return this.jaxRsName;
    }

    public Library getJerseyLibrary() {
        return this.getLibrary(this.JERSEY_PATTERN, this.getJerseyName());
    }

    public Library getJaxRsLibrary() {
        return this.getLibrary(this.JAXRS_PATTERN, this.getJaxRsName());
    }

    public Library getJavaEELibrary() {
        return this.getLibrary(this.JAVAEE_PATTERN, this.getJavaEEName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LibraryBuilder getBuilder() {
        if (this.builder != null) {
            return this.builder;
        }
        Hk2LibraryProvider hk2LibraryProvider = this;
        synchronized (hk2LibraryProvider) {
            if (this.builder == null) {
                this.builder = new LibraryBuilder(libraryConfig, this.serverHome, this.serverHome, this.serverHome);
            }
        }
        return this.builder;
    }

    private Library getLibrary(Pattern namePattern, String libraryName) {
        Library lib = LibraryManager.getDefault().getLibrary(libraryName);
        if (lib != null) {
            return lib;
        }
        LibraryBuilder lb = this.getBuilder();
        List gfLibs = lb.getLibraries(GlassFishVersion.GF_3);
        for (GlassFishLibrary gfLib : gfLibs) {
            if (!namePattern.matcher(gfLib.getLibraryID()).matches()) continue;
            HashMap<String, List> contents = new HashMap<String, List>(1);
            HashMap<String, String> properties = new HashMap<String, String>(2);
            contents.put("classpath", gfLib.getClasspath());
            contents.put("javadoc", gfLib.getJavadocs());
            properties.put("maven-dependencies", gfLib.getMavenDeps());
            properties.put("maven-repositories", "default");
            try {
                return LibraryManager.getDefault().createLibrary(PROVIDER_TYPE, libraryName, null, null, contents, properties);
            }
            catch (IOException ioe) {
                Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Could not create Jersey library for " + this.serverName + ": ", ioe);
            }
        }
        return null;
    }
}

