/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spellchecker.CompoundDictionary;
import org.netbeans.modules.spellchecker.DefaultLocaleQueryImplementation;
import org.netbeans.modules.spellchecker.DictionaryImpl;
import org.netbeans.modules.spellchecker.LookupAccessor;
import org.netbeans.modules.spellchecker.SpellcheckerHighlightLayerFactory;
import org.netbeans.modules.spellchecker.api.LocaleQuery;
import org.netbeans.modules.spellchecker.hints.AddToDictionaryHint;
import org.netbeans.modules.spellchecker.hints.DictionaryBasedHint;
import org.netbeans.modules.spellchecker.spi.dictionary.Dictionary;
import org.netbeans.modules.spellchecker.spi.dictionary.DictionaryProvider;
import org.netbeans.modules.spellchecker.spi.dictionary.ValidityType;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.netbeans.modules.spellchecker.spi.language.TokenListProvider;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class ComponentPeer
implements PropertyChangeListener,
DocumentListener,
ChangeListener,
CaretListener,
AncestorListener {
    private static final Logger LOG = Logger.getLogger(ComponentPeer.class.getName());
    private JTextComponent pane;
    private Document document;
    private static final RequestProcessor WORKER = new RequestProcessor("Spellchecker", 1, false, false);
    private final RequestProcessor.Task checker = WORKER.create(new Runnable(){

        @Override
        public void run() {
            try {
                ComponentPeer.this.process();
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    });
    private final RequestProcessor.Task updateVisibleSpans = WORKER.create(new Runnable(){

        @Override
        public void run() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ComponentPeer.this.updateCurrentVisibleSpan();
                        ComponentPeer.this.reschedule();
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    });
    private final RequestProcessor.Task computeHint = WORKER.create(new Runnable(){

        @Override
        public void run() {
            ComponentPeer.this.computeHint();
        }
    });
    private Component parentWithListener;
    private int[] currentVisibleRange;
    private final Object tokenListLock = new Object();
    private TokenList tokenList;
    private static Set<Document> knownDocuments = new WeakSet();
    private static Map<Locale, DictionaryImpl> locale2UsersLocalDictionary = new HashMap<Locale, DictionaryImpl>();
    private static Map<Project, Reference<DictionaryImpl>> project2Reference = new WeakHashMap<Project, Reference<DictionaryImpl>>();
    private final AtomicBoolean cancel = new AtomicBoolean();
    private static final AttributeSet ERROR = AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, Color.RED, EditorStyleConstants.Tooltip, NbBundle.getMessage(ComponentPeer.class, (String)"TP_MisspelledWord")});
    private int lastCaretPosition = -1;
    public static LookupAccessor ACCESSOR = new LookupAccessor(){

        @Override
        public Dictionary lookupDictionary(Locale locale) {
            for (DictionaryProvider p : Lookup.getDefault().lookupAll(DictionaryProvider.class)) {
                Dictionary d = p.getDictionary(locale);
                if (d == null) continue;
                return d;
            }
            return null;
        }

        @Override
        public TokenList lookupTokenList(Document doc) {
            Object mimeTypeObj = doc.getProperty("mimeType");
            String mimeType = "text/plain";
            if (mimeTypeObj instanceof String) {
                mimeType = (String)mimeTypeObj;
            }
            for (TokenListProvider p : MimeLookup.getLookup((MimePath)MimePath.get((String)mimeType)).lookupAll(TokenListProvider.class)) {
                TokenList l = p.findTokenList(doc);
                if (l == null) continue;
                return l;
            }
            return null;
        }
    };

    public static void assureInstalled(JTextComponent pane) {
        if (pane.getClientProperty(ComponentPeer.class) == null) {
            pane.putClientProperty(ComponentPeer.class, new ComponentPeer(pane));
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (this.document != this.pane.getDocument()) {
            if (this.document != null) {
                this.document.removeDocumentListener(this);
            }
            this.document = this.pane.getDocument();
            this.document.addDocumentListener(this);
            this.document = this.pane.getDocument();
            this.doUpdateCurrentVisibleSpan();
        }
    }

    public void reschedule() {
        this.cancel();
        this.checker.schedule(100);
    }

    private synchronized Document getDocument() {
        return this.document;
    }

    private ComponentPeer(JTextComponent pane) {
        this.pane = pane;
        pane.addPropertyChangeListener(this);
        pane.addCaretListener(this);
        pane.addAncestorListener(this);
        this.document = pane.getDocument();
        this.document.addDocumentListener(this);
        this.ancestorAdded(null);
    }

    private int[] computeVisibleSpan() {
        Container parent = this.pane.getParent();
        if (parent instanceof JViewport) {
            JViewport vp = (JViewport)parent;
            Point start = vp.getViewPosition();
            Dimension size = vp.getExtentSize();
            Point end = new Point((int)(start.getX() + size.getWidth()), (int)(start.getY() + size.getHeight()));
            int startPosition = this.pane.viewToModel(start);
            int endPosition = this.pane.viewToModel(end);
            if (this.parentWithListener != vp) {
                vp.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)vp));
                this.parentWithListener = vp;
            }
            return new int[]{startPosition, endPosition};
        }
        return new int[]{0, this.pane.getDocument().getLength()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentVisibleSpan() {
        int[] newSpan = this.computeVisibleSpan();
        ComponentPeer componentPeer = this;
        synchronized (componentPeer) {
            if (this.currentVisibleRange == null || this.currentVisibleRange[0] != newSpan[0] || this.currentVisibleRange[1] != newSpan[1]) {
                this.currentVisibleRange = newSpan;
                this.reschedule();
            }
        }
    }

    private synchronized int[] getCurrentVisibleSpan() {
        return this.currentVisibleRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenList getTokenList() {
        Object object = this.tokenListLock;
        synchronized (object) {
            if (this.tokenList == null) {
                this.tokenList = ACCESSOR.lookupTokenList(this.getDocument());
                if (this.tokenList != null) {
                    this.tokenList.addChangeListener((ChangeListener)this);
                }
            }
            return this.tokenList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void process() throws BadLocationException {
        boolean[] cont;
        int[] span;
        Dictionary d;
        TokenList _tokenList;
        long startTime;
        LinkedList localHighlights;
        Document _document;
        block31: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            _document = this.getDocument();
                            if (_document.getLength() == 0) {
                                return;
                            }
                            localHighlights = new LinkedList();
                            startTime = System.currentTimeMillis();
                            this.resume();
                            _tokenList = this.getTokenList();
                            if (_tokenList != null) break block27;
                            if (this.isCanceled()) return;
                            if (!(this.pane instanceof JEditorPane)) {
                                SwingUtilities.invokeLater(new Runnable(_document, localHighlights){
                                    final /* synthetic */ Document val$_document;
                                    final /* synthetic */ List val$localHighlights;
                                    {
                                        this.val$_document = document;
                                        this.val$localHighlights = list;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$_document.render(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (ComponentPeer.this.isCanceled()) {
                                                    return;
                                                }
                                                try {
                                                    Highlighter h = ComponentPeer.this.pane.getHighlighter();
                                                    if (h != null) {
                                                        List oldTags = (List)ComponentPeer.this.pane.getClientProperty(ErrorHighlightPainter.class);
                                                        if (oldTags != null) {
                                                            for (Object tag : oldTags) {
                                                                h.removeHighlight(tag);
                                                            }
                                                        }
                                                        LinkedList<Object> newTags = new LinkedList<Object>();
                                                        for (int[] current : val$localHighlights) {
                                                            newTags.add(h.addHighlight(current[0], current[1], new ErrorHighlightPainter()));
                                                        }
                                                        ComponentPeer.this.pane.putClientProperty(ErrorHighlightPainter.class, newTags);
                                                    }
                                                }
                                                catch (BadLocationException e) {
                                                    Exceptions.printStackTrace((Throwable)e);
                                                }
                                            }
                                        });
                                    }
                                });
                            } else {
                                OffsetsBag paneBag = SpellcheckerHighlightLayerFactory.getBag(this.pane);
                                _document.render(new Runnable(_document, localHighlights, paneBag){
                                    final /* synthetic */ Document val$_document;
                                    final /* synthetic */ List val$localHighlights;
                                    final /* synthetic */ OffsetsBag val$paneBag;
                                    {
                                        this.val$_document = document;
                                        this.val$localHighlights = list;
                                        this.val$paneBag = offsetsBag;
                                    }

                                    @Override
                                    public void run() {
                                        if (ComponentPeer.this.isCanceled()) {
                                            return;
                                        }
                                        OffsetsBag localHighlightsBag = new OffsetsBag(this.val$_document);
                                        for (int[] current : this.val$localHighlights) {
                                            localHighlightsBag.addHighlight(current[0], current[1], ERROR);
                                        }
                                        this.val$paneBag.setHighlights(localHighlightsBag);
                                    }
                                });
                            }
                            FileObject file = NbEditorUtilities.getFileObject((Document)_document);
                            if (file == null) return;
                            Logger.getLogger("TIMER").log(Level.FINE, "Spellchecker", new Object[]{file, System.currentTimeMillis() - startTime});
                            return;
                        }
                        d = ComponentPeer.getDictionary(_document);
                        if (d != null) break block28;
                        if (this.isCanceled()) return;
                        if (!(this.pane instanceof JEditorPane)) {
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        } else {
                            OffsetsBag paneBag = SpellcheckerHighlightLayerFactory.getBag(this.pane);
                            _document.render(new /* invalid duplicate definition of identical inner class */);
                        }
                        FileObject file = NbEditorUtilities.getFileObject((Document)_document);
                        if (file == null) return;
                        Logger.getLogger("TIMER").log(Level.FINE, "Spellchecker", new Object[]{file, System.currentTimeMillis() - startTime});
                        return;
                    }
                    span = this.getCurrentVisibleSpan();
                    if (span != null) break block29;
                    this.doUpdateCurrentVisibleSpan();
                    if (this.isCanceled()) return;
                    if (!(this.pane instanceof JEditorPane)) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        OffsetsBag paneBag = SpellcheckerHighlightLayerFactory.getBag(this.pane);
                        _document.render(new /* invalid duplicate definition of identical inner class */);
                    }
                    FileObject file = NbEditorUtilities.getFileObject((Document)_document);
                    if (file == null) return;
                    Logger.getLogger("TIMER").log(Level.FINE, "Spellchecker", new Object[]{file, System.currentTimeMillis() - startTime});
                    return;
                }
                if (span[0] != -1) break block30;
                if (this.isCanceled()) return;
                if (!(this.pane instanceof JEditorPane)) {
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                } else {
                    OffsetsBag paneBag = SpellcheckerHighlightLayerFactory.getBag(this.pane);
                    _document.render(new /* invalid duplicate definition of identical inner class */);
                }
                FileObject file = NbEditorUtilities.getFileObject((Document)_document);
                if (file == null) return;
                Logger.getLogger("TIMER").log(Level.FINE, "Spellchecker", new Object[]{file, System.currentTimeMillis() - startTime});
                return;
            }
            cont = new boolean[1];
            _document.render(new Runnable(){

                @Override
                public void run() {
                    if (ComponentPeer.this.isCanceled()) {
                        cont[0] = false;
                        return;
                    }
                    _tokenList.setStartOffset(span[0]);
                    cont[0] = true;
                }
            });
            if (cont[0]) break block31;
            if (this.isCanceled()) return;
            if (!(this.pane instanceof JEditorPane)) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            } else {
                OffsetsBag paneBag = SpellcheckerHighlightLayerFactory.getBag(this.pane);
                _document.render(new /* invalid duplicate definition of identical inner class */);
            }
            FileObject file = NbEditorUtilities.getFileObject((Document)_document);
            if (file == null) return;
            Logger.getLogger("TIMER").log(Level.FINE, "Spellchecker", new Object[]{file, System.currentTimeMillis() - startTime});
            return;
        }
        try {
            final CharSequence[] word = new CharSequence[1];
            while (!this.isCanceled()) {
                _document.render(new Runnable(){

                    @Override
                    public void run() {
                        if (ComponentPeer.this.isCanceled()) {
                            cont[0] = false;
                            return;
                        }
                        cont[0] = _tokenList.nextWord();
                        if (cont[0]) {
                            if (_tokenList.getCurrentWordStartOffset() > span[1]) {
                                cont[0] = false;
                                return;
                            }
                            word[0] = _tokenList.getCurrentWordText();
                        }
                    }
                });
                if (!cont[0]) break;
                LOG.log(Level.FINER, "going to test word: {0}", word[0]);
                if (word[0].length() < 2) {
                    LOG.log(Level.FINER, "too short");
                    continue;
                }
                ValidityType validity = d.validateWord(word[0]);
                LOG.log(Level.FINER, "validity: {0}", validity);
                switch (validity) {
                    case PREFIX_OF_VALID: 
                    case BLACKLISTED: 
                    case INVALID: {
                        _document.render(new Runnable(){

                            @Override
                            public void run() {
                                if (!ComponentPeer.this.isCanceled()) {
                                    localHighlights.add(new int[]{_tokenList.getCurrentWordStartOffset(), _tokenList.getCurrentWordStartOffset() + word[0].length()});
                                }
                            }
                        });
                    }
                }
            }
            if (this.isCanceled()) return;
        }
        catch (Throwable throwable) {
            if (this.isCanceled()) throw throwable;
            if (!(this.pane instanceof JEditorPane)) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            } else {
                OffsetsBag paneBag = SpellcheckerHighlightLayerFactory.getBag(this.pane);
                _document.render(new /* invalid duplicate definition of identical inner class */);
            }
            FileObject file = NbEditorUtilities.getFileObject((Document)_document);
            if (file == null) throw throwable;
            Logger.getLogger("TIMER").log(Level.FINE, "Spellchecker", new Object[]{file, System.currentTimeMillis() - startTime});
            throw throwable;
        }
        if (!(this.pane instanceof JEditorPane)) {
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        } else {
            OffsetsBag paneBag = SpellcheckerHighlightLayerFactory.getBag(this.pane);
            _document.render(new /* invalid duplicate definition of identical inner class */);
        }
        FileObject file = NbEditorUtilities.getFileObject((Document)_document);
        if (file == null) return;
        Logger.getLogger("TIMER").log(Level.FINE, "Spellchecker", new Object[]{file, System.currentTimeMillis() - startTime});
    }

    public static synchronized DictionaryImpl getUsersLocalDictionary(Locale locale) {
        DictionaryImpl d = locale2UsersLocalDictionary.get(locale);
        if (d != null) {
            return d;
        }
        String userdir = System.getProperty("netbeans.user");
        File cache = new File(userdir, "private-dictionary-" + locale.toString());
        d = new DictionaryImpl(cache, locale);
        locale2UsersLocalDictionary.put(locale, d);
        return d;
    }

    public static synchronized DictionaryImpl getProjectDictionary(Project p, Locale locale) {
        DictionaryImpl d;
        Reference<DictionaryImpl> r = project2Reference.get(p);
        DictionaryImpl dictionaryImpl = d = r != null ? r.get() : null;
        if (d == null) {
            AuxiliaryConfiguration ac = ProjectUtils.getAuxiliaryConfiguration((Project)p);
            d = new DictionaryImpl(p, ac, locale);
            project2Reference.put(p, new WeakReference<DictionaryImpl>(d));
        }
        return d;
    }

    public static synchronized Dictionary getDictionary(Document doc) {
        DictionaryImpl projectDictionary;
        Project p;
        Dictionary d;
        Dictionary result = (Dictionary)doc.getProperty(CompoundDictionary.class);
        if (result != null) {
            return result;
        }
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        Locale locale = file != null ? LocaleQuery.findLocale((FileObject)file) : DefaultLocaleQueryImplementation.getDefaultLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((d = ACCESSOR.lookupDictionary(locale)) == null) {
            return null;
        }
        LinkedList<Dictionary> dictionaries = new LinkedList<Dictionary>();
        dictionaries.add(ComponentPeer.getUsersLocalDictionary(locale));
        if (file != null && (p = FileOwnerQuery.getOwner((FileObject)file)) != null && (projectDictionary = ComponentPeer.getProjectDictionary(p, locale)) != null) {
            dictionaries.add(projectDictionary);
        }
        dictionaries.add(d);
        result = CompoundDictionary.create(dictionaries.toArray(new Dictionary[0]));
        doc.putProperty(CompoundDictionary.class, result);
        knownDocuments.add(doc);
        return result;
    }

    static synchronized void clearDoc2DictionaryCache() {
        for (Document d : knownDocuments) {
            d.putProperty(CompoundDictionary.class, null);
        }
        knownDocuments.clear();
    }

    private boolean isCanceled() {
        return this.cancel.get();
    }

    private void cancel() {
        this.cancel.set(true);
    }

    private void resume() {
        this.cancel.set(false);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void documentUpdate() {
        this.doUpdateCurrentVisibleSpan();
        this.cancel();
    }

    private void doUpdateCurrentVisibleSpan() {
        this.updateVisibleSpans.schedule(250);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tokenList) {
            this.reschedule();
        } else {
            this.doUpdateCurrentVisibleSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent e) {
        ComponentPeer componentPeer = this;
        synchronized (componentPeer) {
            this.lastCaretPosition = e.getDot();
        }
        LOG.fine("scheduling hints computation");
        this.computeHint.schedule(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeHint() {
        ValidityType validity;
        LOG.entering(ComponentPeer.class.getName(), "computeHint");
        final TokenList l = this.getTokenList();
        if (l == null) {
            LOG.fine("token list == null");
            LOG.exiting(ComponentPeer.class.getName(), "computeHint");
            return;
        }
        Dictionary d = ComponentPeer.getDictionary(this.document);
        if (d == null) {
            LOG.fine("dictionary == null");
            LOG.exiting(ComponentPeer.class.getName(), "computeHint");
            return;
        }
        final int[] lastCaretPositionCopy = new int[1];
        final Position[] span = new Position[2];
        final CharSequence[] word = new CharSequence[1];
        ComponentPeer componentPeer = this;
        synchronized (componentPeer) {
            lastCaretPositionCopy[0] = this.lastCaretPosition;
        }
        this.document.render(new Runnable(){

            @Override
            public void run() {
                LOG.log(Level.FINE, "lastCaretPosition={0}", lastCaretPositionCopy[0]);
                l.setStartOffset(lastCaretPositionCopy[0]);
                if (!l.nextWord()) {
                    LOG.log(Level.FINE, "l.nextWord() == false");
                    return;
                }
                int currentWSO = l.getCurrentWordStartOffset();
                CharSequence w = l.getCurrentWordText();
                int length = w.length();
                LOG.log(Level.FINE, "currentWSO={0}, w={1}, length={2}", new Object[]{currentWSO, w, length});
                if (currentWSO <= lastCaretPositionCopy[0] && currentWSO + length >= lastCaretPositionCopy[0]) {
                    try {
                        span[0] = ComponentPeer.this.document.createPosition(currentWSO);
                        span[1] = ComponentPeer.this.document.createPosition(currentWSO + length);
                        word[0] = w;
                    }
                    catch (BadLocationException e) {
                        LOG.log(Level.INFO, null, e);
                    }
                }
            }
        });
        if (span[0] != null && span[1] != null && (validity = d.validateWord(word[0])) == ValidityType.VALID) {
            span[1] = null;
            span[0] = null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        LOG.log(Level.FINE, "word={0}", word[0]);
        if (span[0] != null && span[1] != null) {
            String currentWord = ((Object)word[0]).toString();
            for (String proposal : d.findProposals((CharSequence)currentWord)) {
                result.add(new DictionaryBasedHint(currentWord, proposal, this.document, span, "0" + currentWord));
            }
            FileObject file = NbEditorUtilities.getFileObject((Document)this.document);
            if (file != null) {
                DictionaryImpl projectDictionary;
                Project p = FileOwnerQuery.getOwner((FileObject)file);
                Locale locale = LocaleQuery.findLocale((FileObject)file);
                if (p != null && (projectDictionary = ComponentPeer.getProjectDictionary(p, locale)) != null) {
                    String displayName = NbBundle.getMessage(ComponentPeer.class, (String)"FIX_ToProjectDictionary");
                    result.add(new AddToDictionaryHint(this, projectDictionary, currentWord, displayName, "1" + currentWord));
                }
                String displayName = NbBundle.getMessage(ComponentPeer.class, (String)"FIX_ToPrivateDictionary");
                result.add(new AddToDictionaryHint(this, ComponentPeer.getUsersLocalDictionary(locale), currentWord, displayName, "2" + currentWord));
            }
            if (!result.isEmpty()) {
                String displayName = NbBundle.getMessage(ComponentPeer.class, (String)"ERR_MisspelledWord");
                HintsController.setErrors((Document)this.document, (String)ComponentPeer.class.getName(), Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)displayName, result, (Document)this.document, (Position)span[0], (Position)span[1])));
            } else {
                HintsController.setErrors((Document)this.document, (String)ComponentPeer.class.getName(), Collections.emptyList());
            }
        } else {
            HintsController.setErrors((Document)this.document, (String)ComponentPeer.class.getName(), Collections.emptyList());
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (this.pane.getParent() != null) {
            this.doUpdateCurrentVisibleSpan();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    private class ErrorHighlightPainter
    implements Highlighter.HighlightPainter {
        private ErrorHighlightPainter() {
        }

        @Override
        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            g.setColor(Color.RED);
            try {
                Rectangle start = ComponentPeer.this.pane.modelToView(p0);
                Rectangle end = ComponentPeer.this.pane.modelToView(p1);
                if (start.x < 0) {
                    LOG.log(Level.INFO, "#182545: negative view position: {0} for: {1}", new Object[]{start, p0});
                    return;
                }
                int waveLength = end.x + end.width - start.x;
                if (waveLength > 0) {
                    int[] wf = new int[]{0, 0, -1, -1};
                    int[] xArray = new int[waveLength + 1];
                    int[] yArray = new int[waveLength + 1];
                    int yBase = start.y + start.height - 2;
                    for (int i = 0; i <= waveLength; ++i) {
                        xArray[i] = start.x + i;
                        yArray[i] = yBase + wf[xArray[i] % 4];
                    }
                    g.drawPolyline(xArray, yArray, waveLength);
                }
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }
}

