/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.api;

import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.actions.Viewable;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.html.HtmlDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class HtmlDataNode
extends DataNode {
    private static final String PROP_FILE_ENCODING = "encoding";
    private static final String SHEETNAME_TEXT_PROPERTIES = "textProperties";
    private Sheet sheet = null;
    private Node.PropertySet[] customPropertySet;
    private static final String VIEWABLE_CLASS_NAME = Viewable.class.getName();

    public HtmlDataNode(DataObject dobj, Children ch) {
        super(dobj, ch);
        this.setShortDescription(NbBundle.getMessage(HtmlDataObject.class, (String)"LBL_htmlNodeShortDesc"));
    }

    private boolean isHtmlProject() {
        Project current = FileOwnerQuery.getOwner((FileObject)this.getDataObject().getPrimaryFile());
        return current != null && current.getClass().getName().equals("org.netbeans.modules.web.clientproject.ClientSideProject");
    }

    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        if (this.isHtmlProject()) {
            ArrayList<Action> filtered = new ArrayList<Action>();
            for (int i = 0; i < actions.length; ++i) {
                String type;
                Object value;
                Action a = actions[i];
                if (a != null && (value = a.getValue("type")) != null && value instanceof String && VIEWABLE_CLASS_NAME.equals(type = (String)value)) continue;
                filtered.add(a);
            }
            return filtered.toArray(new Action[0]);
        }
        return actions;
    }

    public Node.PropertySet[] getPropertySets() {
        if (this.customPropertySet != null) {
            return this.customPropertySet;
        }
        if (this.sheet == null) {
            Sheet.Set set;
            this.sheet = new Sheet();
            Node.PropertySet[] tmp = super.getPropertySets();
            for (int i = 0; i < tmp.length; ++i) {
                set = new Sheet.Set();
                set.setName(tmp[i].getName());
                set.setShortDescription(tmp[i].getShortDescription());
                set.setDisplayName(tmp[i].getDisplayName());
                set.setValue("helpID", (Object)(HtmlDataNode.class.getName() + ".PropertySheet"));
                set.put(tmp[i].getProperties());
                this.sheet.put(set);
            }
            set = new Sheet.Set();
            set.setName(SHEETNAME_TEXT_PROPERTIES);
            set.setDisplayName(NbBundle.getMessage(HtmlDataObject.class, (String)"PROP_textfileSetName"));
            set.setShortDescription(NbBundle.getMessage(HtmlDataObject.class, (String)"HINT_textfileSetName"));
            set.put((Node.Property)new PropertySupport.ReadOnly(PROP_FILE_ENCODING, String.class, NbBundle.getMessage(HtmlDataObject.class, (String)"PROP_fileEncoding"), NbBundle.getMessage(HtmlDataObject.class, (String)"HINT_fileEncoding")){

                public Object getValue() {
                    return FileEncodingQuery.getEncoding((FileObject)HtmlDataNode.this.getDataObject().getPrimaryFile()).name();
                }
            });
            this.sheet.put(set);
        }
        return this.sheet.toArray();
    }

    public void setPropertySets(Node.PropertySet[] sets) {
        Parameters.notNull((CharSequence)"sets", (Object)sets);
        Node.PropertySet[] old = this.customPropertySet != null ? this.customPropertySet : this.getPropertySets();
        Node.PropertySet[] neww = sets != null ? sets : this.getPropertySets();
        this.customPropertySet = sets;
        this.firePropertySetsChange(old, neww);
    }
}

