/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsComponentFactory;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandler;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerChain;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerChains;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerClass;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerName;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModel;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModelFactory;
import org.netbeans.modules.websvc.api.jaxws.bindings.DefinitionsBindings;
import org.netbeans.modules.websvc.api.jaxws.bindings.GlobalBindings;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClientHandlerButtonListener
implements ActionListener {
    private MessageHandlerPanel panel;
    private BindingsModel bindingsModel;
    private JaxWsService client;
    private Node node;
    private String bindingsHandlerFile;

    public ClientHandlerButtonListener(MessageHandlerPanel panel, BindingsModel bindingsModel, JaxWsService client, Node node) {
        this.panel = panel;
        this.bindingsModel = bindingsModel;
        this.client = client;
        this.node = node;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ClientHandlerButtonListener.this.configureHandler();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureHandler() {
        if (!this.panel.isChanged()) {
            return;
        }
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ClientHandlerButtonListener.class, (String)"MSG_ConfigureHandler"));
        handle.start();
        handle.switchToIndeterminate();
        JAXWSLightSupport support = (JAXWSLightSupport)this.node.getLookup().lookup(JAXWSLightSupport.class);
        FileObject bindingsFolder = support.getBindingsFolder(true);
        assert (this.client != null);
        try {
            Project project;
            this.bindingsHandlerFile = this.client.getHandlerBindingFile();
            if (this.bindingsHandlerFile == null) {
                String baseBindingsHandlerFile = this.node.getName() + "_handler";
                this.bindingsHandlerFile = FileUtil.findFreeFileName((FileObject)bindingsFolder, (String)baseBindingsHandlerFile, (String)"xml") + ".xml";
                this.client.setHandlerBindingFile(this.bindingsHandlerFile);
            }
            final FileObject bindingHandlerFO = FileUtil.createData((FileObject)bindingsFolder, (String)this.bindingsHandlerFile);
            if (this.bindingsModel == null) {
                InputStream is = FileUtil.getConfigFile((String)"jax-ws/default-binding-handler.xml").getInputStream();
                final String bindingsContent = ClientHandlerButtonListener.readResource(is);
                is.close();
                bindingsFolder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        BufferedWriter bw = null;
                        OutputStream os = null;
                        OutputStreamWriter osw = null;
                        FileLock lock = bindingHandlerFO.lock();
                        try {
                            os = bindingHandlerFO.getOutputStream(lock);
                            osw = new OutputStreamWriter(os, Charset.forName("UTF-8"));
                            bw = new BufferedWriter(osw);
                            bw.write(bindingsContent);
                        }
                        finally {
                            try {
                                if (bw != null) {
                                    bw.close();
                                }
                                if (os != null) {
                                    os.close();
                                }
                                if (osw != null) {
                                    osw.close();
                                }
                            }
                            catch (IOException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                            if (lock != null) {
                                lock.releaseLock();
                            }
                        }
                    }
                });
                ModelSource ms = org.netbeans.modules.xml.retriever.catalog.Utilities.getModelSource((FileObject)bindingHandlerFO, (boolean)true);
                this.bindingsModel = BindingsModelFactory.getDefault().getModel(ms);
                FileObject localWsdlFile = support.getWsdlFolder(false).getFileObject(this.client.getLocalWsdl());
                File f = FileUtil.toFile((FileObject)bindingHandlerFO);
                String relativePath = org.netbeans.modules.xml.retriever.catalog.Utilities.relativize((URI)f.toURI(), (URI)new URI(localWsdlFile.getURL().toExternalForm()));
                GlobalBindings gb = this.bindingsModel.getGlobalBindings();
                try {
                    this.bindingsModel.startTransaction();
                    gb.setWsdlLocation(relativePath);
                }
                finally {
                    try {
                        this.bindingsModel.endTransaction();
                    }
                    catch (IllegalStateException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                        return;
                    }
                }
                DataObject dobj = DataObject.find((FileObject)bindingHandlerFO);
                if (dobj.isModified()) {
                    SaveCookie saveCookie = (SaveCookie)dobj.getCookie(SaveCookie.class);
                    saveCookie.save();
                }
            }
            TableModel tableModel = this.panel.getHandlerTableModel();
            GlobalBindings gb = this.bindingsModel.getGlobalBindings();
            DefinitionsBindings db = gb.getDefinitionsBindings();
            BindingsHandlerChains bhc = db.getHandlerChains();
            BindingsHandlerChain chain = (BindingsHandlerChain)bhc.getHandlerChains().iterator().next();
            try {
                this.bindingsModel.startTransaction();
                Collection handlers = chain.getHandlers();
                for (BindingsHandler handler : handlers) {
                    chain.removeHandler(handler);
                }
                if (tableModel.getRowCount() > 0) {
                    BindingsComponentFactory factory = this.bindingsModel.getFactory();
                    for (int i = 0; i < tableModel.getRowCount(); ++i) {
                        String className = (String)tableModel.getValueAt(i, 0);
                        BindingsHandler handler = factory.createHandler();
                        String handlerName = className.substring(className.indexOf(".") + 1);
                        BindingsHandlerName name = factory.createHandlerName();
                        name.setHandlerName(handlerName);
                        handler.setHandlerName(name);
                        BindingsHandlerClass handlerClass = factory.createHandlerClass();
                        handlerClass.setClassName(className);
                        handler.setHandlerClass(handlerClass);
                        chain.addHandler(handler);
                    }
                }
            }
            finally {
                try {
                    this.bindingsModel.endTransaction();
                }
                catch (IllegalStateException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            DataObject dobj = DataObject.find((FileObject)bindingHandlerFO);
            if (dobj.isModified()) {
                SaveCookie saveCookie = (SaveCookie)dobj.getCookie(SaveCookie.class);
                saveCookie.save();
            }
            if ((project = FileOwnerQuery.getOwner((FileObject)bindingHandlerFO)) != null) {
                JaxWsClientNode clientNode = (JaxWsClientNode)((Object)this.node.getLookup().lookup(JaxWsClientNode.class));
                final FileObject wsdlFo = clientNode.getLocalWsdl();
                ModelOperation<POMModel> oper = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel model) {
                        MavenModelUtils.addBindingFile(model, wsdlFo.getName(), ClientHandlerButtonListener.this.bindingsHandlerFile);
                    }
                };
                FileObject pom = project.getProjectDirectory().getFileObject("pom.xml");
                Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(oper));
                RunConfig cfg = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (Project)project, (String)"wsimport", Collections.singletonList("jaxws:wsimport"));
                RunUtils.executeMaven((RunConfig)cfg);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        handle.finish();
    }

    private void removeHandlerAnnotation() {
        JaxWsClientNode clientNode = (JaxWsClientNode)((Object)this.node.getLookup().lookup(JaxWsClientNode.class));
        WsdlModel wsdlModel = clientNode.getWsdlModel();
        WsdlService service = (WsdlService)wsdlModel.getServices().get(0);
        String serviceName = service.getJavaName();
        Project project = FileOwnerQuery.getOwner((FileObject)clientNode.getLocalWsdl());
        SourceGroup[] groups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        ClassPath cp = ClassPath.getClassPath((FileObject)groups[0].getRootFolder(), (String)"classpath/source");
        FileObject serviceFO = cp.findResource(serviceName.replaceAll("\\.", "/") + ".java");
        if (serviceFO == null) {
            return;
        }
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)serviceFO);
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker make = workingCopy.getTreeMaker();
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                ClassTree javaClass = workingCopy.getTrees().getTree(typeElement);
                AnnotationTree handlerAnnotation = null;
                List<? extends AnnotationTree> annots = javaClass.getModifiers().getAnnotations();
                for (AnnotationTree annotationTree : annots) {
                    IdentifierTree ident = (IdentifierTree)annotationTree.getAnnotationType();
                    TreePath anTreePath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), ident);
                    TypeElement anElement = (TypeElement)workingCopy.getTrees().getElement(anTreePath);
                    if (anElement == null || !anElement.getQualifiedName().contentEquals("javax.jws.HandlerChain")) continue;
                    handlerAnnotation = annotationTree;
                    break;
                }
                ModifiersTree modifiers = javaClass.getModifiers();
                ModifiersTree modifiersTree = make.removeModifiersAnnotation(modifiers, handlerAnnotation);
                workingCopy.rewrite((Tree)modifiers, (Tree)modifiersTree);
                CompilationUnitTree compileUnitTree = workingCopy.getCompilationUnit();
                List<? extends ImportTree> imports = compileUnitTree.getImports();
                for (ImportTree importTree : imports) {
                    Tree impTree = importTree.getQualifiedIdentifier();
                    TreePath impTreePath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), impTree);
                    TypeElement impElement = (TypeElement)workingCopy.getTrees().getElement(impTreePath);
                    if (impElement == null || !impElement.getQualifiedName().contentEquals("javax.jws.HandlerChain")) continue;
                    CompilationUnitTree newCompileUnitTree = make.removeCompUnitImport(compileUnitTree, importTree);
                    workingCopy.rewrite((Tree)compileUnitTree, (Tree)newCompileUnitTree);
                    break;
                }
            }

            public void cancel() {
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable((CancellableTask)modificationTask, serviceFO){
                final /* synthetic */ CancellableTask val$modificationTask;
                final /* synthetic */ FileObject val$serviceFO;
                {
                    this.val$modificationTask = cancellableTask;
                    this.val$serviceFO = fileObject;
                }

                @Override
                public void run() {
                    try {
                        javaSource.runModificationTask((Task)this.val$modificationTask).commit();
                        ClientHandlerButtonListener.saveFile(this.val$serviceFO);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            });
        } else {
            try {
                javaSource.runModificationTask((Task)modificationTask).commit();
                ClientHandlerButtonListener.saveFile(serviceFO);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private static void saveFile(FileObject file) throws IOException {
        SaveCookie cookie;
        DataObject dataObject = DataObject.find((FileObject)file);
        if (dataObject != null && (cookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            cookie.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readResource(InputStream is) throws IOException {
        BufferedReader br = null;
        InputStreamReader isr = null;
        StringBuilder sb = new StringBuilder();
        try {
            String lineSep = System.getProperty("line.separator");
            isr = new InputStreamReader(is, Charset.forName("UTF-8"));
            br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(lineSep);
                line = br.readLine();
            }
        }
        finally {
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return sb.toString();
    }
}

