/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.actions;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.jaxws.nodes.OperationNode;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class JaxWsCodeGenerator {
    private static final List IMPLICIT_JSP_OBJECTS = Arrays.asList("request", "response", "session", "out", "page", "config", "application", "pageContext");
    private static final String HINT_INIT_ARGUMENTS = " // TODO initialize WS operation arguments here\n";
    private static final String JAVA_TRY = "\ntry '{' // Call Web Service Operation\n";
    private static final String JAVA_SERVICE_DEF = "   {0} {7} = new {0}();\n";
    private static final String JAVA_PORT_DEF = "   {1} port = {7}.{2}();\n";
    private static final String JAVA_RESULT = "   {3}   // TODO process result here\n   {4} result = port.{5}({6});\n";
    private static final String JAVA_VOID = "   {3}   port.{5}({6});\n";
    private static final String JAVA_OUT = "   {8}.println(\"Result = \"+result);\n";
    private static final String JAVA_CATCH = "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    private static final String JAVA_STATIC_STUB_ASYNC_POLLING = "\ntry '{' // Call Web Service Operation(async. polling)\n   {0} service = new {0}();\n   {1} port = service.{2}();\n   {3}   // TODO process asynchronous response here\n   {4} resp = port.{5}({6});\n   while(!resp.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n   System.out.println(\"Result = \"+resp.get());\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    private static final String JAVA_STATIC_STUB_ASYNC_CALLBACK = "\ntry '{' // Call Web Service Operation(async. callback)\n   {0} service = new {0}();\n   {1} port = service.{2}();\n   {3}       public void handleResponse(javax.xml.ws.Response<{7}> response) '{'\n           try '{'\n               // TODO process asynchronous response here\n               System.out.println(\"Result = \"+ response.get());\n           '}' catch(Exception ex) '{'\n               // TODO handle exception\n           '}'\n       '}'\n   '}';\n   {4} result = port.{5}({6});\n   while(!result.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    private static final String JSP_STATIC_STUB = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process result here\n\t{4} result = port.{5}({6});\n\tout.println(\"Result = \"+result);\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";
    private static final String JSP_STATIC_STUB_VOID = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\tport.{5}({6});\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";
    private static final String JSP_STATIC_STUB_ASYNC_POLLING = "    <%-- start web service invocation(async. polling) --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process asynchronous response here\n\t{4} resp = port.{5}({6});\n\twhile(!resp.isDone()) '{'\n\t\t// do something\n\t\tThread.sleep(100);\n\t'}'\n\tout.println(\"Result = \"+resp.get());\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation(async. polling) --%><hr/>\n";
    private static final String JSP_STATIC_STUB_ASYNC_CALLBACK = "    <%-- start web service invocation(async. callback) --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\t{1} port = service.{2}();\n{3}\t// TODO process asynchronous response here\n\t{4} result = port.{5}({6});\n\twhile(!result.isDone()) '{'\n\t\t// do something\n\t\tThread.sleep(100);\n\t'}'\n\tout.println(\"Result = \"+asyncHandler.getResponse());\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation(async. callback) --%><hr/>\n";
    private static final String JSP_CALLBACK_HANDLER = "<%!\nclass {0} implements javax.xml.ws.AsyncHandler<{1}> '{'\n    private {1} output;\n\n    public void handleResponse(javax.xml.ws.Response<{1}> response) '{'\n        try '{'\n            output = response.get();\n        '}' catch(Exception ex) '{'\n            // TODO handle exception\n        '}'\n    '}'\n\n    {1} getResponse() '{'\n         return output;\n    '}'\n'}'\n%>\n";
    private static final String QNAME = "\nQName portQName = new QName(\"{0}\" , \"{1}\"); ";
    private static final String JSP_DISPATCH = "    <%-- start web service invocation --%><hr/>\n    <%\n    try '{'\n\t{0} service = new {0}();\n\tjavax.xml.namespace.QName portQName = new javax.xml.namespace.QName(\"{1}\", \"{2}\");\n\tString req = \"{3}\";\n\tjavax.xml.ws.Dispatch<javax.xml.transform.Source> sourceDispatch = null;\n\tsourceDispatch = service.createDispatch(portQName, javax.xml.transform.Source.class, javax.xml.ws.Service.Mode.PAYLOAD);\n\tjavax.xml.transform.Source result = sourceDispatch.invoke(new javax.xml.transform.stream.StreamSource(new java.io.StringReader(req)));\n    '}' catch (Exception ex) '{'\n\t// TODO handle custom exceptions here\n    '}'\n    %>\n    <%-- end web service invocation --%><hr/>\n";

    private static String resolveInitValue(String type, FileObject targetFile) {
        if ("int".equals(type)) {
            return "0;";
        }
        if ("long".equals(type)) {
            return "0L;";
        }
        if ("float".equals(type)) {
            return "0.0f;";
        }
        if ("double".equals(type)) {
            return "0.0d;";
        }
        if ("short".equals(type)) {
            return "(short)0;";
        }
        if ("byte".equals(type)) {
            return "(byte)0;";
        }
        if ("boolean".equals(type)) {
            return "false;";
        }
        if ("java.lang.String".equals(type)) {
            return "\"\";";
        }
        if ("java.lang.Integer".equals(type)) {
            return "Integer.valueOf(0);";
        }
        if ("java.lang.Long".equals(type)) {
            return "Long.valueOf(0L);";
        }
        if ("java.lang.Float".equals(type)) {
            return "Float.valueOf(0.0f);";
        }
        if ("java.lang.Double".equals(type)) {
            return "Double.valueOf(0.0d);";
        }
        if ("java.lang.Short".equals(type)) {
            return "Short.valueOf((short)0);";
        }
        if ("java.lang.Byte".equals(type)) {
            return "Byte.valueOf((byte)0);";
        }
        if ("java.lang.Boolean".equals(type)) {
            return "Boolean.FALSE;";
        }
        if (type.endsWith("CallbackHandler")) {
            return "new " + type + "();";
        }
        if (type.startsWith("javax.xml.ws.AsyncHandler")) {
            return "new " + type + "() {";
        }
        ResultHolder<String> result = new ResultHolder<String>("");
        JaxWsCodeGenerator.getInitValue(type, targetFile, result);
        String returnText = result.getResult();
        if (!returnText.equals("")) {
            return returnText;
        }
        return "null;";
    }

    private static void getInitValue(final String type, FileObject targetFile, final ResultHolder<String> result) {
        if (targetFile == null) {
            return;
        }
        JavaSource targetSource = JavaSource.forFileObject((FileObject)targetFile);
        if (targetSource == null) {
            result.setResult("null;");
            return;
        }
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                if (typeElement == null) {
                    return;
                }
                if (!JaxWsCodeGenerator.isEnum(controller, typeElement) && JaxWsCodeGenerator.hasNoArgConstructor(controller, typeElement)) {
                    result.setResult("new " + type + "();");
                }
            }

            public void cancel() {
            }
        };
        try {
            targetSource.runUserActionTask((Task)task, true);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private static boolean isEnum(CompilationController controller, TypeElement classEl) {
        if (classEl != null) {
            return classEl.getKind() == ElementKind.ENUM;
        }
        return false;
    }

    private static boolean hasNoArgConstructor(CompilationController controller, TypeElement classEl) {
        if (classEl != null) {
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(classEl.getEnclosedElements());
            for (ExecutableElement c : constructors) {
                if (c.getParameters().size() != 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getCanonicalClassName(String genericClassName) {
        int index = genericClassName.indexOf("<");
        if (index != -1) {
            return genericClassName.substring(0, index);
        }
        return genericClassName;
    }

    private static String resolveResponseType(String argumentType) {
        int start = argumentType.indexOf("<");
        int end = argumentType.indexOf(">");
        if (start > 0 && end > 0 && start < end) {
            return argumentType.substring(start + 1, end);
        }
        return "javax.xml.ws.Response";
    }

    private static String pureJavaName(String javaNameWithPackage) {
        int index = javaNameWithPackage.lastIndexOf(".");
        return index >= 0 ? javaNameWithPackage.substring(index + 1) : javaNameWithPackage;
    }

    public static void insertMethod(Document document, int pos, OperationNode operationNode) {
        Node portNode = operationNode.getParentNode();
        Node serviceNode = portNode.getParentNode();
        Node wsdlNode = serviceNode.getParentNode();
        WsdlOperation operation = (WsdlOperation)operationNode.getLookup().lookup(WsdlOperation.class);
        WsdlPort port = (WsdlPort)portNode.getLookup().lookup(WsdlPort.class);
        WsdlService service = (WsdlService)serviceNode.getLookup().lookup(WsdlService.class);
        JaxWsService client = (JaxWsService)wsdlNode.getLookup().lookup(JaxWsService.class);
        String wsdlUrl = JaxWsCodeGenerator.findWsdlLocation(client, NbEditorUtilities.getFileObject((Document)document));
        JaxWsCodeGenerator.insertMethod(document, pos, service, port, operation, wsdlUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertMethod(final Document document, final int pos, WsdlService service, WsdlPort port, WsdlOperation operation, String wsdlUrl) {
        String argumentDeclarationPart;
        String argumentInitializationPart;
        String returnTypeName;
        String serviceJavaName;
        String portGetterMethod;
        String portJavaName;
        String operationJavaName;
        String serviceFieldName;
        boolean inJsp = "text/x-jsp".equals(document.getProperty("mimeType"));
        String responseType = "Object";
        String callbackHandlerName = "javax.xml.ws.AsyncHandler";
        try {
            serviceFieldName = "service";
            operationJavaName = operation.getJavaName();
            portJavaName = port.getJavaName();
            portGetterMethod = port.getPortGetter();
            serviceJavaName = service.getJavaName();
            List arguments = operation.getParameters();
            returnTypeName = operation.getReturnTypeName();
            StringBuffer argumentBuffer1 = new StringBuffer();
            StringBuffer argumentBuffer2 = new StringBuffer();
            for (int i = 0; i < arguments.size(); ++i) {
                String argumentTypeName = ((WsdlParameter)arguments.get(i)).getTypeName();
                if (argumentTypeName.startsWith("javax.xml.ws.AsyncHandler")) {
                    responseType = JaxWsCodeGenerator.resolveResponseType(argumentTypeName);
                    if (inJsp) {
                        argumentTypeName = JaxWsCodeGenerator.pureJavaName(portJavaName) + "CallbackHandler";
                    }
                    callbackHandlerName = argumentTypeName;
                }
                String argumentName = ((WsdlParameter)arguments.get(i)).getName();
                if (inJsp && IMPLICIT_JSP_OBJECTS.contains(argumentName)) {
                    argumentName = argumentName + "_1";
                }
                argumentBuffer1.append("\t" + argumentTypeName + " " + argumentName + " = " + JaxWsCodeGenerator.resolveInitValue(argumentTypeName, NbEditorUtilities.getFileObject((Document)document)) + "\n");
                argumentBuffer2.append(i > 0 ? ", " + argumentName : argumentName);
            }
            argumentInitializationPart = argumentBuffer1.length() > 0 ? "\t // TODO initialize WS operation arguments here\n" + argumentBuffer1.toString() : "";
            argumentDeclarationPart = argumentBuffer2.toString();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            String message = NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_FailedUnexpectedWebServiceDescriptionPattern");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return;
        }
        if (inJsp) {
            block27: {
                Object[] args = new Object[]{serviceJavaName, portJavaName, portGetterMethod, argumentInitializationPart, returnTypeName, operationJavaName, argumentDeclarationPart};
                final String invocationBody = JaxWsCodeGenerator.getJSPInvocationBody(operation, args);
                try {
                    if (2 == operation.getOperationType()) {
                        Object[] args1 = new Object[]{callbackHandlerName, responseType};
                        final String methodBody = MessageFormat.format(JSP_CALLBACK_HANDLER, args1);
                        NbDocument.runAtomic((StyledDocument)((StyledDocument)document), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    document.insertString(document.getLength(), methodBody, null);
                                    document.insertString(pos, invocationBody, null);
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                        break block27;
                    }
                    document.insertString(pos, invocationBody, null);
                    Indent indent = Indent.get((Document)document);
                    indent.lock();
                    try {
                        indent.reindent(pos, pos + invocationBody.length());
                    }
                    finally {
                        indent.unlock();
                    }
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
            return;
        }
        FileObject targetFo = NbEditorUtilities.getFileObject((Document)document);
        final JavaSource targetSource = JavaSource.forFileObject((FileObject)targetFo);
        String respType = responseType;
        String[] argumentInitPart = new String[]{argumentInitializationPart};
        String[] argumentDeclPart = new String[]{argumentDeclarationPart};
        String[] serviceFName = new String[]{serviceFieldName};
        try {
            final CompilerTask task = new CompilerTask(serviceJavaName, serviceFName, argumentDeclPart, argumentInitPart);
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        targetSource.runUserActionTask((Task)task, true);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JaxWsCodeGenerator.class.getName()).log(Level.FINE, "cannot parse " + serviceJavaName + " class", ex);
                    }
                }
            };
            final String title = NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"LBL_ParseWsClass");
            if (SwingUtilities.isEventDispatchThread()) {
                ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Logger.getLogger(JaxWsCodeGenerator.class.getName()).log(Level.WARNING, null, e);
                }
                catch (InterruptedException e) {
                    Logger.getLogger(JaxWsCodeGenerator.class.getName()).log(Level.WARNING, null, e);
                }
            }
            String invocationBody = task.getJavaInvocationBody(operation, portJavaName, portGetterMethod, returnTypeName, operationJavaName, respType);
            try {
                document.insertString(pos, invocationBody, null);
            }
            catch (BadLocationException badLoc) {
                document.insertString(pos + 1, invocationBody, null);
            }
            Indent indent = Indent.get((Document)document);
            indent.lock();
            try {
                indent.reindent(pos, pos + invocationBody.length());
            }
            finally {
                indent.unlock();
            }
            if (!task.containsWsRefInjection()) {
                InsertTask modificationTask = new InsertTask(serviceJavaName, serviceFName[0], wsdlUrl);
                targetSource.runModificationTask((Task)modificationTask).commit();
            }
        }
        catch (BadLocationException badLoc) {
            ErrorManager.getDefault().notify(1, (Throwable)badLoc);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
    }

    private static String findWsdlLocation(JaxWsService client, FileObject targetFo) {
        Project targetProject = FileOwnerQuery.getOwner((FileObject)targetFo);
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)targetProject.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider != null && J2eeModule.Type.WAR.equals(moduleProvider.getJ2eeModule().getType())) {
            return "WEB-INF/wsdl/" + client.getLocalWsdl();
        }
        return "META-INF/wsdl/" + client.getLocalWsdl();
    }

    private static String getJSPInvocationBody(WsdlOperation operation, Object[] args) {
        String invocationBody = "";
        switch (operation.getOperationType()) {
            case 0: {
                if ("void".equals(args[4])) {
                    invocationBody = MessageFormat.format(JSP_STATIC_STUB_VOID, args);
                    break;
                }
                invocationBody = MessageFormat.format(JSP_STATIC_STUB, args);
                break;
            }
            case 1: {
                invocationBody = MessageFormat.format(JSP_STATIC_STUB_ASYNC_POLLING, args);
                break;
            }
            case 2: {
                invocationBody = MessageFormat.format(JSP_STATIC_STUB_ASYNC_CALLBACK, args);
                break;
            }
        }
        return invocationBody;
    }

    static boolean foundImport(String importStatement, CompilationUnitTree tree) {
        List<? extends ImportTree> imports = tree.getImports();
        for (ImportTree importTree : imports) {
            if (!importStatement.equals(importTree.getQualifiedIdentifier().toString())) continue;
            return true;
        }
        return false;
    }

    public static String generateXMLMessage(WsdlPort port, WsdlOperation operation) {
        StringBuffer message = new StringBuffer("");
        String operationName = operation.getOperationName();
        String namespace = port.getNamespaceURI();
        message.append("<");
        message.append(operationName);
        message.append("  xmlns=\\\"");
        message.append(namespace);
        message.append("\\\">");
        List parameters = operation.getParameters();
        for (WsdlParameter parameter : parameters) {
            String name = parameter.getName();
            message.append("<");
            message.append(name);
            message.append(">");
            message.append("ENTER VALUE");
            message.append("</");
            message.append(name);
            message.append(">");
        }
        message.append("</");
        message.append(operationName);
        message.append(">");
        return message.toString();
    }

    private static String getDispatchInvocationMethod(WsdlPort port, WsdlOperation operation) {
        StringBuffer invoke = new StringBuffer("");
        invoke.append(MessageFormat.format(QNAME, port.getNamespaceURI(), port.getName()));
        invoke.append("\n");
        invoke.append("String req = ");
        invoke.append("\"");
        invoke.append(JaxWsCodeGenerator.generateXMLMessage(port, operation));
        invoke.append("\";\n");
        invoke.append(MessageFormat.format(JAVA_TRY, new Object[0]));
        invoke.append("\n");
        invoke.append("Dispatch<Source> sourceDispatch = null;\n");
        invoke.append("sourceDispatch = service.createDispatch(portQName, Source.class, Service.Mode.PAYLOAD);\n");
        invoke.append("Source result = sourceDispatch.invoke(new StreamSource(new StringReader(req)));\n");
        invoke.append(MessageFormat.format(JAVA_CATCH, new Object[0]));
        invoke.append("\n");
        return invoke.toString();
    }

    private static String getJSPDispatchBody(Object[] args) {
        return MessageFormat.format(JSP_DISPATCH, args);
    }

    public static String getWSInvocationCode(FileObject target, boolean inJsp, WsdlService service, WsdlPort port, WsdlOperation operation) {
        String argumentDeclarationPart;
        String argumentInitializationPart;
        String returnTypeName;
        String serviceJavaName;
        String portGetterMethod;
        String portJavaName;
        String operationJavaName;
        String serviceFieldName;
        String responseType = "Object";
        String callbackHandlerName = "javax.xml.ws.AsyncHandler";
        try {
            serviceFieldName = "service";
            operationJavaName = operation.getJavaName();
            portJavaName = port.getJavaName();
            portGetterMethod = port.getPortGetter();
            serviceJavaName = service.getJavaName();
            List arguments = operation.getParameters();
            returnTypeName = operation.getReturnTypeName();
            StringBuffer argumentBuffer1 = new StringBuffer();
            StringBuffer argumentBuffer2 = new StringBuffer();
            for (int i = 0; i < arguments.size(); ++i) {
                String argumentTypeName = ((WsdlParameter)arguments.get(i)).getTypeName();
                if (argumentTypeName.startsWith("javax.xml.ws.AsyncHandler")) {
                    responseType = JaxWsCodeGenerator.resolveResponseType(argumentTypeName);
                    if (inJsp) {
                        argumentTypeName = JaxWsCodeGenerator.pureJavaName(portJavaName) + "CallbackHandler";
                    }
                    callbackHandlerName = argumentTypeName;
                }
                String argumentName = ((WsdlParameter)arguments.get(i)).getName();
                if (inJsp && IMPLICIT_JSP_OBJECTS.contains(argumentName)) {
                    argumentName = argumentName + "_1";
                }
                argumentBuffer1.append("\t" + argumentTypeName + " " + argumentName + " = " + JaxWsCodeGenerator.resolveInitValue(argumentTypeName, target) + "\n");
                argumentBuffer2.append(i > 0 ? ", " + argumentName : argumentName);
            }
            argumentInitializationPart = argumentBuffer1.length() > 0 ? "\t // TODO initialize WS operation arguments here\n" + argumentBuffer1.toString() : "";
            argumentDeclarationPart = argumentBuffer2.toString();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            String message = NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"ERR_FailedUnexpectedWebServiceDescriptionPattern");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return "";
        }
        if (inJsp) {
            Object[] args = new Object[]{serviceJavaName, portJavaName, portGetterMethod, argumentInitializationPart, returnTypeName, operationJavaName, argumentDeclarationPart};
            String invocationBody = JaxWsCodeGenerator.getJSPInvocationBody(operation, args);
            if (2 == operation.getOperationType()) {
                Object[] args1 = new Object[]{callbackHandlerName, responseType};
                String methodBody = MessageFormat.format(JSP_CALLBACK_HANDLER, args1);
                invocationBody = invocationBody + "\n\n" + methodBody;
            }
            return invocationBody;
        }
        final JavaSource targetSource = JavaSource.forFileObject((FileObject)target);
        String respType = responseType;
        String[] argumentInitPart = new String[]{argumentInitializationPart};
        String[] argumentDeclPart = new String[]{argumentDeclarationPart};
        String[] serviceFName = new String[]{serviceFieldName};
        final CompilerTask task = new CompilerTask(serviceJavaName, serviceFName, argumentDeclPart, argumentInitPart);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    targetSource.runWhenScanFinished((Task)task, true);
                }
                catch (IOException ex) {
                    Logger.getLogger(JaxWsCodeGenerator.class.getName()).log(Level.FINE, "cannot parse " + serviceJavaName + " class", ex);
                }
            }
        };
        final String title = NbBundle.getMessage(JaxWsCodeGenerator.class, (String)"LBL_ParseWsClass");
        if (SwingUtilities.isEventDispatchThread()) {
            ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
                    }
                });
            }
            catch (InvocationTargetException e) {
                Logger.getLogger(JaxWsCodeGenerator.class.getName()).log(Level.WARNING, null, e);
            }
            catch (InterruptedException e) {
                Logger.getLogger(JaxWsCodeGenerator.class.getName()).log(Level.WARNING, null, e);
            }
        }
        String javaInvocationBody = task.getJavaInvocationBody(operation, portJavaName, portGetterMethod, returnTypeName, operationJavaName, respType);
        return javaInvocationBody;
    }

    static final class DispatchCompilerTask
    implements CancellableTask<WorkingCopy> {
        DispatchCompilerTask() {
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            CompilationUnitTree cut;
            boolean changed = false;
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            TreeMaker make = workingCopy.getTreeMaker();
            CompilationUnitTree copy = cut = workingCopy.getCompilationUnit();
            if (!JaxWsCodeGenerator.foundImport("javax.xml.namespace.QName", copy)) {
                copy = make.addCompUnitImport(copy, make.Import((Tree)make.Identifier((CharSequence)"javax.xml.namespace.QName"), false));
                changed = true;
            }
            if (!JaxWsCodeGenerator.foundImport("javax.xml.transform.Source", copy)) {
                copy = make.addCompUnitImport(copy, make.Import((Tree)make.Identifier((CharSequence)"javax.xml.transform.Source"), false));
                changed = true;
            }
            if (!JaxWsCodeGenerator.foundImport("javax.xml.ws.Dispatch", copy)) {
                copy = make.addCompUnitImport(copy, make.Import((Tree)make.Identifier((CharSequence)"javax.xml.ws.Dispatch"), false));
                changed = true;
            }
            if (!JaxWsCodeGenerator.foundImport("javax.xml.transform.stream.StreamSource", copy)) {
                copy = make.addCompUnitImport(copy, make.Import((Tree)make.Identifier((CharSequence)"javax.xml.transform.stream.StreamSource"), false));
                changed = true;
            }
            if (!JaxWsCodeGenerator.foundImport("javax.xml.ws.Service", copy)) {
                copy = make.addCompUnitImport(copy, make.Import((Tree)make.Identifier((CharSequence)"javax.xml.ws.Service"), false));
                changed = true;
            }
            if (!JaxWsCodeGenerator.foundImport("java.io.StringReader", copy)) {
                copy = make.addCompUnitImport(copy, make.Import((Tree)make.Identifier((CharSequence)"java.io.StringReader"), false));
                changed = true;
            }
            if (changed) {
                workingCopy.rewrite((Tree)cut, (Tree)copy);
            }
        }

        public void cancel() {
        }
    }

    static class InsertTask
    implements CancellableTask<WorkingCopy> {
        private final String serviceJavaName;
        private final String serviceFName;
        private final String wsdlUrl;

        public InsertTask(String serviceJavaName, String serviceFName, String wsdlUrl) {
            this.serviceJavaName = serviceJavaName;
            this.serviceFName = serviceFName;
            this.wsdlUrl = wsdlUrl;
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            TreeMaker make = workingCopy.getTreeMaker();
            ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
            if (javaClass != null) {
                TypeElement wsRefElement = workingCopy.getElements().getTypeElement("javax.xml.ws.WebServiceRef");
                AnnotationTree wsRefAnnotation = make.Annotation((Tree)make.QualIdent((Element)wsRefElement), Collections.singletonList(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"wsdlLocation"), (ExpressionTree)make.Literal((Object)this.wsdlUrl))));
                HashSet<Modifier> modifiers = new HashSet<Modifier>();
                modifiers.add(Modifier.PRIVATE);
                ModifiersTree methodModifiers = make.Modifiers(modifiers, Collections.singletonList(wsRefAnnotation));
                TypeElement typeElement = workingCopy.getElements().getTypeElement(this.serviceJavaName);
                Tree type = typeElement != null ? make.Type(typeElement.asType()) : make.Type(this.serviceJavaName);
                VariableTree serviceRefInjection = make.Variable(methodModifiers, (CharSequence)this.serviceFName, type, null);
                ClassTree modifiedClass = make.insertClassMember(javaClass, 0, (Tree)serviceRefInjection);
                workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
            }
        }

        public void cancel() {
        }
    }

    static final class CompilerTask
    implements CancellableTask<CompilationController> {
        private final boolean[] insertServiceDef = new boolean[]{true};
        private final boolean[] generateWsRefInjection = new boolean[]{false};
        private final String[] printerName = new String[]{"System.out"};
        private final String serviceJavaName;
        private final String[] serviceFName;
        private final String[] argumentDeclPart;
        private final String[] argumentInitPart;

        public CompilerTask(String serviceJavaName, String[] serviceFName, String[] argumentDeclPart, String[] argumentInitPart) {
            this.serviceJavaName = serviceJavaName;
            this.argumentInitPart = argumentInitPart;
            this.argumentDeclPart = argumentDeclPart;
            this.serviceFName = serviceFName;
        }

        public void run(CompilationController controller) throws IOException {
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            CompilationUnitTree cut = controller.getCompilationUnit();
            TypeElement thisTypeEl = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
            if (thisTypeEl != null) {
                ClassTree javaClass = controller.getTrees().getTree(thisTypeEl);
                this.generateWsRefInjection[0] = InjectionTargetQuery.isInjectionTarget((CompilationController)controller, (TypeElement)thisTypeEl);
                boolean bl = this.insertServiceDef[0] = !this.generateWsRefInjection[0];
                if (CompilerTask.isServletClass(controller, thisTypeEl)) {
                    this.printerName[0] = "out";
                    this.argumentInitPart[0] = CompilerTask.fixNamesInInitializationPart(this.argumentInitPart[0]);
                    this.argumentDeclPart[0] = CompilerTask.fixNamesInDeclarationPart(this.argumentDeclPart[0]);
                }
                if (this.generateWsRefInjection[0]) {
                    HashSet<String> serviceFieldNames = new HashSet<String>();
                    boolean injectionExists = false;
                    int memberOrder = 0;
                    for (Tree tree : javaClass.getMembers()) {
                        String variableType;
                        ++memberOrder;
                        if (Tree.Kind.VARIABLE != tree.getKind()) continue;
                        VariableTree var = (VariableTree)tree;
                        Tree typeTree = var.getType();
                        TreePath typeTreePath = controller.getTrees().getPath(cut, typeTree);
                        TypeElement typeEl = (TypeElement)controller.getTrees().getElement(typeTreePath);
                        if (typeEl != null && this.serviceJavaName.equals(variableType = typeEl.getQualifiedName().toString())) {
                            this.serviceFName[0] = var.getName().toString();
                            this.generateWsRefInjection[0] = false;
                            injectionExists = true;
                            break;
                        }
                        serviceFieldNames.add(var.getName().toString());
                    }
                    if (!injectionExists) {
                        this.serviceFName[0] = CompilerTask.findProperServiceFieldName(serviceFieldNames);
                    }
                }
            }
        }

        public void cancel() {
        }

        public String getJavaInvocationBody(WsdlOperation operation, String portJavaName, String portGetterMethod, String returnTypeName, String operationJavaName, String responseType) {
            String invocationBody = "";
            Object[] args = new Object[]{this.serviceJavaName, portJavaName, portGetterMethod, this.argumentInitPart[0], returnTypeName, operationJavaName, this.argumentDeclPart[0], this.serviceFName[0], this.printerName[0]};
            switch (operation.getOperationType()) {
                case 0: {
                    if ("void".equals(returnTypeName)) {
                        String body = JaxWsCodeGenerator.JAVA_TRY + (this.insertServiceDef[0] ? JaxWsCodeGenerator.JAVA_SERVICE_DEF : "") + JaxWsCodeGenerator.JAVA_PORT_DEF + JaxWsCodeGenerator.JAVA_VOID + JaxWsCodeGenerator.JAVA_CATCH;
                        invocationBody = MessageFormat.format(body, args);
                        break;
                    }
                    String body = JaxWsCodeGenerator.JAVA_TRY + (this.insertServiceDef[0] ? JaxWsCodeGenerator.JAVA_SERVICE_DEF : "") + JaxWsCodeGenerator.JAVA_PORT_DEF + JaxWsCodeGenerator.JAVA_RESULT + JaxWsCodeGenerator.JAVA_OUT + JaxWsCodeGenerator.JAVA_CATCH;
                    invocationBody = MessageFormat.format(body, args);
                    break;
                }
                case 1: {
                    invocationBody = MessageFormat.format(JaxWsCodeGenerator.JAVA_STATIC_STUB_ASYNC_POLLING, args);
                    break;
                }
                case 2: {
                    args[7] = responseType;
                    invocationBody = MessageFormat.format(JaxWsCodeGenerator.JAVA_STATIC_STUB_ASYNC_CALLBACK, args);
                }
            }
            return invocationBody;
        }

        public boolean containsWsRefInjection() {
            return !this.generateWsRefInjection[0];
        }

        private static boolean isServletClass(CompilationController controller, TypeElement typeElement) {
            return SourceUtils.isSubtype((CompilationController)controller, (TypeElement)typeElement, (String)"javax.servlet.http.HttpServlet");
        }

        private static String fixNamesInInitializationPart(String argumentInitializationPart) {
            return argumentInitializationPart.replaceFirst(" request ", " request_1 ").replaceFirst(" response ", " response_1 ").replaceFirst(" out ", " out_1 ");
        }

        private static String fixNamesInDeclarationPart(String argumentDeclarationPart) {
            StringTokenizer tok = new StringTokenizer(argumentDeclarationPart, " ,");
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                String newName = null;
                newName = "request".equals(token) ? "request_1" : ("response".equals(token) ? "response_1" : ("out".equals(token) ? "out_1" : token));
                buf.append(i > 0 ? ", " + newName : newName);
                ++i;
            }
            return buf.toString();
        }

        private static String findProperServiceFieldName(Set serviceFieldNames) {
            String name = "service";
            int i = 0;
            while (serviceFieldNames.contains(name)) {
                name = "service_" + String.valueOf(++i);
            }
            return name;
        }
    }

    private static class ResultHolder<E> {
        private E result;

        public ResultHolder(E result) {
            this.result = result;
        }

        public E getResult() {
            return this.result;
        }

        public void setResult(E result) {
            this.result = result;
        }
    }
}

