/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.jaxws.ConfirmationPanel;
import org.netbeans.modules.maven.jaxws.MavenJAXWSSupportImpl;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSStackUtils;
import org.netbeans.modules.maven.jaxws.WsimportPomInfo;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class WSUtils {
    public static final String NON_JSR109_DONT_ASK = "dont_ask_for_nonjsr109_config";
    private static final String SERVLET_CLASS_NAME = "com.sun.xml.ws.transport.http.servlet.WSServlet";
    private static final String SERVLET_LISTENER = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";
    private static final String DEFAULT_PACKAGE_NAME = "org.netbeans.ws";

    public static FileObject retrieveResource(FileObject targetFolder, URI catalog, URI source) throws UnknownHostException, URISyntaxException, IOException {
        try {
            Iterator i$;
            Map map;
            Retriever retriever = Retriever.getDefault();
            FileObject result = retriever.retrieveResource(targetFolder, catalog, source);
            if (result == null && (map = retriever.getRetrievedResourceExceptionMap()) != null && (i$ = map.entrySet().iterator()).hasNext()) {
                Map.Entry entry = i$.next();
                RetrieveEntry key = (RetrieveEntry)entry.getKey();
                Exception exc = (Exception)entry.getValue();
                if (exc instanceof IOException) {
                    throw (IOException)exc;
                }
                if (exc instanceof URISyntaxException) {
                    throw (URISyntaxException)exc;
                }
                IOException ex = new IOException(NbBundle.getMessage(WSUtils.class, (String)"ERR_retrieveResource", (Object)key.getCurrentAddress()));
                ex.initCause(exc);
                throw ex;
            }
            return result;
        }
        catch (RuntimeException ex) {
            throw (IOException)new IOException(ex.getLocalizedMessage()).initCause(ex);
        }
    }

    public static void generateSunJaxwsFile(final FileObject targetDir) throws IOException {
        final String sunJaxwsContent = WSUtils.readResource(WsdlModel.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/sun-jaxws.xml"));
        FileSystem fs = targetDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject sunJaxwsFo = FileUtil.createData((FileObject)targetDir, (String)"sun-jaxws.xml");
                FileLock lock = sunJaxwsFo.lock();
                BufferedWriter bw = null;
                OutputStream os = null;
                OutputStreamWriter osw = null;
                try {
                    os = sunJaxwsFo.getOutputStream(lock);
                    osw = new OutputStreamWriter(os, Charset.forName("UTF-8"));
                    bw = new BufferedWriter(osw);
                    bw.write(sunJaxwsContent);
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        });
    }

    static final J2eeModuleProvider getModuleProvider(Project project) {
        return (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
    }

    private static String readResource(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public static void removeImplClass(Project project, String implClass) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        String resource = implClass.replace('.', '/') + ".java";
        if (sources != null) {
            SourceGroup[] srcGroup = sources.getSourceGroups("java");
            for (int i = 0; i < srcGroup.length; ++i) {
                FileObject srcRoot = srcGroup[i].getRootFolder();
                final FileObject implClassFo = srcRoot.getFileObject(resource);
                if (implClassFo == null) continue;
                try {
                    FileSystem fs = implClassFo.getFileSystem();
                    fs.runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() {
                            WSUtils.deleteFile(implClassFo);
                        }
                    });
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFile(FileObject f) {
        FileLock lock = null;
        try {
            SaveCookie save;
            DataObject dObj = DataObject.find((FileObject)f);
            if (dObj != null && (save = (SaveCookie)dObj.getCookie(SaveCookie.class)) != null) {
                save.save();
            }
            lock = f.lock();
            f.delete(lock);
        }
        catch (IOException e) {
            NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSUtils.class, (String)"MSG_Unable_Delete_File", (Object)f.getNameExt()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public static void copyFiles(FileObject sourceFolder, FileObject targetFolder) throws IOException {
        FileObject[] children = sourceFolder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isFolder()) {
                FileObject folder = targetFolder.createFolder(children[i].getNameExt());
                WSUtils.copyFiles(children[i], folder);
                continue;
            }
            children[i].copy(targetFolder, children[i].getName(), children[i].getExt());
        }
    }

    public static FileObject findJaxWsFileObject(Project project) {
        return project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
    }

    private static String getPackageNameFromNamespace(String ns) {
        String base = ns;
        int doubleSlashIndex = ns.indexOf("//");
        if (doubleSlashIndex >= 0) {
            base = ns.substring(doubleSlashIndex + 2);
        } else {
            int colonIndex = ns.indexOf(":");
            if (colonIndex >= 0) {
                base = ns.substring(colonIndex + 1);
            }
        }
        StringTokenizer tokens = new StringTokenizer(base, "/");
        if (tokens.countTokens() > 0) {
            ArrayList<String> packageParts = new ArrayList<String>();
            ArrayList<String> nsParts = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                String part = tokens.nextToken();
                if (part.length() < 0) continue;
                nsParts.add(part);
            }
            if (nsParts.size() > 0) {
                int i;
                StringTokenizer tokens1 = new StringTokenizer((String)nsParts.get(0), ".");
                int countTokens = tokens1.countTokens();
                if (countTokens > 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    while (tokens1.hasMoreTokens()) {
                        list.add(tokens1.nextToken());
                    }
                    for (i = countTokens - 1; i >= 0; --i) {
                        String part = (String)list.get(i);
                        if (i <= 0 && "www".equals(part)) continue;
                        packageParts.add(((String)list.get(i)).toLowerCase());
                    }
                } else {
                    return DEFAULT_PACKAGE_NAME;
                }
                for (int i2 = 1; i2 < nsParts.size(); ++i2) {
                    packageParts.add(((String)nsParts.get(i2)).toLowerCase());
                }
                StringBuffer buf = new StringBuffer((String)packageParts.get(0));
                for (i = 1; i < packageParts.size(); ++i) {
                    buf.append("." + (String)packageParts.get(i));
                }
                return buf.toString();
            }
        }
        return DEFAULT_PACKAGE_NAME;
    }

    public static boolean isProjectReferenceable(Project sourceProject, Project targetProject) {
        if (sourceProject == targetProject) {
            return true;
        }
        NbMavenProject mavenProject = (NbMavenProject)sourceProject.getLookup().lookup(NbMavenProject.class);
        return mavenProject != null && "jar".equals(mavenProject.getPackagingType());
    }

    public static boolean isEJB(Project project) {
        J2eeModule.Type moduleType;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        return j2eeModuleProvider != null && J2eeModule.Type.EJB.equals(moduleType = j2eeModuleProvider.getJ2eeModule().getType());
    }

    public static boolean isWeb(Project project) {
        J2eeModule.Type moduleType;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        return j2eeModuleProvider != null && J2eeModule.Type.WAR.equals(moduleType = j2eeModuleProvider.getJ2eeModule().getType());
    }

    public static void updateClients(final Project prj, final JAXWSLightSupport jaxWsSupport) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WSUtils.doUpdateClients(prj, jaxWsSupport);
            }
        };
        jaxWsSupport.runAtomic(runnable);
    }

    public static void detectWsdlClients(final Project prj, final JAXWSLightSupport jaxWsSupport) {
        final List<WsimportPomInfo> candidates = MavenModelUtils.getWsdlFiles(prj);
        if (candidates.size() > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (WsimportPomInfo candidate : candidates) {
                        if (!WSUtils.isClient(prj, candidate)) continue;
                        String wsdlPath = candidate.getWsdlPath();
                        JaxWsService client = new JaxWsService(wsdlPath, false);
                        if (candidate.getHandlerFile() != null) {
                            client.setHandlerBindingFile(candidate.getHandlerFile());
                        }
                        client.setId(candidate.getId());
                        client.setWsdlUrl(WSUtils.getOriginalWsdlUrl(prj, client.getId(), false));
                        jaxWsSupport.addService(client);
                    }
                }
            };
            jaxWsSupport.runAtomic(runnable);
        }
    }

    private static void doUpdateClients(Project prj, JAXWSLightSupport jaxWsSupport) {
        ArrayList<JaxWsService> oldClients = new ArrayList<JaxWsService>();
        HashSet<String> oldNames = new HashSet<String>();
        for (JaxWsService s : jaxWsSupport.getServices()) {
            if (s.isServiceProvider()) continue;
            oldClients.add(s);
            oldNames.add(s.getId());
        }
        FileObject wsdlFolder = jaxWsSupport.getWsdlFolder(false);
        if (wsdlFolder != null) {
            List<JaxWsService> newClients = WSUtils.getJaxWsClients(prj);
            HashSet<String> commonNames = new HashSet<String>();
            for (JaxWsService client : newClients) {
                String id = client.getId();
                if (!oldNames.contains(id)) continue;
                commonNames.add(id);
            }
            for (JaxWsService oldClient : oldClients) {
                if (commonNames.contains(oldClient.getId())) continue;
                jaxWsSupport.removeService(oldClient);
            }
            for (JaxWsService newClient : newClients) {
                if (commonNames.contains(newClient.getId())) continue;
                newClient.setWsdlUrl(WSUtils.getOriginalWsdlUrl(prj, newClient.getId(), false));
                jaxWsSupport.addService(newClient);
            }
        } else {
            for (JaxWsService client : oldClients) {
                jaxWsSupport.removeService(client);
            }
        }
    }

    private static List<JaxWsService> getJaxWsClients(Project prj) {
        List<WsimportPomInfo> candidates = MavenModelUtils.getWsdlFiles(prj);
        ArrayList<JaxWsService> clients = new ArrayList<JaxWsService>();
        for (WsimportPomInfo candidate : candidates) {
            if (!WSUtils.isClient(prj, candidate)) continue;
            String wsdlPath = candidate.getWsdlPath();
            JaxWsService client = new JaxWsService(wsdlPath, false);
            client.setId(candidate.getId());
            if (candidate.getHandlerFile() != null) {
                client.setHandlerBindingFile(candidate.getHandlerFile());
            }
            clients.add(client);
        }
        return clients;
    }

    private static boolean isClient(Project prj, WsimportPomInfo candidate) {
        Preferences prefs = ProjectUtils.getPreferences((Project)prj, MavenWebService.class, (boolean)true);
        return prefs == null || prefs.get("_S_" + candidate.getId(), null) == null;
    }

    static FileObject getLocalWsdl(JAXWSLightSupport jaxWsSupport, String localWsdlPath) {
        FileObject wsdlFolder = jaxWsSupport.getWsdlFolder(false);
        if (wsdlFolder != null) {
            return wsdlFolder.getFileObject(localWsdlPath);
        }
        return null;
    }

    public static String getOriginalWsdlUrl(Project prj, String id, boolean forService) {
        Preferences prefs = ProjectUtils.getPreferences((Project)prj, MavenWebService.class, (boolean)true);
        if (prefs != null) {
            if (forService) {
                return prefs.get("_S_" + id, null);
            }
            return prefs.get("_C_" + id, null);
        }
        return null;
    }

    private static boolean webAppHasListener(WebApp webApp, String listenerClass) {
        Listener[] listeners = webApp.getListener();
        for (int i = 0; i < listeners.length; ++i) {
            Listener listener = listeners[i];
            if (!listenerClass.equals(listener.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    private static WebApp getWebApp(Project prj) {
        try {
            FileObject deploymentDescriptor = WSUtils.getDeploymentDescriptor(prj);
            if (deploymentDescriptor != null) {
                return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, e.getLocalizedMessage());
        }
        return null;
    }

    private static FileObject getDeploymentDescriptor(Project prj) {
        J2eeModuleProvider provider = (J2eeModuleProvider)prj.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            File dd = provider.getJ2eeModule().getDeploymentConfigurationFile("WEB-INF/web.xml");
            if (dd != null && dd.exists()) {
                return FileUtil.toFileObject((File)dd);
            }
            WebModule wm = WebModule.getWebModule((FileObject)prj.getProjectDirectory());
            if (wm == null) {
                return null;
            }
            FileObject webInf = wm.getWebInf();
            try {
                FileObject docBase;
                if (webInf == null && (docBase = wm.getDocumentBase()) != null) {
                    webInf = docBase.createFolder("WEB-INF");
                }
                if (webInf == null) {
                    return null;
                }
                return DDHelper.createWebXml((Profile)wm.getJ2eeProfile(), (FileObject)webInf);
            }
            catch (IOException e) {
                Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, null, e);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSunJaxWsEntry(FileObject ddFolder, JaxWsService service) throws IOException {
        FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
        if (sunjaxwsFile == null) {
            WSUtils.generateSunJaxwsFile(ddFolder);
        }
        sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
        Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile);
        Endpoint oldEndpoint = endpoints.findEndpointByName(service.getServiceName());
        if (oldEndpoint == null) {
            WSUtils.addService(endpoints, service);
            FileLock lock = null;
            OutputStream os = null;
            FileObject fileObject = sunjaxwsFile;
            synchronized (fileObject) {
                try {
                    lock = sunjaxwsFile.lock();
                    os = sunjaxwsFile.getOutputStream(lock);
                    endpoints.write(os);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addJaxWsEntries(FileObject ddFolder, JAXWSLightSupport jaxWsSupport) throws IOException {
        WSUtils.generateSunJaxwsFile(ddFolder);
        FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
        Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile);
        for (JaxWsService service : jaxWsSupport.getServices()) {
            if (!service.isServiceProvider()) continue;
            WSUtils.addService(endpoints, service);
        }
        FileLock lock = null;
        OutputStream os = null;
        FileObject fileObject = sunjaxwsFile;
        synchronized (fileObject) {
            try {
                lock = sunjaxwsFile.lock();
                os = sunjaxwsFile.getOutputStream(lock);
                endpoints.write(os);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    private static void addService(Endpoints endpoints, JaxWsService service) {
        Endpoint endpoint = endpoints.newEndpoint();
        endpoint.setEndpointName(service.getServiceName());
        endpoint.setImplementation(service.getImplementationClass());
        endpoint.setUrlPattern("/" + service.getServiceName());
        endpoints.addEnpoint(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSunJaxWsEntry(FileObject ddFolder, JaxWsService service) throws IOException {
        Endpoints endpoints;
        Endpoint endpoint;
        FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
        if (sunjaxwsFile != null && (endpoint = (endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile)).findEndpointByName(service.getServiceName())) != null) {
            endpoints.removeEndpoint(endpoint);
            FileLock lock = null;
            OutputStream os = null;
            FileObject fileObject = sunjaxwsFile;
            synchronized (fileObject) {
                try {
                    lock = sunjaxwsFile.lock();
                    os = sunjaxwsFile.getOutputStream(lock);
                    endpoints.write(os);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            }
        }
    }

    private static void removeSunJaxWs(FileObject ddFolder) throws IOException {
        FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
        if (sunjaxwsFile != null) {
            sunjaxwsFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceSunJaxWsEntries(FileObject ddFolder, String oldServiceName, String newServiceName) throws IOException {
        Endpoints endpoints;
        Endpoint endpoint;
        FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
        if (sunjaxwsFile != null && (endpoint = (endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile)).findEndpointByName(oldServiceName)) != null) {
            endpoint.setEndpointName(newServiceName);
            endpoint.setUrlPattern("/" + newServiceName);
            FileLock lock = null;
            OutputStream os = null;
            FileObject fileObject = sunjaxwsFile;
            synchronized (fileObject) {
                try {
                    lock = sunjaxwsFile.lock();
                    os = sunjaxwsFile.getOutputStream(lock);
                    endpoints.write(os);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            }
        }
    }

    public static boolean needNonJsr109Artifacts(Project prj) {
        FileObject ddFolder = WSUtils.getDeploymentDescriptorFolder(prj);
        if (ddFolder == null || ddFolder.getFileObject("sun-jaxws.xml") == null) {
            return WSUtils.generateNonJsr109Artifacts(prj);
        }
        return true;
    }

    public static boolean generateNonJsr109Artifacts(Project prj) {
        Preferences prefs = ProjectUtils.getPreferences((Project)prj, MavenWebService.class, (boolean)true);
        if (prefs == null || prefs.get(NON_JSR109_DONT_ASK, null) == null) {
            ConfirmationPanel panel = new ConfirmationPanel(NbBundle.getMessage(WSUtils.class, (String)"MSG_GenerateDDEntries", (Object)prj.getProjectDirectory().getName()));
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(WSUtils.class, (String)"TTL_GenerateDDEntries"), true, 0, null, null);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (panel.notAskAgain() && prefs != null) {
                prefs.put(NON_JSR109_DONT_ASK, "true");
            }
            return NotifyDescriptor.YES_OPTION.equals(result);
        }
        return false;
    }

    private static boolean removeNonJsr109Artifacts(Project prj) {
        Preferences prefs = ProjectUtils.getPreferences((Project)prj, MavenWebService.class, (boolean)true);
        if (prefs == null || prefs.get(NON_JSR109_DONT_ASK, null) == null) {
            ConfirmationPanel panel = new ConfirmationPanel(NbBundle.getMessage(WSUtils.class, (String)"MSG_RemoveDDEntries"));
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(WSUtils.class, (String)"TTL_RemoveDDEntries"), true, 0, null, null);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (panel.notAskAgain() && prefs != null) {
                prefs.put(NON_JSR109_DONT_ASK, "true");
            }
            return NotifyDescriptor.YES_OPTION.equals(result);
        }
        return false;
    }

    public static FileObject getDeploymentDescriptorFolder(Project project) {
        JAXWSLightSupport jaxWsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)project.getProjectDirectory());
        return jaxWsSupport.getDeploymentDescriptorFolder();
    }

    public static boolean isJsr109Supported(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return true;
        }
        WSStackUtils stackUtils = new WSStackUtils(project);
        return stackUtils.isJsr109Supported();
    }

    public static void addServiceToDD(Project prj, JaxWsService service) throws IOException {
        WebApp webApp = WSUtils.getWebApp(prj);
        if (webApp != null) {
            try {
                WSUtils.addServlet(webApp, service);
                if (!WSUtils.webAppHasListener(webApp, SERVLET_LISTENER)) {
                    webApp.addBean("Listener", new String[]{"ListenerClass"}, new Object[]{SERVLET_LISTENER}, "ListenerClass");
                }
                webApp.write(WSUtils.getDeploymentDescriptor(prj));
            }
            catch (ClassNotFoundException exc) {
                Logger.getLogger("global").log(Level.INFO, exc.getLocalizedMessage());
            }
            catch (NameAlreadyUsedException exc) {
                Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, exc.getLocalizedMessage());
            }
        }
    }

    private static void addServicesToDD(Project prj, JAXWSLightSupport jaxWsSupport) throws IOException {
        WebApp webApp = WSUtils.getWebApp(prj);
        if (webApp != null) {
            try {
                if (!WSUtils.webAppHasListener(webApp, SERVLET_LISTENER)) {
                    webApp.addBean("Listener", new String[]{"ListenerClass"}, new Object[]{SERVLET_LISTENER}, "ListenerClass");
                }
                for (JaxWsService service : jaxWsSupport.getServices()) {
                    if (!service.isServiceProvider()) continue;
                    WSUtils.addServlet(webApp, service);
                }
            }
            catch (NameAlreadyUsedException exc) {
                Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, exc.getLocalizedMessage());
            }
            catch (ClassNotFoundException exc) {
                Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, exc.getLocalizedMessage());
            }
            webApp.write(WSUtils.getDeploymentDescriptor(prj));
        }
    }

    private static void addServlet(WebApp webApp, JaxWsService service) throws ClassNotFoundException, NameAlreadyUsedException {
        String servletName = service.getServiceName();
        Servlet servlet = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{servletName, SERVLET_CLASS_NAME}, "ServletName");
        servlet.setLoadOnStartup(new BigInteger("1"));
        webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{servletName, "/" + servletName}, "ServletName");
    }

    public static void removeServiceFromDD(Project prj, JaxWsService service) throws IOException {
        WebApp webApp = WSUtils.getWebApp(prj);
        if (webApp != null) {
            boolean changed = WSUtils.removeServiceFromDD(webApp, service.getServiceName());
            boolean hasMoreWebServices = false;
            Servlet[] remainingServlets = webApp.getServlet();
            for (int i = 0; i < remainingServlets.length; ++i) {
                if (!SERVLET_CLASS_NAME.equals(remainingServlets[i].getServletClass())) continue;
                hasMoreWebServices = true;
                break;
            }
            if (!hasMoreWebServices) {
                Listener[] listeners = webApp.getListener();
                for (int i = 0; i < listeners.length; ++i) {
                    Listener listener = listeners[i];
                    if (!SERVLET_LISTENER.equals(listener.getListenerClass())) continue;
                    webApp.removeListener(listener);
                    changed = true;
                    break;
                }
            }
            if (changed) {
                webApp.write(WSUtils.getDeploymentDescriptor(prj));
            }
        }
    }

    private static void removeServicesFromDD(Project prj, JAXWSLightSupport jaxWsSupport) throws IOException {
        WebApp webApp = WSUtils.getWebApp(prj);
        if (webApp != null) {
            boolean changed = false;
            for (JaxWsService service : jaxWsSupport.getServices()) {
                changed = WSUtils.removeServiceFromDD(webApp, service.getServiceName());
            }
            Listener[] listeners = webApp.getListener();
            for (int i = 0; i < listeners.length; ++i) {
                Listener listener = listeners[i];
                if (!SERVLET_LISTENER.equals(listener.getListenerClass())) continue;
                webApp.removeListener(listener);
                changed = true;
                break;
            }
            if (changed) {
                webApp.write(WSUtils.getDeploymentDescriptor(prj));
            }
        }
    }

    private static boolean removeServiceFromDD(WebApp webApp, String serviceName) {
        boolean changed = false;
        Servlet[] servlets = webApp.getServlet();
        for (int i = 0; i < servlets.length; ++i) {
            Servlet servlet = servlets[i];
            if (!servlet.getServletName().equals(serviceName)) continue;
            webApp.removeServlet(servlet);
            changed = true;
            break;
        }
        ServletMapping[] mappings = webApp.getServletMapping();
        for (int i = 0; i < mappings.length; ++i) {
            ServletMapping mapping = mappings[i];
            if (!mapping.getServletName().equals(serviceName)) continue;
            webApp.removeServletMapping(mapping);
            changed = true;
            break;
        }
        return changed;
    }

    public static void replaceServiceEntriesFromDD(Project prj, String oldServiceName, String newServiceName) throws IOException {
        boolean changed;
        WebApp webApp = WSUtils.getWebApp(prj);
        if (webApp != null && (changed = WSUtils.replaceServiceInDD(webApp, oldServiceName, newServiceName))) {
            webApp.write(WSUtils.getDeploymentDescriptor(prj));
        }
    }

    private static boolean replaceServiceInDD(WebApp webApp, String oldServiceName, String newServiceName) {
        boolean changed = false;
        Servlet[] servlets = webApp.getServlet();
        for (int i = 0; i < servlets.length; ++i) {
            Servlet servlet = servlets[i];
            if (!servlet.getServletName().equals(oldServiceName)) continue;
            servlet.setServletName(newServiceName);
            changed = true;
            break;
        }
        ServletMapping[] mappings = webApp.getServletMapping();
        for (int i = 0; i < mappings.length; ++i) {
            ServletMapping mapping = mappings[i];
            if (!mapping.getServletName().equals(oldServiceName)) continue;
            mapping.setServletName(newServiceName);
            mapping.setUrlPattern("/" + newServiceName);
            break;
        }
        return changed;
    }

    public static void checkNonJSR109Entries(Project prj) {
        WSStack<JaxWs> wsStack;
        JAXWSLightSupport jaxWsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)prj.getProjectDirectory());
        if (jaxWsSupport != null && (wsStack = new WSStackUtils(prj).getWsStack(JaxWs.class)) != null) {
            FileObject ddFolder = jaxWsSupport.getDeploymentDescriptorFolder();
            if (wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109)) {
                if (ddFolder != null && ddFolder.getFileObject("sun-jaxws.xml") != null && WSUtils.removeNonJsr109Artifacts(prj)) {
                    try {
                        WSUtils.removeSunJaxWs(ddFolder);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(WSUtils.class.getName()).log(Level.WARNING, "Cannot remove sun-jaxws.xml file.", ex);
                    }
                    try {
                        WSUtils.removeServicesFromDD(prj, jaxWsSupport);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(WSUtils.class.getName()).log(Level.WARNING, "Cannot remove services from web.xml.", ex);
                    }
                }
            } else if (WSUtils.needNonJsr109Artifacts(prj)) {
                if (ddFolder != null) {
                    try {
                        WSUtils.addJaxWsEntries(ddFolder, jaxWsSupport);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(WSUtils.class.getName()).log(Level.WARNING, "Cannot modify sun-jaxws.xml file", ex);
                    }
                    try {
                        WSUtils.addServicesToDD(prj, jaxWsSupport);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(WSUtils.class.getName()).log(Level.WARNING, "Cannot modify web.xml file", ex);
                    }
                } else {
                    String mes = NbBundle.getMessage(MavenJAXWSSupportImpl.class, (String)"MSG_CannotFindWEB-INF");
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
            }
        }
    }

    public static String getUniqueId(String id, List<JaxWsService> services) {
        String result = id;
        HashSet<String> serviceIdSet = new HashSet<String>();
        for (JaxWsService s : services) {
            String serviceId = s.getId();
            if (serviceId == null) continue;
            serviceIdSet.add(serviceId);
        }
        int i = 1;
        while (serviceIdSet.contains(result)) {
            result = id + "_" + String.valueOf(i++);
        }
        return result;
    }

    static boolean isInSourceGroup(Project prj, String serviceClass) {
        SourceGroup[] sourceGroups;
        if (serviceClass == null) {
            return false;
        }
        String resource = serviceClass.replace('.', '/') + ".java";
        for (SourceGroup group : sourceGroups = ProjectUtils.getSources((Project)prj).getSourceGroups("java")) {
            if (group.getRootFolder() == null || group.getRootFolder().getFileObject(resource) == null) continue;
            return true;
        }
        return false;
    }
}

