/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MavenProjectRestSupport
extends WebRestSupport {
    private static final String DEPLOYMENT_GOAL = "package";
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    public static final String ACTION_PROPERTY_DEPLOY_OPEN = "netbeans.deploy.open.in.browser";
    private static final String TEST_SERVICES_HTML = "test-services.html";
    String[] classPathTypes = new String[]{"classpath/compile"};

    public MavenProjectRestSupport(Project project) {
        super(project);
    }

    public void ensureRestDevelopmentReady() throws IOException {
        String configType = this.getProjectProperty("rest.config.type");
        WebRestSupport.RestConfig restConfig = null;
        boolean hasJaxRs = this.hasJaxRsApi();
        if (!hasJaxRs && configType == null && this.getApplicationPathFromDD() == null && (restConfig = this.setApplicationConfigProperty(false)) == WebRestSupport.RestConfig.DD) {
            this.addResourceConfigToWebApp(restConfig.getResourcePath());
        }
        if (SwingUtilities.isEventDispatchThread()) {
            final WebRestSupport.RestConfig config = restConfig;
            final IOException[] exception = new IOException[1];
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MavenProjectRestSupport.this.addSwdpLibrary(config);
                    }
                    catch (IOException e) {
                        exception[0] = e;
                    }
                }
            };
            AtomicBoolean cancel = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)NbBundle.getMessage(MavenProjectRestSupport.class, (String)"TTL_ExtendProjectClasspath"), (AtomicBoolean)cancel, (boolean)false);
            if (exception[0] != null) {
                throw exception[0];
            }
        } else {
            this.addSwdpLibrary(restConfig);
        }
    }

    public void enableRestSupport(final WebRestSupport.RestConfig config) {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MavenProjectRestSupport.this.enableRestSupport(config);
                }
            };
            AtomicBoolean cancel = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)NbBundle.getMessage(MavenProjectRestSupport.class, (String)"TTL_ExtendProjectClasspath"), (AtomicBoolean)cancel, (boolean)false);
        } else {
            super.enableRestSupport(config);
        }
    }

    public void removeRestDevelopmentReadiness() throws IOException {
        this.removeResourceConfigFromWebApp();
        this.removeSwdpLibrary(new String[]{"classpath/compile"});
    }

    public boolean isReady() {
        return this.isRestSupportOn() && this.hasSwdpLibrary() && this.hasRestServletAdaptor();
    }

    public String getContextRootURL() {
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceID = provider.getServerInstanceID();
        if ("DEV-NULL".equals(serverInstanceID)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RestSupport.class, (String)"MSG_MissingServer"), 0));
            return "";
        }
        return super.getContextRootURL();
    }

    public boolean hasSwdpLibrary() {
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (srcGroups.length > 0) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)srcGroups[0].getRootFolder(), (String)"classpath/compile");
            FileObject contextFO = classPath.findResource("javax/ws/rs/core/Context.class");
            return contextFO != null;
        }
        return false;
    }

    public String getBaseURL() throws IOException {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            StringBuilder servletNames = new StringBuilder();
            StringBuilder urlPatterns = new StringBuilder();
            int i = 0;
            for (ServletMapping mapping : webApp.getServletMapping()) {
                servletNames.append(i > 0 ? "," : "");
                servletNames.append(mapping.getServletName());
                urlPatterns.append(i > 0 ? "," : "");
                urlPatterns.append(mapping.getUrlPattern());
                ++i;
            }
            return this.getContextRootURL() + "||" + servletNames + "||" + urlPatterns;
        }
        throw new IOException("Cannot read web.xml");
    }

    private void addSwdpLibrary(WebRestSupport.RestConfig config) throws IOException {
        JaxRsStackSupport support;
        boolean addLibrary = false;
        if (!this.hasSwdpLibrary()) {
            addLibrary = true;
            boolean jsr311Added = false;
            if (config != null && config.isServerJerseyLibSelected() && (support = this.getJaxRsStackSupport()) != null) {
                jsr311Added = support.addJsr311Api(this.project);
            }
            if (!jsr311Added) {
                JaxRsStackSupport.getDefault().addJsr311Api(this.project);
            }
        }
        if (config != null) {
            boolean added = false;
            if (config.isServerJerseyLibSelected() && (support = this.getJaxRsStackSupport()) != null) {
                added = support.extendsJerseyProjectClasspath(this.project);
            }
            if (!added && config.isJerseyLibSelected()) {
                JaxRsStackSupport.getDefault().extendsJerseyProjectClasspath(this.project);
            }
        } else if (addLibrary) {
            JaxRsStackSupport.getDefault().extendsJerseyProjectClasspath(this.project);
        }
    }

    public Datasource getDatasource(String jndiName) {
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        try {
            return provider.getConfigSupport().findDatasource(jndiName);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public boolean isRestSupportOn() {
        return this.getProjectProperty("rest.config.type") != null;
    }

    public FileObject generateTestClient(File testdir, String url) throws IOException {
        return this.generateMavenTester(testdir, url);
    }

    public FileObject generateTestClient(File testdir) throws IOException {
        return this.generateMavenTester(testdir, this.getBaseURL());
    }

    public void deploy() {
        RunConfig config = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (Project)this.project, (String)NbBundle.getMessage(MavenProjectRestSupport.class, (String)"MSG_Deploy", (Object)((ProjectInformation)this.getProject().getLookup().lookup(ProjectInformation.class)).getDisplayName()), Collections.singletonList(DEPLOYMENT_GOAL));
        config.setProperty(ACTION_PROPERTY_DEPLOY_OPEN, Boolean.FALSE.toString());
        ExecutorTask task = RunUtils.executeMaven((RunConfig)config);
        task.waitFinished();
    }

    public File getLocalTargetTestRest() {
        try {
            FileObject mainFolder = this.project.getProjectDirectory().getFileObject("src/main");
            if (mainFolder != null) {
                FileObject resourcesFolder = mainFolder.getFileObject("resources");
                if (resourcesFolder == null) {
                    resourcesFolder = mainFolder.createFolder("resources");
                }
                if (resourcesFolder != null) {
                    FileObject restFolder = resourcesFolder.getFileObject("rest");
                    if (restFolder == null) {
                        restFolder = resourcesFolder.createFolder("rest");
                    }
                    return FileUtil.toFile((FileObject)restFolder);
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger(MavenProjectRestSupport.class.getName()).log(Level.WARNING, null, e);
        }
        return null;
    }

    private FileObject generateMavenTester(File testdir, String baseURL) throws IOException {
        String[] replaceKeys1 = new String[]{"TTL_TEST_RESBEANS", "MSG_TEST_RESBEANS_INFO"};
        String[] replaceKeys2 = new String[]{"MSG_TEST_RESBEANS_wadlErr", "MSG_TEST_RESBEANS_No_AJAX", "MSG_TEST_RESBEANS_Resource", "MSG_TEST_RESBEANS_See", "MSG_TEST_RESBEANS_No_Container", "MSG_TEST_RESBEANS_Content", "MSG_TEST_RESBEANS_TabularView", "MSG_TEST_RESBEANS_RawView", "MSG_TEST_RESBEANS_ResponseHeaders", "MSG_TEST_RESBEANS_Help", "MSG_TEST_RESBEANS_TestButton", "MSG_TEST_RESBEANS_Loading", "MSG_TEST_RESBEANS_Status", "MSG_TEST_RESBEANS_Headers", "MSG_TEST_RESBEANS_HeaderName", "MSG_TEST_RESBEANS_HeaderValue", "MSG_TEST_RESBEANS_Insert", "MSG_TEST_RESBEANS_NoContents", "MSG_TEST_RESBEANS_AddParamButton", "MSG_TEST_RESBEANS_Monitor", "MSG_TEST_RESBEANS_No_SubResources", "MSG_TEST_RESBEANS_SubResources", "MSG_TEST_RESBEANS_ChooseMethod", "MSG_TEST_RESBEANS_ChooseMime", "MSG_TEST_RESBEANS_Continue", "MSG_TEST_RESBEANS_AdditionalParams", "MSG_TEST_RESBEANS_INFO", "MSG_TEST_RESBEANS_Request", "MSG_TEST_RESBEANS_Sent", "MSG_TEST_RESBEANS_Received", "MSG_TEST_RESBEANS_TimeStamp", "MSG_TEST_RESBEANS_Response", "MSG_TEST_RESBEANS_CurrentSelection", "MSG_TEST_RESBEANS_DebugWindow", "MSG_TEST_RESBEANS_Wadl", "MSG_TEST_RESBEANS_RequestFailed"};
        FileObject testFO = this.copyFileAndReplaceBaseUrl(testdir, TEST_SERVICES_HTML, replaceKeys1, baseURL);
        MavenProjectRestSupport.copyFile((File)testdir, (String)"test-resbeans.js", (String[])replaceKeys2, (boolean)false);
        MavenProjectRestSupport.copyFile((File)testdir, (String)"test-resbeans.css");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"css_master-all.css");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"expand.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"collapse.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"item.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"cc.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"og.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"cg.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"app.gif");
        File testdir2 = new File(testdir, "images");
        testdir2.mkdir();
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/background_border_bottom.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/pbsel.png");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/bg_gradient.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/pname.png");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/level1_selected-1lvl.jpg");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/primary-enabled.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/masthead.png");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/primary-roll.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/pbdis.png");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/secondary-enabled.gif");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/pbena.png");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/tbsel.png");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/pbmou.png");
        MavenProjectRestSupport.copyFile((File)testdir, (String)"images/tbuns.png");
        return testFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject copyFileAndReplaceBaseUrl(File testdir, String name, String[] replaceKeys, String baseURL) throws IOException {
        FileObject dir = FileUtil.toFileObject((File)testdir);
        FileObject fo = dir.getFileObject(name);
        if (fo == null) {
            fo = dir.createData(name);
        }
        FileLock lock = null;
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            int i;
            lock = fo.lock();
            OutputStream os = fo.getOutputStream(lock);
            writer = new BufferedWriter(new OutputStreamWriter(os, Charset.forName("UTF-8")));
            InputStream is = RestSupport.class.getResourceAsStream("resources/" + name);
            reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String lineSep = "\n";
            if (File.separatorChar == '\\') {
                lineSep = "\r\n";
            }
            String[] replaceValues = null;
            if (replaceKeys != null) {
                replaceValues = new String[replaceKeys.length];
                for (i = 0; i < replaceKeys.length; ++i) {
                    replaceValues[i] = NbBundle.getMessage(RestSupport.class, (String)replaceKeys[i]);
                }
            }
            while ((line = reader.readLine()) != null) {
                for (i = 0; i < replaceKeys.length; ++i) {
                    line = line.replaceAll(replaceKeys[i], replaceValues[i]);
                }
                line = line.replace("${BASE_URL}", baseURL);
                writer.write(line);
                writer.write(lineSep);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return fo;
    }

    protected void logResourceCreation(Project prj) {
        Object[] params = new Object[]{"JAX-RS", this.project.getClass().getName(), "RESOURCE"};
        LogUtils.logWsDetect((Object[])params);
    }

    public String getProjectProperty(String name) {
        Preferences prefs = ProjectUtils.getPreferences((Project)this.project, MavenProjectRestSupport.class, (boolean)true);
        if (prefs != null) {
            return prefs.get(name, null);
        }
        return null;
    }

    public void setPrivateProjectProperty(String name, String value) {
        this.setProjectProperty(name, value);
    }

    public void setProjectProperty(String name, String value) {
        Preferences prefs = ProjectUtils.getPreferences((Project)this.project, MavenProjectRestSupport.class, (boolean)true);
        if (prefs != null) {
            prefs.put(name, value);
        }
    }

    public void removeProjectProperties(String[] propertyNames) {
        Preferences prefs = ProjectUtils.getPreferences((Project)this.project, MavenProjectRestSupport.class, (boolean)true);
        if (prefs != null) {
            for (String p : propertyNames) {
                prefs.remove(p);
            }
        }
    }

    public int getProjectType() {
        String packagingType;
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject != null && (packagingType = nbMavenProject.getPackagingType()) != null) {
            if ("jar".equals(packagingType)) {
                return 0;
            }
            if ("war".equals(packagingType)) {
                return 1;
            }
            if ("nbm".equals(packagingType) || "nbm-application".equals(packagingType)) {
                return 2;
            }
        }
        return 0;
    }
}

