/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MavenJAXWSSupportImpl
implements JAXWSLightSupportImpl {
    private Project prj;
    private List<JaxWsService> services = new LinkedList<JaxWsService>();
    public static final String CATALOG_PATH = "src/jax-ws-catalog.xml";
    private static final String SERVLET_CLASS_NAME = "com.sun.xml.ws.transport.http.servlet.WSServlet";
    private static final String SERVLET_LISTENER = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";

    MavenJAXWSSupportImpl(Project prj) {
        this.prj = prj;
    }

    public void addService(JaxWsService service) {
        boolean generateNonJsr109Stuff;
        this.services.add(service);
        if (service.isServiceProvider() && !WSUtils.isJsr109Supported(this.prj) && (generateNonJsr109Stuff = WSUtils.needNonJsr109Artifacts(this.prj))) {
            try {
                WSUtils.addServiceToDD(this.prj, service);
            }
            catch (IOException ex) {
                Logger.getLogger(MavenJAXWSSupportImpl.class.getName()).log(Level.WARNING, "Cannot add service elements to web.xml file", ex);
            }
            try {
                this.addSunJaxWsEntries(service);
            }
            catch (IOException ex) {
                Logger.getLogger(MavenJAXWSSupportImpl.class.getName()).log(Level.WARNING, "Cannot modify sun-jaxws.xml file", ex);
            }
        }
    }

    private void addSunJaxWsEntries(JaxWsService service) throws IOException {
        FileObject ddFolder = this.getDeploymentDescriptorFolder();
        if (ddFolder != null) {
            WSUtils.addSunJaxWsEntry(ddFolder, service);
        } else {
            String mes = NbBundle.getMessage(MavenJAXWSSupportImpl.class, (String)"MSG_CannotFindWEB-INF");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    public List<JaxWsService> getServices() {
        return this.services;
    }

    public void removeService(JaxWsService service) {
        Preferences prefs;
        FileObject wsdlFo;
        FileObject wsdlFolder;
        String localWsdl = service.getLocalWsdl();
        if (localWsdl != null && (wsdlFolder = this.getWsdlFolder(false)) != null && (wsdlFo = wsdlFolder.getFileObject(localWsdl)) != null && (prefs = ProjectUtils.getPreferences((Project)this.prj, MavenWebService.class, (boolean)true)) != null) {
            prefs.remove("_C_" + service.getId());
            prefs.remove("_S_" + service.getId());
        }
        if (service.isServiceProvider() && !WSUtils.isJsr109Supported(this.prj)) {
            try {
                WSUtils.removeServiceFromDD(this.prj, service);
            }
            catch (IOException ex) {
                Logger.getLogger(MavenJAXWSSupportImpl.class.getName()).log(Level.WARNING, "Cannot remove services from web.xml", ex);
            }
            try {
                this.removeSunJaxWsEntries(service);
            }
            catch (IOException ex) {
                Logger.getLogger(MavenJAXWSSupportImpl.class.getName()).log(Level.WARNING, "Cannot modify sun-jaxws.xml file", ex);
            }
        }
        this.services.remove(service);
    }

    private void removeSunJaxWsEntries(JaxWsService service) throws IOException {
        FileObject ddFolder = this.getDeploymentDescriptorFolder();
        if (ddFolder != null) {
            WSUtils.removeSunJaxWsEntry(ddFolder, service);
        } else {
            String mes = NbBundle.getMessage(MavenJAXWSSupportImpl.class, (String)"MSG_CannotFindWEB-INF");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    public FileObject getDeploymentDescriptorFolder() {
        File wsdlDir = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.prj.getProjectDirectory()), (String)"src/main/webapp/WEB-INF");
        if (wsdlDir.exists()) {
            return FileUtil.toFileObject((File)wsdlDir);
        }
        return null;
    }

    public FileObject getWsdlFolder(boolean createFolder) {
        boolean created;
        File wsdlDir = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.prj.getProjectDirectory()), (String)"src/wsdl");
        if (wsdlDir.exists()) {
            return FileUtil.toFileObject((File)wsdlDir);
        }
        if (createFolder && (created = wsdlDir.mkdirs())) {
            return FileUtil.toFileObject((File)wsdlDir);
        }
        return null;
    }

    public FileObject getBindingsFolder(boolean createFolder) {
        boolean created;
        File bindingsDir = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.prj.getProjectDirectory()), (String)"src/jaxws-bindings");
        if (bindingsDir.exists()) {
            return FileUtil.toFileObject((File)bindingsDir);
        }
        if (createFolder && (created = bindingsDir.mkdirs())) {
            return FileUtil.toFileObject((File)bindingsDir);
        }
        return null;
    }

    public URL getCatalog() {
        File catalogFile = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.prj.getProjectDirectory()), (String)CATALOG_PATH);
        try {
            return catalogFile.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        J2eeModuleProvider provider = WSUtils.getModuleProvider(this.prj);
        if (provider == null) {
            return null;
        }
        J2eeModule module = provider.getJ2eeModule();
        if (module == null) {
            return null;
        }
        return module.getMetadataModel(WebservicesMetadata.class);
    }
}

