/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.options;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mobility.svgcore.api.snippets.SVGSnippetsProvider;
import org.netbeans.modules.mobility.svgcore.options.SvgcoreOptionsPanelController;
import org.netbeans.modules.mobility.svgcore.options.SvgcoreSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class SvgcorePanel
extends JPanel {
    private final SvgcoreOptionsPanelController controller;
    private JButton jButtonBrowse;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField pathTextField;

    SvgcorePanel(SvgcoreOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(SvgcorePanel.getListSnippets());
        this.jComboBox1.setModel(model);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.pathTextField = new JTextField();
        this.jButtonBrowse = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_SVGFrame"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_EditorFrame"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_SnippetsName"));
        this.jLabel2.setPreferredSize(new Dimension(136, 16));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_AnimatorPath"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowse, (String)NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_ButtonChange"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SvgcorePanel.this.jButtonBrowseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(5, 5, 5).addComponent(this.pathTextField, -1, 81, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBrowse, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jSeparator1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jComboBox1, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jSeparator2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.pathTextField, -2, -1, -2).addComponent(this.jButtonBrowse)).addContainerGap()));
        layout.linkSize(1, this.jComboBox1, this.jLabel2);
        layout.linkSize(1, this.jButtonBrowse, this.jLabel1, this.pathTextField);
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.pathTextField.getText());
        chooser.setFileSelectionMode(0);
        int r = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_Select"));
        if (r == 0) {
            File file = chooser.getSelectedFile();
            if (!file.isFile()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SvgcorePanel.class, (String)"ERROR_NotFile", (Object)file), 2));
                return;
            }
            this.pathTextField.setText(file.getAbsoluteFile().toString());
        }
    }

    void load() {
        this.pathTextField.setText(SvgcoreSettings.getDefault().getExternalEditorPath());
        this.jComboBox1.setSelectedItem(SvgcoreSettings.getDefault().getCurrentSnippet());
    }

    void store() {
        SvgcoreSettings.getDefault().setExternalEditorPath(this.pathTextField.getText());
        SvgcoreSettings.getDefault().setCurrentSnippet((String)this.jComboBox1.getSelectedItem());
    }

    boolean valid() {
        return true;
    }

    private static final String[] getListSnippets() {
        Collection snippetCollection = Lookup.getDefault().lookupAll(SVGSnippetsProvider.class);
        String[] names = new String[snippetCollection.size()];
        int i = 0;
        for (SVGSnippetsProvider provider : snippetCollection) {
            names[i++] = provider.getDisplayName();
        }
        return names;
    }
}

