/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.DependencyTreeFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.spi.ui.ArtifactViewerFactory;
import org.netbeans.modules.maven.indexer.spi.ui.ArtifactViewerPanelProvider;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.repository.dependency.AddAsDependencyAction;
import org.netbeans.modules.maven.repository.ui.Bundle;
import org.netbeans.modules.maven.repository.ui.ErrorPanel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ArtifactMultiViewFactory
implements ArtifactViewerFactory {
    private static final RequestProcessor RP = new RequestProcessor(ArtifactMultiViewFactory.class);
    private static final String MAVEN_TC_PROPERTY = "mvn_tc_id";

    @NonNull
    public Lookup createLookup(@NonNull Artifact artifact, @NullAllowed List<ArtifactRepository> repos) {
        return this.createViewerLookup(null, artifact, repos);
    }

    @NonNull
    public Lookup createLookup(@NonNull NBVersionInfo info) {
        return this.createViewerLookup(info, RepositoryUtil.createArtifact((NBVersionInfo)info), null);
    }

    @CheckForNull
    public Lookup createLookup(@NonNull Project prj) {
        NbMavenProject mvPrj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        MavenProject mvn = mvPrj.getMavenProject();
        Artifact artifact = mvn.getArtifact();
        return artifact != null ? this.createPomEditorLookup(prj, artifact) : null;
    }

    @NonNull
    public TopComponent createTopComponent(@NonNull Lookup lookup) {
        Artifact artifact = (Artifact)lookup.lookup(Artifact.class);
        assert (artifact != null);
        TopComponent existing = ArtifactMultiViewFactory.findExistingTc(artifact);
        if (existing != null) {
            return existing;
        }
        Collection provs = Lookup.getDefault().lookupAll(ArtifactViewerPanelProvider.class);
        MultiViewDescription[] panels = new MultiViewDescription[provs.size()];
        int i = 0;
        for (ArtifactViewerPanelProvider prov : provs) {
            panels[i] = prov.createPanel(lookup);
            ++i;
        }
        TopComponent tc = MultiViewFactory.createMultiView((MultiViewDescription[])panels, (MultiViewDescription)panels[0]);
        tc.setDisplayName(artifact.getArtifactId() + ":" + artifact.getVersion());
        tc.setToolTipText(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion());
        tc.putClientProperty((Object)MAVEN_TC_PROPERTY, (Object)ArtifactMultiViewFactory.getTcId(artifact));
        return tc;
    }

    @NonNull
    private Lookup createViewerLookup(final @NullAllowed NBVersionInfo info, @NonNull Artifact artifact, final @NullAllowed List<ArtifactRepository> fRepos) {
        final InstanceContent ic = new InstanceContent();
        AbstractLookup lookup = new AbstractLookup((AbstractLookup.Content)ic);
        ic.add((Object)artifact);
        if (info != null) {
            ic.add((Object)info);
        }
        final Artifact fArt = artifact;
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MavenEmbedder embedder = EmbedderFactory.getOnlineEmbedder();
                AggregateProgressHandle hndl = AggregateProgressFactory.createHandle((String)Bundle.Progress_Download(), (ProgressContributor[])new ProgressContributor[]{AggregateProgressFactory.createProgressContributor((String)"zaloha")}, (Cancellable)ProgressTransferListener.cancellable(), null);
                ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)hndl);
                hndl.start();
                try {
                    MavenProject mvnprj;
                    ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
                    if (fRepos != null) {
                        repos.addAll(fRepos);
                    }
                    if (repos.isEmpty()) {
                        String url;
                        RepositoryInfo rinfo;
                        repos.add(embedder.createRemoteRepository("http://repo.maven.apache.org/maven2", "central"));
                        if (info != null && !"central".equals(info.getRepoId()) && (rinfo = RepositoryPreferences.getInstance().getRepositoryInfoById(info.getRepoId())) != null && (url = rinfo.getRepositoryUrl()) != null) {
                            repos.add(embedder.createRemoteRepository(url, rinfo.getId()));
                        }
                    }
                    if ((mvnprj = ArtifactMultiViewFactory.readMavenProject(embedder, fArt, repos)) != null) {
                        DependencyNode root = DependencyTreeFactory.createDependencyTree((MavenProject)mvnprj, (MavenEmbedder)embedder, (String)"test");
                        ic.add((Object)root);
                        ic.add((Object)mvnprj);
                    }
                }
                catch (ProjectBuildingException ex) {
                    ErrorPanel pnl = new ErrorPanel((Exception)((Object)ex));
                    DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Error());
                    JButton close = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)close, (String)Bundle.BTN_CLOSE());
                    dd.setOptions(new Object[]{close});
                    dd.setClosingOptions(new Object[]{close});
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    ic.add((Object)new MavenProject());
                }
                catch (ThreadDeath d) {
                }
                catch (IllegalStateException ise) {
                    if (!(ise.getCause() instanceof ThreadDeath)) {
                        throw ise;
                    }
                }
                finally {
                    hndl.finish();
                    ProgressTransferListener.clearAggregateHandle();
                }
            }
        });
        Action[] toolbarActions = new Action[]{new AddAsDependencyAction(fArt), CommonArtifactActions.createScmCheckoutAction((Lookup)lookup), CommonArtifactActions.createLibraryAction((Lookup)lookup)};
        ic.add((Object)toolbarActions);
        return lookup;
    }

    private static MavenProject readMavenProject(MavenEmbedder embedder, Artifact artifact, List<ArtifactRepository> remoteRepos) throws ProjectBuildingException {
        MavenProjectBuilder bldr = (MavenProjectBuilder)embedder.lookupComponent(MavenProjectBuilder.class);
        assert (bldr != null) : "MavenProjectBuilder component not found in maven";
        embedder.setUpLegacySupport();
        return bldr.buildFromRepository(artifact, remoteRepos, embedder.getLocalRepository());
    }

    private static TopComponent findExistingTc(Artifact artifact) {
        String id = ArtifactMultiViewFactory.getTcId(artifact);
        Set tcs = WindowManager.getDefault().getRegistry().getOpened();
        for (TopComponent tc : tcs) {
            if (!id.equals(tc.getClientProperty((Object)MAVEN_TC_PROPERTY))) continue;
            return tc;
        }
        return null;
    }

    private static String getTcId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    private Lookup createPomEditorLookup(final Project prj, @NonNull Artifact artifact) {
        final InstanceContent ic = new InstanceContent();
        AbstractLookup lookup = new AbstractLookup((AbstractLookup.Content)ic);
        ic.add((Object)artifact);
        if (prj != null) {
            ic.add((Object)prj);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    POMModel model;
                    ModelSource ms;
                    NbMavenProject im = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
                    MavenProject mvnprj = im.getMavenProject();
                    DependencyNode tree = DependencyTreeFactory.createDependencyTree((MavenProject)mvnprj, (MavenEmbedder)EmbedderFactory.getProjectEmbedder(), (String)"test");
                    FileObject fo = (FileObject)prj.getLookup().lookup(FileObject.class);
                    POMModel pommodel = null;
                    if (fo != null && (ms = Utilities.createModelSource((FileObject)fo)).isEditable() && (model = POMModelFactory.getDefault().getModel(ms)) != null) {
                        pommodel = model;
                    }
                    if (pommodel != null) {
                        ic.add(pommodel);
                    }
                    ic.add((Object)tree);
                    ic.add((Object)mvnprj);
                }
            });
        }
        Action[] toolbarActions = new Action[]{new AddAsDependencyAction(artifact), CommonArtifactActions.createScmCheckoutAction((Lookup)lookup), CommonArtifactActions.createLibraryAction((Lookup)lookup)};
        ic.add((Object)toolbarActions);
        return lookup;
    }
}

