/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.register;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URISyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.repository.register.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RepositoryRegisterUI
extends JPanel {
    private boolean modify = false;
    private boolean alreadyFilled = false;
    private JButton btnOK;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel lblHeader;
    private JLabel lblRepoId;
    private JLabel lblRepoName;
    private JLabel lblRepoUrl;
    private JLabel lblValidate;
    private JTextField txtRepoId;
    private JTextField txtRepoName;
    private JTextField txtRepoUrl;

    public RepositoryRegisterUI() {
        this.initComponents();
        this.validateInfo();
    }

    public RepositoryRegisterUI(RepositoryInfo info) {
        this();
        this.modify(info);
        this.validateInfo();
        this.btnOK.setText(Bundle.LBL_Repo_EDIT());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.btnOK = new JButton();
        this.lblHeader = new JLabel();
        this.lblRepoId = new JLabel();
        this.txtRepoId = new JTextField();
        this.lblRepoName = new JLabel();
        this.txtRepoName = new JTextField();
        this.lblRepoUrl = new JLabel();
        this.txtRepoUrl = new JTextField();
        this.lblValidate = new JLabel();
        this.jLabel1 = new JLabel();
        this.btnOK.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"CMB_Repo_ADD", (Object[])new Object[0]));
        this.btnOK.setEnabled(false);
        this.lblHeader.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Register_Header", (Object[])new Object[0]));
        this.lblRepoId.setLabelFor(this.txtRepoId);
        Mnemonics.setLocalizedText((JLabel)this.lblRepoId, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_ID", (Object[])new Object[0]));
        this.txtRepoId.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RepositoryRegisterUI.this.txtRepoIdKeyReleased(evt);
            }
        });
        this.lblRepoName.setLabelFor(this.txtRepoName);
        Mnemonics.setLocalizedText((JLabel)this.lblRepoName, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_Name", (Object[])new Object[0]));
        this.txtRepoName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RepositoryRegisterUI.this.txtRepoNameKeyReleased(evt);
            }
        });
        this.lblRepoUrl.setLabelFor(this.txtRepoUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblRepoUrl, (String)NbBundle.getMessage(RepositoryRegisterUI.class, (String)"LBL_Repo_URL", (Object[])new Object[0]));
        this.txtRepoUrl.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RepositoryRegisterUI.this.txtRepoUrlKeyReleased(evt);
            }
        });
        this.lblValidate.setForeground(new Color(204, 0, 0));
        this.jLabel1.setText(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.jLabel1.text"));
        this.jLabel1.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRepoId).addComponent(this.lblRepoName).addComponent(this.lblRepoUrl)).addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtRepoId).addComponent(this.txtRepoName).addComponent(this.txtRepoUrl)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblValidate, -1, -1, Short.MAX_VALUE).addContainerGap(456, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblHeader, -1, 515, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(6, 6, 6)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblHeader).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblRepoId).addComponent(this.txtRepoId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblRepoName).addComponent(this.txtRepoName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblRepoUrl).addComponent(this.txtRepoUrl, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 57, Short.MAX_VALUE).addComponent(this.lblValidate, -2, 17, -2)));
        this.txtRepoId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.txtRepoId.AccessibleContext.accessibleDescription"));
        this.txtRepoName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.txtRepoName.AccessibleContext.accessibleDescription"));
        this.txtRepoUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryRegisterUI.class, (String)"RepositoryRegisterUI.txtRepoUrl.AccessibleContext.accessibleDescription"));
    }

    private void selectRemoteRepo(boolean checkValidity) {
        this.txtRepoUrl.setEnabled(true);
        if (checkValidity) {
            this.validateInfo();
        }
    }

    private void txtRepoIdKeyReleased(KeyEvent evt) {
        this.validateInfo();
    }

    private void txtRepoNameKeyReleased(KeyEvent evt) {
        this.validateInfo();
    }

    private void txtRepoUrlKeyReleased(KeyEvent evt) {
        this.validateInfo();
    }

    private void modify(RepositoryInfo info) {
        this.modify = true;
        this.txtRepoId.setEnabled(false);
        this.txtRepoId.setText(info.getId());
        this.txtRepoName.setText(info.getName());
        if (info.isLocal()) {
            throw new IllegalStateException("cannot modify local repository definition");
        }
        if (info.isRemoteDownloadable()) {
            this.txtRepoUrl.setText(info.getRepositoryUrl());
        }
    }

    public RepositoryInfo getRepositoryInfo() throws URISyntaxException {
        return new RepositoryInfo(this.txtRepoId.getText().trim(), this.txtRepoName.getText().trim(), null, this.txtRepoUrl.getText().trim());
    }

    private void validateInfo() {
        String id = this.txtRepoId.getText().trim();
        if (id.length() == 0) {
            this.btnOK.setEnabled(false);
            this.lblValidate.setText(Bundle.LBL_Repo_id_Error1());
            return;
        }
        if (id.indexOf(47) != -1) {
            this.btnOK.setEnabled(false);
            this.lblValidate.setText(Bundle.LBL_Repo_id_slash());
            return;
        }
        if (!this.modify) {
            RepositoryInfo info = RepositoryPreferences.getInstance().getRepositoryInfoById(id);
            if (info != null && (info.isLocal() || info.isRemoteDownloadable())) {
                this.btnOK.setEnabled(false);
                this.lblValidate.setText(Bundle.LBL_Repo_id_Error2());
                return;
            }
            if (info != null && !this.alreadyFilled) {
                this.txtRepoUrl.setText(info.getRepositoryUrl());
                this.txtRepoName.setText(info.getName());
                this.selectRemoteRepo(false);
                this.alreadyFilled = true;
            }
        }
        if (this.txtRepoName.getText().trim().length() == 0) {
            this.btnOK.setEnabled(false);
            this.lblValidate.setText(Bundle.LBL_Repo_Name_Error1());
            return;
        }
        if (this.txtRepoUrl.getText().trim().length() == 0) {
            this.btnOK.setEnabled(false);
            this.lblValidate.setText(Bundle.LBL_Repo_Url_Error());
            return;
        }
        this.lblValidate.setText("");
        this.btnOK.setEnabled(true);
    }

    public JButton getButton() {
        return this.btnOK;
    }
}

