/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.JCheckTree;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.api.GestureSubmitter;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderType;
import org.netbeans.modules.profiler.selector.api.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.api.nodes.ConstructorNode;
import org.netbeans.modules.profiler.selector.api.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.api.nodes.MethodNode;
import org.netbeans.modules.profiler.selector.api.nodes.PackageNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.Bundle;
import org.netbeans.modules.profiler.selector.ui.CancellableController;
import org.netbeans.modules.profiler.selector.ui.SearchPanel;
import org.netbeans.modules.profiler.selector.ui.TreePathSearch;
import org.netbeans.modules.profiler.utilities.trees.NodeFilter;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public class RootSelectorTree
extends JPanel {
    private static final MethodNameFormatterFactory methodFormatterFactory = MethodNameFormatterFactory.getDefault((MethodNameFormatter)new DefaultMethodNameFormatter(5));
    private static final Comparator<ClientUtils.SourceCodeSelection> containmentComparator = new Comparator<ClientUtils.SourceCodeSelection>(){

        @Override
        public int compare(ClientUtils.SourceCodeSelection o1, ClientUtils.SourceCodeSelection o2) {
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1.equals((Object)o2)) {
                return 0;
            }
            if (o1.contains(o2)) {
                return -1;
            }
            if (o2.contains(o1)) {
                return 1;
            }
            return o1.toFlattened().compareTo(o2.toFlattened());
        }
    };
    private JCheckTree tree = new JCheckTree(){

        public String getToolTipText(MouseEvent event) {
            TreePath tp = RootSelectorTree.this.tree.getPathForLocation(event.getX(), event.getY());
            if (tp != null && tp.getPathCount() > 1) {
                while (tp != null) {
                    TreeNode n = (TreeNode)tp.getLastPathComponent();
                    if (n instanceof SelectorNode) {
                        SourceMethodInfo mi;
                        if (tp.getPathCount() == 2) {
                            return ((SelectorNode)n).getDisplayName();
                        }
                        String txt = null;
                        if (n instanceof PackageNode) {
                            txt = ((PackageNode)n).getPackageInfo().getBinaryName();
                        } else if (n instanceof ClassNode) {
                            txt = ((ClassNode)n).getClassInfo().getQualifiedName();
                        } else if (n instanceof MethodNode) {
                            mi = ((MethodNode)n).getMethodInfo();
                            txt = methodFormatterFactory.getFormatter().formatMethodName(mi.getClassName(), mi.getName(), mi.getSignature()).toFormatted();
                        } else if (n instanceof ConstructorNode) {
                            mi = ((ConstructorNode)n).getMethodInfo();
                            txt = methodFormatterFactory.getFormatter().formatMethodName(mi.getClassName(), mi.getName(), mi.getSignature()).toFormatted();
                        }
                        if (txt != null) {
                            if (txt.isEmpty()) {
                                txt = "<default>";
                            }
                            return txt;
                        }
                    }
                    tp = tp.getParentPath();
                }
            }
            return super.getToolTipText(event);
        }
    };
    private static final NodeFilter<SelectorNode> DEFAULT_FILTER_INNER = new NodeFilter<SelectorNode>(){

        public boolean match(SelectorNode node) {
            return true;
        }

        public boolean maymatch(SelectorNode node) {
            return true;
        }
    };
    public static NodeFilter<SelectorNode> DEFAULT_FILTER = DEFAULT_FILTER_INNER;
    private static final TreeModel DEFAULTMODEL = new DefaultTreeModel(new DefaultMutableTreeNode(Bundle.RootSelectorTree_EmptyString()));
    public static final String SELECTION_TREE_VIEW_LIST_PROPERTY = "SELECTION_TREE_VIEW_LIST";
    private final Set<ClientUtils.SourceCodeSelection> currentSelectionSet = new HashSet<ClientUtils.SourceCodeSelection>();
    private ProgressDisplayer progress = ProgressDisplayer.DEFAULT;
    private Lookup context = Lookup.EMPTY;
    private SelectionTreeBuilderType builderType = null;
    private SearchPanel searchPanel = null;
    private final TreePathSearch.ClassIndex ci;
    private Cancellable cancellHandler;
    private final AtomicBoolean isActive = new AtomicBoolean(true);
    private final Semaphore semaphore = new Semaphore(1);
    private final Semaphore lazyOpeningSemaphore = new Semaphore(1);
    private TreePathSearch sCont;
    private AtomicBoolean searchInProgress = new AtomicBoolean(false);

    public RootSelectorTree(ProgressDisplayer pd, TreePathSearch.ClassIndex ci) {
        this.progress = pd;
        this.ci = ci;
        this.init();
    }

    public void setContext(Lookup context) {
        this.context = context;
        this.firePropertyChange(SELECTION_TREE_VIEW_LIST_PROPERTY, null, null);
    }

    public void setCancelHandler(Cancellable cancellable) {
        this.cancellHandler = cancellable;
    }

    public void setSelection(ClientUtils.SourceCodeSelection[] selection, Lookup context) {
        this.setSelection(selection);
        this.setContext(context);
    }

    private void setSelection(ClientUtils.SourceCodeSelection[] selection) {
        new SelectionSetter(selection).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getSelection() {
        Set<ClientUtils.SourceCodeSelection> set = this.currentSelectionSet;
        synchronized (set) {
            if (this.currentSelectionSet.isEmpty()) {
                return new ClientUtils.SourceCodeSelection[0];
            }
            ArrayList<ClientUtils.SourceCodeSelection> selectionList = new ArrayList<ClientUtils.SourceCodeSelection>(this.currentSelectionSet);
            Collections.sort(selectionList, containmentComparator);
            this.currentSelectionSet.clear();
            ClientUtils.SourceCodeSelection parentSel = null;
            for (ClientUtils.SourceCodeSelection scs : selectionList) {
                if (parentSel != null && parentSel.contains(scs)) continue;
                parentSel = scs;
                this.currentSelectionSet.add(scs);
            }
            return this.currentSelectionSet.toArray(new ClientUtils.SourceCodeSelection[this.currentSelectionSet.size()]);
        }
    }

    public List<SelectionTreeBuilderType> getBuilderTypes() {
        ArrayList<TypeEntry> entries = new ArrayList<TypeEntry>();
        for (SelectionTreeBuilder builder : this.context.lookupAll(SelectionTreeBuilder.class)) {
            if (builder.estimatedNodeCount() == -1) continue;
            SelectionTreeBuilderType type = builder.getType();
            TypeEntry te = new TypeEntry(type);
            if (entries.contains(te)) {
                int index = entries.indexOf(te);
                te = (TypeEntry)entries.get(index);
                te.frequency = te.frequency + (builder.isPreferred() ? 2 : 1);
                continue;
            }
            te.frequency = builder.isPreferred() ? 2 : 1;
            entries.add(te);
        }
        Collections.sort(entries, new Comparator<TypeEntry>(){

            @Override
            public int compare(TypeEntry o1, TypeEntry o2) {
                if (o1.frequency < o2.frequency) {
                    return 1;
                }
                if (o1.frequency > o2.frequency) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<SelectionTreeBuilderType> types = new ArrayList<SelectionTreeBuilderType>(entries.size());
        for (TypeEntry entry : entries) {
            types.add(entry.type);
        }
        return types;
    }

    public void setBuilderType(SelectionTreeBuilderType type) {
        this.builderType = type;
        this.refreshTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.isActive.set(true);
        this.tree.setModel(DEFAULTMODEL);
        this.context = Lookup.EMPTY;
        this.sCont = null;
        if (this.searchPanel != null) {
            this.searchPanel.reset();
        }
        Set<ClientUtils.SourceCodeSelection> set = this.currentSelectionSet;
        synchronized (set) {
            this.currentSelectionSet.clear();
        }
    }

    public void setRowHeight(int rowHeight) {
        this.tree.setRowHeight(rowHeight);
    }

    public static boolean canBeShown(Lookup ctx) {
        return ctx.lookup(SelectionTreeBuilder.class) != null;
    }

    private void init() {
        CellTipManager.sharedInstance().unregisterComponent((JComponent)this.tree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.tree);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        UIUtils.makeTreeAutoExpandable((JTree)this.tree, (boolean)true);
        this.setupTreeNodeToggleLogic();
        this.addTreeLazyOpening();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setModel(DEFAULTMODEL);
        JScrollPane scrollPane = new JScrollPane((Component)this.tree, 20, 30);
        this.add((Component)scrollPane, "Center");
        if (!Boolean.getBoolean("profiler.roots.hide.libraries")) {
            this.searchPanel = new SearchPanel((JComponent)this.tree){

                @Override
                protected void performFind() {
                    RootSelectorTree.this.tree.requestFocus();
                    RootSelectorTree.this.findNode(this.getSearchText());
                }

                @Override
                protected void performNext() {
                    RootSelectorTree.this.tree.requestFocus();
                    RootSelectorTree.this.find(false);
                }

                @Override
                protected void performPrevious() {
                    RootSelectorTree.this.tree.requestFocus();
                    RootSelectorTree.this.find(true);
                }

                @Override
                protected void onCancel() {
                    RootSelectorTree.this.tree.requestFocus();
                }

                @Override
                protected void onClose() {
                    RootSelectorTree.this.searchPanel.setPermanent(false);
                }
            };
            this.add((Component)this.searchPanel, "South");
        }
        scrollPane.setPreferredSize(this.tree.getPreferredSize());
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void addTreeLazyOpening() {
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){
            private volatile boolean openingSubtree = false;

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(final TreeExpansionEvent event) throws ExpandVetoException {
                TreeNode node = (TreeNode)event.getPath().getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) {
                    return;
                }
                final DefaultMutableTreeNode myNode = (DefaultMutableTreeNode)node;
                if (myNode.getChildCount() == -1) {
                    if (this.openingSubtree) {
                        throw new ExpandVetoException(event);
                    }
                    this.openingSubtree = true;
                    new SwingWorker(RootSelectorTree.this.lazyOpeningSemaphore){

                        protected void doInBackground() {
                            RootSelectorTree.checkNodeChildren(myNode, false);
                        }

                        protected void nonResponding() {
                            RootSelectorTree.this.progress.showProgress(Bundle.NodeLoadingMessage());
                        }

                        protected void done() {
                            RootSelectorTree.this.progress.close();
                            RootSelectorTree.this.tree.expandPath(event.getPath());
                            RootSelectorTree.this.doLayout();
                            openingSubtree = false;
                        }
                    }.execute();
                    throw new ExpandVetoException(event);
                }
                RootSelectorTree.checkNodeChildren(myNode, false);
            }
        });
    }

    private void setupTreeNodeToggleLogic() {
        this.tree.addCheckTreeListener(new JCheckTree.CheckTreeListener(){

            public void checkTreeChanged(Collection<CheckTreeNode> nodes) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void checkNodeToggled(TreePath treePath, boolean before) {
                if (!before) {
                    SelectorNode selectedNode = (SelectorNode)treePath.getLastPathComponent();
                    Collection signatures = selectedNode.getRootMethods(true);
                    if (selectedNode.isFullyChecked()) {
                        ArrayList<ClientUtils.SourceCodeSelection> toRemove = new ArrayList<ClientUtils.SourceCodeSelection>();
                        Set set = RootSelectorTree.this.currentSelectionSet;
                        synchronized (set) {
                            for (ClientUtils.SourceCodeSelection signature : signatures) {
                                for (ClientUtils.SourceCodeSelection rootMethod : RootSelectorTree.this.currentSelectionSet) {
                                    if (!signature.contains(rootMethod)) continue;
                                    toRemove.add(rootMethod);
                                }
                            }
                        }
                        RootSelectorTree.this.removeSelection(toRemove.toArray(new ClientUtils.SourceCodeSelection[toRemove.size()]));
                        RootSelectorTree.this.applySelection(signatures.toArray(new ClientUtils.SourceCodeSelection[signatures.size()]));
                    } else {
                        ContainerNode parent = selectedNode.getParent();
                        ArrayList toAdd = new ArrayList();
                        if (parent != null) {
                            Enumeration siblings = parent.children();
                            while (siblings.hasMoreElements()) {
                                SelectorNode siblingNode = (SelectorNode)siblings.nextElement();
                                if (siblingNode == selectedNode || !siblingNode.isFullyChecked()) continue;
                                toAdd.addAll(siblingNode.getRootMethods(true));
                            }
                            toAdd.removeAll(signatures);
                        }
                        ArrayList<ClientUtils.SourceCodeSelection> toRemove = new ArrayList<ClientUtils.SourceCodeSelection>();
                        for (ClientUtils.SourceCodeSelection signature : signatures) {
                            for (ClientUtils.SourceCodeSelection rootMethod : RootSelectorTree.this.currentSelectionSet) {
                                if (!rootMethod.contains(signature) && !signature.contains(rootMethod)) continue;
                                toRemove.add(rootMethod);
                            }
                        }
                        toRemove.addAll(signatures);
                        TreeNode root = (TreeNode)RootSelectorTree.this.tree.getModel().getRoot();
                        ArrayList selection = new ArrayList();
                        int firstLevelCnt = root.getChildCount();
                        for (int i = 0; i < firstLevelCnt; ++i) {
                            RootSelectorTree.calculateInflatedSelection((SelectorNode)parent, (SelectorNode)root.getChildAt(i), selection, toRemove);
                        }
                        RootSelectorTree.addRequiredPackages(selection, toAdd);
                        RootSelectorTree.this.removeSelection(toRemove.toArray(new ClientUtils.SourceCodeSelection[toRemove.size()]));
                        RootSelectorTree.this.applySelection(toAdd.toArray(new ClientUtils.SourceCodeSelection[toAdd.size()]));
                    }
                }
            }
        });
    }

    private void findNode(String searchText) {
        GestureSubmitter.logRMSSearch((String)searchText);
        this.sCont = new TreePathSearch((TreeNode)this.tree.getModel().getRoot(), searchText, this.ci);
        this.find(false);
    }

    private void find(final boolean backward) {
        if (this.sCont == null) {
            return;
        }
        if (this.searchInProgress.compareAndSet(false, true)) {
            new SwingWorker(){
                private volatile TreePath rsltPath;
                private volatile ProgressDisplayer pd;

                protected void doInBackground() {
                    this.rsltPath = backward ? (TreePath)RootSelectorTree.this.sCont.back() : (TreePath)RootSelectorTree.this.sCont.forward();
                }

                protected void nonResponding() {
                    this.pd = RootSelectorTree.this.progress.showProgress(Bundle.MSG_SEARCHING(), new ProgressDisplayer.ProgressController(){

                        public boolean cancel() {
                            if (RootSelectorTree.this.sCont != null) {
                                RootSelectorTree.this.sCont.cancel();
                            }
                            return true;
                        }
                    });
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void done() {
                    try {
                        if (this.pd != null) {
                            this.pd.close();
                        }
                        if (this.rsltPath != null) {
                            RootSelectorTree.this.tree.makeVisible(this.rsltPath);
                            RootSelectorTree.this.tree.setSelectionPath(this.rsltPath);
                            RootSelectorTree.this.tree.scrollPathToVisible(this.rsltPath);
                        } else {
                            ProfilerDialogs.displayWarning((String)Bundle.MSG_NOMATCH(), (String)Bundle.CAP_SEARCHRSLT(), null);
                        }
                    }
                    finally {
                        RootSelectorTree.this.searchInProgress.set(false);
                    }
                }
            }.execute();
        }
    }

    private static void checkNodeChildren(DefaultMutableTreeNode myNode, boolean recurse) {
        RootSelectorTree.checkNodeChildren(myNode, recurse, null);
    }

    private static void checkNodeChildren(DefaultMutableTreeNode myNode, boolean recurse, CancellableController controller) {
        if (controller != null && controller.isCancelled()) {
            return;
        }
        Enumeration<TreeNode> children = myNode.children();
        if (myNode instanceof CheckTreeNode && ((CheckTreeNode)myNode).isFullyChecked()) {
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (!(child instanceof CheckTreeNode)) continue;
                ((CheckTreeNode)child).setChecked(true);
                if (!recurse) continue;
                RootSelectorTree.checkNodeChildren((DefaultMutableTreeNode)((CheckTreeNode)child), recurse, controller);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySelection(ClientUtils.SourceCodeSelection[] selections) {
        if (!this.isActive.get()) {
            return;
        }
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        Enumeration<? extends TreeNode> childrenEnum = root.children();
        while (childrenEnum.hasMoreElements()) {
            if (!this.isActive.get()) {
                return;
            }
            TreeNode child = childrenEnum.nextElement();
            if (!(child instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection selection : selections) {
                this.applySelection((SelectorNode)child, selection);
            }
        }
        Set<ClientUtils.SourceCodeSelection> set = this.currentSelectionSet;
        synchronized (set) {
            this.currentSelectionSet.addAll(Arrays.asList(selections));
        }
    }

    private void applySelection(SelectorNode node, ClientUtils.SourceCodeSelection selection) {
        if (!this.isActive.get()) {
            return;
        }
        ClientUtils.SourceCodeSelection signature = node.getSignature();
        if (signature != null) {
            if (signature.equals((Object)selection) || selection.contains(signature)) {
                node.setChecked(true);
                return;
            }
            if (!signature.contains(selection)) {
                return;
            }
        }
        Enumeration childrenEnum = node.children();
        while (childrenEnum.hasMoreElements()) {
            if (!this.isActive.get()) {
                return;
            }
            Object child = childrenEnum.nextElement();
            if (!(child instanceof SelectorNode)) continue;
            this.applySelection((SelectorNode)child, selection);
        }
    }

    private void removeSelection(ClientUtils.SourceCodeSelection[] selections) {
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        Enumeration<? extends TreeNode> childrenEnum = root.children();
        while (childrenEnum.hasMoreElements()) {
            TreeNode child = childrenEnum.nextElement();
            if (!(child instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection selection : selections) {
                this.removeSelection((SelectorNode)child, selection);
            }
        }
        this.currentSelectionSet.removeAll(Arrays.asList(selections));
    }

    private void removeSelection(SelectorNode node, ClientUtils.SourceCodeSelection selection) {
        ClientUtils.SourceCodeSelection signature = node.getSignature();
        if (signature != null) {
            if (signature.equals((Object)selection)) {
                node.setChecked(false);
                return;
            }
            if (!signature.contains(selection)) {
                return;
            }
        }
        Enumeration childrenEnum = node.children();
        while (childrenEnum.hasMoreElements()) {
            Object child = childrenEnum.nextElement();
            if (!(child instanceof SelectorNode)) continue;
            this.removeSelection((SelectorNode)child, selection);
        }
    }

    private static void calculateInflatedSelection(SelectorNode node, SelectorNode root, Collection<ClientUtils.SourceCodeSelection> selection, Collection<ClientUtils.SourceCodeSelection> toRemove) {
        if (node == null || root == null || selection == null || toRemove == null) {
            return;
        }
        if (root.isFullyChecked() || root.isPartiallyChecked()) {
            if (root.getSignature() != null && root.isFullyChecked() && !toRemove.contains(root.getSignature())) {
                selection.add(root.getSignature());
            }
            if (root.getSignature() == null || node.getSignature() == null || root.getSignature().contains(node.getSignature())) {
                int childrenCount = root.getChildCount();
                for (int i = 0; i < childrenCount; ++i) {
                    SelectorNode childNode = (SelectorNode)root.getChildAt(i);
                    RootSelectorTree.calculateInflatedSelection(node, childNode, selection, toRemove);
                }
            }
        }
    }

    private static void addRequiredPackages(Collection<ClientUtils.SourceCodeSelection> selection, Collection<ClientUtils.SourceCodeSelection> toAdd) {
        for (ClientUtils.SourceCodeSelection signature : selection) {
            boolean appendSignature = true;
            for (ClientUtils.SourceCodeSelection addSignature : toAdd) {
                appendSignature = appendSignature && !signature.contains(addSignature);
            }
            if (!appendSignature) continue;
            toAdd.add(signature);
        }
    }

    private void refreshTree() {
        this.tree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode(Bundle.RootSelectorTree_LoadingString())));
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setModel((TreeModel)new DefaultTreeModel(this.getTreeRoot()));
        this.tree.treeDidChange();
        this.applyCurrentSelection();
    }

    private DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(Bundle.RootSelectorTree_RootString());
        if (this.builderType != null) {
            for (SelectionTreeBuilder builder : this.context.lookupAll(SelectionTreeBuilder.class)) {
                if (!builder.getType().equals((Object)this.builderType)) continue;
                for (SelectorNode node : builder.buildSelectionTree()) {
                    rootNode.add((MutableTreeNode)node);
                }
            }
        }
        return rootNode;
    }

    private void applyCurrentSelection() {
        new SelectionSetter(new SelectionGetter(){

            @Override
            public ClientUtils.SourceCodeSelection[] getSelection() {
                return RootSelectorTree.this.getSelection();
            }
        }).execute();
    }

    private final class SelectionSetter
    extends SwingWorker {
        private volatile ProgressDisplayer pd;
        private final SelectionGetter getter;

        private SelectionSetter(SelectionGetter selection) {
            super(RootSelectorTree.this.semaphore);
            this.pd = null;
            this.getter = selection;
        }

        private SelectionSetter(final ClientUtils.SourceCodeSelection[] newSelection) {
            this(new SelectionGetter(){

                @Override
                public ClientUtils.SourceCodeSelection[] getSelection() {
                    return newSelection;
                }
            });
        }

        protected void doInBackground() {
            RootSelectorTree.this.isActive.set(true);
            ClientUtils.SourceCodeSelection[] newSelection = this.getter.getSelection();
            RootSelectorTree.this.removeSelection(RootSelectorTree.this.getSelection());
            RootSelectorTree.this.applySelection(newSelection);
        }

        protected void nonResponding() {
            final CountDownLatch cl = new CountDownLatch(1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RootSelectorTree.this.setEnabled(false);
                    cl.countDown();
                }
            });
            final SelectionSetter worker = this;
            this.pd = RootSelectorTree.this.progress.showProgress(Bundle.MSG_ApplyingSelection(), new ProgressDisplayer.ProgressController(){

                public boolean cancel() {
                    worker.cancel();
                    return true;
                }
            });
            try {
                cl.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        protected void done() {
            this.closeProgress();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RootSelectorTree.this.setEnabled(true);
                }
            });
            RootSelectorTree.this.tree.treeDidChange();
        }

        private void closeProgress() {
            if (this.pd != null) {
                this.pd.close();
                this.pd = null;
            }
        }

        protected int getWarmup() {
            return 50;
        }

        protected void cancelled() {
            RootSelectorTree.this.isActive.set(false);
            this.closeProgress();
            if (RootSelectorTree.this.cancellHandler != null) {
                RootSelectorTree.this.cancellHandler.cancel();
            }
        }
    }

    private static interface SelectionGetter {
        public ClientUtils.SourceCodeSelection[] getSelection();
    }

    private static class TypeEntry {
        SelectionTreeBuilderType type;
        int frequency;

        public TypeEntry(SelectionTreeBuilderType type) {
            this.type = type;
            this.frequency = 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeEntry other = (TypeEntry)obj;
            return this.type == other.type || this.type != null && this.type.equals((Object)other.type);
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + (this.type != null ? this.type.hashCode() : 0);
            return hash;
        }
    }
}

