/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.html.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.html.lexer.HtmlLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum HTMLTokenId implements TokenId
{
    TEXT("text"),
    SCRIPT("script"),
    STYLE("style"),
    WS("ws"),
    ERROR("error"),
    TAG_OPEN("tag"),
    TAG_CLOSE("tag"),
    ARGUMENT("argument"),
    OPERATOR("operator"),
    VALUE("value"),
    VALUE_JAVASCRIPT("value"),
    VALUE_CSS("value"),
    BLOCK_COMMENT("block-comment"),
    SGML_COMMENT("sgml-comment"),
    DECLARATION("sgml-declaration"),
    XML_PI("xml-pi"),
    CHARACTER("character"),
    EOL("text"),
    TAG_OPEN_SYMBOL("tag"),
    TAG_CLOSE_SYMBOL("tag");

    private final String primaryCategory;
    private static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    private static final String STYLE_MIMETYPE = "text/css";
    public static final String VALUE_CSS_TOKEN_TYPE_PROPERTY = "valueCssType";
    public static final String VALUE_CSS_TOKEN_TYPE_ID = "id";
    public static final String VALUE_CSS_TOKEN_TYPE_CLASS = "class";
    public static final String SCRIPT_TYPE_TOKEN_PROPERTY = "type";
    private static final Logger LOGGER;
    private static final boolean LOG;
    private static final Language<HTMLTokenId> language;

    private HTMLTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public static Language<HTMLTokenId> language() {
        return language;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    static {
        LOGGER = Logger.getLogger(HtmlLexer.class.getName());
        LOG = LOGGER.isLoggable(Level.FINE);
        language = new LanguageHierarchy<HTMLTokenId>(){

            protected Collection<HTMLTokenId> createTokenIds() {
                return EnumSet.allOf(HTMLTokenId.class);
            }

            protected Map<String, Collection<HTMLTokenId>> createTokenCategories() {
                return null;
            }

            protected Lexer<HTMLTokenId> createLexer(LexerRestartInfo<HTMLTokenId> info) {
                return new HtmlLexer(info);
            }

            protected LanguageEmbedding embedding(Token<HTMLTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                if (LOG) {
                    LOGGER.log(Level.FINE, String.format("HTMLTokenId$Language<HTMLTokenId>.embedding(...) called on removed token with %s token id. LanguagePath: %s", token.id(), languagePath), new IllegalStateException());
                }
                String mimeType = null;
                switch ((HTMLTokenId)token.id()) {
                    case VALUE_JAVASCRIPT: {
                        mimeType = HTMLTokenId.JAVASCRIPT_MIMETYPE;
                        if (mimeType == null) break;
                        Language lang = Language.find((String)mimeType);
                        if (lang == null) {
                            return null;
                        }
                        PartType ptype = token.partType();
                        int startSkipLength = ptype == PartType.COMPLETE || ptype == PartType.START ? 1 : 0;
                        int endSkipLength = ptype == PartType.COMPLETE || ptype == PartType.END ? 1 : 0;
                        return LanguageEmbedding.create((Language)lang, (int)startSkipLength, (int)endSkipLength, (ptype != PartType.END && ptype != PartType.COMPLETE ? 1 : 0) != 0);
                    }
                    case VALUE_CSS: {
                        mimeType = HTMLTokenId.STYLE_MIMETYPE;
                        if (mimeType == null) break;
                        Language lang = Language.find((String)mimeType);
                        if (lang == null) {
                            return null;
                        }
                        PartType ptype = token.partType();
                        if (token.isRemoved()) {
                            return null;
                        }
                        char firstChar = token.text().charAt(0);
                        boolean quoted = firstChar == '\'' || firstChar == '\"';
                        int startSkipLength = quoted && (ptype == PartType.COMPLETE || ptype == PartType.START) ? 1 : 0;
                        int endSkipLength = quoted && (ptype == PartType.COMPLETE || ptype == PartType.END) ? 1 : 0;
                        return LanguageEmbedding.create((Language)lang, (int)startSkipLength, (int)endSkipLength, (ptype != PartType.END && ptype != PartType.COMPLETE ? 1 : 0) != 0);
                    }
                    case SCRIPT: {
                        String scriptType = (String)token.getProperty((Object)HTMLTokenId.SCRIPT_TYPE_TOKEN_PROPERTY);
                        if (scriptType != null && !HTMLTokenId.JAVASCRIPT_MIMETYPE.equals(scriptType)) break;
                        mimeType = HTMLTokenId.JAVASCRIPT_MIMETYPE;
                        break;
                    }
                    case STYLE: {
                        mimeType = HTMLTokenId.STYLE_MIMETYPE;
                    }
                }
                if (mimeType != null) {
                    Language lang = Language.find((String)mimeType);
                    if (lang == null) {
                        return null;
                    }
                    return LanguageEmbedding.create((Language)lang, (int)0, (int)0, (boolean)true);
                }
                return null;
            }

            protected String mimeType() {
                return "text/html";
            }
        }.language();
    }
}

